package plugins.perrine.flip;

import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;
import plugins.adufour.vars.lang.VarSequence;
import icy.gui.dialog.MessageDialog;
import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.type.collection.array.Array1DUtil;
import icy.type.collection.array.Array2DUtil;

public class Flip extends EzPlug implements Block {
	EzVarSequence inputsequence=new EzVarSequence("sequence to flip");
	//private EzVarText choiceflippingmethod= new EzVarText("flip orientation",
	//		new String[] { "Horizontal", "Vertical" }, 0, false);
	private VarSequence out= new VarSequence("output sequence", null);
	@Override
	protected void initialize() {
		addEzComponent(inputsequence);
		//addEzComponent(choiceflippingmethod);
	}

	@Override
	protected void execute() {
		Sequence sequence=inputsequence.getValue();
		Sequence result=new Sequence(sequence.getName() +" - Flipped");
		result.beginUpdate();
		try
		{
			/*if (choiceflippingmethod.getValue()=="Horizontal"){
			for (int t=0;t<sequence.getSizeT();t++){
				for (int z=0;z<sequence.getSizeZ();z++){
				IcyBufferedImage image= FlipHorizontal(sequence,t,z);
				result.setImage(t, z, image);
				}
			}
			}
			else{*/
				for (int t=0;t<sequence.getSizeT();t++){
					for (int z=0;z<sequence.getSizeZ();z++){
					IcyBufferedImage image= FlipVertical(sequence,t,z);
					result.setImage(t, z, image);
					}
				}
			//}
		}
		finally
		{
			result.endUpdate();
		}
		for (int c=0; c<sequence.getSizeC();c++){
			result.setColormap(c, sequence.getColorMap(c));
		}
		result.setPixelSizeX(sequence.getPixelSizeX());
		result.setPixelSizeY(sequence.getPixelSizeY());
		result.setPixelSizeZ(sequence.getPixelSizeZ());
		if (!this.isHeadLess())
			addSequence(result);
		else
			out.setValue(result);
	}

	private IcyBufferedImage FlipVertical(Sequence sequence, int t, int z) {
		IcyBufferedImage result = new IcyBufferedImage(sequence.getSizeX(),sequence.getSizeY(),sequence.getSizeC(), sequence.getDataType_());
		double[] doubleArray= new double[sequence.getSizeX()*sequence.getSizeY()];
		double[][] imgAllCArray=new double[sequence.getSizeC()][doubleArray.length];
		
		Object dataArray=sequence.getDataXYC(t, z);
		
		imgAllCArray=Array2DUtil.arrayToDoubleArray(dataArray, sequence.isSignedDataType());
		for (int c=0; c<sequence.getSizeC();c++){
			
			for (int i=0;i<doubleArray.length;i=i+sequence.getSizeX()){
					for(int l=0;l<sequence.getSizeX();l++){
					doubleArray[i+l]=imgAllCArray[c][i+(sequence.getSizeX()-1)-l];
					}
			}
		
					
		imgAllCArray=Array2DUtil.arrayToDoubleArray(dataArray, sequence.isSignedDataType());
		Array1DUtil.doubleArrayToArray(doubleArray,result.getDataXY(c))	;
		}
		result.dataChanged();
		return result;
	}

	/*private IcyBufferedImage FlipHorizontal(Sequence sequence, int t, int z) {
		IcyBufferedImage result = new IcyBufferedImage(sequence.getSizeX(),sequence.getSizeY(),sequence.getSizeC(), sequence.getDataType_());
		double[] doubleArray= new double[sequence.getSizeX()*sequence.getSizeY()];
		double[][] imgAllCArray=new double[sequence.getSizeC()][doubleArray.length];
		
		Object dataArray=sequence.getDataXYC(t, z);
		
		imgAllCArray=Array2DUtil.arrayToDoubleArray(dataArray, sequence.isSignedDataType());
		for (int c=0; c<sequence.getSizeC();c++){
			
			for (int i=0;i<doubleArray.length;i=i+sequence.getSizeX()){
					for(int l=0;l<sequence.getSizeX();l++){
					doubleArray[i+l]=imgAllCArray[c][i+(sequence.getSizeX()-1)-l];
					}
			}
		
					
		imgAllCArray=Array2DUtil.arrayToDoubleArray(dataArray, sequence.isSignedDataType());
		Array1DUtil.doubleArrayToArray(doubleArray,result.getDataXY(c))	;
		}
		result.dataChanged();
		return result;
	}*/

	@Override
	public void clean() {
		// TODO Auto-generated by Icy4Eclipse
	}
	
	@Override
	public void declareInput(VarList inputMap) {
		// TODO Auto-generated method stub
		inputMap.add("Input Image",inputsequence.getVariable());
		
		
	}
	@Override
	public void declareOutput(VarList outputMap) {
		// TODO Auto-generated method stub
		outputMap.add("Flipped sequence", out);
	}
}
