package plugins.lagache.roisr;

import java.util.ArrayList;

import icy.plugin.abstract_.Plugin;
import icy.sequence.Sequence;
import icy.type.point.Point3D;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarDoubleArrayNative;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi3d.ROI3DArea;

// Colocalisation with Ripley function K
// Significant 

public class DBSCAN extends Plugin implements Block {

	// EzVarSwimmingObject<DetectionResult> detections = new
	// EzVarSwimmingObject<DetectionResult>("Detections");
	VarDoubleArrayNative positions_x = new VarDoubleArrayNative("Positions x",null);
	VarDoubleArrayNative positions_y = new VarDoubleArrayNative("Positions y",null);
	VarDoubleArrayNative positions_z = new VarDoubleArrayNative("Positions z",null);
	VarSequence input_sequence = new VarSequence("Input sequence (dimensions z/t ?) ", null);
	VarDouble search = new VarDouble("Search distance (in pixels)", 5);
	VarDouble threshold = new VarDouble("Neighbors' threshold", 20.0);
	VarDouble buffer = new VarDouble("ROI dilatation (in pixels)", 3.0);	
	//VarSequence sequence_out = new VarSequence("Sequence with ROI3D",null);
	//VarString sequence_name = new VarString("Sequence name", "ROI conversion");
	VarROIArray roi_analysis = new VarROIArray("ROIs for Analysis", null);

	double maxdist;

	@Override
	public void declareInput(VarList inputMap) {

		inputMap.add("Positions x",positions_x);
		inputMap.add("Positions y",positions_y);
		inputMap.add("Positions z",positions_z);
		inputMap.add("Input Sequence (dimensions z/t ?)", input_sequence);
		inputMap.add("Search distance (in pixels)", search);
		inputMap.add("Neighbors' threshold", threshold);
		inputMap.add("ROI dilatation (in pixels)", buffer);
		//inputMap.add("Name of the ROI sequence", sequence_name);
	}

	@Override
	public void declareOutput(VarList outputMap) {
		outputMap.add("ROIs for Analysis", roi_analysis);
		//outputMap.add("Sequence with ROI for analysis", sequence_out);
	}

	// N: nb entre dmin et dmax avec pas donne
	@Override
	public void run() {
		if ((positions_x.getValue()!=null)&(positions_y.getValue()!=null)&(positions_z.getValue()!=null)){
		int length_x=positions_x.getValue().length;
		int length_y=positions_y.getValue().length;
		int length_z=positions_z.getValue().length;
		//si on est en 2D
		if ((length_x==length_y)&(length_z==0)){
			 ArrayList<Point3D > positions_1 = new ArrayList<Point3D>();
			 for (int i =0;i<positions_x.getValue().length;i++)
			 {Point3D pt = new Point3D.Double(positions_x.getValue()[i],positions_y.getValue()[i],0.0);
			 positions_1.add(pt);}
			
			 maxdist = search.getValue();
			// initialisation du workbook
			Sequence sequence = input_sequence.getValue();
			double window_size = maxdist;
			//d�finition du ratio Z/X
			double ratio_zx=1;
			Window2D[][] imageWindows_1 = new Window2D[(int) (sequence.getWidth() / window_size)][(int) (sequence.getHeight()/ window_size)];
			imageWindows_1 = Window2D.window_tab(positions_1, sequence, maxdist);
			// calcul des parametres globaux: aire totale des rois et nb de
			// detections
			// faut-refaire une fonction calcul de volume
			
			int nbdeta = positions_x.getValue().length;		
			// calcul de la fonction de Ripley L
			////////////////////////////////////////////////////////		
			ROI2DArea analysis_roi = Ripley2D.correlation_new(imageWindows_1, maxdist,input_sequence,nbdeta, threshold,buffer);
			ROI2DArea[] output=new ROI2DArea[1];
			output[0]=analysis_roi;
			roi_analysis.setValue(output);}					
		else{//on est en 3D
		if ((length_x==length_y)&(length_x==length_z)){
		//on crée la liste de points 3D
		 ArrayList<Point3D > positions_1 = new ArrayList<Point3D>();
		 for (int i =0;i<positions_x.getValue().length;i++)
		 {Point3D pt = new Point3D.Double(positions_x.getValue()[i],positions_y.getValue()[i],positions_z.getValue()[i]);
		 positions_1.add(pt);}
		
		 maxdist = search.getValue();
		// initialisation du workbook
		Sequence sequence = input_sequence.getValue();
		double window_size = maxdist;
		//d�finition du ratio Z/X
		double ratio_zx=1;
		if (sequence.getSizeZ()>1)
		{ratio_zx = sequence.getPixelSizeZ()/sequence.getPixelSizeX();}
		double max_z = maxdist/ratio_zx;		
		Window3D[][][] imageWindows_1 = new Window3D[(int) (sequence.getWidth() / window_size)][(int) (sequence.getHeight()/ window_size)][(int) (sequence.getSizeZ() / max_z)];
		imageWindows_1 = Window3D.window_tab(positions_1, sequence, maxdist,max_z);
		// calcul des parametres globaux: aire totale des rois et nb de
		// detections
		// faut-refaire une fonction calcul de volume
		double volume = sequence.getHeight()*sequence.getWidth()*sequence.getSizeZ()*ratio_zx;
		
		int nbdeta = positions_x.getValue().length;		
		// calcul de la fonction de Ripley L
		////////////////////////////////////////////////////////		
		ROI3DArea analysis_roi = Ripley3D.correlation_new(imageWindows_1, volume, maxdist,ratio_zx,input_sequence,nbdeta, threshold,buffer);
		ROI3DArea[] output=new ROI3DArea[1];
		output[0]=analysis_roi;
		roi_analysis.setValue(output);}
		}}
		
	}

	
}