package plugins.lagache.roisr;

import icy.roi.BooleanMask2D;
import icy.roi.BooleanMask3D;

import icy.type.point.Point3D;
import icy.type.rectangle.Rectangle3D;

import java.util.ArrayList;


import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarSequence;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi3d.ROI3DArea;

public class Ripley3D {
	// Calcul de la fonction de correlation (Ripley)
	public static ROI3DArea correlation_new(Window3D[][][] imageWindows_1,double volume, double distance,double ratio_zx, VarSequence sequence1, int nbdeta,VarDouble threshold,VarDouble buffer) {

		
		ArrayList<Point3D> point_liste = new ArrayList<Point3D>();		
		for (int i = 0; i < imageWindows_1.length; i++) {
			for (int j = 0; j < imageWindows_1[i].length; j++) {
				for (int z = 0; z < imageWindows_1[i][j].length; z++){					
				for (Point3D pos_a : imageWindows_1[i][j][z].detectionlist) {	
					double K=0;					
					for (int k = Math.max(i - 1, 0); k <= Math.min(i + 1, imageWindows_1.length - 1); k++) {
						for (int l = Math.max(j - 1, 0); l <= Math.min(j + 1, imageWindows_1[i].length - 1); l++) {
							for (int m = Math.max(z - 1, 0); m <= Math.min(z + 1, imageWindows_1[i][j].length - 1); m++) {

							for (Point3D pos_b : imageWindows_1[k][l][m].detectionlist) {
								
								double temp = Math.sqrt(Math.pow(pos_a.getX() - pos_b.getX(), 2)
										+ Math.pow(pos_a.getY() - pos_b.getY(), 2)+Math.pow((pos_a.getZ()-pos_b.getZ())*ratio_zx, 2));
								// Calcul du poids (Ripley)
								// calcul de la fonction de Ripley locale								
									if ((temp < distance) & (temp > 0.0)) {
										K += 1;																				
									}
								}
							}
						}
					}
					//calcul de la fonction L_a associée et ajout su nombre de coloc associé					
					if (K>threshold.getValue()){
						//on définit le pixel de la position a
						int ax = (int)(pos_a.getX());int ay = (int)(pos_a.getY());int az=(int)(pos_a.getZ());
						//on ajoute les pixels les points (i,j) dans un rayon de buffer 
						for (int k=Math.max((int)(ax-buffer.getValue()),0);k<Math.min(sequence1.getValue().getWidth(),(int)(ax+buffer.getValue()));k++){
							for (int l=Math.max((int)(ay-buffer.getValue()),0);l<Math.min(sequence1.getValue().getHeight(),(int)(ay+buffer.getValue()));l++){
								for (int m=Math.max((int)(az-buffer.getValue()/ratio_zx),0);m<Math.min(sequence1.getValue().getSizeZ(),(int)(az+buffer.getValue()/ratio_zx)+1);m++){							
								//on crée le Point si il est dans le rayon distance
								if (Math.pow(k-ax, 2)+Math.pow(l-ay, 2)+Math.pow((m-az)*ratio_zx, 2)<Math.pow(buffer.getValue(), 2)){
								Point3D pt = new Point3D.Integer(k, l,m);
								point_liste.add(pt);
							}}}}}					
					}
				}
				}
		}
		
		
		//on transforme la lsite de points en tableau
		Point3D[] point_tab=new Point3D[point_liste.size()];
		int inc=0;
		for (Point3D pt:point_liste)
		{point_tab[inc]=pt;inc++;}
		
		BooleanMask3D mask3d = new BooleanMask3D(point_tab);
		 ROI3DArea roi3d = new ROI3DArea();
	        final Rectangle3D.Integer bounds3d = mask3d.bounds;
	        int startZ = bounds3d.z;
	        int sizeZ = bounds3d.sizeZ;

	        for (int z = 0; z < sizeZ; z++)
	        {
	            int posZ = startZ + z;

	            BooleanMask2D masks2d = mask3d.getMask2D(posZ);
	            if (masks2d == null)
	                roi3d.setSlice(posZ, new ROI2DArea());
	            else
	                roi3d.setSlice(posZ, new ROI2DArea(masks2d));
	        }
		return roi3d;
	}
}