/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.security;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Constants;
import org.jets3t.service.ServiceException;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.AWSDevPayCredentials;
import org.jets3t.service.security.EncryptionUtil;
import org.jets3t.service.utils.ServiceUtils;

public abstract class ProviderCredentials {
    protected static final Log log = LogFactory.getLog(ProviderCredentials.class);
    protected static final int CREDENTIALS_STORAGE_VERSION = 3;
    protected static final String V2_KEYS_DELIMITER = "AWSKEYS";
    protected static final String V3_KEYS_DELIMITER = "\n";
    protected String accessKey = null;
    protected String secretKey = null;
    protected String friendlyName = null;

    public ProviderCredentials(String accessKey, String secretKey) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    public ProviderCredentials(String accessKey, String secretKey, String friendlyName) {
        this(accessKey, secretKey);
        this.friendlyName = friendlyName;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public boolean hasFriendlyName() {
        return this.friendlyName != null && this.friendlyName.trim().length() > 0;
    }

    public String getLogString() {
        return this.getAccessKey() + " : " + this.getSecretKey();
    }

    protected String getDataToEncrypt() {
        return this.getAccessKey() + V3_KEYS_DELIMITER + this.getSecretKey();
    }

    protected abstract String getTypeName();

    protected abstract String getVersionPrefix();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save(String password, File file, String algorithm) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            this.save(password, fos, algorithm);
            Object var6_5 = null;
            if (fos == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fos == null) throw throwable;
            fos.close();
            throw throwable;
        }
        fos.close();
    }

    public void save(String password, File file) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, IOException {
        this.save(password, file, "PBEWithMD5AndDES");
    }

    public void save(String password, OutputStream outputStream, String algorithm) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, IOException {
        BufferedOutputStream bufferedOS = null;
        EncryptionUtil encryptionUtil = new EncryptionUtil(password, algorithm, "2");
        bufferedOS = new BufferedOutputStream(outputStream);
        byte[] encryptedData = encryptionUtil.encrypt(this.getDataToEncrypt());
        bufferedOS.write((this.getVersionPrefix() + 3 + V3_KEYS_DELIMITER).getBytes(Constants.DEFAULT_ENCODING));
        bufferedOS.write((encryptionUtil.getAlgorithm() + V3_KEYS_DELIMITER).getBytes(Constants.DEFAULT_ENCODING));
        bufferedOS.write(((this.friendlyName == null ? "" : this.friendlyName) + V3_KEYS_DELIMITER).getBytes(Constants.DEFAULT_ENCODING));
        bufferedOS.write((this.getTypeName() + V3_KEYS_DELIMITER).getBytes(Constants.DEFAULT_ENCODING));
        bufferedOS.write(encryptedData);
        bufferedOS.flush();
    }

    public void save(String password, OutputStream outputStream) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, IOException {
        this.save(password, outputStream, "PBEWithMD5AndDES");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ProviderCredentials load(String password, File file) throws ServiceException {
        ProviderCredentials providerCredentials;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading credentials from file: " + file.getAbsolutePath()));
        }
        BufferedInputStream fileIS = null;
        try {
            try {
                fileIS = new BufferedInputStream(new FileInputStream(file));
                providerCredentials = ProviderCredentials.load(password, fileIS);
                Object var5_5 = null;
                if (fileIS == null) return providerCredentials;
            }
            catch (Throwable t) {
                throw new ServiceException("Failed to load credentials", t);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (fileIS == null) throw throwable;
            try {
                fileIS.close();
                throw throwable;
            }
            catch (IOException e) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return providerCredentials;
        }
        fileIS.close();
        return providerCredentials;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ProviderCredentials load(String password, BufferedInputStream inputStream) throws ServiceException {
        block25: {
            block24: {
                block23: {
                    block22: {
                        v0 = partialReadOnly = password == null;
                        if (partialReadOnly) {
                            if (ProviderCredentials.log.isDebugEnabled()) {
                                ProviderCredentials.log.debug((Object)"Loading partial information about credentials from input stream");
                            }
                        } else if (ProviderCredentials.log.isDebugEnabled()) {
                            ProviderCredentials.log.debug((Object)"Loading credentials from input stream");
                        }
                        try {
                            try {
                                encryptionUtil = null;
                                encryptedKeys = new byte[2048];
                                encryptedDataIndex = 0;
                                version = null;
                                versionNum = 0;
                                algorithm = "";
                                friendlyName = "";
                                usingDevPay = false;
                                version = ServiceUtils.readInputStreamLineToString(inputStream, Constants.DEFAULT_ENCODING);
                                firstColonOffset = version.indexOf(":");
                                versionString = version.substring(firstColonOffset + 1).trim();
                                versionNum = Integer.parseInt(versionString);
                                algorithm = ServiceUtils.readInputStreamLineToString(inputStream, Constants.DEFAULT_ENCODING);
                                friendlyName = ServiceUtils.readInputStreamLineToString(inputStream, Constants.DEFAULT_ENCODING);
                                if (!partialReadOnly) {
                                    encryptionUtil = new EncryptionUtil(password, algorithm, "2");
                                }
                                if (3 <= versionNum) {
                                    credentialsType = ServiceUtils.readInputStreamLineToString(inputStream, Constants.DEFAULT_ENCODING);
                                    usingDevPay = "devpay".equals(credentialsType);
                                }
                                if (partialReadOnly) {
                                    if (usingDevPay) {
                                        credentialsType = new AWSDevPayCredentials(null, null, friendlyName);
                                        var18_16 = null;
                                        if (inputStream == null) return credentialsType;
                                        break block22;
                                    }
                                    credentialsType = new AWSCredentials(null, null, friendlyName);
                                    break block23;
                                }
                                encryptedDataIndex = inputStream.read(encryptedKeys);
                                keys = encryptionUtil.decryptString(encryptedKeys, 0, encryptedDataIndex);
                                parts = keys.split(3 <= versionNum ? "\n" : "AWSKEYS");
                                v1 = expectedParts = usingDevPay != false ? 4 : 2;
                                if (parts.length != expectedParts) {
                                    throw new Exception("Number of parts (" + parts.length + ") did not match the expected number of parts (" + expectedParts + ") for this version (" + versionNum + ")");
                                }
                                if (usingDevPay) {
                                    var16_28 = new AWSDevPayCredentials(parts[0], parts[1], parts[2], parts[3], friendlyName);
                                    break block24;
                                }
                                var16_29 = new AWSCredentials(parts[0], parts[1], friendlyName);
                                break block25;
                            }
                            catch (BadPaddingException bpe) {
                                throw new ServiceException("Unable to decrypt credentials. Is your password correct?", bpe);
                            }
                            catch (Throwable t) {
                                throw new ServiceException("Failed to load credentials", t);
                            }
                        }
                        catch (Throwable var17_30) {
                            var18_20 = null;
                            if (inputStream == null) throw var17_30;
                            try {
                                inputStream.close();
                                throw var17_30;
                            }
                            catch (IOException e) {
                                throw var17_30;
                            }
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [13 : 447->454)] { 
lbl67:
                    // 1 sources

                    inputStream.close();
                    return credentialsType;
lbl69:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                    return credentialsType;
                }
                var18_17 = null;
                if (inputStream == null) return credentialsType;
                ** try [egrp 2[TRYBLOCK] [13 : 447->454)] { 
lbl76:
                // 1 sources

                inputStream.close();
                return credentialsType;
lbl78:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return credentialsType;
            }
            var18_18 = null;
            if (inputStream == null) return var16_28;
            ** try [egrp 2[TRYBLOCK] [13 : 447->454)] { 
lbl85:
            // 1 sources

            inputStream.close();
            return var16_28;
lbl87:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return var16_28;
        }
        var18_19 = null;
        if (inputStream == null) return var16_29;
        try {}
        catch (IOException e) {
            // empty catch block
            return var16_29;
        }
        inputStream.close();
        return var16_29;
    }
}

