/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.utils.signedurl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.contrib.proxy.PluginProxyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.EntityUtils;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.utils.RestUtils;
import org.jets3t.service.utils.ServiceUtils;
import org.jets3t.service.utils.gatekeeper.GatekeeperMessage;
import org.jets3t.service.utils.gatekeeper.SignatureRequest;

public class GatekeeperClientUtils {
    private HttpClient httpClientGatekeeper = null;
    private static final Log log = LogFactory.getLog(GatekeeperClientUtils.class);
    private Exception priorFailureException = null;
    private String gatekeeperUrl = null;
    private final String userAgentDescription;
    private final int maxRetryCount;
    private final int connectionTimeout;
    private CredentialsProvider credentialsProvider = null;

    public GatekeeperClientUtils(String gatekeeperUrl, String userAgentDescription, int maxRetryCount, int connectionTimeoutMS, CredentialsProvider credentialsProvider) {
        this.gatekeeperUrl = gatekeeperUrl;
        this.userAgentDescription = userAgentDescription;
        this.maxRetryCount = maxRetryCount;
        this.connectionTimeout = connectionTimeoutMS;
        this.credentialsProvider = credentialsProvider;
    }

    private HttpClient initHttpConnection() {
        HttpParams params = RestUtils.createDefaultHttpParams();
        HttpProtocolParams.setUserAgent(params, ServiceUtils.getUserAgentDescription(this.userAgentDescription));
        HttpConnectionParams.setConnectionTimeout(params, this.connectionTimeout);
        HttpConnectionParams.setSoTimeout(params, this.connectionTimeout);
        HttpConnectionParams.setStaleCheckingEnabled(params, false);
        DefaultHttpClient httpClient = new DefaultHttpClient(params);
        httpClient.setHttpRequestRetryHandler(new RestUtils.JetS3tRetryHandler(this.maxRetryCount, null));
        httpClient.setCredentialsProvider(this.credentialsProvider);
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GatekeeperMessage requestActionThroughGatekeeper(String operationType, String bucketName, S3Object[] objects, Map applicationPropertiesMap) throws HttpException, Exception {
        String contentType;
        int responseCode;
        HttpResponse response;
        block26: {
            HttpPost postMethod;
            block25: {
                GatekeeperMessage gatekeeperMessage = new GatekeeperMessage();
                gatekeeperMessage.addApplicationProperties(applicationPropertiesMap);
                gatekeeperMessage.addApplicationProperty("clientVersionId", this.userAgentDescription);
                if (this.priorFailureException != null) {
                    gatekeeperMessage.addApplicationProperty("priorFailureMessage", this.priorFailureException.getMessage());
                    this.priorFailureException = null;
                }
                for (int i = 0; i < objects.length; ++i) {
                    SignatureRequest signatureRequest = new SignatureRequest(operationType, objects[i].getKey());
                    signatureRequest.setObjectMetadata(objects[i].getMetadataMap());
                    signatureRequest.setBucketName(bucketName);
                    gatekeeperMessage.addSignatureRequest(signatureRequest);
                }
                postMethod = new HttpPost(this.gatekeeperUrl);
                Properties properties = gatekeeperMessage.encodeToProperties();
                Iterator<Map.Entry<Object, Object>> propsIter = properties.entrySet().iterator();
                ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>(properties.size());
                while (propsIter.hasNext()) {
                    Map.Entry<Object, Object> entry = propsIter.next();
                    String fieldName = (String)entry.getKey();
                    String fieldValue = (String)entry.getValue();
                    parameters.add(new BasicNameValuePair(fieldName, fieldValue));
                }
                postMethod.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)parameters));
                if (this.httpClientGatekeeper == null) {
                    this.httpClientGatekeeper = this.initHttpConnection();
                }
                try {
                    HttpHost proxyHost = PluginProxyUtil.detectProxy(new URL(this.gatekeeperUrl));
                    if (proxyHost != null) {
                        this.httpClientGatekeeper.getParams().setParameter("http.route.default-proxy", proxyHost);
                    }
                }
                catch (Throwable t) {
                    if (!log.isDebugEnabled()) break block25;
                    log.debug((Object)"No proxy detected");
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Contacting Gatekeeper at: " + this.gatekeeperUrl));
            }
            response = null;
            response = this.httpClientGatekeeper.execute(postMethod);
            responseCode = response.getStatusLine().getStatusCode();
            contentType = response.getFirstHeader("Content-Type").getValue();
            if (responseCode != 200) break block26;
            InputStream responseInputStream = null;
            Header encodingHeader = response.getFirstHeader("Content-Encoding");
            if (encodingHeader != null && "gzip".equalsIgnoreCase(encodingHeader.getValue())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Inflating gzip-encoded response");
                }
                responseInputStream = new GZIPInputStream(response.getEntity().getContent());
            } else {
                responseInputStream = response.getEntity().getContent();
            }
            if (responseInputStream == null) {
                throw new IOException("No response input stream available from Gatekeeper");
            }
            Properties responseProperties = new Properties();
            try {
                responseProperties.load(responseInputStream);
                Object var17_21 = null;
            }
            catch (Throwable throwable) {
                Object var17_22 = null;
                responseInputStream.close();
                throw throwable;
            }
            responseInputStream.close();
            GatekeeperMessage gatekeeperResponseMessage = GatekeeperMessage.decodeFromProperties(responseProperties);
            String gatekeeperErrorCode = gatekeeperResponseMessage.getApplicationProperties().getProperty("gatekeeperErrorCode");
            if (gatekeeperErrorCode != null && log.isWarnEnabled()) {
                log.warn((Object)("Received Gatekeeper error code: " + gatekeeperErrorCode));
            }
            GatekeeperMessage gatekeeperMessage = gatekeeperResponseMessage;
            Object var20_26 = null;
            try {
                EntityUtils.consume(response.getEntity());
            }
            catch (Exception ee) {
                // empty catch block
            }
            return gatekeeperMessage;
        }
        try {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The Gatekeeper did not permit a request. Response code: " + responseCode + ", Response content type: " + contentType));
                }
                throw new IOException("The Gatekeeper did not permit your request");
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new Exception("Gatekeeper did not respond", e);
            }
        }
        catch (Throwable throwable) {
            Object var20_27 = null;
            try {
                EntityUtils.consume(response.getEntity());
            }
            catch (Exception ee) {}
            throw throwable;
        }
    }

    public S3Object[] buildS3ObjectsFromSignatureRequests(SignatureRequest[] srs) {
        S3Object[] objects = new S3Object[srs.length];
        for (int i = 0; i < srs.length; ++i) {
            objects[i] = new S3Object(srs[i].getObjectKey());
            objects[i].addAllMetadata(srs[i].getObjectMetadata());
        }
        return objects;
    }

    public String getGatekeeperUrl() {
        return this.gatekeeperUrl;
    }
}

