/*
 * Decompiled with CFR 0.152.
 */
package microTiPi.epifluorescence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import microTiPi.microUtils.Zernike;
import microTiPi.microscopy.MicroscopeModel;
import mitiv.array.Array3D;
import mitiv.array.Array4D;
import mitiv.array.Double1D;
import mitiv.array.Double2D;
import mitiv.array.Double3D;
import mitiv.array.Double4D;
import mitiv.array.DoubleArray;
import mitiv.array.Float2D;
import mitiv.array.Float3D;
import mitiv.array.Float4D;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.linalg.VectorSpace;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.utils.MathUtils;
import org.jtransforms.fft.DoubleFFT_2D;
import org.jtransforms.fft.FloatFFT_2D;

public class WideFieldModel
extends MicroscopeModel {
    protected double deltaX = 0.0;
    protected double deltaY = 0.0;
    protected int Nzern;
    protected boolean radial = false;
    protected double lambda;
    protected double NA;
    protected double ni;
    protected double lambda_ni;
    protected double radius;
    protected double pupil_area;
    protected double[] Z;
    protected boolean[] maskPupil;
    protected boolean[] mapPupil;
    protected double[] rho;
    protected double[] phi;
    protected double[] psi;
    protected Array4D cpxPsf;
    protected Shape cpxPsfShape;
    protected Shape aShape;
    protected Shape psf2DShape;
    protected int nModulus;
    protected int nDefocus;
    protected int nPhase;
    public static final int DEFOCUS = 0;
    public static final int PHASE = 1;
    public static final int MODULUS = 2;
    public static final int[] parametersFlag = new int[]{0, 1, 2};
    private boolean para = true;

    public WideFieldModel(Shape psfShape, double NA, double lambda, double ni, double dxy, double dz, boolean radial, boolean single) {
        this(psfShape, 0, 1, NA, lambda, ni, dxy, dz, radial, single);
    }

    public WideFieldModel(Shape psfShape, int nPhase, int nModulus, double NA, double lambda, double ni, double dxy, double dz, boolean radial, boolean single) {
        super(psfShape, dxy, dz, single);
        if (this.Nx != this.Ny) {
            throw new IllegalArgumentException("Nx should equal Ny");
        }
        this.lambda = lambda;
        this.ni = ni;
        this.Nzern = 4;
        this.NA = NA;
        this.radius = NA / lambda;
        this.lambda_ni = ni / lambda;
        this.phi = new double[this.Ny * this.Nx];
        this.psi = new double[this.Ny * this.Nx];
        this.radial = radial;
        this.cpxPsfShape = new Shape(2, this.Nx, this.Ny, this.Nz);
        this.aShape = new Shape(2, this.Nx, this.Ny);
        this.psf2DShape = new Shape(this.Nx, this.Ny);
        this.computeMaskPupil();
        this.nModulus = nModulus;
        if (this.nModulus < 1) {
            this.nModulus = 1;
        }
        this.parameterSpace = new DoubleShapedVectorSpace[3];
        this.parameterCoefs = new DoubleShapedVector[3];
        this.nPhase = nPhase;
        this.setNModulus();
        this.setNPhase();
        this.setDefocus();
    }

    protected void computeZernike() {
        this.Z = Zernike.zernikeArray(this.Nzern, this.Nx, this.Ny, this.radius * this.dxy * (double)this.Nx, true, this.radial);
        this.Z = MathUtils.gram_schmidt_orthonormalization((double[])this.Z, (int)this.Nx, (int)this.Ny, (int)this.Nzern);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void computePsf() {
        if (this.PState > 0) {
            return;
        }
        if (this.single) {
            this.cpxPsf = Float4D.create((Shape)this.cpxPsfShape);
            this.psf = Float3D.create((Shape)this.psfShape);
            final float PSFnorm = (float)(1.0 / (double)(this.Nx * this.Ny * this.Nz));
            final int Npix = this.Nx * this.Ny;
            int threads = Runtime.getRuntime().availableProcessors();
            ExecutorService service = Executors.newFixedThreadPool(threads);
            ArrayList<Future<GetPsfParaOut>> futures = new ArrayList<Future<GetPsfParaOut>>();
            int iz = 0;
            while (iz < this.Nz) {
                final int n = iz++;
                Callable<GetPsfParaOut> callable = new Callable<GetPsfParaOut>(){

                    @Override
                    public GetPsfParaOut call() throws Exception {
                        GetPsfParaOut output = new GetPsfParaOut(Npix, n, WideFieldModel.this.single);
                        float[] A = new float[2 * Npix];
                        double defoc_scale = n > WideFieldModel.this.Nz / 2 ? Math.PI * 2 * (double)(n - WideFieldModel.this.Nz) * WideFieldModel.this.dz : Math.PI * 2 * (double)n * WideFieldModel.this.dz;
                        for (int in = 0; in < Npix; ++in) {
                            double phasePupil = WideFieldModel.this.phi[in] + defoc_scale * WideFieldModel.this.psi[in];
                            A[2 * in] = (float)(WideFieldModel.this.rho[in] * Math.cos(phasePupil));
                            A[2 * in + 1] = (float)(WideFieldModel.this.rho[in] * Math.sin(phasePupil));
                        }
                        FloatFFT_2D FFT2D = new FloatFFT_2D((long)WideFieldModel.this.Nx, (long)WideFieldModel.this.Ny);
                        FFT2D.complexForward(A);
                        for (int in = 0; in < Npix; ++in) {
                            ((float[])output.outA)[2 * in] = A[2 * in];
                            ((float[])output.outA)[2 * in + 1] = -A[2 * in + 1];
                            ((float[])output.outPsf)[in] = (A[2 * in] * A[2 * in] + A[2 * in + 1] * A[2 * in + 1]) * PSFnorm;
                        }
                        return output;
                    }
                };
                futures.add(service.submit(callable));
            }
            service.shutdown();
            for (Future future : futures) {
                try {
                    GetPsfParaOut getPsfParaOut = (GetPsfParaOut)future.get();
                    this.cpxPsf.slice(getPsfParaOut.idxz).assign((ShapedArray)Float3D.wrap((float[])((float[])getPsfParaOut.outA), (Shape)this.aShape));
                    this.psf.slice(getPsfParaOut.idxz).assign((ShapedArray)Float2D.wrap((float[])((float[])getPsfParaOut.outPsf), (Shape)this.psf2DShape));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        } else if (this.para) {
            void var7_21;
            this.cpxPsf = Double4D.create((Shape)this.cpxPsfShape);
            this.psf = Double3D.create((Shape)this.psfShape);
            double PSFnorm = 1.0 / (double)(this.Nx * this.Ny * this.Nz);
            final int Npix = this.Nx * this.Ny;
            int threads = Runtime.getRuntime().availableProcessors();
            ExecutorService service = Executors.newFixedThreadPool(threads);
            ArrayList<Future<GetPsfParaOut>> futures = new ArrayList<Future<GetPsfParaOut>>();
            boolean bl = false;
            while (var7_21 < this.Nz) {
                void var8_26 = var7_21++;
                Callable<GetPsfParaOut> callable = new Callable<GetPsfParaOut>((int)var8_26, PSFnorm){
                    final /* synthetic */ int val$iz1;
                    final /* synthetic */ double val$PSFnorm;
                    {
                        this.val$iz1 = n2;
                        this.val$PSFnorm = d;
                    }

                    @Override
                    public GetPsfParaOut call() throws Exception {
                        GetPsfParaOut output = new GetPsfParaOut(Npix, this.val$iz1, WideFieldModel.this.single);
                        double[] A = new double[2 * Npix];
                        double defoc_scale = this.val$iz1 > WideFieldModel.this.Nz / 2 ? Math.PI * 2 * (double)(this.val$iz1 - WideFieldModel.this.Nz) * WideFieldModel.this.dz : Math.PI * 2 * (double)this.val$iz1 * WideFieldModel.this.dz;
                        for (int in = 0; in < Npix; ++in) {
                            double phasePupil = WideFieldModel.this.phi[in] + defoc_scale * WideFieldModel.this.psi[in];
                            A[2 * in] = WideFieldModel.this.rho[in] * Math.cos(phasePupil);
                            A[2 * in + 1] = WideFieldModel.this.rho[in] * Math.sin(phasePupil);
                        }
                        DoubleFFT_2D FFT2D = new DoubleFFT_2D((long)WideFieldModel.this.Nx, (long)WideFieldModel.this.Ny);
                        FFT2D.complexForward(A);
                        for (int in = 0; in < Npix; ++in) {
                            ((double[])output.outA)[2 * in] = A[2 * in];
                            ((double[])output.outA)[2 * in + 1] = -A[2 * in + 1];
                            ((double[])output.outPsf)[in] = (A[2 * in] * A[2 * in] + A[2 * in + 1] * A[2 * in + 1]) * this.val$PSFnorm;
                        }
                        return output;
                    }
                };
                futures.add(service.submit(callable));
            }
            service.shutdown();
            for (Future future : futures) {
                try {
                    GetPsfParaOut output = (GetPsfParaOut)future.get();
                    this.cpxPsf.slice(output.idxz).assign((ShapedArray)Double3D.wrap((double[])((double[])output.outA), (Shape)this.aShape));
                    this.psf.slice(output.idxz).assign((ShapedArray)Double2D.wrap((double[])((double[])output.outPsf), (Shape)this.psf2DShape));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.cpxPsf = Double4D.create((Shape)this.cpxPsfShape);
            this.psf = Double3D.create((Shape)this.psfShape);
            double PSFnorm = 1.0 / (double)(this.Nx * this.Ny * this.Nz);
            int Npix = this.Nx * this.Ny;
            DoubleFFT_2D FFT2D = new DoubleFFT_2D((long)this.Nx, (long)this.Ny);
            for (int iz = 0; iz < this.Nz; ++iz) {
                double[] A = new double[2 * Npix];
                double defoc_scale = iz > this.Nz / 2 ? Math.PI * 2 * (double)(iz - this.Nz) * this.dz : Math.PI * 2 * (double)iz * this.dz;
                for (int in = 0; in < Npix; ++in) {
                    double d = this.phi[in] + defoc_scale * this.psi[in];
                    A[2 * in] = this.rho[in] * Math.cos(d);
                    A[2 * in + 1] = this.rho[in] * Math.sin(d);
                }
                FFT2D.complexForward(A);
                for (int iy = 0; iy < this.Ny; ++iy) {
                    for (int ix = 0; ix < this.Nx; ++ix) {
                        int in = ix + this.Nx * iy;
                        ((Double4D)this.cpxPsf).set(0, ix, iy, iz, A[2 * in]);
                        ((Double4D)this.cpxPsf).set(1, ix, iy, iz, -A[2 * in + 1]);
                        ((Double3D)this.psf).set(ix, iy, iz, (A[2 * in] * A[2 * in] + A[2 * in + 1] * A[2 * in + 1]) * PSFnorm);
                    }
                }
            }
        }
        this.PState = 1;
    }

    @Override
    public DoubleShapedVector apply_Jacobian(ShapedVector grad, ShapedVectorSpace xspace) {
        if (xspace == this.parameterSpace[0]) {
            return this.apply_J_defocus(grad);
        }
        if (xspace == this.parameterSpace[1]) {
            return this.apply_J_phase(grad);
        }
        if (xspace == this.parameterSpace[2]) {
            return this.apply_J_modulus(grad);
        }
        throw new IllegalArgumentException("DoubleShapedVector grad does not belong to any space");
    }

    @Override
    public void setParam(DoubleShapedVector param) {
        if (param.getOwner() == this.parameterSpace[0]) {
            this.setDefocus(param);
        } else if (param.getOwner() == this.parameterSpace[1]) {
            this.setPhase(param);
        } else if (param.getOwner() == this.parameterSpace[2]) {
            this.setModulus(param);
        } else {
            throw new IllegalArgumentException("DoubleShapedVector param does not belong to any space");
        }
    }

    public DoubleShapedVector apply_J_modulus(ShapedVector q) {
        final int Npix = this.Nx * this.Ny;
        double defoc_scale = 0.0;
        final double PSFNorm = 1.0 / (double)(this.Nx * this.Ny * this.Nz);
        final double NBeta = 1.0 / this.parameterCoefs[2].norm2();
        Double1D JRho = Double1D.create((Shape)this.parameterSpace[2].getShape());
        JRho.fill(0.0);
        if (this.single) {
            if (this.para) {
                int threads = Runtime.getRuntime().availableProcessors();
                ExecutorService service = Executors.newFixedThreadPool(threads);
                ArrayList<Future<ApplyJPhaOut>> futures = new ArrayList<Future<ApplyJPhaOut>>();
                int iz = 0;
                while (iz < this.Nz) {
                    final Float2D float2D = ((Float3D)q.asShapedArray()).slice(iz);
                    final int iz1 = iz++;
                    Callable<ApplyJPhaOut> callable = new Callable<ApplyJPhaOut>(){

                        @Override
                        public ApplyJPhaOut call() throws Exception {
                            double defoc_scale = 0.0;
                            float[] Aq = new float[2 * Npix];
                            ApplyJPhaOut pout = new ApplyJPhaOut(WideFieldModel.this.parameterSpace[2].getNumber());
                            defoc_scale = iz1 > WideFieldModel.this.Nz / 2 ? Math.PI * 2 * (double)(iz1 - WideFieldModel.this.Nz) * WideFieldModel.this.dz : Math.PI * 2 * (double)iz1 * WideFieldModel.this.dz;
                            for (int iy = 0; iy < WideFieldModel.this.Ny; ++iy) {
                                for (int ix = 0; ix < WideFieldModel.this.Nx; ++ix) {
                                    int in = ix + WideFieldModel.this.Nx * iy;
                                    float qin = float2D.get(ix, iy);
                                    Aq[2 * in] = ((Float4D)WideFieldModel.this.cpxPsf).get(0, ix, iy, iz1) * qin;
                                    Aq[2 * in + 1] = ((Float4D)WideFieldModel.this.cpxPsf).get(1, ix, iy, iz1) * qin;
                                }
                            }
                            FloatFFT_2D FFT2D = new FloatFFT_2D((long)WideFieldModel.this.Nx, (long)WideFieldModel.this.Ny);
                            FFT2D.complexForward(Aq);
                            for (int j = 0; j < WideFieldModel.this.Ny; ++j) {
                                for (int i = 0; i < WideFieldModel.this.Nx; ++i) {
                                    int in = i + j * WideFieldModel.this.Nx;
                                    if (!WideFieldModel.this.maskPupil[in]) continue;
                                    double ph = WideFieldModel.this.phi[in] + defoc_scale * WideFieldModel.this.psi[in];
                                    double jin = WideFieldModel.this.rho[in] * ((double)Aq[2 * in] * Math.sin(ph) + (double)Aq[2 * in + 1] * Math.cos(ph));
                                    for (int k = 0; k < WideFieldModel.this.parameterSpace[2].getNumber(); ++k) {
                                        int Ci = k * Npix + in;
                                        int n = k;
                                        pout.grd[n] = pout.grd[n] + 2.0 * PSFNorm * jin * WideFieldModel.this.Z[Ci] * (1.0 - Math.pow(WideFieldModel.this.parameterCoefs[2].get(k) * NBeta, 2.0)) * NBeta;
                                    }
                                }
                            }
                            return pout;
                        }
                    };
                    futures.add(service.submit(callable));
                }
                service.shutdown();
                for (Future future : futures) {
                    try {
                        ApplyJPhaOut pout = (ApplyJPhaOut)future.get();
                        for (int k = 0; k < this.parameterSpace[2].getNumber(); ++k) {
                            JRho.set(k, JRho.get(k) + pout.grd[k]);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                int Ci;
                double[] J = new double[this.Ny * this.Nx];
                FloatFFT_2D FFT2D = new FloatFFT_2D((long)this.Nx, (long)this.Ny);
                for (int iz = 0; iz < this.Nz; ++iz) {
                    int n;
                    float[] Aq = new float[2 * Npix];
                    defoc_scale = iz > this.Nz / 2 ? Math.PI * 2 * (double)(iz - this.Nz) * this.dz : Math.PI * 2 * (double)iz * this.dz;
                    for (n = 0; n < this.Ny; ++n) {
                        for (int ix = 0; ix < this.Nx; ++ix) {
                            int in = ix + this.Nx * n;
                            float qin = ((Float3D)q.asShapedArray()).get(ix, n, iz);
                            Aq[2 * in] = ((Float4D)this.cpxPsf).get(0, ix, n, iz) * qin;
                            Aq[2 * in + 1] = ((Float4D)this.cpxPsf).get(1, ix, n, iz) * qin;
                        }
                    }
                    FFT2D.complexForward(Aq);
                    for (n = 0; n < Npix; ++n) {
                        Ci = iz * Npix + n;
                        double ph = this.phi[n] + defoc_scale * this.psi[n];
                        J[n] = J[n] + (double)Aq[2 * n] * Math.cos(ph) - (double)Aq[2 * n + 1] * Math.sin(ph);
                    }
                }
                for (int k = 0; k < this.parameterSpace[2].getNumber(); ++k) {
                    double tmp = 0.0;
                    for (int in = 0; in < Npix; ++in) {
                        Ci = k * Npix + in;
                        tmp += J[in] * this.Z[Ci];
                    }
                    JRho.set(k, 2.0 * PSFNorm * tmp * (1.0 - Math.pow(this.parameterCoefs[2].get(k) * NBeta, 2.0)) * NBeta);
                }
            }
        } else if (this.para) {
            int threads = Runtime.getRuntime().availableProcessors();
            ExecutorService service = Executors.newFixedThreadPool(threads);
            ArrayList<Future<double[]>> futures = new ArrayList<Future<double[]>>();
            int iz = 0;
            while (iz < this.Nz) {
                final Double2D double2D = ((Double3D)q.asShapedArray()).slice(iz);
                final int iz1 = iz++;
                Callable<double[]> callable = new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double defoc_scale = 0.0;
                        double[] Aq = new double[2 * Npix];
                        double[] J = new double[Npix];
                        defoc_scale = iz1 > WideFieldModel.this.Nz / 2 ? Math.PI * 2 * (double)(iz1 - WideFieldModel.this.Nz) * WideFieldModel.this.dz : Math.PI * 2 * (double)iz1 * WideFieldModel.this.dz;
                        for (int iy = 0; iy < WideFieldModel.this.Ny; ++iy) {
                            for (int ix = 0; ix < WideFieldModel.this.Nx; ++ix) {
                                int in = ix + WideFieldModel.this.Nx * iy;
                                double qin = double2D.get(ix, iy);
                                Aq[2 * in] = ((Double4D)WideFieldModel.this.cpxPsf).get(0, ix, iy, iz1) * qin;
                                Aq[2 * in + 1] = ((Double4D)WideFieldModel.this.cpxPsf).get(1, ix, iy, iz1) * qin;
                            }
                        }
                        DoubleFFT_2D FFT2D = new DoubleFFT_2D((long)WideFieldModel.this.Nx, (long)WideFieldModel.this.Ny);
                        FFT2D.complexForward(Aq);
                        for (int in = 0; in < Npix; ++in) {
                            double ph = WideFieldModel.this.phi[in] + defoc_scale * WideFieldModel.this.psi[in];
                            J[in] = J[in] + Aq[2 * in] * Math.cos(ph) - Aq[2 * in + 1] * Math.sin(ph);
                        }
                        return J;
                    }
                };
                futures.add(service.submit(callable));
            }
            service.shutdown();
            for (Future future : futures) {
                try {
                    double[] jt = (double[])future.get();
                    for (int k = 0; k < this.parameterSpace[2].getNumber(); ++k) {
                        double tmp = 0.0;
                        for (int in = 0; in < Npix; ++in) {
                            int Ci = k * Npix + in;
                            tmp += jt[in] * this.Z[Ci];
                        }
                        JRho.set(k, 2.0 * PSFNorm * tmp * (1.0 - Math.pow(this.parameterCoefs[2].get(k) * NBeta, 2.0)) * NBeta);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        } else {
            int Ci;
            int in;
            double[] J = new double[this.Ny * this.Nx];
            double[] Aq = new double[2 * Npix];
            DoubleFFT_2D FFT2D = new DoubleFFT_2D((long)this.Nx, (long)this.Ny);
            for (int iz = 0; iz < this.Nz; ++iz) {
                int n;
                defoc_scale = iz > this.Nz / 2 ? Math.PI * 2 * (double)(iz - this.Nz) * this.dz : Math.PI * 2 * (double)iz * this.dz;
                for (n = 0; n < this.Ny; ++n) {
                    for (int ix = 0; ix < this.Nx; ++ix) {
                        in = ix + this.Nx * n;
                        double qin = ((Double3D)q.asShapedArray()).get(ix, n, iz);
                        Aq[2 * in] = ((Double4D)this.cpxPsf).get(0, ix, n, iz) * qin;
                        Aq[2 * in + 1] = ((Double4D)this.cpxPsf).get(1, ix, n, iz) * qin;
                    }
                }
                FFT2D.complexForward(Aq);
                for (n = 0; n < Npix; ++n) {
                    Ci = iz * Npix + n;
                    double ph = this.phi[n] + defoc_scale * this.psi[n];
                    J[n] = J[n] + Aq[2 * n] * Math.cos(ph) - Aq[2 * n + 1] * Math.sin(ph);
                }
            }
            for (int k = 0; k < this.parameterSpace[2].getNumber(); ++k) {
                double d = 0.0;
                for (in = 0; in < Npix; ++in) {
                    Ci = k * Npix + in;
                    d += J[in] * this.Z[Ci];
                }
                JRho.set(k, 2.0 * PSFNorm * d * (1.0 - Math.pow(this.parameterCoefs[2].get(k) * NBeta, 2.0)) * NBeta);
            }
        }
        return this.parameterSpace[2].create((DoubleArray)JRho);
    }

    public DoubleShapedVector apply_J_phase(ShapedVector q) {
        final int Npix = this.Nx * this.Ny;
        final double PSFNorm = 1.0 / (double)(this.Nx * this.Ny * this.Nz);
        Double1D JPhi = Double1D.create((Shape)this.parameterSpace[1].getShape());
        JPhi.fill(0.0);
        if (this.single) {
            if (this.para) {
                int threads = Runtime.getRuntime().availableProcessors();
                ExecutorService service = Executors.newFixedThreadPool(threads);
                ArrayList<Future<ApplyJPhaOut>> futures = new ArrayList<Future<ApplyJPhaOut>>();
                int iz = 0;
                while (iz < this.Nz) {
                    final Float2D float2D = ((Float3D)q.asShapedArray()).slice(iz);
                    final int iz1 = iz++;
                    Callable<ApplyJPhaOut> callable = new Callable<ApplyJPhaOut>(){

                        @Override
                        public ApplyJPhaOut call() throws Exception {
                            double defoc_scale = 0.0;
                            float[] Aq = new float[2 * Npix];
                            ApplyJPhaOut pout = new ApplyJPhaOut(WideFieldModel.this.parameterSpace[1].getNumber());
                            defoc_scale = iz1 > WideFieldModel.this.Nz / 2 ? Math.PI * 2 * (double)(iz1 - WideFieldModel.this.Nz) * WideFieldModel.this.dz : Math.PI * 2 * (double)iz1 * WideFieldModel.this.dz;
                            for (int iy = 0; iy < WideFieldModel.this.Ny; ++iy) {
                                for (int ix = 0; ix < WideFieldModel.this.Nx; ++ix) {
                                    int in = ix + WideFieldModel.this.Nx * iy;
                                    float qin = float2D.get(ix, iy);
                                    Aq[2 * in] = ((Float4D)WideFieldModel.this.cpxPsf).get(0, ix, iy, iz1) * qin;
                                    Aq[2 * in + 1] = ((Float4D)WideFieldModel.this.cpxPsf).get(1, ix, iy, iz1) * qin;
                                }
                            }
                            FloatFFT_2D FFT2D = new FloatFFT_2D((long)WideFieldModel.this.Nx, (long)WideFieldModel.this.Ny);
                            FFT2D.complexForward(Aq);
                            for (int j = 0; j < WideFieldModel.this.Ny; ++j) {
                                for (int i = 0; i < WideFieldModel.this.Nx; ++i) {
                                    int in = i + j * WideFieldModel.this.Nx;
                                    if (!WideFieldModel.this.maskPupil[in]) continue;
                                    double ph = WideFieldModel.this.phi[in] + defoc_scale * WideFieldModel.this.psi[in];
                                    double jin = WideFieldModel.this.rho[in] * ((double)Aq[2 * in] * Math.sin(ph) + (double)Aq[2 * in + 1] * Math.cos(ph));
                                    int k = 0;
                                    while (k < WideFieldModel.this.parameterSpace[1].getNumber()) {
                                        int Ci = WideFieldModel.this.radial ? (k + 1) * Npix + in : (k + 3) * Npix + in;
                                        int n = k++;
                                        pout.grd[n] = pout.grd[n] - 2.0 * PSFNorm * jin * WideFieldModel.this.Z[Ci];
                                    }
                                }
                            }
                            return pout;
                        }
                    };
                    futures.add(service.submit(callable));
                }
                service.shutdown();
                for (Future future : futures) {
                    try {
                        ApplyJPhaOut pout = (ApplyJPhaOut)future.get();
                        for (int k = 0; k < this.parameterSpace[1].getNumber(); ++k) {
                            JPhi.set(k, JPhi.get(k) + pout.grd[k]);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                int Ci;
                int in;
                double d;
                double[] J = new double[this.Ny * this.Nx];
                float[] Aq = new float[2 * Npix];
                FloatFFT_2D FFT2D = new FloatFFT_2D((long)this.Nx, (long)this.Ny);
                for (int iz = 0; iz < this.Nz; ++iz) {
                    double d = 0.0;
                    d = iz > this.Nz / 2 ? Math.PI * 2 * (double)(iz - this.Nz) * this.dz : Math.PI * 2 * (double)iz * this.dz;
                    for (int iy = 0; iy < this.Ny; ++iy) {
                        for (int ix = 0; ix < this.Nx; ++ix) {
                            int in2 = ix + this.Nx * iy;
                            float qin = ((Float3D)q.asShapedArray()).get(ix, iy, iz);
                            Aq[2 * in2] = ((Float4D)this.cpxPsf).get(0, ix, iy, iz) * qin;
                            Aq[2 * in2 + 1] = ((Float4D)this.cpxPsf).get(1, ix, iy, iz) * qin;
                        }
                    }
                    FFT2D.complexForward(Aq);
                    for (in = 0; in < Npix; ++in) {
                        Ci = iz * Npix + in;
                        double ph = this.phi[in] + d * this.psi[in];
                        J[in] = J[in] + this.rho[in] * ((double)Aq[2 * in] * Math.sin(ph) + (double)Aq[2 * in + 1] * Math.cos(ph));
                    }
                }
                for (int k = 0; k < this.parameterSpace[1].getNumber(); ++k) {
                    d = 0.0;
                    for (in = 0; in < Npix; ++in) {
                        Ci = k * Npix + in;
                        if (this.radial) {
                            d += J[in] * this.Z[Ci + 1 * Npix];
                            continue;
                        }
                        d += J[in] * this.Z[Ci + 3 * Npix];
                    }
                    JPhi.set(k, -2.0 * PSFNorm * d);
                }
            }
        } else if (this.para) {
            int threads = Runtime.getRuntime().availableProcessors();
            ExecutorService service = Executors.newFixedThreadPool(threads);
            ArrayList<Future<ApplyJPhaOut>> futures = new ArrayList<Future<ApplyJPhaOut>>();
            int iz = 0;
            while (iz < this.Nz) {
                final Double2D double2D = ((Double3D)q.asShapedArray()).slice(iz);
                final int iz1 = iz++;
                Callable<ApplyJPhaOut> callable = new Callable<ApplyJPhaOut>(){

                    @Override
                    public ApplyJPhaOut call() throws Exception {
                        double defoc_scale = 0.0;
                        double[] Aq = new double[2 * Npix];
                        ApplyJPhaOut pout = new ApplyJPhaOut(WideFieldModel.this.parameterSpace[1].getNumber());
                        defoc_scale = iz1 > WideFieldModel.this.Nz / 2 ? Math.PI * 2 * (double)(iz1 - WideFieldModel.this.Nz) * WideFieldModel.this.dz : Math.PI * 2 * (double)iz1 * WideFieldModel.this.dz;
                        for (int iy = 0; iy < WideFieldModel.this.Ny; ++iy) {
                            for (int ix = 0; ix < WideFieldModel.this.Nx; ++ix) {
                                int in = ix + WideFieldModel.this.Nx * iy;
                                double qin = double2D.get(ix, iy);
                                Aq[2 * in] = ((Double4D)WideFieldModel.this.cpxPsf).get(0, ix, iy, iz1) * qin;
                                Aq[2 * in + 1] = ((Double4D)WideFieldModel.this.cpxPsf).get(1, ix, iy, iz1) * qin;
                            }
                        }
                        DoubleFFT_2D FFT2D = new DoubleFFT_2D((long)WideFieldModel.this.Nx, (long)WideFieldModel.this.Ny);
                        FFT2D.complexForward(Aq);
                        for (int j = 0; j < WideFieldModel.this.Ny; ++j) {
                            for (int i = 0; i < WideFieldModel.this.Nx; ++i) {
                                int in = i + j * WideFieldModel.this.Nx;
                                if (!WideFieldModel.this.maskPupil[in]) continue;
                                double ph = WideFieldModel.this.phi[in] + defoc_scale * WideFieldModel.this.psi[in];
                                double jin = WideFieldModel.this.rho[in] * (Aq[2 * in] * Math.sin(ph) + Aq[2 * in + 1] * Math.cos(ph));
                                int k = 0;
                                while (k < WideFieldModel.this.parameterSpace[1].getNumber()) {
                                    int Ci = WideFieldModel.this.radial ? (k + 1) * Npix + in : (k + 3) * Npix + in;
                                    int n = k++;
                                    pout.grd[n] = pout.grd[n] - 2.0 * PSFNorm * jin * WideFieldModel.this.Z[Ci];
                                }
                            }
                        }
                        return pout;
                    }
                };
                futures.add(service.submit(callable));
            }
            service.shutdown();
            for (Future future : futures) {
                try {
                    ApplyJPhaOut pout = (ApplyJPhaOut)future.get();
                    for (int k = 0; k < this.parameterSpace[1].getNumber(); ++k) {
                        JPhi.set(k, JPhi.get(k) + pout.grd[k]);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        } else {
            int Ci;
            int in;
            double d;
            double[] J = new double[this.Ny * this.Nx];
            double[] Aq = new double[2 * Npix];
            DoubleFFT_2D FFT2D = new DoubleFFT_2D((long)this.Ny, (long)this.Nx);
            for (int iz = 0; iz < this.Nz; ++iz) {
                double d = 0.0;
                d = iz > this.Nz / 2 ? Math.PI * 2 * (double)(iz - this.Nz) * this.dz : Math.PI * 2 * (double)iz * this.dz;
                for (int iy = 0; iy < this.Ny; ++iy) {
                    for (int ix = 0; ix < this.Nx; ++ix) {
                        int in3 = ix + this.Nx * iy;
                        double qin = ((Double3D)q.asShapedArray()).get(ix, iy, iz);
                        Aq[2 * in3] = ((Double4D)this.cpxPsf).get(0, ix, iy, iz) * qin;
                        Aq[2 * in3 + 1] = ((Double4D)this.cpxPsf).get(1, ix, iy, iz) * qin;
                    }
                }
                FFT2D.complexForward(Aq);
                for (in = 0; in < Npix; ++in) {
                    Ci = iz * Npix + in;
                    double ph = this.phi[in] + d * this.psi[in];
                    J[in] = J[in] + this.rho[in] * (Aq[2 * in] * Math.sin(ph) + Aq[2 * in + 1] * Math.cos(ph));
                }
            }
            for (int k = 0; k < this.parameterSpace[1].getNumber(); ++k) {
                d = 0.0;
                for (in = 0; in < Npix; ++in) {
                    Ci = k * Npix + in;
                    if (this.radial) {
                        d += J[in] * this.Z[Ci + 1 * Npix];
                        continue;
                    }
                    d += J[in] * this.Z[Ci + 3 * Npix];
                }
                JPhi.set(k, -2.0 * PSFNorm * d);
            }
        }
        return this.parameterSpace[1].create((DoubleArray)JPhi);
    }

    public DoubleShapedVector apply_J_defocus(ShapedVector q) {
        int threads;
        double scale_x = 1.0 / ((double)this.Nx * this.dxy);
        double scale_y = 1.0 / ((double)this.Ny * this.dxy);
        double d0 = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        final double[] rx = new double[this.Nx];
        final double[] ry = new double[this.Ny];
        final int Npix = this.Nx * this.Ny;
        final double PSFNorm = 1.0 / (double)(this.Nx * this.Ny * this.Nz);
        double[] grd = new double[this.parameterSpace[0].getNumber()];
        for (int nx = 0; nx < this.Nx; ++nx) {
            rx[nx] = nx > this.Nx / 2 ? (double)(nx - this.Nx) * scale_x - this.deltaX : (double)nx * scale_x - this.deltaX;
        }
        for (int ny = 0; ny < this.Ny; ++ny) {
            ry[ny] = ny > this.Ny / 2 ? (double)(ny - this.Ny) * scale_y - this.deltaY : (double)ny * scale_y - this.deltaY;
        }
        if (this.single) {
            if (this.para) {
                threads = Runtime.getRuntime().availableProcessors();
                ExecutorService service = Executors.newFixedThreadPool(threads);
                ArrayList<Future<ApplyJDefOut>> futures = new ArrayList<Future<ApplyJDefOut>>();
                int iz = 0;
                while (iz < this.Nz) {
                    final Float2D float2D = ((Float3D)q.asShapedArray()).slice(iz);
                    final int iz1 = iz++;
                    Callable<ApplyJDefOut> callable = new Callable<ApplyJDefOut>(){

                        @Override
                        public ApplyJDefOut call() throws Exception {
                            double defoc;
                            double defoc_scale = 0.0;
                            float[] Aq = new float[2 * Npix];
                            ApplyJDefOut dout = new ApplyJDefOut(0.0, 0.0, 0.0);
                            if (iz1 > WideFieldModel.this.Nz / 2) {
                                defoc = (double)(iz1 - WideFieldModel.this.Nz) * WideFieldModel.this.dz;
                                defoc_scale = Math.PI * 2 * (double)(iz1 - WideFieldModel.this.Nz) * WideFieldModel.this.dz;
                            } else {
                                defoc = (double)iz1 * WideFieldModel.this.dz;
                                defoc_scale = Math.PI * 2 * (double)iz1 * WideFieldModel.this.dz;
                            }
                            for (int iy = 0; iy < WideFieldModel.this.Ny; ++iy) {
                                for (int ix = 0; ix < WideFieldModel.this.Nx; ++ix) {
                                    int in = ix + WideFieldModel.this.Nx * iy;
                                    float qin = float2D.get(ix, iy);
                                    Aq[2 * in] = ((Float4D)WideFieldModel.this.cpxPsf).get(0, ix, iy, iz1) * qin;
                                    Aq[2 * in + 1] = ((Float4D)WideFieldModel.this.cpxPsf).get(1, ix, iy, iz1) * qin;
                                }
                            }
                            FloatFFT_2D FFT2D = new FloatFFT_2D((long)WideFieldModel.this.Nx, (long)WideFieldModel.this.Ny);
                            FFT2D.complexForward(Aq);
                            for (int j = 0; j < WideFieldModel.this.Ny; ++j) {
                                for (int i = 0; i < WideFieldModel.this.Nx; ++i) {
                                    int in = i + j * WideFieldModel.this.Nx;
                                    if (!WideFieldModel.this.maskPupil[in]) continue;
                                    double idef = 1.0 / WideFieldModel.this.psi[in];
                                    double ph = WideFieldModel.this.phi[in] + defoc_scale * WideFieldModel.this.psi[in];
                                    double tmpvar = Math.PI * -2 * WideFieldModel.this.rho[in] * ((double)Aq[2 * in] * Math.sin(ph) + (double)Aq[2 * in + 1] * Math.cos(ph)) * PSFNorm;
                                    dout.d1 -= tmpvar * (rx[i] * (defoc * idef));
                                    dout.d2 -= tmpvar * (ry[j] * (defoc * idef));
                                    dout.d0 += tmpvar * (idef * WideFieldModel.this.lambda_ni * defoc);
                                }
                            }
                            return dout;
                        }
                    };
                    futures.add(service.submit(callable));
                }
                service.shutdown();
                for (Future future : futures) {
                    try {
                        ApplyJDefOut output = (ApplyJDefOut)future.get();
                        d0 += output.d0;
                        d1 -= output.d1;
                        d2 -= output.d2;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                FloatFFT_2D FFT2D = new FloatFFT_2D((long)this.Nx, (long)this.Ny);
                float[] Aq = new float[2 * Npix];
                for (int iz = 0; iz < this.Nz; ++iz) {
                    int in;
                    double defoc;
                    double defoc_scale = 0.0;
                    if (iz > this.Nz / 2) {
                        defoc = (double)(iz - this.Nz) * this.dz;
                        defoc_scale = Math.PI * 2 * defoc;
                    } else {
                        defoc = (double)iz * this.dz;
                        defoc_scale = Math.PI * 2 * defoc;
                    }
                    for (int iy = 0; iy < this.Ny; ++iy) {
                        for (int ix = 0; ix < this.Nx; ++ix) {
                            in = ix + this.Nx * iy;
                            float qin = ((Float3D)q.asShapedArray()).get(ix, iy, iz);
                            Aq[2 * in] = ((Float4D)this.cpxPsf).get(0, ix, iy, iz) * qin;
                            Aq[2 * in + 1] = ((Float4D)this.cpxPsf).get(1, ix, iy, iz) * qin;
                        }
                    }
                    FFT2D.complexForward(Aq);
                    for (int j = 0; j < this.Ny; ++j) {
                        for (int i = 0; i < this.Nx; ++i) {
                            in = i + j * this.Nx;
                            if (!this.maskPupil[in]) continue;
                            double idef = 1.0 / this.psi[in];
                            double ph = this.phi[in] + defoc_scale * this.psi[in];
                            double tmpvar = Math.PI * -2 * this.rho[in] * ((double)Aq[2 * in] * Math.sin(ph) + (double)Aq[2 * in + 1] * Math.cos(ph)) * PSFNorm;
                            d1 -= tmpvar * (rx[i] * (defoc * idef));
                            d2 -= tmpvar * (ry[j] * (defoc * idef));
                            d0 += tmpvar * (idef * this.lambda_ni * defoc);
                        }
                    }
                }
            }
        } else if (this.para) {
            threads = Runtime.getRuntime().availableProcessors();
            ExecutorService service = Executors.newFixedThreadPool(threads);
            ArrayList<Future<double[]>> futures = new ArrayList<Future<double[]>>();
            int iz = 0;
            while (iz < this.Nz) {
                final Double2D double2D = ((Double3D)q.asShapedArray()).slice(iz);
                final int iz1 = iz++;
                Callable<double[]> callable = new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double defoc;
                        double defoc_scale = 0.0;
                        double[] Aq = new double[2 * Npix];
                        double[] dout = new double[3];
                        if (iz1 > WideFieldModel.this.Nz / 2) {
                            defoc = (double)(iz1 - WideFieldModel.this.Nz) * WideFieldModel.this.dz;
                            defoc_scale = Math.PI * 2 * (double)(iz1 - WideFieldModel.this.Nz) * WideFieldModel.this.dz;
                        } else {
                            defoc = (double)iz1 * WideFieldModel.this.dz;
                            defoc_scale = Math.PI * 2 * (double)iz1 * WideFieldModel.this.dz;
                        }
                        for (int iy = 0; iy < WideFieldModel.this.Ny; ++iy) {
                            for (int ix = 0; ix < WideFieldModel.this.Nx; ++ix) {
                                int in = ix + WideFieldModel.this.Nx * iy;
                                double qin = double2D.get(ix, iy);
                                Aq[2 * in] = ((Double4D)WideFieldModel.this.cpxPsf).get(0, ix, iy, iz1) * qin;
                                Aq[2 * in + 1] = ((Double4D)WideFieldModel.this.cpxPsf).get(1, ix, iy, iz1) * qin;
                            }
                        }
                        DoubleFFT_2D FFT2D = new DoubleFFT_2D((long)WideFieldModel.this.Nx, (long)WideFieldModel.this.Ny);
                        FFT2D.complexForward(Aq);
                        for (int j = 0; j < WideFieldModel.this.Ny; ++j) {
                            for (int i = 0; i < WideFieldModel.this.Nx; ++i) {
                                int in = i + j * WideFieldModel.this.Nx;
                                if (!WideFieldModel.this.maskPupil[in]) continue;
                                double idef = 1.0 / WideFieldModel.this.psi[in];
                                double ph = WideFieldModel.this.phi[in] + defoc_scale * WideFieldModel.this.psi[in];
                                double tmpvar = Math.PI * -2 * WideFieldModel.this.rho[in] * (Aq[2 * in] * Math.sin(ph) + Aq[2 * in + 1] * Math.cos(ph)) * PSFNorm;
                                dout[1] = dout[1] - tmpvar * (rx[i] * (defoc * idef));
                                dout[2] = dout[2] - tmpvar * (ry[j] * (defoc * idef));
                                dout[0] = dout[0] + tmpvar * (idef * WideFieldModel.this.lambda_ni * defoc);
                            }
                        }
                        return dout;
                    }
                };
                futures.add(service.submit(callable));
            }
            service.shutdown();
            for (Future future : futures) {
                try {
                    double[] output = (double[])future.get();
                    d0 += output[0];
                    d1 -= output[1];
                    d2 -= output[2];
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        } else {
            DoubleFFT_2D FFT2D = new DoubleFFT_2D((long)this.Nx, (long)this.Ny);
            for (int iz = 0; iz < this.Nz; ++iz) {
                int in;
                double defoc;
                Double2D qz = ((Double3D)q.asShapedArray()).slice(iz);
                int iz1 = iz;
                double d = 0.0;
                double[] Aq = new double[2 * Npix];
                if (iz1 > this.Nz / 2) {
                    defoc = (double)(iz1 - this.Nz) * this.dz;
                    d = Math.PI * 2 * (double)(iz1 - this.Nz) * this.dz;
                } else {
                    defoc = (double)iz1 * this.dz;
                    d = Math.PI * 2 * (double)iz1 * this.dz;
                }
                for (int iy = 0; iy < this.Ny; ++iy) {
                    for (int ix = 0; ix < this.Nx; ++ix) {
                        in = ix + this.Nx * iy;
                        double qin = qz.get(ix, iy);
                        Aq[2 * in] = ((Double4D)this.cpxPsf).get(0, ix, iy, iz1) * qin;
                        Aq[2 * in + 1] = ((Double4D)this.cpxPsf).get(1, ix, iy, iz1) * qin;
                    }
                }
                FFT2D.complexForward(Aq);
                for (int j = 0; j < this.Ny; ++j) {
                    for (int i = 0; i < this.Nx; ++i) {
                        in = i + j * this.Nx;
                        if (!this.maskPupil[in]) continue;
                        double idef = 1.0 / this.psi[in];
                        double ph = this.phi[in] + d * this.psi[in];
                        double tmpvar = Math.PI * -2 * this.rho[in] * (Aq[2 * in] * Math.sin(ph) + Aq[2 * in + 1] * Math.cos(ph)) * PSFNorm;
                        d1 -= tmpvar * (rx[i] * (defoc * idef));
                        d2 -= tmpvar * (ry[j] * (defoc * idef));
                        d0 += tmpvar * (idef * this.lambda_ni * defoc);
                    }
                }
            }
        }
        switch (this.parameterSpace[0].getNumber()) {
            case 3: {
                grd[2] = d2;
                grd[1] = d1;
            }
            case 1: {
                grd[0] = d0;
                break;
            }
            case 2: {
                grd[2] = d2;
                grd[1] = d1;
            }
        }
        return this.parameterSpace[0].create((DoubleArray)Double1D.wrap((double[])grd, (Shape)this.parameterSpace[0].getShape()));
    }

    protected void computeMaskPupil() {
        this.maskPupil = new boolean[this.Nx * this.Ny];
        this.mapPupil = new boolean[this.Nx * this.Ny];
        double scale_y = Math.pow(1.0 / this.dxy / (double)this.Ny, 2.0);
        double scale_x = Math.pow(1.0 / this.dxy / (double)this.Nx, 2.0);
        double radius2 = this.radius * this.radius;
        this.pupil_area = 0.0;
        for (int ny = 0; ny < this.Ny; ++ny) {
            double iy = Math.min(ny, this.Ny - ny);
            double ry = iy * iy * scale_y;
            for (int nx = 0; nx < this.Nx; ++nx) {
                double ix = Math.min(nx, this.Nx - nx);
                double rx = ix * ix * scale_x;
                if (rx + ry < radius2) {
                    this.maskPupil[nx + ny * this.Nx] = true;
                    this.mapPupil[nx + ny * this.Nx] = true;
                    this.pupil_area += 1.0;
                    continue;
                }
                this.maskPupil[nx + ny * this.Nx] = false;
                this.mapPupil[nx + ny * this.Nx] = false;
            }
        }
        this.pupil_area = Math.sqrt(this.pupil_area);
        this.freeMem();
    }

    public void computeDefocus() {
        double lambda_ni2 = this.lambda_ni * this.lambda_ni;
        double scale_x = 1.0 / ((double)this.Nx * this.dxy);
        double scale_y = 1.0 / ((double)this.Ny * this.dxy);
        for (int ny = 0; ny < this.Ny; ++ny) {
            double ry = ny > this.Ny / 2 ? Math.pow(scale_y * (double)(ny - this.Ny) - this.deltaY, 2.0) : Math.pow(scale_y * (double)ny - this.deltaY, 2.0);
            for (int nx = 0; nx < this.Nx; ++nx) {
                int nxy = nx + ny * this.Nx;
                if (!this.mapPupil[nxy]) continue;
                double rx = nx > this.Nx / 2 ? Math.pow(scale_x * (double)(nx - this.Nx) - this.deltaX, 2.0) : Math.pow(scale_x * (double)nx - this.deltaX, 2.0);
                double q = lambda_ni2 - rx - ry;
                if (q < 0.0) {
                    this.psi[nxy] = 0.0;
                    this.maskPupil[nxy] = false;
                    continue;
                }
                this.psi[nxy] = Math.sqrt(q);
                this.maskPupil[nxy] = true;
            }
        }
    }

    public void setDefocus(DoubleShapedVector defoc) {
        if (!defoc.belongsTo((VectorSpace)this.parameterSpace[0])) {
            throw new IllegalArgumentException("defocus  does not belong to the parameterSpace[DEFOCUS]");
        }
        this.parameterCoefs[0] = defoc;
        switch (defoc.getNumber()) {
            case 3: {
                this.deltaX = defoc.get(1);
                this.deltaY = defoc.get(2);
            }
            case 1: {
                this.lambda_ni = defoc.get(0);
                this.ni = this.lambda_ni * this.lambda;
                break;
            }
            case 2: {
                this.deltaX = defoc.get(1);
                this.deltaY = defoc.get(2);
                break;
            }
            default: {
                throw new IllegalArgumentException("bad defocus  parameters");
            }
        }
        this.computeDefocus();
        this.freeMem();
    }

    public void setDefocus(double[] defoc) {
        if (this.parameterSpace[0] == null) {
            this.parameterSpace[0] = new DoubleShapedVectorSpace(new int[]{3});
        }
        this.parameterCoefs[0] = this.parameterSpace[0].wrap(defoc);
        this.setDefocus(this.parameterCoefs[0]);
    }

    protected void setDefocus() {
        this.setDefocus(new double[]{this.ni / this.lambda, this.deltaX, this.deltaY});
    }

    public void setPupilAxis(double[] axis) {
        if (this.parameterSpace[0] == null) {
            this.parameterSpace[0] = new DoubleShapedVectorSpace(new int[]{3});
        }
        this.parameterCoefs[0] = this.parameterSpace[0].wrap(new double[]{this.ni / this.lambda, axis[0], axis[1]});
        this.setDefocus(this.parameterCoefs[0]);
    }

    public void setModulus(DoubleShapedVector modulus) {
        if (!modulus.belongsTo((VectorSpace)this.parameterSpace[2])) {
            throw new IllegalArgumentException("DoubleShapedVector beta does not belong to the modulus space");
        }
        this.parameterCoefs[2] = modulus;
        int Npix = this.Nx * this.Ny;
        this.rho = new double[Npix];
        double betaNorm = 1.0 / modulus.norm2();
        for (int in = 0; in < Npix; ++in) {
            if (!this.maskPupil[in]) continue;
            for (int n = 0; n < modulus.getNumber(); ++n) {
                int n2 = in;
                this.rho[n2] = this.rho[n2] + this.Z[in + n * Npix] * modulus.get(n) * betaNorm;
            }
        }
        this.freeMem();
    }

    public void setModulus(double[] modulus) {
        this.setNModulus(modulus.length);
        this.parameterCoefs[2] = this.parameterSpace[2].wrap(modulus);
        this.setModulus(this.parameterCoefs[2]);
    }

    public void setPhase(DoubleShapedVector phase) {
        if (!phase.belongsTo((VectorSpace)this.parameterSpace[1])) {
            throw new IllegalArgumentException("phase parameter does not belong to the right space  ");
        }
        this.parameterCoefs[1] = phase;
        int Npix = this.Nx * this.Ny;
        this.phi = new double[Npix];
        for (int in = 0; in < Npix; ++in) {
            if (!this.maskPupil[in]) continue;
            for (int n = 0; n < phase.getNumber(); ++n) {
                if (this.radial) {
                    int n2 = in;
                    this.phi[n2] = this.phi[n2] + this.Z[in + (n + 1) * Npix] * phase.get(n);
                    continue;
                }
                int n3 = in;
                this.phi[n3] = this.phi[n3] + this.Z[in + (n + 3) * Npix] * phase.get(n);
            }
        }
        this.freeMem();
    }

    public void setPhase(double[] alpha) {
        if (alpha == null || alpha.length == 0) {
            this.nPhase = 0;
            this.parameterCoefs[1] = null;
        } else {
            this.setNPhase(alpha.length);
            this.parameterCoefs[1] = this.parameterSpace[1].wrap(alpha);
            this.setPhase(this.parameterCoefs[1]);
        }
    }

    public double[] getRho() {
        if (this.PState < 1) {
            this.computePsf();
        }
        return this.rho;
    }

    public double getLambda() {
        return this.lambda;
    }

    public double getNi() {
        return this.ni;
    }

    public void setNi(Double value) {
        this.ni = value;
        this.lambda_ni = this.ni / this.lambda;
        if (this.parameterSpace[0] == null) {
            this.parameterSpace[0] = new DoubleShapedVectorSpace(new int[]{3});
        }
        this.parameterCoefs[0] = this.parameterSpace[0].wrap(new double[]{this.ni / this.lambda, this.deltaX, this.deltaY});
        this.setDefocus(this.parameterCoefs[0]);
    }

    public double[] getPhi() {
        if (this.PState < 1) {
            this.computePsf();
        }
        return this.phi;
    }

    public double[] getPsi() {
        if (this.PState < 1) {
            this.computePsf();
        }
        return this.psi;
    }

    public DoubleShapedVector getModulusCoefs() {
        return this.parameterCoefs[2];
    }

    public DoubleShapedVector getPhaseCoefs() {
        return this.parameterCoefs[1];
    }

    public double[] getDefocusMultiplyByLambda() {
        if (this.PState < 1) {
            this.computePsf();
        }
        double[] defocus = new double[]{this.lambda_ni * this.lambda, this.deltaX * this.lambda, this.deltaY * this.lambda};
        return defocus;
    }

    public double[] getDefocus() {
        if (this.PState < 1) {
            this.computePsf();
        }
        double[] defocus = new double[]{this.lambda_ni, this.deltaX, this.deltaY};
        return defocus;
    }

    public double[] getPupilShift() {
        if (this.PState < 1) {
            this.computePsf();
        }
        double[] shift = new double[]{this.deltaX, this.deltaY};
        return shift;
    }

    public boolean[] getMaskPupil() {
        if (this.PState < 1) {
            this.computePsf();
        }
        return this.maskPupil;
    }

    @Override
    public Array3D getPsf() {
        if (this.PState < 1) {
            this.computePsf();
        }
        return this.psf;
    }

    public double[] getZernike() {
        return this.Z;
    }

    public int getNZern() {
        return this.Nzern;
    }

    public double[] getZernike(int k) {
        return MathUtils.getArray((double[])this.Z, (int)this.Nx, (int)this.Ny, (int)k);
    }

    public Array4D get_cpxPsf() {
        if (this.PState < 1) {
            this.computePsf();
        }
        return this.cpxPsf;
    }

    public void getInfo() {
        System.out.println("----PSF----");
        MathUtils.stat((double[])this.psf.toDouble().getData());
        System.out.println();
        System.out.println("----PHI----");
        MathUtils.stat((double[])this.phi);
        System.out.println();
        System.out.println("----RHO----");
        MathUtils.stat((double[])this.rho);
        System.out.println();
        System.out.println("----PSI----");
        MathUtils.stat((double[])this.psi);
        System.out.println();
        System.out.println("----a----");
        MathUtils.statC((double[])this.cpxPsf.toDouble().getData());
        System.out.println();
        System.out.println("----ZERNIKES----");
        MathUtils.stat((double[])this.Z);
    }

    protected void setNPhase() {
        if (this.nPhase > 0) {
            this.parameterSpace[1] = new DoubleShapedVectorSpace(new int[]{this.nPhase});
            this.Nzern = this.radial ? Math.max(this.nPhase + 1, this.parameterSpace[2].getNumber()) : Math.max(this.nPhase + 3, this.parameterSpace[2].getNumber());
            this.computeZernike();
            this.parameterCoefs[1] = this.parameterSpace[1].create(0.0);
            this.setPhase(this.parameterCoefs[1]);
        } else {
            this.parameterSpace[1] = null;
            this.parameterCoefs[1] = null;
        }
    }

    public void setNPhase(int nPh) {
        this.nPhase = nPh;
        this.setNPhase();
    }

    public void setNModulus(int nMod) {
        this.nModulus = nMod;
        this.setNModulus();
    }

    protected void setNModulus() {
        if (this.nModulus < 1) {
            this.nModulus = 1;
        }
        this.parameterSpace[2] = new DoubleShapedVectorSpace(new int[]{this.nModulus});
        this.Nzern = this.parameterSpace[1] == null ? this.nModulus : (this.radial ? Math.max(this.parameterSpace[1].getNumber() + 1, this.nModulus) : Math.max(this.parameterSpace[1].getNumber() + 3, this.nModulus));
        this.computeZernike();
        this.parameterCoefs[2] = this.parameterSpace[2].create(0.0);
        this.parameterCoefs[2].set(0, 1.0);
        this.setModulus(this.parameterCoefs[2]);
    }

    @Override
    public void freeMem() {
        this.PState = 0;
        this.cpxPsf = null;
        this.psf = null;
    }

    public int getNModulus() {
        return this.parameterCoefs[2].getNumber();
    }

    public int getNPhase() {
        if (this.parameterCoefs[1] == null) {
            return 0;
        }
        return this.parameterCoefs[1].getNumber();
    }

    @Override
    public int[] getParametersFlags() {
        return parametersFlag;
    }

    private class GetPsfParaOut {
        Object outA;
        Object outPsf;
        int idxz;

        public GetPsfParaOut(int nPix, int iz, boolean single) {
            this.idxz = iz;
            if (single) {
                this.outA = new float[2 * nPix];
                this.outPsf = new float[2 * nPix];
            } else {
                this.outA = new double[2 * nPix];
                this.outPsf = new double[2 * nPix];
            }
        }
    }

    private class ApplyJPhaOut {
        double[] grd;

        public ApplyJPhaOut(int nMode) {
            this.grd = new double[nMode];
            Arrays.fill(this.grd, 0.0);
        }
    }

    private class ApplyJDefOut {
        double d0;
        double d1;
        double d2;

        public ApplyJDefOut(double d0_, double d1_, double d2_) {
            this.d0 = d0_;
            this.d1 = d1_;
            this.d2 = d2_;
        }
    }
}

