package plugins.tboudier.color3d;

import icy.gui.dialog.MessageDialog;
import icy.gui.frame.IcyFrame;
import icy.roi.ROI3D;
import icy.sequence.Sequence;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVarEnum;
import plugins.adufour.ezplug.EzVarSequence;

import java.awt.*;
import java.util.ArrayList;

enum EnumChoice {
    RANDOM, VOLUME
}

public class colorize3d extends EzPlug implements Block, EzStoppable {

    static IcyFrame mainFrame;
    private final EzVarSequence varSequence = new EzVarSequence("Input Sequence");
    private final EzVarEnum varEnum = new EzVarEnum("Color by:", EnumChoice.values());

    @Override
    protected void initialize() {
        super.addEzComponent(varSequence);
        super.addEzComponent(varEnum);
    }

    @Override
    protected void execute() {
        final boolean gui = !isHeadLess();
        Sequence seq = varSequence.getValue();
        if (seq == null) {
            if (gui) {
                MessageDialog.showDialog("Open a image first.");
            }
            return;
        }

        // TEST ICY AREA3D selected
        ArrayList<ROI3D> rois = seq.getSelectedROI3Ds();
        if (rois.isEmpty()) {
            rois = seq.getROI3Ds();
        }
        if (rois.isEmpty()) {
            if (gui) {
                MessageDialog.showDialog("No 3D Rois found");
            }
            return;
        }
        if (gui) {
            super.getUI().setProgressBarVisible(true);
        }

        Color color;
        int r = 0, g = 0, b = 0;
        // from ImageJ LutLoader, fire
        int[] reds = {0, 0, 1, 25, 49, 73, 98, 122, 146, 162, 173, 184, 195, 207, 217, 229, 240, 252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
        int[] greens = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 35, 57, 79, 101, 117, 133, 147, 161, 175, 190, 205, 219, 234, 248, 255, 255, 255, 255};
        int[] blues = {0, 61, 96, 130, 165, 192, 220, 227, 210, 181, 151, 122, 93, 64, 35, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 98, 160, 223, 255};
        int nColors = reds.length;
        int[] rr = new int[nColors];
        int[] gg = new int[nColors];
        int[] bb = new int[nColors];
        System.arraycopy(reds, 0, rr, 0, nColors);
        System.arraycopy(greens, 0, gg, 0, nColors);
        System.arraycopy(blues, 0, bb, 0, nColors);
        double scale = nColors / 256.0;
        int i1, i2;
        double fraction;
        reds = new int[256];
        greens = new int[256];
        blues = new int[256];
        for (int i = 0; i < 256; i++) {
            i1 = (int) (i * scale);
            i2 = i1 + 1;
            if (i2 == nColors) i2 = nColors - 1;
            fraction = i * scale - i1;
            reds[i] = (int) ((1.0 - fraction) * (rr[i1]) + fraction * (rr[i2]));
            greens[i] = (int) ((1.0 - fraction) * (gg[i1]) + fraction * (gg[i2]));
            blues[i] = (int) ((1.0 - fraction) * (bb[i1]) + fraction * (bb[i2]));
        }

        double maxV = rois.get(0).getNumberOfPoints();
        double minV = rois.get(0).getNumberOfPoints();
        if (varEnum.getValue() == EnumChoice.VOLUME) {
            for (ROI3D roi : rois) {
                double volume = roi.getNumberOfPoints();
                if (volume > maxV) maxV = volume;
                if (volume < minV) minV = volume;
            }
        }

        for (ROI3D roi : rois) {
            if (varEnum.getValue() == EnumChoice.RANDOM) {
                r = (int) (Math.random() * 255);
                g = (int) (Math.random() * 255);
                b = (int) (Math.random() * 255);
                while ((r < 50) && (g < 50) && (b < 50)) {
                    r = (int) (Math.random() * 255);
                    g = (int) (Math.random() * 255);
                    b = (int) (Math.random() * 255);
                }
                roi.setColor(new Color(r, g, b));
            } else if (varEnum.getValue() == EnumChoice.VOLUME) {
                int index = (int) Math.round(255.0 * ((maxV - roi.getNumberOfPoints()) / (maxV - minV)));
                roi.setColor(new Color(reds[index], greens[index], blues[index]));
            }
        }
    }

    @Override
    public void clean() {
        //
    }

    @Override
    public void stopExecution() {
        System.out.println("3D colorize plugin stopped.");
    }

    @Override
    public void declareInput(VarList inputMap) {
        inputMap.add("Sequence", varSequence.getVariable());
        inputMap.add("ColorBy", varEnum.getVariable());
    }

    @Override
    public void declareOutput(VarList outputMap) {
    }
}
