package plugins.lagache.sodasuite;

import java.awt.Point;
import java.util.ArrayList;
import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROIUtil;
import icy.sequence.Sequence;
import icy.type.point.Point5D;

public class Methods_overlap {
	public static double[] Overlap(Sequence seq1, ArrayList<ROI> roi1, ArrayList<ROI> roi2,ArrayList<ROI> roi_t,int nb_mc,int t,double T) {
		double[] p = new double[3];
		p[0]=0;p[1]=0;p[2]=1;
		if (roi_t.size()==0){			
			return p;}
		//computation of the coefficients
		double[] coeffs = OverlapCoeff(seq1, roi1, roi2,roi_t,t,T);
		p[0] = coeffs[0];p[1] = coeffs[1];
		//computation of the p_value		
		p[2]=pvalue_computation_overlap(coeffs[0], seq1, roi1, roi2, roi_t, nb_mc,t,T);
		return p;		
	}
	public static double[] Manders(Sequence seq1, ArrayList<ROI> roi1, ArrayList<ROI> roi2,ArrayList<ROI> roi_t,int nb_mc,int t) {		
		double[] p=new double[3];
		p[0]=0;p[1]=0;p[2]=1;
		if (roi_t==null){			
			return p;}
		//computation of the coefficients
		double[] coeffs = MandersCoeff(roi1, roi2,roi_t,t);
		p[0] = coeffs[0];p[1]=coeffs[1];
		//computation of the p_value		
		p[2]=pvalue_computation(coeffs[0], seq1, roi1, roi2, roi_t, nb_mc,t);
		return p;		
	}
	public static double[] MandersCoeff(ArrayList<ROI> roi1, ArrayList<ROI> roi2,ArrayList<ROI> roi_t,int t) {
		
		double[] p=new double[2];
		p[0]=0;p[1]=0;
		if (roi_t.size()==0){			
			return p;}
		ArrayList<ROI> liste1 = new ArrayList<ROI>();
		ArrayList<ROI> liste2 = new ArrayList<ROI>();
		for (ROI r1:roi1){
			if (r1.getPosition5D().getT()==t)
			liste1.add(r1);}
		for (ROI r2:roi2){
			if (r2.getPosition5D().getT()==t)
			liste2.add(r2);}
		
		ROI union1 = ROIUtil.getUnion(liste1);
		ROI union2 = ROIUtil.getUnion(liste2);
		ROI union_t = ROIUtil.getUnion(roi_t);
		ArrayList<ROI> total = new ArrayList<ROI>();
		total.add(union1);total.add(union2);total.add(union_t);		
		ROI inter = ROIUtil.getIntersection(total);
		if (union1.getNumberOfPoints()>0)
			p[0] = inter.getNumberOfPoints()/union1.getNumberOfPoints();
		if (union2.getNumberOfPoints()>0)
			p[1] = inter.getNumberOfPoints()/union2.getNumberOfPoints();		
		
		return p;		
	}
public static double[] OverlapCoeff(Sequence seq1, ArrayList<ROI> roi1, ArrayList<ROI> roi2,ArrayList<ROI> roi_t,int t,double T) {
		
		double[] p=new double[2];
		p[0]=0;p[1]=0;
		if (roi_t.size()==0){			
			return p;}
		ArrayList<ROI> liste1 = new ArrayList<ROI>();
		for (ROI r1:roi1){
			if (r1.getPosition5D().getT()==t)
			liste1.add(r1);}
		ROI union1 = ROIUtil.getUnion(liste1);
		
		int compteur_roi = 0;
		for (ROI r2:roi2){
			if (r2.getPosition5D().getT()==t)
			{
				//calcul intersection avec union 1
				double alpha = ROIUtil.getIntersection(r2, union1).getNumberOfPoints()/(r2.getNumberOfPoints());
				if (alpha>T)
					compteur_roi+=1;
			}
		}
		p[0] = (double)(compteur_roi)/((double)roi1.size());
		p[1] = (double)(compteur_roi)/((double)roi2.size());
		return p;		
	}
	public static double pvalue_computation (double m1,Sequence seq1,ArrayList<ROI> liste1,ArrayList<ROI> liste2, ArrayList<ROI> cell, int nb_mc,int t)
	{double pvalue=0;		
	for (int i=1;i<nb_mc;i++){
		ArrayList<ROI> liste_new = randomization(liste2,cell,t);
		double[] coeffs = MandersCoeff(liste1, liste_new,cell,t);
		if (coeffs[0]>m1)
			pvalue+=1;
	}
	if (pvalue>0){
		return Math.log10(pvalue/nb_mc);}
	else
		return pvalue/nb_mc;	
	}
	public static double pvalue_computation_overlap (double m1,Sequence seq1,ArrayList<ROI> liste1,ArrayList<ROI> liste2, ArrayList<ROI> cell, int nb_mc,int t,double T)
	{double pvalue=0;		
	for (int i=1;i<nb_mc;i++){
		ArrayList<ROI> liste_new = randomization(liste2,cell,t);
		double[] coeffs = OverlapCoeff(seq1, liste1, liste_new,cell,t,T);
		if (coeffs[0]>m1)
			pvalue+=1;
	}
	if (pvalue>0){
		return Math.log10(pvalue/nb_mc);}
	else
		return pvalue/nb_mc;	
	}		
	public static ArrayList<ROI> randomization (ArrayList<ROI> liste, ArrayList<ROI> cell,int t){
		ArrayList<ROI> liste_retour = new ArrayList<ROI>();		
		BooleanMask2D mask = ROIUtil.getUnion(cell).getBooleanMask2D(0,t,0,true);
		Point[] mask_pts = mask.getPoints();
		int ind=0;
		while (ind<liste.size()){
			ROI r=liste.get(ind).getCopy();
			int indice = (int) (mask_pts.length*Math.random());
			Point5D newPosition = new Point5D.Double(mask_pts[indice].x, mask_pts[indice].y, 0, t, 0);
			r.setPosition5D(newPosition);
			if (ROIUtil.getUnion(cell).contains(r)){
				liste_retour.add(r);ind++;}			
		}			
		return liste_retour;			
	}
		
}
