package plugins.adufour.hcs.data;

import java.awt.geom.Rectangle2D;
import java.util.Arrays;

public class Field
{
    private final Well well;
    
    private final int ID;
    
    private final Rectangle2D.Double bounds;
    
    private String[] filePaths;
    
    public Field(Well well, int ID)
    {
        this(well, ID, Double.NaN, Double.NaN);
    }

    public Field(Well well, int ID, double x, double y)
    {
        this(well, ID, x, y, Double.NaN, Double.NaN, new String[0]);
    }
    
    public Field(Well well, int ID, double x, double y, double w, double h, String[] filePaths)
    {
        this.well = well;
        this.ID = ID;
        this.bounds = new Rectangle2D.Double(x, y, w, h);
        this.filePaths = filePaths;
    }
    
    public void addFilePath(String filePath)
    {
        int n = filePaths.length;
        filePaths = Arrays.copyOf(filePaths, n + 1);
        filePaths[n] = filePath;
    }
    
    public void setFieldSize(double w, double h)
    {
        bounds.width = w;
        bounds.height = h;
    }
    
    public int getID()
    {
        return ID;
    }
    
    public Rectangle2D getBounds()
    {
        return bounds;
    }
    
    public String[] getFilePaths()
    {
        return filePaths;
    }
    
    public Well getWell()
    {
        return well;
    }
    
    @Override
    public String toString()
    {
        return well.getAlphanumericID() + "#" + ID;
    }
}
