/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.math.windowing;

public class Windowing {
    public static double rectangle(double x, double N) {
        return Windowing.elliptical(x, N);
    }

    public static double elliptical(double x, double N) {
        if (x < -0.5 * N) {
            return 0.0;
        }
        if (x > 0.5 * N) {
            return 0.0;
        }
        return 1.0;
    }

    public static double bartlett(double x, double N) {
        return Windowing.triangle(x, N);
    }

    public static double triangle(double x, double N) {
        if (x < -0.5 * N) {
            return 0.0;
        }
        if (x > 0.5 * N) {
            return 0.0;
        }
        return 1.0 - Math.abs(2.0 * x / N);
    }

    public static double gaussian(double x, double N, double sigma) {
        if (x < -0.5 * N) {
            return 0.0;
        }
        if (x > 0.5 * N) {
            return 0.0;
        }
        return Math.exp(-0.5 * x * x / (sigma * sigma));
    }

    public static double gaussian(double x, double N) {
        if (x < -0.5 * N) {
            return 0.0;
        }
        if (x > 0.5 * N) {
            return 0.0;
        }
        double sigma = N / 3.0;
        return Math.exp(-0.5 * x * x / (sigma * sigma));
    }

    public static double supergaussian(double x, double N, double sigma) {
        if (x < -0.5 * N) {
            return 0.0;
        }
        if (x > 0.5 * N) {
            return 0.0;
        }
        return Math.exp(-0.5 * x * x * x * x * x * x / (sigma * sigma));
    }

    public static double supergaussian(double x, double N) {
        if (x < -0.5 * N) {
            return 0.0;
        }
        if (x > 0.5 * N) {
            return 0.0;
        }
        double sigma = N / 3.0;
        return Math.exp(-0.5 * x * x * x * x * x * x / (sigma * sigma));
    }

    public static double cosine(double x, double N) {
        if (x < -0.5 * N) {
            return 0.0;
        }
        if (x > 0.5 * N) {
            return 0.0;
        }
        double t = 2.0 * x / N;
        return Math.cos(1.5707963267948966 * t);
    }

    public static double raisedcosine(double x, double N, double power) {
        if (x < -0.5 * N) {
            return 0.0;
        }
        if (x > 0.5 * N) {
            return 0.0;
        }
        double t = 2.0 * x / N;
        return Math.pow(Math.cos(1.5707963267948966 * t), power);
    }

    public static double cubicspline(double x, double N) {
        double t = 2.0 * x / (0.5 * N);
        if (t < -2.0) {
            return 0.0;
        }
        if (t < -1.0) {
            return 0.25 * (t + 2.0) * (t + 2.0) * (t + 2.0);
        }
        if (t < 0.0) {
            return 0.25 * (-3.0 * t * t * t - 6.0 * t * t + 4.0);
        }
        if (t < 1.0) {
            return 0.25 * (3.0 * t * t * t - 6.0 * t * t + 4.0);
        }
        if (t < 2.0) {
            return 0.25 * (2.0 - t) * (2.0 - t) * (2.0 - t);
        }
        return 0.0;
    }

    public static double parzen(double x, double N) {
        if (x < -0.5 * N) {
            return 0.0;
        }
        if (x > 0.5 * N) {
            return 0.0;
        }
        double t = 2.0 * (x < 0.0 ? -x : x) / N;
        if (t < 0.5) {
            return 1.0 - 6.0 * t * t + 6.0 * t * t * t;
        }
        if (t < 1.0) {
            return 2.0 * (1.0 - t) * (1.0 - t) * (1.0 - t);
        }
        return 0.0;
    }

    public static double sigmoid(double x, double N, double slope) {
        return 1.0 / (1.0 + Math.exp(-slope * (x + N * 0.5))) - 1.0 / (1.0 + Math.exp(-slope * (x - N * 0.5)));
    }

    public static double hann(double x, double N) {
        if (x < -0.5 * N) {
            return 0.0;
        }
        if (x > 0.5 * N) {
            return 0.0;
        }
        double t = 2.0 * x / N;
        return Math.cos(1.5707963267948966 * t);
    }

    public static double hamming(double x, double N, double alpha) {
        if (x < -0.5 * N) {
            return 0.0;
        }
        if (x > 0.5 * N) {
            return 0.0;
        }
        double t = 2.0 * x / N;
        return alpha + (1.0 - alpha) * Math.cos(Math.PI * t);
    }

    public static double tukey(double x, double N, double alpha) {
        if (x < -0.5 * N) {
            return 0.0;
        }
        if (x > 0.5 * N) {
            return 0.0;
        }
        if (x > -0.5 * N + alpha && x < 0.5 * N - alpha) {
            return 1.0;
        }
        return Math.cos(Math.PI * ((2.0 * x - N) / (4.0 * alpha) + 0.5));
    }

    public static double exponential(double x, double N) {
        if (x < -0.5 * N) {
            return 0.0;
        }
        if (x > 0.5 * N) {
            return 0.0;
        }
        double k = 4.60517018599 / N;
        return Math.exp(-(x < 0.0 ? -x : x) * k);
    }

    public static double lanczos(double x, double N) {
        if (x < -0.5 * N) {
            return 0.0;
        }
        if (x > 0.5 * N) {
            return 0.0;
        }
        double t = 2.0 * x / N;
        if (t == 0.0) {
            return 1.0;
        }
        return Math.sin(Math.PI * t) / (Math.PI * t);
    }

    public static void main(String[] args) {
        double N = 20.0;
        String title = "t\trectangle\ttriangle\tgaussian3\tgaussian\tsupergaussian3\tsupergaussian\tcosine\traisedcosine\tcubicspline\tparzen\tsigmoid\thann\thamming\ttukey\texponential\tlanczos";
        System.out.println(title);
        double x = -25.0;
        while (x < 25.0) {
            double[] results = new double[]{x, Windowing.rectangle(x, N), Windowing.triangle(x, N), Windowing.gaussian(x, N, 3.0), Windowing.gaussian(x, N), Windowing.supergaussian(x, N, 3.0), Windowing.supergaussian(x, N), Windowing.cosine(x, N), Windowing.raisedcosine(x, N, 6.0), Windowing.cubicspline(x, N), Windowing.parzen(x, N), Windowing.sigmoid(x, N, 10.0), Windowing.hann(x, N), Windowing.hamming(x, N, 0.5), Windowing.tukey(x, N, 2.0), Windowing.exponential(x, N), Windowing.lanczos(x, N)};
            String s = "";
            int i = 0;
            while (i < results.length) {
                s = String.valueOf(s) + String.format("%2.3f\t ", results[i]);
                ++i;
            }
            System.out.println(s);
            x += 0.1;
        }
    }
}

