/*
 * Decompiled with CFR 0.152.
 */
package psf.defocusplane.lateral;

import psf.defocusplane.lateral.LateralFunction;

public class OrientedGaussian
extends LateralFunction {
    private double elongation = 2.0;
    private double cosa;
    private double sina;
    private double kgaussU;
    private double kgaussV;

    public OrientedGaussian(double sigma, double defocusFactor) {
        this.kgaussU = 1.0 / (sigma * sigma * this.elongation);
        this.kgaussV = 1.0 / (sigma * sigma / this.elongation);
        this.cosa = Math.cos(defocusFactor);
        this.sina = Math.sin(defocusFactor);
    }

    @Override
    public double eval(double x, double y) {
        double u = x * this.cosa + y * this.sina;
        double v = -x * this.sina + y * this.cosa;
        u = u * u * this.kgaussU;
        v = v * v * this.kgaussV;
        return Math.exp(-(u + v));
    }
}

