/*
 * Decompiled with CFR 0.152.
 */
package psf.defocussing;

import bilib.commons.components.GridToolbar;
import bilib.commons.components.SpinnerRangeDouble;
import bilib.commons.fft.BasicFFT;
import bilib.commons.job.runnable.Job;
import bilib.commons.job.runnable.Pool;
import bilib.commons.settings.Settings;
import javax.swing.JLabel;
import javax.swing.JPanel;
import psf.PSF;

public class DefocussingPSF
extends PSF {
    private double zi_Default = 2000.0;
    private double K_Default = 275.0;
    private double dTop_Default = 30.0;
    private double dMid_Default = 1.0;
    private double dBot_Default = 30.0;
    private double zi = this.zi_Default;
    private double K = this.K_Default;
    private double dTop = this.dTop_Default;
    private double dMid = this.dMid_Default;
    private double dBot = this.dBot_Default;
    private SpinnerRangeDouble spnZI = new SpinnerRangeDouble(this.zi_Default, 0.0, 10000.0, 1.0);
    private SpinnerRangeDouble spnK = new SpinnerRangeDouble(this.K_Default, 0.0, 10000.0, 1.0);
    private SpinnerRangeDouble spnDTop = new SpinnerRangeDouble(this.dTop_Default, 0.0, 10000.0, 1.0);
    private SpinnerRangeDouble spnDMid = new SpinnerRangeDouble(this.dMid_Default, 0.0, 10000.0, 1.0);
    private SpinnerRangeDouble spnDBot = new SpinnerRangeDouble(this.dBot_Default, 0.0, 10000.0, 1.0);

    public DefocussingPSF() {
        this.shortname = "Defocus";
        this.fullname = "Simulation of Lens Defocussing";
    }

    @Override
    public String getDescription() {
        String html = "<h1>Simulation of the lens defocussing</h1>";
        html = String.valueOf(html) + "<p>Simulation the defocussing of a microscope lens.";
        html = String.valueOf(html) + "It is defined by its optical transfer function (OTF) in";
        html = String.valueOf(html) + "the Fourier domain: OTF(&omega;) = exp(-&omega;<sup>2</sup>&sigma;<sup>2</sup>).&#124;sin(&xi)/&xi&#124;";
        html = String.valueOf(html) + "where &xi; = (d.&omega;.(1-&omega;)) / (K.(z<sub>i</sub>-d) and &sigma; = sqrt(3)";
        html = String.valueOf(html) + "d is the defocusing distance<p>";
        return html;
    }

    @Override
    public String checkSize(int nx, int ny, int nz) {
        if (nz < 3) {
            return "nz should be greater than 3.";
        }
        int mx = 1;
        while (mx < nx) {
            mx *= 2;
        }
        if (mx != nx) {
            return "nx should be a power of 2.";
        }
        int my = 1;
        while (my < ny) {
            my *= 2;
        }
        if (my != ny) {
            return "ny should be a power of 2.";
        }
        return "";
    }

    public void setParameters(double zi, double K, double dTop, double dMid, double dBot) {
        this.zi = zi;
        this.K = K;
        this.dTop = dTop;
        this.dMid = dMid;
        this.dBot = dBot;
    }

    @Override
    public void resetParameters() {
        this.spnZI.set(this.zi_Default);
        this.spnK.set(this.K_Default);
        this.spnDTop.set(this.dTop_Default);
        this.spnDMid.set(this.dMid_Default);
        this.spnDBot.set(this.dBot_Default);
    }

    @Override
    public void fetchParameters() {
        this.zi = this.spnZI.get();
        this.K = this.spnK.get();
        this.dTop = this.spnDTop.get();
        this.dMid = this.spnDMid.get();
        this.dBot = this.spnDBot.get();
    }

    @Override
    public JPanel buildPanel(Settings settings) {
        GridToolbar pn = new GridToolbar(false, 1);
        pn.place(1, 0, new JLabel("<html>z<sub>i</sub></html>"));
        pn.place(2, 0, new JLabel("<html>K (x 10<sup>-6</sup>)</html>"));
        pn.place(3, 0, new JLabel("<html>Out-of-focus - top</html>"));
        pn.place(4, 0, new JLabel("<html>Out-of-focus - middle</html>"));
        pn.place(5, 0, new JLabel("<html>Out-of-focus - bottom</html>"));
        pn.place(1, 1, this.spnZI);
        pn.place(2, 1, this.spnK);
        pn.place(3, 1, this.spnDTop);
        pn.place(4, 1, this.spnDMid);
        pn.place(5, 1, this.spnDBot);
        pn.place(1, 2, new JLabel("<html>[&mu;m]</html>"));
        pn.place(2, 2, new JLabel(""));
        pn.place(3, 2, new JLabel("<html>[&mu;m]</html>"));
        pn.place(4, 2, new JLabel("<html>[&mu;m]</html>"));
        pn.place(5, 2, new JLabel("<html>[&mu;m]</html>"));
        JPanel panel = new JPanel();
        panel.add(pn);
        settings.record("psf-" + this.shortname + "-ZI", this.spnZI, "" + this.zi_Default);
        settings.record("psf-" + this.shortname + "-K", this.spnK, "" + this.K_Default);
        settings.record("psf-" + this.shortname + "-DTop", this.spnDTop, "" + this.dTop_Default);
        settings.record("psf-" + this.shortname + "-DMid", this.spnDMid, "" + this.dMid_Default);
        settings.record("psf-" + this.shortname + "-DBot", this.spnDBot, "" + this.dBot_Default);
        return panel;
    }

    @Override
    public void generate(Pool pool) {
        int z = 0;
        while (z < this.nz) {
            Plane p = new Plane(z);
            p.addMonitor(this);
            pool.register(p);
            ++z;
        }
    }

    public class Plane
    extends Job {
        private int z;

        public Plane(int z) {
            this.z = z;
        }

        @Override
        public void process() {
            double r;
            int n = DefocussingPSF.this.nz / 2;
            double d = DefocussingPSF.this.dMid;
            if (this.z < n) {
                r = (double)(n - this.z) / (double)n;
                d = DefocussingPSF.this.dMid * (1.0 - r) + DefocussingPSF.this.dTop * r;
            }
            if (this.z == n) {
                d = DefocussingPSF.this.dMid;
            }
            if (this.z > n) {
                r = (double)(this.z - n) / (double)n;
                d = DefocussingPSF.this.dMid * (1.0 - r) + DefocussingPSF.this.dBot * r;
            }
            if (!this.live) {
                return;
            }
            double[] slice = this.create(d);
            if (!this.live) {
                return;
            }
            new BasicFFT().shift2D(slice, DefocussingPSF.this.nx, DefocussingPSF.this.ny);
            if (!this.live) {
                return;
            }
            DefocussingPSF.this.data.putXY(this.z, slice);
            this.increment(90.0 / (double)DefocussingPSF.this.nz, this.z + " / " + DefocussingPSF.this.nz);
        }

        private double[] create(double d) {
            double d_um = d * 1.0E-6;
            double zi_um = DefocussingPSF.this.zi * 1.0E-6;
            double K_um = DefocussingPSF.this.K * 1.0E-6;
            if (d_um == zi_um) {
                return new double[DefocussingPSF.this.nx * DefocussingPSF.this.ny];
            }
            double wm = d_um / (zi_um - d_um) / K_um;
            double sigma = Math.sqrt(3.0);
            int xsize = DefocussingPSF.this.nx / 2;
            int ysize = DefocussingPSF.this.ny / 2;
            double[][] function = new double[xsize + 1][ysize + 1];
            int y = 0;
            while (y <= xsize) {
                int x = 0;
                while (x <= xsize) {
                    double wx = Math.PI * (double)x / (double)xsize;
                    double wy = Math.PI * (double)y / (double)ysize;
                    double wr = Math.sqrt(wx * wx + wy * wy);
                    double s = wm * wr * (1.0 - wr);
                    double sinc = s == 0.0 ? 1.0 : Math.sin(s) / s;
                    if (sinc < 0.0) {
                        sinc = -sinc;
                    }
                    function[x][y] = Math.exp(-sigma * sigma * wr * wr) * sinc;
                    ++x;
                }
                ++y;
            }
            double[] real = new BasicFFT().fillHermitian2D(function);
            double[][] signal = new BasicFFT().inverse2D(real, new double[real.length], DefocussingPSF.this.nx, DefocussingPSF.this.ny);
            return signal[0];
        }
    }
}

