/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.components;

import java.awt.Dimension;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class HTMLPane
extends JEditorPane {
    private String html = "";
    private String header = "";
    private String footer = "";
    private Dimension dim;
    private String font = "verdana";
    private String color = "#222222";
    private String background = "#f8f8f8";

    public HTMLPane() {
        this.create();
    }

    public HTMLPane(String font) {
        this.font = font;
        this.create();
    }

    public HTMLPane(int width, int height) {
        this.dim = new Dimension(width, height);
        this.create();
    }

    public HTMLPane(String font, int width, int height) {
        this.font = font;
        this.dim = new Dimension(width, height);
        this.create();
    }

    public HTMLPane(String font, String color, String background, int width, int height) {
        this.font = font;
        this.dim = new Dimension(width, height);
        this.color = color;
        this.background = background;
        this.create();
    }

    @Override
    public String getText() {
        Document doc = this.getDocument();
        try {
            return doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return this.getText();
        }
    }

    public void clear() {
        this.html = "";
        this.append("");
    }

    private void create() {
        this.header = String.valueOf(this.header) + "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n";
        this.header = String.valueOf(this.header) + "<html><head>\n";
        this.header = String.valueOf(this.header) + "<style>body {background-color:" + this.background + "; color:" + this.color + "; font-family: " + this.font + ";margin:4px}</style>\n";
        this.header = String.valueOf(this.header) + "<style>h1 {color:#555555; font-size:1.0em; font-weight:bold; padding:1px; margin:1px;}</style>\n";
        this.header = String.valueOf(this.header) + "<style>h2 {color:#333333; font-size:0.9em; font-weight:bold; padding:1px; margin:1px;}</style>\n";
        this.header = String.valueOf(this.header) + "<style>h3 {color:#000000; font-size:0.9em; font-weight:italic; padding:1px; margin:1px;}</style>\n";
        this.header = String.valueOf(this.header) + "<style>p  {color:" + this.color + "; font-size:0.9em; padding:1px; margin:0px;}</style>\n";
        this.header = String.valueOf(this.header) + "</head>\n";
        this.header = String.valueOf(this.header) + "<body>\n";
        this.footer = String.valueOf(this.footer) + "</body></html>\n";
        this.setEditable(false);
        this.setContentType("text/html; charset=ISO-8859-1");
    }

    public void append(String content) {
        this.html = String.valueOf(this.html) + content;
        this.setText(String.valueOf(this.header) + this.html + this.footer);
        if (this.dim != null) {
            this.setPreferredSize(this.dim);
        }
        this.setCaretPosition(0);
    }

    public void append(String tag, String content) {
        this.html = String.valueOf(this.html) + "<" + tag + ">" + content + "</" + tag + ">";
        this.setText(String.valueOf(this.header) + this.html + this.footer);
        if (this.dim != null) {
            this.setPreferredSize(this.dim);
        }
        this.setCaretPosition(0);
    }

    public JScrollPane getPane() {
        JScrollPane scroll = new JScrollPane(this, 20, 30);
        scroll.setPreferredSize(this.dim);
        return scroll;
    }
}

