/*
 * Decompiled with CFR 0.152.
 */
import bilib.commons.buttons.ButtonFactory;
import bilib.commons.job.ExecutionMode;
import bilib.commons.job.JobEvent;
import bilib.commons.job.runnable.Pool;
import bilib.commons.job.runnable.PoolResponder;
import bilib.commons.settings.Settings;
import bilib.commons.utils.WebBrowser;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GUI;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import matlab.Converter;
import psf.PSF;
import psfgenerator.About;
import psfgenerator.CollectionPSF;
import psfgenerator.MainPanel;
import psfgenerator.ResultPlanesTable;
import psfgenerator.SummaryPanel;

public class PSFGenerator
implements ActionListener,
PoolResponder {
    private static String[] types = new String[]{"32-bits", "8-bits", "16-bits"};
    private static MainPanel panel;
    private HashMap<String, JButton> buttons = new HashMap();

    public static void main(String[] args) {
        ImagePlus imp;
        if (args.length > 1) {
            System.out.println("Run with a GUI: no expected argument.");
            System.out.println("Run without GUI: the argument has to be the configuration file which defines the parameters.");
            System.exit(0);
        }
        if (args.length == 0) {
            PSFGenerator generator = new PSFGenerator();
            generator.showFrame(true, null);
        }
        if (args.length == 1 && (imp = PSFGenerator.computeImagePlus(args[0])) != null) {
            System.out.println("Save " + imp.getTitle());
            IJ.saveAsTiff((ImagePlus)imp, (String)imp.getTitle());
        }
    }

    public static void gui() {
        PSFGenerator generator = new PSFGenerator();
        generator.showFrame(false, null);
    }

    public static Object get() {
        if (panel == null) {
            System.out.println("No open GUI");
            return "No open GUI";
        }
        panel.compute(ExecutionMode.MULTITHREAD_NO);
        PSF psf = panel.getLastPSF();
        int type = panel.getSelectedType();
        ImagePlus imp = new PSF_Generator().createImagePlus(psf, type);
        if (imp != null) {
            return Converter.get(imp);
        }
        return "ERROR";
    }

    public static Object compute(String config) {
        ArrayList<PSF> psfs = CollectionPSF.getStandardCollection();
        MainPanel panel = new MainPanel(new Settings("PSFGenerator", config), new HashMap<String, JButton>(), psfs, null, types, null);
        panel.compute(ExecutionMode.MULTITHREAD_NO);
        PSF psf = panel.getLastPSF();
        int type = panel.getSelectedType();
        ImagePlus imp = new PSF_Generator().createImagePlus(psf, type);
        if (imp != null) {
            return Converter.get(imp);
        }
        return "ERROR";
    }

    public static ImagePlus computeImagePlus(String config) {
        return PSFGenerator.computeImagePlus(new Settings("PSFGenerator", config));
    }

    private static ImagePlus computeImagePlus(Settings settings) {
        ArrayList<PSF> psfs = CollectionPSF.getStandardCollection();
        MainPanel panel = new MainPanel(settings, new HashMap<String, JButton>(), psfs, null, types, null);
        System.out.println("Computing " + panel.getSelectedPSFShortname());
        panel.compute(ExecutionMode.MULTITHREAD_NO);
        PSF psf = panel.getLastPSF();
        return new PSF_Generator().createImagePlus(psf, panel.getSelectedType());
    }

    public void close() {
        if (panel == null) {
            return;
        }
        panel.onClosed();
        panel = null;
    }

    public void showFrame(boolean withRun, String config) {
        if (config == null) {
            this.buildPanel(withRun, new Settings("PSFGenerator", null));
        } else {
            this.buildPanel(withRun, new Settings("PSFGenerator", config));
        }
        JFrame frame = new JFrame(About.title());
        frame.getContentPane().add(panel);
        frame.setResizable(false);
        frame.pack();
        GUI.center((Window)frame);
        frame.setVisible(true);
    }

    private void buildPanel(boolean withRunStop, Settings settings) {
        ArrayList<PSF> psfs = CollectionPSF.getStandardCollection();
        if (withRunStop) {
            this.buttons.put("run", ButtonFactory.run(true));
            this.buttons.put("stop", ButtonFactory.stop(true));
            this.buttons.put("about", ButtonFactory.about(false));
            this.buttons.put("close", new JButton("Exit"));
            this.buttons.get("close").addActionListener(this);
            this.buttons.get("about").addActionListener(this);
        }
        panel = new MainPanel(settings, this.buttons, psfs, null, types, this);
    }

    @Override
    public void onFailure(Pool pool, JobEvent event) {
        panel.setEnabledRun(true);
        Exception ex = event.getException();
        if (ex != null) {
            StackTraceElement[] elements = ex.getStackTrace();
            System.out.println("Exception " + ex.getMessage());
            StackTraceElement[] stackTraceElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement element = stackTraceElementArray[n2];
                IJ.log((String)element.toString());
                ++n2;
            }
        }
    }

    @Override
    public void onEvent(Pool pool, JobEvent event) {
    }

    @Override
    public void onSuccess(Pool pool, JobEvent event) {
        if (event.getJob() instanceof PSF) {
            int type = panel.getSelectedType();
            PSF psf = (PSF)event.getSource();
            panel.finish();
            ImagePlus imp = new PSF_Generator().createImagePlus(psf, type);
            imp.show();
            JFrame frame = new JFrame("Characterization of PSF");
            JTabbedPane tab = new JTabbedPane();
            tab.add("Summary", new SummaryPanel(psf));
            tab.add("Plane by plane", new ResultPlanesTable(psf));
            frame.getContentPane().add(tab);
            frame.pack();
            frame.setVisible(true);
        }
        panel.setEnabledRun(true);
    }

    public void exit() {
        if (panel != null) {
            panel.onClosed();
        }
        System.exit(0);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JButton bn = (JButton)event.getSource();
        if (bn == this.buttons.get("close")) {
            this.exit();
        }
        if (bn == this.buttons.get("help")) {
            WebBrowser.open(About.url());
        }
        if (bn == this.buttons.get("save")) {
            PSF psf = panel.getLastPSF();
            if (psf == null) {
                return;
            }
            int type = panel.getSelectedType();
            JFileChooser fc = new JFileChooser();
            FileNameExtensionFilter ext = new FileNameExtensionFilter("Stack TIF", "tif");
            fc.addChoosableFileFilter(ext);
            fc.setFileFilter(ext);
            fc.setSelectedFile(new File(String.valueOf(psf.getShortname()) + ".tif"));
            int ret = fc.showSaveDialog(new JFrame());
            if (ret == 0) {
                File file = fc.getSelectedFile();
                ImagePlus imp = new PSF_Generator().createImagePlus(psf, type);
                IJ.saveAsTiff((ImagePlus)imp, (String)file.getPath());
            }
        }
    }
}

