/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.fft;

public class BasicFFT {
    public double[] fillHermitian2D(double[][] realFunction) {
        int x;
        int xsize = realFunction.length - 1;
        int ysize = realFunction[0].length - 1;
        int nx = xsize * 2;
        int ny = ysize * 2;
        double[] signal = new double[nx * ny];
        int y = 0;
        while (y <= ysize) {
            x = 0;
            while (x <= xsize) {
                signal[x + nx * y] = realFunction[x][y];
                ++x;
            }
            ++y;
        }
        y = 0;
        while (y < ysize) {
            x = 0;
            while (x < xsize) {
                signal[nx - 1 - x + nx * y] = realFunction[x + 1][y];
                signal[nx - 1 - x + nx * (ny - 1 - y)] = realFunction[x + 1][y + 1];
                signal[x + nx * (ny - 1 - y)] = realFunction[x][y + 1];
                ++x;
            }
            ++y;
        }
        return signal;
    }

    public double[][] transform2D(double[] real, double[] imag, int nx, int ny) {
        double[][] signal = new double[2][nx * ny];
        double[] rowReal = new double[nx];
        double[] rowImag = new double[nx];
        int y = 0;
        while (y < ny) {
            int x = 0;
            while (x < nx) {
                rowReal[x] = real[x + y * nx];
                rowImag[x] = imag[x + y * nx];
                ++x;
            }
            this.transform1D(rowReal, rowImag);
            x = 0;
            while (x < nx) {
                signal[0][x + nx * y] = rowReal[x];
                signal[1][x + nx * y] = rowImag[x];
                ++x;
            }
            ++y;
        }
        double[] colReal = new double[ny];
        double[] colImag = new double[ny];
        int x = 0;
        while (x < nx) {
            int y2 = 0;
            while (y2 < ny) {
                colReal[y2] = signal[0][x + nx * y2];
                colImag[y2] = signal[1][x + nx * y2];
                ++y2;
            }
            this.transform1D(colReal, colImag);
            y2 = 0;
            while (y2 < ny) {
                signal[0][x + nx * y2] = colReal[y2];
                signal[1][x + nx * y2] = colImag[y2];
                ++y2;
            }
            ++x;
        }
        return signal;
    }

    public double[][] inverse2D(double[] real, double[] imag, int nx, int ny) {
        double[][] tmpreal = new double[nx][ny];
        double[][] tmpimag = new double[nx][ny];
        double[] colReal = new double[ny];
        double[] colImag = new double[ny];
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                colReal[y] = real[x + nx * y];
                colImag[y] = imag[x + nx * y];
                ++y;
            }
            this.inverseFFT1D(colReal, colImag);
            y = 0;
            while (y < ny) {
                tmpreal[x][y] = colReal[y];
                tmpimag[x][y] = colImag[y];
                ++y;
            }
            ++x;
        }
        double[] rowReal = new double[nx];
        double[] rowImag = new double[nx];
        double[][] signal = new double[2][nx * ny];
        int y = 0;
        while (y < ny) {
            int x2 = 0;
            while (x2 < nx) {
                rowReal[x2] = tmpreal[x2][y];
                rowImag[x2] = tmpimag[x2][y];
                ++x2;
            }
            this.inverseFFT1D(rowReal, rowImag);
            x2 = 0;
            while (x2 < nx) {
                signal[0][x2 + nx * y] = rowReal[x2];
                signal[1][x2 + nx * y] = rowImag[x2];
                ++x2;
            }
            ++y;
        }
        return signal;
    }

    public void transform1D(double[] real, double[] imag) {
        this.fft1D(real, imag);
    }

    public void inverseFFT1D(double[] real, double[] imag) {
        int size = real.length;
        int i = 0;
        while (i < size) {
            imag[i] = -imag[i];
            ++i;
        }
        this.fft1D(real, imag);
        i = 0;
        while (i < size) {
            real[i] = real[i] / (double)size;
            imag[i] = -imag[i] / (double)size;
            ++i;
        }
    }

    public void shift2D(double[] plane, int nx, int ny) {
        int nx2 = nx / 2;
        int ny2 = ny / 2;
        double[] tmp = new double[nx * ny];
        int x = 0;
        while (x < nx) {
            int i = x >= nx2 ? x - nx2 : x + nx2;
            int y = 0;
            while (y < ny) {
                tmp[i + nx * y] = plane[x + nx * y];
                ++y;
            }
            ++x;
        }
        int y = 0;
        while (y < ny) {
            int j = y >= ny2 ? y - ny2 : y + ny2;
            int x2 = 0;
            while (x2 < nx) {
                plane[x2 + nx * j] = tmp[x2 + nx * y];
                ++x2;
            }
            ++y;
        }
    }

    private void fft1D(double[] real, double[] imaginary) {
        double Imtmp;
        double Retmp;
        int j;
        int shift = 0;
        int size = real.length;
        int m = (int)Math.floor(Math.log(size) / Math.log(2.0));
        int n = 1 << m;
        double[] Imarg = new double[n];
        double[] Rearg = new double[n];
        double arg0 = Math.PI * 2 / (double)n;
        int i = 0;
        while (i < n) {
            double arg = arg0 * (double)i;
            Rearg[i] = Math.cos(arg);
            Imarg[i] = -Math.sin(arg);
            ++i;
        }
        i = j = shift;
        while (i < shift + n - 1) {
            if (i < j) {
                Retmp = real[i];
                Imtmp = imaginary[i];
                real[i] = real[j];
                imaginary[i] = imaginary[j];
                real[j] = Retmp;
                imaginary[j] = Imtmp;
            }
            int k = n >> 1;
            while (k + shift <= j) {
                j -= k;
                k /= 2;
            }
            j += k;
            ++i;
        }
        int stepsize = 1;
        int shifter = m - 1;
        while (stepsize < n) {
            j = shift;
            while (j < shift + n) {
                i = 0;
                while (i < stepsize) {
                    int i_j = i + j;
                    int i_j_s = i_j + stepsize;
                    if (i > 0) {
                        Retmp = Rearg[i << shifter] * real[i_j_s] - Imarg[i << shifter] * imaginary[i_j_s];
                        imaginary[i_j_s] = Rearg[i << shifter] * imaginary[i_j_s] + Imarg[i << shifter] * real[i_j_s];
                        real[i_j_s] = Retmp;
                    }
                    Retmp = real[i_j] - real[i_j_s];
                    Imtmp = imaginary[i_j] - imaginary[i_j_s];
                    int n2 = i_j;
                    real[n2] = real[n2] + real[i_j_s];
                    int n3 = i_j;
                    imaginary[n3] = imaginary[n3] + imaginary[i_j_s];
                    real[i_j_s] = Retmp;
                    imaginary[i_j_s] = Imtmp;
                    ++i;
                }
                j += stepsize << 1;
            }
            stepsize <<= 1;
            --shifter;
        }
    }
}

