/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.job;

import bilib.commons.job.MonitorAbstract;
import java.awt.Insets;
import java.text.DecimalFormat;
import javax.swing.JTextArea;
import javax.swing.text.DefaultCaret;

public class MonitorTimedLog
extends JTextArea
implements MonitorAbstract {
    private double chrono = System.nanoTime();

    public MonitorTimedLog(int rows, int columns) {
        super(rows, columns);
        this.setMargin(new Insets(5, 5, 5, 5));
        this.setEditable(false);
        DefaultCaret caret = (DefaultCaret)this.getCaret();
        caret.setUpdatePolicy(2);
    }

    @Override
    public void rewind() {
        this.chrono = System.nanoTime();
        this.setText("");
    }

    @Override
    public void print(String message) {
        this.update(message);
    }

    @Override
    public void error(String message) {
        this.update(message);
    }

    @Override
    public void warning(String message) {
        this.update(message);
    }

    @Override
    public void progress(double percentage) {
        this.update("Progression: " + percentage);
    }

    @Override
    public void progress(double percentage, String message) {
        this.update("Progression: " + percentage + " - ");
    }

    @Override
    public void increment(double percentage) {
        this.update("+ Progression: " + percentage);
    }

    @Override
    public void increment(double percentage, String message) {
        this.update("+ Progression: " + percentage + " - ");
    }

    private void update(String message) {
        this.append(String.valueOf(this.toc()) + " " + message + "\n");
        this.setCaretPosition(this.getDocument().getLength());
    }

    private String toc() {
        double te = (double)System.nanoTime() - this.chrono;
        String s = " ";
        DecimalFormat df = new DecimalFormat("####.##");
        if (te < 1000.0) {
            return String.valueOf(s) + df.format(te) + " ns";
        }
        if ((te /= 1000.0) < 1000.0) {
            return String.valueOf(s) + df.format(te) + " us";
        }
        if ((te /= 1000.0) < 3000.0) {
            return String.valueOf(s) + df.format(te) + " ms";
        }
        if ((te /= 1000.0) < 600.1) {
            return String.valueOf(s) + df.format(te) + " s";
        }
        if ((te /= 60.0) < 600.1) {
            return String.valueOf(s) + df.format(te) + " min.";
        }
        return String.valueOf(s) + df.format(te /= 60.0) + " h.";
    }
}

