/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.job.runnable;

import bilib.commons.job.ExecutionMode;
import bilib.commons.job.JobAbstract;
import bilib.commons.job.JobEvent;
import bilib.commons.job.PoolAbstract;
import bilib.commons.job.runnable.Job;
import bilib.commons.job.runnable.PoolResponder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class Pool
implements PoolAbstract {
    private ArrayList<Job> jobs = new ArrayList();
    protected String name;
    protected PoolResponder responder;
    protected HashMap<String, Future<Object>> results = new HashMap();

    public Pool(Job job, PoolResponder responder) {
        this.name = job.getName();
        this.responder = responder;
        this.register(job);
    }

    public Pool(String name, PoolResponder responder) {
        this.name = name;
        this.responder = responder;
    }

    @Override
    public void fire(JobEvent event) {
        byte t = event.getTypeEvent();
        if (this.responder != null) {
            this.responder.onEvent(this, event);
        }
        if (t == JobEvent.EXCEPTION) {
            this.die();
            if (this.responder != null) {
                this.responder.onFailure(this, event);
            }
        } else if (t == JobEvent.ABORTED) {
            this.die();
            if (this.responder != null) {
                this.responder.onFailure(this, event);
            }
        } else if (t == JobEvent.TIMEOUT) {
            this.die();
            if (this.responder != null) {
                this.responder.onFailure(this, event);
            }
        } else if (t == JobEvent.COMPLETED && this.isJobDone()) {
            this.die();
            if (this.responder != null) {
                this.responder.onSuccess(this, event);
            }
        }
    }

    @Override
    public void fire(JobAbstract parent, JobEvent event) {
        if (parent == null) {
            return;
        }
        if (parent.getPool() == null) {
            return;
        }
        if (event.getTypeEvent() == JobEvent.EXCEPTION) {
            parent.getPool().fire(new JobEvent(parent, event.getException(), event.getMessage()));
        } else {
            parent.getPool().fire(new JobEvent(parent, event.getTypeEvent(), event.getMessage()));
        }
    }

    public ArrayList<Job> getRegisteredJobs() {
        return this.jobs;
    }

    public Job getRegisteredJob(int i) {
        return this.jobs.get(i);
    }

    @Override
    public void execute(ExecutionMode mode) {
        this.execute(mode, this.jobs.size());
    }

    @Override
    public void execute(ExecutionMode mode, int nThreads) {
        for (Job job : this.jobs) {
            job.init();
        }
        if (mode == ExecutionMode.MULTITHREAD_NO) {
            for (Job job : this.jobs) {
                job.run();
            }
        } else {
            if (nThreads <= 0) {
                nThreads = this.jobs.size();
            }
            ExecutorService executor = Executors.newFixedThreadPool(nThreads);
            for (Job job : this.jobs) {
                Future<?> future = executor.submit(job);
                this.results.put(job.getName(), future);
            }
            executor.shutdown();
            if (mode == ExecutionMode.MULTITHREAD_SYNCHRONIZED) {
                this.waitTermination();
            }
        }
    }

    @Override
    public Future<Object> getFuture(String jobName) {
        if (this.jobs != null) {
            int i = 0;
            while (i < this.jobs.size()) {
                if (this.jobs.get(i).getName().equals(jobName)) {
                    return this.results.get(this.jobs.get(i).getName());
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public int size() {
        int s = 0;
        if (this.jobs != null) {
            s += this.jobs.size();
        }
        return s;
    }

    @Override
    public void cancel() {
        if (this.jobs != null) {
            for (Job job : this.jobs) {
                this.results.get(job.getName()).cancel(true);
            }
        }
    }

    @Override
    public void register(JobAbstract job) {
        if (this.jobs == null) {
            return;
        }
        if (job instanceof Job && this.jobs.add((Job)job)) {
            job.setName(String.valueOf(this.name) + "-" + this.jobs.size());
            job.setPool(this);
        }
    }

    @Override
    public void register(JobAbstract job, double timeoutms) {
        if (this.jobs == null) {
            return;
        }
        if (job instanceof Job && this.jobs.add((Job)job)) {
            job.setTimeOut(timeoutms);
            job.setName(String.valueOf(this.name) + "-" + this.jobs.size());
            job.setPool(this);
        }
    }

    @Override
    public void unregister(JobAbstract job) {
        if (this.jobs == null) {
            return;
        }
        if (job instanceof Job) {
            this.jobs.remove((Job)job);
            job.setPool(null);
        }
    }

    @Override
    public void unregisterAll() {
        if (this.jobs != null) {
            this.jobs.clear();
        }
    }

    @Override
    public boolean isJobDone() {
        int count = 0;
        if (this.jobs != null) {
            for (Job job : this.jobs) {
                if (!job.done) continue;
                ++count;
            }
            return count == this.jobs.size();
        }
        return false;
    }

    @Override
    public boolean isJobLive() {
        int count = 0;
        if (this.jobs != null) {
            for (Job job : this.jobs) {
                if (!job.live) continue;
                ++count;
            }
            return count == this.jobs.size();
        }
        return false;
    }

    @Override
    public boolean isJobIdle() {
        int count = 0;
        if (this.jobs != null) {
            for (Job job : this.jobs) {
                if (!job.idle) continue;
                ++count;
            }
            return count == this.jobs.size();
        }
        return false;
    }

    @Override
    public void waitTermination() {
        boolean termination = false;
        if (this.jobs != null) {
            while (!termination) {
                int count = 0;
                for (Job job : this.jobs) {
                    if (job.live) continue;
                    ++count;
                }
                boolean bl = termination = count >= this.jobs.size();
            }
        }
    }

    @Override
    public synchronized void die() {
        if (this.jobs != null) {
            for (Job job : this.jobs) {
                job.live = false;
                job.done = true;
            }
        }
    }

    public String toString() {
        String form = "";
        if (this.jobs != null) {
            form = this.jobs.getClass().getName();
        }
        return " Pool=(" + this.name + ", " + this.size() + " " + form + ") ";
    }

    @Override
    public String getName() {
        return this.name;
    }
}

