/*
 * Decompiled with CFR 0.152.
 */
package matlab;

import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ShortProcessor;

public class Converter {
    public static Object get(ImagePlus imageplus) {
        if (imageplus == null) {
            return null;
        }
        int width = imageplus.getWidth();
        int height = imageplus.getHeight();
        int stackSize = imageplus.getStackSize();
        int counter = 0;
        ImageStack imagestack = imageplus.getStack();
        switch (imageplus.getType()) {
            case 0: 
            case 3: {
                short[][][] is = new short[height][width][stackSize];
                int sz = 0;
                while (sz < stackSize) {
                    ByteProcessor byteprocessor = (ByteProcessor)imagestack.getProcessor(sz + 1);
                    byte[] pixels = (byte[])byteprocessor.getPixels();
                    counter = 0;
                    int h = 0;
                    while (h < height) {
                        int w = 0;
                        while (w < width) {
                            is[h][w][sz] = (short)(pixels[counter] & 0xFF);
                            ++w;
                            ++counter;
                        }
                        counter = ++h * width;
                    }
                    ++sz;
                }
                return is;
            }
            case 1: {
                int[][][] is = new int[height][width][stackSize];
                int sz = 0;
                while (sz < stackSize) {
                    counter = 0;
                    ShortProcessor shortprocessor = (ShortProcessor)imagestack.getProcessor(sz + 1);
                    short[] spixels = (short[])shortprocessor.getPixels();
                    int h = 0;
                    while (h < height) {
                        int w = 0;
                        while (w < width) {
                            is[h][w][sz] = spixels[counter] & 0xFFFF;
                            ++w;
                            ++counter;
                        }
                        counter = ++h * width;
                    }
                    ++sz;
                }
                return is;
            }
            case 2: {
                double[][][] fs = new double[height][width][stackSize];
                int sz = 0;
                while (sz < stackSize) {
                    FloatProcessor floatprocessor = (FloatProcessor)imagestack.getProcessor(sz + 1);
                    float[] fpixels = (float[])floatprocessor.getPixels();
                    counter = 0;
                    int i = 0;
                    while (i < height) {
                        int j = 0;
                        while (j < width) {
                            fs[i][j][sz] = fpixels[counter];
                            ++j;
                            ++counter;
                        }
                        counter = ++i * width;
                    }
                    ++sz;
                }
                return fs;
            }
            case 4: {
                if (stackSize == 1) {
                    short[][][] is = new short[height][width][3];
                    ColorProcessor colorprocessor = (ColorProcessor)imagestack.getProcessor(1);
                    byte[] red = new byte[width * height];
                    byte[] green = new byte[width * height];
                    byte[] blue = new byte[width * height];
                    colorprocessor.getRGB(red, green, blue);
                    counter = 0;
                    int h = 0;
                    while (h < height) {
                        int w = 0;
                        while (w < width) {
                            is[h][w][0] = (short)(red[counter] & 0xFF);
                            is[h][w][1] = (short)(green[counter] & 0xFF);
                            is[h][w][2] = (short)(blue[counter] & 0xFF);
                            ++w;
                            ++counter;
                        }
                        counter = ++h * width;
                    }
                    return is;
                }
                short[][][][] is = new short[height][width][stackSize][3];
                int sz = 0;
                while (sz < stackSize) {
                    ColorProcessor colorprocessor = (ColorProcessor)imagestack.getProcessor(sz + 1);
                    byte[] red = new byte[width * height];
                    byte[] green = new byte[width * height];
                    byte[] blue = new byte[width * height];
                    colorprocessor.getRGB(red, green, blue);
                    counter = 0;
                    int h = 0;
                    while (h < height) {
                        int w = 0;
                        while (w < width) {
                            is[h][w][sz][0] = red[counter];
                            is[h][w][sz][1] = green[counter];
                            is[h][w][sz][2] = blue[counter];
                            ++w;
                            ++counter;
                        }
                        counter = ++h * width;
                    }
                    ++sz;
                }
                return is;
            }
        }
        System.out.println("MIJ Error message: Unknow type of volumes.");
        return null;
    }
}

