/*
 * Decompiled with CFR 0.152.
 */
package psf;

import psf.Point3D;

public class Data3D {
    public double[][] data;
    public int nx;
    public int ny;
    public int nz;
    private int nxy;
    public Point3D max = new Point3D();
    public Point3D fwhm = new Point3D();
    public double energy;

    public Data3D(int nx, int ny, int nz) {
        this.nx = nx;
        this.ny = ny;
        this.nz = nz;
        this.nxy = nx * ny;
        this.data = new double[nz][nx * ny];
    }

    public byte[] createAsByte(int z) {
        byte[] p = new byte[this.nxy];
        int k = 0;
        while (k < this.nx * this.ny) {
            double v = this.data[z][k] * 255.0;
            p[k] = (byte)(v > 255.0 ? 255.0 : (v < 0.0 ? 0.0 : v));
            ++k;
        }
        return p;
    }

    public short[] createAsShort(int z) {
        short[] p = new short[this.nxy];
        int k = 0;
        while (k < this.nx * this.ny) {
            double v = this.data[z][k] * 65535.0;
            p[k] = (short)(v > 65535.0 ? 65535.0 : (v < 0.0 ? 0.0 : v));
            ++k;
        }
        return p;
    }

    public float[] createAsFloat(int z) {
        float[] p = new float[this.nxy];
        int k = 0;
        while (k < this.nx * this.ny) {
            double v = this.data[z][k];
            p[k] = (float)v;
            ++k;
        }
        return p;
    }

    public double[] createAsDouble(int z) {
        double[] p = new double[this.nxy];
        System.arraycopy(this.data[z], 0, p, 0, this.nxy);
        return p;
    }

    public int[] getHistogram(int nbins) {
        int[] histo = new int[nbins];
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                int k = 0;
                while (k < this.nz) {
                    int v = (int)(this.data[k][i + this.nx * j] * (double)nbins);
                    if (v >= 0) {
                        int n = v;
                        histo[n] = histo[n] + 1;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return histo;
    }

    public double[] getPlane(int z) {
        return this.data[z];
    }

    public void setPlane(int z, double[] plane) {
        this.data[z] = plane;
    }

    public void putXY(int z, double[] plane) {
        System.arraycopy(plane, 0, this.data[z], 0, this.nxy);
    }

    public void getXY(int z, double[] plane) {
        System.arraycopy(this.data[z], 0, plane, 0, this.nxy);
    }

    public void determineMaximumAndEnergy() {
        this.max.value = -1.7976931348623157E308;
        this.energy = 0.0;
        int z = 0;
        while (z < this.nz) {
            double[] slice = this.data[z];
            int k = 0;
            while (k < this.nxy) {
                this.energy += slice[k] * slice[k];
                if (this.max.value < slice[k]) {
                    this.max.value = slice[k];
                    this.max.x = k % this.nx;
                    this.max.y = k / this.nx;
                    this.max.z = z;
                }
                ++k;
            }
            ++z;
        }
    }

    public double getMaximum(int z) {
        double max = -1.7976931348623157E308;
        double[] slice = this.data[z];
        int k = 0;
        while (k < this.nxy) {
            if (max < slice[k]) {
                max = slice[k];
            }
            ++k;
        }
        return max;
    }

    public void multiply(double num) {
        int z = 0;
        while (z < this.nz) {
            double[] slice = this.data[z];
            int k = 0;
            while (k < this.nxy) {
                int n = k++;
                slice[n] = slice[n] * num;
            }
            ++z;
        }
    }

    public void clip(double lower, double upper) {
        int z = 0;
        while (z < this.nz) {
            double[] slice = this.data[z];
            int k = 0;
            while (k < this.nxy) {
                if (slice[k] > upper) {
                    slice[k] = upper;
                }
                if (slice[k] < lower) {
                    slice[k] = lower;
                }
                ++k;
            }
            ++z;
        }
    }

    public void rescale(int scale, double max) {
        block9: {
            int nxy;
            block11: {
                block10: {
                    block8: {
                        nxy = this.nx * this.ny;
                        if (scale != 0) break block8;
                        int z = 0;
                        while (z < this.nz) {
                            int k = 0;
                            while (k < nxy) {
                                double[] dArray = this.data[z];
                                int n = k++;
                                dArray[n] = dArray[n] / max;
                            }
                            ++z;
                        }
                        break block9;
                    }
                    if (scale != 1) break block10;
                    int z = 0;
                    while (z < this.nz) {
                        int k = 0;
                        while (k < nxy) {
                            this.data[z][k] = Math.log(this.data[z][k] <= 1.0E-6 ? 1.0E-6 : this.data[z][k] / max);
                            ++k;
                        }
                        ++z;
                    }
                    break block9;
                }
                if (scale != 2) break block11;
                int z = 0;
                while (z < this.nz) {
                    int k = 0;
                    while (k < nxy) {
                        this.data[z][k] = Math.sqrt(this.data[z][k] <= 1.0E-6 ? 1.0E-6 : this.data[z][k] / max);
                        ++k;
                    }
                    ++z;
                }
                break block9;
            }
            if (scale != 3) break block9;
            int z = 0;
            while (z < this.nz) {
                int k = 0;
                while (k < nxy) {
                    this.data[z][k] = 20.0 * Math.log10(this.data[z][k] <= 1.0E-6 ? 1.0E-6 : this.data[z][k] / max);
                    ++k;
                }
                ++z;
            }
        }
    }

    public double getNorm2() {
        double norm = 0.0;
        int z = 0;
        while (z < this.nz) {
            double[] slice = this.data[z];
            int k = 0;
            while (k < this.nxy) {
                norm += slice[k] * slice[k];
                ++k;
            }
            ++z;
        }
        return norm;
    }

    public double getNorm2(int z) {
        double norm = 0.0;
        double[] slice = this.data[z];
        int k = 0;
        while (k < this.nxy) {
            norm += slice[k] * slice[k];
            ++k;
        }
        return norm;
    }

    public double[][] getPlaneInformation() {
        double[][] p = new double[this.nz][4];
        int z = 0;
        while (z < this.nz) {
            double sliceMaxValue = this.getMaximum(z);
            double sliceEnergy = this.getNorm2(z);
            p[z][0] = z;
            p[z][1] = sliceMaxValue / this.max.value;
            p[z][2] = sliceEnergy / this.energy;
            double x0 = (double)(this.nx - 1) / 2.0;
            double y0 = (double)(this.ny - 1) / 2.0;
            double sum = 0.0;
            double sigma2 = 0.0;
            double value = 0.0;
            int x = 0;
            while (x < this.nx) {
                int y = 0;
                while (y < this.ny) {
                    value = this.data[z][x + this.nx * y];
                    sum += value;
                    sigma2 += value * (((double)x - x0) * ((double)x - x0) + ((double)y - y0) * ((double)y - y0));
                    ++y;
                }
                ++x;
            }
            p[z][3] = Math.sqrt(sigma2 / sum);
            ++z;
        }
        return p;
    }

    public void estimateFWHM() {
        int x = 0;
        int y = 0;
        int z = 0;
        double value = this.max.value;
        x = this.max.x;
        while (x < this.nx) {
            value = this.data[this.max.z][x + this.nx * this.max.y];
            if (value < this.max.value * 0.5) break;
            ++x;
        }
        int x2 = x;
        value = this.max.value;
        x = this.max.x;
        while (x < 0) {
            value = this.data[this.max.z][x + this.nx * this.max.y];
            if (value < this.max.value * 0.5) break;
            --x;
        }
        int x1 = x;
        value = this.max.value;
        y = this.max.y;
        while (y < this.ny) {
            value = this.data[this.max.z][this.max.x + this.nx * y];
            if (value < this.max.value * 0.5) break;
            ++y;
        }
        int y2 = y;
        value = this.max.value;
        y = this.max.y;
        while (y < 0) {
            value = this.data[this.max.z][this.max.x + this.nx * y];
            if (value < this.max.value * 0.5) break;
            --y;
        }
        int y1 = y;
        value = this.max.value;
        z = this.max.z;
        while (z < this.nz) {
            value = this.data[z][this.max.x + this.nx * this.max.y];
            if (value < this.max.value * 0.5) break;
            ++z;
        }
        int z2 = z;
        value = this.max.value;
        z = this.max.z;
        while (z < 0) {
            value = this.data[z][x + this.nx * this.max.y];
            if (value < this.max.value * 0.5) break;
            --z;
        }
        int z1 = z;
        this.fwhm.x = x2 - x1;
        this.fwhm.y = y2 - y1;
        this.fwhm.z = z2 - z1;
        this.fwhm.value = 0.0;
        z = z1;
        while (z <= Math.min(z2, this.nz - 1)) {
            x = x1;
            while (x <= Math.min(x2, this.nx - 1)) {
                y = y1;
                while (y <= Math.min(y2, this.ny - 1)) {
                    this.fwhm.value += this.data[z][x + this.nx * y];
                    ++y;
                }
                ++x;
            }
            ++z;
        }
    }
}

