/*
 * Decompiled with CFR 0.152.
 */
package psf;

import bilib.commons.job.ExecutionMode;
import bilib.commons.job.JobEvent;
import bilib.commons.job.runnable.Job;
import bilib.commons.job.runnable.Pool;
import bilib.commons.job.runnable.PoolResponder;
import bilib.commons.settings.Settings;
import javax.swing.JPanel;
import psf.Data3D;

public abstract class PSF
extends Job
implements PoolResponder {
    protected Data3D data;
    protected String fullname = "Untitled";
    protected String shortname = "...";
    public int nx;
    public int ny;
    public int nz;
    protected int type;
    private int scale;
    public double resLateral;
    public double resAxial;
    public double NA;
    public double lambda;
    private Pool pool;

    public Data3D getData() {
        return this.data;
    }

    public void setOpticsParameters(double NA, double lambdaNM) {
        this.NA = NA;
        this.lambda = lambdaNM * 1.0E-9;
    }

    public void setResolutionParameters(double resLateral, double resAxial) {
        this.resLateral = resLateral;
        this.resAxial = resAxial;
    }

    public void setOutputParameters(int nx, int ny, int nz, int type, int scale) {
        this.nx = nx;
        this.ny = ny;
        this.nz = nz;
        this.type = type;
        this.scale = scale;
    }

    @Override
    public void abort() {
        if (this.pool != null) {
            this.pool.die();
        }
        super.abort();
    }

    @Override
    public void process() {
        this.progress(1.0, "Starting " + this.getShortname() + "...");
        this.rewind();
        String errorSize = this.checkSize(this.nx, this.ny, this.nz);
        if (!errorSize.equals("")) {
            this.abort(errorSize);
            this.print(errorSize);
            return;
        }
        this.fetchParameters();
        this.data = new Data3D(this.nx, this.ny, this.nz);
        this.progress(4.0, "Init " + this.getShortname() + "...");
        this.pool = new Pool(this.shortname, (PoolResponder)this);
        this.generate(this.pool);
        this.progress(5.0, "Executing " + this.getShortname() + "...");
        this.pool.execute(ExecutionMode.MULTITHREAD_SYNCHRONIZED);
        this.data.determineMaximumAndEnergy();
        this.data.estimateFWHM();
        this.data.rescale(this.scale, this.data.max.value);
    }

    public double[] getPlane(int z) {
        return this.data.getPlane(z);
    }

    public void setPlane(int z, double[] plane) {
        this.data.setPlane(z, plane);
    }

    public String getShortname() {
        return this.shortname;
    }

    public String getFullname() {
        return this.fullname;
    }

    public abstract void generate(Pool var1);

    public abstract String checkSize(int var1, int var2, int var3);

    public abstract JPanel buildPanel(Settings var1);

    public abstract String getDescription();

    public abstract void resetParameters();

    public abstract void fetchParameters();

    @Override
    public void onFailure(Pool pool, JobEvent event) {
        this.getPool().fire(event);
    }

    @Override
    public void onEvent(Pool pool, JobEvent event) {
        this.getPool().fire(event);
    }

    @Override
    public void onSuccess(Pool pool, JobEvent event) {
        this.getPool().fire(event);
    }
}

