/*
 * Decompiled with CFR 0.152.
 */
package psf.bornwolf;

import bilib.commons.math.bessel.Bessel;

public class KirchhoffDiffractionSimpson {
    private double TOL = 0.1;
    private int K;
    private double NA = 1.4;
    private double lambda = 610.0;
    private double defocus = 1.0;
    private double ni = 1.5;

    public KirchhoffDiffractionSimpson(double defocus, double ni, int accuracy, double NA, double lambda) {
        this.NA = NA;
        this.lambda = lambda;
        this.defocus = defocus;
        this.ni = ni;
        this.K = accuracy == 0 ? 5 : (accuracy == 1 ? 7 : (accuracy == 2 ? 9 : 3));
    }

    double calculate(double r) {
        double[] sumOddIndex = new double[2];
        double[] sumEvenIndex = new double[2];
        double[] valueX0 = new double[2];
        double[] valueXn = new double[2];
        double[] value = new double[2];
        double curI = 0.0;
        double prevI = 0.0;
        int N = 2;
        double del = 0.5;
        int k = 0;
        int iteration = 1;
        double rho = 0.5;
        sumOddIndex = this.integrand(rho, r);
        sumEvenIndex[0] = 0.0;
        sumEvenIndex[1] = 0.0;
        valueX0 = this.integrand(0.0, r);
        valueXn = this.integrand(1.0, r);
        double realSum = valueX0[0] + 2.0 * sumEvenIndex[0] + 4.0 * sumOddIndex[0] + valueXn[0];
        double imagSum = valueX0[1] + 2.0 * sumEvenIndex[1] + 4.0 * sumOddIndex[1] + valueXn[1];
        prevI = curI = (realSum * realSum + imagSum * imagSum) * del * del;
        double curDifference = this.TOL;
        while (k < this.K && iteration < 10000) {
            ++iteration;
            N *= 2;
            del /= 2.0;
            sumEvenIndex[0] = sumEvenIndex[0] + sumOddIndex[0];
            sumEvenIndex[1] = sumEvenIndex[1] + sumOddIndex[1];
            sumOddIndex[0] = 0.0;
            sumOddIndex[1] = 0.0;
            int n = 1;
            while (n < N) {
                rho = (double)n * del;
                value = this.integrand(rho, r);
                sumOddIndex[0] = sumOddIndex[0] + value[0];
                sumOddIndex[1] = sumOddIndex[1] + value[1];
                n += 2;
            }
            realSum = valueX0[0] + 2.0 * sumEvenIndex[0] + 4.0 * sumOddIndex[0] + valueXn[0];
            imagSum = valueX0[1] + 2.0 * sumEvenIndex[1] + 4.0 * sumOddIndex[1] + valueXn[1];
            curI = (realSum * realSum + imagSum * imagSum) * del * del;
            curDifference = prevI == 0.0 ? Math.abs((prevI - curI) / 1.0E-5) : Math.abs((prevI - curI) / curI);
            k = curDifference <= this.TOL ? ++k : 0;
            prevI = curI;
        }
        return curI;
    }

    private double[] integrand(double rho, double r) {
        double k0 = Math.PI * 2 / this.lambda;
        double BesselValue = Bessel.J0(k0 * this.NA * r * rho);
        double[] I = new double[2];
        double OPD = this.NA * this.NA * this.defocus * rho * rho / (2.0 * this.ni);
        double W = k0 * OPD;
        I[0] = BesselValue * Math.cos(W) * rho;
        I[1] = -BesselValue * Math.sin(W) * rho;
        return I;
    }
}

