/*
 * Decompiled with CFR 0.152.
 */
package psf.defocusplane;

import bilib.commons.components.GridToolbar;
import bilib.commons.components.SpinnerRangeDouble;
import bilib.commons.job.runnable.Job;
import bilib.commons.job.runnable.Pool;
import bilib.commons.settings.Settings;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import psf.PSF;
import psf.defocusplane.ZFunction;
import psf.defocusplane.lateral.Astigmatism;
import psf.defocusplane.lateral.CardinalSin;
import psf.defocusplane.lateral.CircularPupil;
import psf.defocusplane.lateral.Cosine;
import psf.defocusplane.lateral.DoubleHelix;
import psf.defocusplane.lateral.Gaussian;
import psf.defocusplane.lateral.LateralFunction;
import psf.defocusplane.lateral.Lorentz;
import psf.defocusplane.lateral.OrientedGaussian;

public class DefocusPlanePSF
extends PSF {
    public static int GAUSSIAN = 0;
    public static int LORENTZ = 1;
    public static int SINC = 2;
    public static int COSINE = 3;
    public static int CIRCULAR = 4;
    public static int ASTIGMATISM = 5;
    public static int ROTATED_GAUSSIAN = 6;
    public static int DOUBLE_HELIX = 7;
    public static String[] namesXY = new String[]{"Gaussian", "Lorentz", "Cardinale-Sine", "Cosine", "Circular-Pupil", "Astigmatism", "Oriented-Gaussian", "Double-Helix"};
    private double zFocus_Default = 0.0;
    private double zDefocus_Default = 100.0;
    private int zfunction = 10;
    private int xyfunction = 0;
    private double zFocus = this.zFocus_Default;
    private double zDefocus = this.zDefocus_Default;
    private SpinnerRangeDouble spnFocus = new SpinnerRangeDouble(this.zFocus_Default, 0.0, 1000000.0, 1.0, 3);
    private SpinnerRangeDouble spnDefocus = new SpinnerRangeDouble(this.zDefocus_Default, 0.0, 1000000.0, 1.0, 3);
    private JComboBox cmbAxial = new JComboBox<String>(ZFunction.names);

    public DefocusPlanePSF(int xyfunction) {
        this.fullname = "Lateral (" + namesXY[xyfunction] + ") and Axial Definition";
        this.shortname = namesXY[xyfunction];
        this.xyfunction = xyfunction;
    }

    @Override
    public String checkSize(int nx, int ny, int nz) {
        if (nz < 3) {
            return "nz should be greater than 3.";
        }
        if (nx < 4) {
            return "nx should be greater than 4.";
        }
        if (ny < 4) {
            return "ny should be greater than 4.";
        }
        return "";
    }

    @Override
    public void resetParameters() {
        this.spnFocus.set(this.zFocus_Default);
        this.spnDefocus.set(this.zDefocus_Default);
        this.cmbAxial.setSelectedIndex(0);
    }

    @Override
    public void fetchParameters() {
        this.zFocus = this.spnFocus.get();
        this.zDefocus = this.spnDefocus.get();
        this.zfunction = this.cmbAxial.getSelectedIndex();
    }

    @Override
    public JPanel buildPanel(Settings settings) {
        GridToolbar pn = new GridToolbar(false);
        pn.place(3, 0, "<html>Z function</sub></html>");
        pn.place(4, 0, "<html>Z focal plane</sub></html>");
        pn.place(5, 0, "<html>Z defocused plane (x2)</html>");
        pn.place(3, 1, 2, 1, this.cmbAxial);
        pn.place(4, 1, this.spnFocus);
        pn.place(5, 1, this.spnDefocus);
        pn.place(4, 2, "[nm]");
        pn.place(5, 2, "[nm]");
        JPanel panel = new JPanel();
        panel.add(pn);
        settings.record("psf-" + this.shortname + "-focus", this.spnFocus, "" + this.zFocus_Default);
        settings.record("psf-" + this.shortname + "-defocus", this.spnDefocus, "" + this.zDefocus_Default);
        settings.record("psf-" + this.shortname + "-axial", this.cmbAxial, "" + this.cmbAxial.getItemAt(0));
        return panel;
    }

    @Override
    public String getDescription() {
        String desc = "<h1>" + this.fullname + "</h1>";
        desc = String.valueOf(desc) + "<p>These synthetic PSFs are defined by the tensor product of 2 functions, ";
        desc = String.valueOf(desc) + "the lateral 2D function and the axial Z-function. ";
        desc = String.valueOf(desc) + "At the Z defocussed plane the 2D lateral function is two times larger than ";
        desc = String.valueOf(desc) + "the focal plane.</p>";
        return desc;
    }

    @Override
    public void generate(Pool pool) {
        int z = 0;
        while (z < this.nz) {
            Plane p = new Plane(z);
            p.addMonitor(this);
            pool.register(p);
            ++z;
        }
    }

    public class Plane
    extends Job {
        private int z;

        public Plane(int z) {
            this.z = z;
        }

        @Override
        public void process() {
            int y;
            ZFunction zfunc = new ZFunction(DefocusPlanePSF.this.zfunction, DefocusPlanePSF.this.zDefocus / DefocusPlanePSF.this.resAxial, DefocusPlanePSF.this.zFocus / DefocusPlanePSF.this.resAxial);
            double fwhm = 0.5 * DefocusPlanePSF.this.lambda / DefocusPlanePSF.this.NA;
            double radiusPix = fwhm / 2.35482005 / (DefocusPlanePSF.this.resLateral * 1.0E-9);
            double[] array = new double[DefocusPlanePSF.this.nx * DefocusPlanePSF.this.ny];
            double defocusFactor = zfunc.getDefocusFactor(this.z);
            LateralFunction func = null;
            if (DefocusPlanePSF.this.xyfunction == GAUSSIAN) {
                func = new Gaussian(radiusPix, defocusFactor);
            } else if (DefocusPlanePSF.this.xyfunction == LORENTZ) {
                func = new Lorentz(radiusPix, defocusFactor);
            } else if (DefocusPlanePSF.this.xyfunction == SINC) {
                func = new CardinalSin(radiusPix, defocusFactor);
            } else if (DefocusPlanePSF.this.xyfunction == COSINE) {
                func = new Cosine(radiusPix, defocusFactor);
            } else if (DefocusPlanePSF.this.xyfunction == CIRCULAR) {
                func = new CircularPupil(radiusPix, defocusFactor);
            } else if (DefocusPlanePSF.this.xyfunction == ASTIGMATISM) {
                func = new Astigmatism(radiusPix, defocusFactor);
            } else if (DefocusPlanePSF.this.xyfunction == ROTATED_GAUSSIAN) {
                func = new OrientedGaussian(radiusPix, defocusFactor);
            } else if (DefocusPlanePSF.this.xyfunction == DOUBLE_HELIX) {
                func = new DoubleHelix(radiusPix, defocusFactor);
            } else {
                return;
            }
            double xo = (double)DefocusPlanePSF.this.nx * 0.5;
            double yo = (double)DefocusPlanePSF.this.ny * 0.5;
            double v = 0.0;
            double integral = 0.0;
            int x = 0;
            while (x < DefocusPlanePSF.this.nx & this.live) {
                y = 0;
                while (y < DefocusPlanePSF.this.ny) {
                    array[x + DefocusPlanePSF.this.nx * y] = v = func.eval((double)x - xo, (double)y - yo);
                    integral += v;
                    ++y;
                }
                if (!this.live) {
                    return;
                }
                ++x;
            }
            x = 0;
            while (x < DefocusPlanePSF.this.nx & this.live) {
                y = 0;
                while (y < DefocusPlanePSF.this.ny) {
                    int n = x + DefocusPlanePSF.this.nx * y;
                    array[n] = array[n] / integral;
                    ++y;
                }
                if (!this.live) {
                    return;
                }
                ++x;
            }
            this.increment(90.0 / (double)DefocusPlanePSF.this.nz, this.z + "/" + DefocusPlanePSF.this.nz);
            DefocusPlanePSF.this.data.putXY(this.z, array);
        }
    }
}

