/*
 * Decompiled with CFR 0.152.
 */
package psf.defocusplane.lateral;

import psf.defocusplane.lateral.LateralFunction;

public class Astigmatism
extends LateralFunction {
    private double sigma;
    private double kx;
    private double ky;

    public Astigmatism(double radius, double defocusFactor) {
        this.sigma = 0.8493218 * radius;
        double dy = defocusFactor * 1.5 - 1.0;
        double dx = 1.0 / dy;
        this.kx = 1.0 / (dx * dx * this.sigma * this.sigma * 2.0);
        this.ky = 1.0 / (dy * dy * this.sigma * this.sigma * 2.0);
    }

    @Override
    public double eval(double x, double y) {
        return Math.exp(-x * x * this.kx - y * y * this.ky);
    }
}

