/*
 * Decompiled with CFR 0.152.
 */
package psf.koehler;

import bilib.commons.components.GridToolbar;
import bilib.commons.components.SpinnerRangeDouble;
import bilib.commons.fft.BasicFFT;
import bilib.commons.job.runnable.Job;
import bilib.commons.job.runnable.Pool;
import bilib.commons.settings.Settings;
import javax.swing.JPanel;
import psf.PSF;

public class KoehlerPSF
extends PSF {
    private double dTop_Default = 6.0;
    private double dMid_Default = 3.0;
    private double dBot_Default = 6.0;
    private double n0_Default = 1.5;
    private double n1_Default = 1.0;
    private double dTop = this.dTop_Default;
    private double dMid = this.dMid_Default;
    private double dBot = this.dBot_Default;
    private double n0 = this.n0_Default;
    private double n1 = this.n1_Default;
    private SpinnerRangeDouble spnN0 = new SpinnerRangeDouble(this.n0_Default, 0.0, 10000.0, 1.0);
    private SpinnerRangeDouble spnN1 = new SpinnerRangeDouble(this.n1_Default, 0.0, 10000.0, 1.0);
    private SpinnerRangeDouble spnDTop = new SpinnerRangeDouble(this.dTop_Default, 0.0, 1000000.0, 1.0);
    private SpinnerRangeDouble spnDMid = new SpinnerRangeDouble(this.dMid_Default, 0.0, 1000000.0, 1.0);
    private SpinnerRangeDouble spnDBot = new SpinnerRangeDouble(this.dBot_Default, 0.0, 1000000.0, 1.0);

    public KoehlerPSF() {
        this.shortname = "Koehler";
        this.fullname = "Koehler Illumination - OTF Definition";
    }

    @Override
    public void resetParameters() {
        this.spnN0.set(this.n0_Default);
        this.spnN1.set(this.n1_Default);
        this.spnDTop.set(this.dTop_Default);
        this.spnDMid.set(this.dMid_Default);
        this.spnDBot.set(this.dBot_Default);
    }

    @Override
    public String checkSize(int nx, int ny, int nz) {
        if (nz < 3) {
            return "nz should be greater than 3.";
        }
        int mx = 1;
        while (mx < nx) {
            mx *= 2;
        }
        if (mx != nx) {
            return "nx should be a power of 2.";
        }
        int my = 1;
        while (my < ny) {
            my *= 2;
        }
        if (my != ny) {
            return "ny should be a power of 2.";
        }
        return "";
    }

    @Override
    public void fetchParameters() {
        this.n0 = this.spnN0.get();
        this.n1 = this.spnN1.get();
        this.dTop = this.spnDTop.get();
        this.dMid = this.spnDMid.get();
        this.dBot = this.spnDBot.get();
    }

    @Override
    public JPanel buildPanel(Settings settings) {
        GridToolbar pn = new GridToolbar(false, 1);
        pn.place(1, 0, "<html>Refractive index &nu;<sub>0</sub></html>");
        pn.place(2, 0, "<html>Refractive index &nu;<sub>1</sub></html>");
        pn.place(3, 0, "<html>Out-of-focus - top</html>");
        pn.place(4, 0, "<html>Out-of-focus - middle</html>");
        pn.place(5, 0, "<html>Out-of-focus - bottom</html>");
        pn.place(1, 1, this.spnN0);
        pn.place(2, 1, this.spnN1);
        pn.place(3, 1, this.spnDTop);
        pn.place(4, 1, this.spnDMid);
        pn.place(5, 1, this.spnDBot);
        pn.place(1, 2, "");
        pn.place(2, 2, "");
        pn.place(3, 2, "<html>[&mu;m]</html>");
        pn.place(4, 2, "<html>[&mu;m]</html>");
        pn.place(5, 2, "<html>[&mu;m]</html>");
        JPanel panel = new JPanel();
        panel.add(pn);
        settings.record("psf-" + this.shortname + "-n0", this.spnN0, "" + this.n0_Default);
        settings.record("psf-" + this.shortname + "-n1", this.spnN1, "" + this.n1_Default);
        settings.record("psf-" + this.shortname + "-dTop", this.spnDTop, "" + this.n0_Default);
        settings.record("psf-" + this.shortname + "-dMid", this.spnDMid, "" + this.dMid_Default);
        settings.record("psf-" + this.shortname + "-dBot", this.spnDBot, "" + this.dBot_Default);
        return panel;
    }

    @Override
    public String getDescription() {
        String desc = "<h1>" + this.fullname + "</h1>";
        desc = String.valueOf(desc) + "<p>Simulates a defocussing effect due to the K&ouml;hler ";
        desc = String.valueOf(desc) + "illumination in a brightfield microscope. The ";
        desc = String.valueOf(desc) + "optical transfer function in the Fourier domain is ";
        desc = String.valueOf(desc) + "OTF(&omega;) = exp(-&omega;<sup>2</sup>&sigma;<sup>2</sup>/2),";
        desc = String.valueOf(desc) + "where &sigma; = &nu;<sub>0</sub> + &nu;<sub>1</sub>.(d+z)</p>";
        return desc;
    }

    @Override
    public void generate(Pool pool) {
        int z = 0;
        while (z < this.nz) {
            Plane p = new Plane(z);
            p.addMonitor(this);
            pool.register(p);
            ++z;
        }
    }

    public class Plane
    extends Job {
        private int z;

        public Plane(int z) {
            this.z = z;
        }

        @Override
        public void process() {
            double r;
            double z0 = (double)(KoehlerPSF.this.nz - 1) / 2.0;
            double d = 0.0;
            if ((double)this.z < z0) {
                r = (z0 - (double)this.z) / z0;
                d = KoehlerPSF.this.dMid * (1.0 - r) + KoehlerPSF.this.dTop * r;
            }
            if ((double)this.z >= z0) {
                r = ((double)this.z - z0) / z0;
                d = KoehlerPSF.this.dMid * (1.0 - r) + KoehlerPSF.this.dBot * r;
            }
            if (!this.live) {
                return;
            }
            double[] slice = this.create(d + (double)this.z);
            if (!this.live) {
                return;
            }
            new BasicFFT().shift2D(slice, KoehlerPSF.this.nx, KoehlerPSF.this.ny);
            if (!this.live) {
                return;
            }
            ((KoehlerPSF)KoehlerPSF.this).data.data[this.z] = slice;
            this.increment(90.0 / (double)KoehlerPSF.this.nz, this.z + " / " + KoehlerPSF.this.nz);
        }

        private double[] create(double d) {
            double sigma = KoehlerPSF.this.n0 + KoehlerPSF.this.n1 * Math.abs(d);
            int xsize = KoehlerPSF.this.nx / 2 + 1;
            int ysize = KoehlerPSF.this.ny / 2 + 1;
            double ampl = 1.0;
            double[][] function = new double[xsize][ysize];
            int y = 0;
            while (y < xsize) {
                int x = 0;
                while (x < ysize) {
                    double wx = Math.PI * (double)x / (double)xsize;
                    double wy = Math.PI * (double)y / (double)ysize;
                    double wr = Math.sqrt(wx * wx + wy * wy);
                    function[x][y] = ampl * Math.exp(-wr * wr * sigma * sigma / 2.0);
                    ++x;
                }
                ++y;
            }
            double[] real = new BasicFFT().fillHermitian2D(function);
            double[][] signal = new BasicFFT().inverse2D(real, new double[real.length], KoehlerPSF.this.nx, KoehlerPSF.this.ny);
            return signal[0];
        }
    }
}

