/*
 * Decompiled with CFR 0.152.
 */
package plugins.mitiv.io;

import icy.file.Saver;
import icy.main.Icy;
import icy.sequence.Sequence;
import java.io.File;
import mitiv.array.ShapedArray;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.utils.Imager;
import plugins.mitiv.io.Icy2TiPi;

public class IcyImager
implements Imager {
    protected boolean headless = false;
    protected String title;
    private Sequence sequence;

    public IcyImager(Sequence seq, boolean headless) {
        this.sequence = seq;
        this.headless = headless;
    }

    public IcyImager(Sequence seq) {
        this.sequence = seq;
    }

    public IcyImager(boolean headless) {
        this.headless = headless;
    }

    public static void show(ShapedArray arr, Sequence sequence, String title, boolean headless) {
        if (sequence == null) {
            sequence = new Sequence();
            if (headless) {
                Icy.getMainInterface().addSequence(sequence);
            }
        }
        sequence.beginUpdate();
        sequence = Icy2TiPi.arrayToSequence(arr, sequence);
        if (sequence.getFirstViewer() == null && !headless) {
            Icy.getMainInterface().addSequence(sequence);
        }
        sequence.endUpdate();
        sequence.setName(title);
    }

    public void show(ShapedArray arr) {
        IcyImager.show(arr, this.sequence, this.title, this.headless);
    }

    public void show(ShapedVector vec) {
        this.show(vec.asShapedArray());
    }

    public void show(ShapedArray arr, String title) {
        this.title = title;
        IcyImager.show(arr, this.sequence, title, this.headless);
    }

    public void show(ShapedVector vec, String title) {
        this.show(vec.asShapedArray(), title);
    }

    protected void show(ShapedVector arr, Sequence sequence, String title) {
        this.title = title;
        this.sequence = sequence;
        this.show(arr.asShapedArray());
    }

    public void save(ShapedVector vec, String path) {
        this.save(vec.asShapedArray(), path);
    }

    public void save(ShapedArray arr, String path) {
        IcyImager.save(arr, this.sequence, path);
    }

    public static void save(ShapedArray arr, Sequence sequence, String path) {
        if (sequence == null) {
            if (arr == null) {
                return;
            }
            sequence = new Sequence();
        }
        if (arr != null) {
            sequence = Icy2TiPi.arrayToSequence(arr, sequence);
        }
        if (path != null) {
            File f = new File(path);
            if (f.isDirectory()) {
                f = new File(f.getAbsolutePath() + File.separator + sequence + ".tif");
            }
            Saver.save((Sequence)sequence, (File)f, (boolean)false, (boolean)false);
        }
    }

    public static void save(Sequence sequence, String path) {
        if (sequence == null) {
            return;
        }
        if (path != null) {
            File f = new File(path);
            if (f.isDirectory()) {
                f = new File(f.getAbsolutePath() + File.separator + sequence + ".tif");
            }
            Saver.save((Sequence)sequence, (File)f, (boolean)false, (boolean)false);
        }
    }
}

