/*
 * Decompiled with CFR 0.152.
 */
package plugins.ofuica.h5importer;

import bdv.BigDataViewer;
import bdv.img.cache.CachedCellImg;
import bdv.img.hdf5.Hdf5ImageLoader;
import bdv.img.hdf5.MipmapInfo;
import bdv.spimdata.SequenceDescriptionMinimal;
import bdv.spimdata.SpimDataMinimal;
import bdv.spimdata.XmlIoSpimDataMinimal;
import bdv.tools.brightness.ConverterSetup;
import bdv.viewer.SourceAndConverter;
import icy.common.exception.UnsupportedFormatException;
import icy.file.FileUtil;
import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.plugin.PluginLoader;
import icy.plugin.abstract_.PluginSequenceFileImporter;
import icy.sequence.MetaDataUtil;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import loci.formats.gui.ExtensionFileFilter;
import loci.formats.ome.OMEXMLMetadataImpl;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import net.imagej.Extents;
import net.imagej.Position;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.cell.CellRandomAccess;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import ome.xml.meta.OMEXMLMetadata;

public class H5Importer
extends PluginSequenceFileImporter {
    private SpimDataMinimal spimData_ = null;
    private Hdf5ImageLoader hdf5ImageLoader_ = null;
    private final ArrayList<ConverterSetup> converterSetups_ = new ArrayList();
    private final ArrayList<SourceAndConverter<?>> sources_ = new ArrayList();
    private String xmlFile_ = null;

    public void close() throws IOException {
        this.sources_.clear();
        this.converterSetups_.clear();
        this.hdf5ImageLoader_.close();
    }

    public OMEXMLMetadataImpl getMetaData() throws UnsupportedFormatException, IOException {
        int defaultResolution = 0;
        return this.getMetaData(defaultResolution);
    }

    public OMEXMLMetadataImpl getMetaData(int resolution) throws UnsupportedFormatException, IOException {
        OMEXMLMetadataImpl metaData = new OMEXMLMetadataImpl();
        AbstractSequenceDescription seq = this.spimData_.getSequenceDescription();
        if (resolution >= this.getResolutions(0).length) {
            return null;
        }
        int series = ((SequenceDescriptionMinimal)this.spimData_.getSequenceDescription()).getViewSetups().size();
        TimePoints timePoints = ((SequenceDescriptionMinimal)this.spimData_.getSequenceDescription()).getTimePoints();
        TimePoint initialTimePoint = (TimePoint)timePoints.getTimePointsOrdered().get(0);
        MetaDataUtil.setNumSerie((OMEXMLMetadataImpl)metaData, (int)series);
        int serie = 0;
        while (serie < series) {
            double[][] resolutions = this.getResolutions(serie);
            if (resolution < resolutions.length) {
                double div = resolutions[resolution][0];
                Hdf5ImageLoader.SetupImgLoader setup = this.hdf5ImageLoader_.getSetupImgLoader(serie);
                Dimensions dims = setup.getImageSize(initialTimePoint.getId());
                String name = String.valueOf(FileUtil.getFileName((String)this.hdf5ImageLoader_.getHdf5File().getAbsolutePath(), (boolean)false)) + " (" + serie + ")";
                MetaDataUtil.setName((OMEXMLMetadataImpl)metaData, (int)serie, (String)name);
                MetaDataUtil.setSizeX((OMEXMLMetadataImpl)metaData, (int)serie, (int)new Long((long)((double)dims.dimension(0) / div)).intValue());
                MetaDataUtil.setSizeY((OMEXMLMetadataImpl)metaData, (int)serie, (int)new Long((long)((double)dims.dimension(1) / div)).intValue());
                MetaDataUtil.setSizeZ((OMEXMLMetadataImpl)metaData, (int)serie, (int)new Long((long)((double)dims.dimension(2) / div)).intValue());
                MetaDataUtil.setSizeT((OMEXMLMetadataImpl)metaData, (int)serie, (int)seq.getTimePoints().size());
                MetaDataUtil.setSizeC((OMEXMLMetadataImpl)metaData, (int)serie, (int)1);
                MetaDataUtil.setDataType((OMEXMLMetadataImpl)metaData, (int)serie, (DataType)this.getDataType(resolution));
            }
            ++serie;
        }
        return metaData;
    }

    public int getTileWidth(int serie) throws UnsupportedFormatException, IOException {
        Hdf5ImageLoader.SetupImgLoader setup = this.hdf5ImageLoader_.getSetupImgLoader(serie);
        MipmapInfo mipmapInfo = setup.getMipmapInfo();
        int resolutionLvl = mipmapInfo.getMaxLevel();
        int[][] subDivisions = this.hdf5ImageLoader_.getSetupImgLoader(serie).getMipmapInfo().getSubdivisions();
        return subDivisions[resolutionLvl][0];
    }

    public int getTileHeight(int serie) throws UnsupportedFormatException, IOException {
        Hdf5ImageLoader.SetupImgLoader setup = this.hdf5ImageLoader_.getSetupImgLoader(serie);
        MipmapInfo mipmapInfo = setup.getMipmapInfo();
        int resolutionLvl = mipmapInfo.getMaxLevel();
        int[][] subDivisions = this.hdf5ImageLoader_.getSetupImgLoader(serie).getMipmapInfo().getSubdivisions();
        return subDivisions[resolutionLvl][1];
    }

    public IcyBufferedImage getThumbnail(int serie) throws UnsupportedFormatException, IOException {
        Hdf5ImageLoader.SetupImgLoader setup = this.hdf5ImageLoader_.getSetupImgLoader(serie);
        MipmapInfo mipmapInfo = setup.getMipmapInfo();
        int resolutionLvl = mipmapInfo.getMaxLevel();
        OMEXMLMetadataImpl metaData = this.getMetaData(resolutionLvl);
        double scale = Math.pow(2.0, resolutionLvl);
        int sizeT = MetaDataUtil.getSizeT((OMEXMLMetadataImpl)metaData, (int)serie);
        int sizeZ = (int)((double)MetaDataUtil.getSizeZ((OMEXMLMetadataImpl)metaData, (int)serie) / scale);
        return this.getImage(serie, resolutionLvl, sizeZ / 2, sizeT / 2);
    }

    public Object getPixels(int serie, int resolution, Rectangle rectangle, int z, int t, int c) throws UnsupportedFormatException, IOException {
        return this.getPixels(serie, resolution, rectangle, z, t, c, false);
    }

    private Object StackToPlanarXY(RandomAccessibleInterval<?> stack, Rectangle rectangle, int z) throws UnsupportedFormatException {
        if (!(stack instanceof CachedCellImg)) {
            throw new UnsupportedFormatException("An invalid stack type detected.");
        }
        int X = rectangle != null ? (int)rectangle.getX() : 0;
        int Y = rectangle != null ? (int)rectangle.getY() : 0;
        int W = rectangle != null ? (int)Math.max(Math.min((long)((int)rectangle.getWidth()), stack.dimension(0) - (long)X), 0L) : (int)stack.dimension(0) - X;
        int H = rectangle != null ? (int)Math.max(Math.min((long)((int)rectangle.getHeight()), stack.dimension(1) - (long)Y), 0L) : (int)stack.dimension(1) - Y;
        CachedCellImg cachedStack = (CachedCellImg)stack;
        DataType dataType = this.getDataType(cachedStack.firstElement());
        Object ret = rectangle != null ? Array1DUtil.createArray((DataType)dataType, (int)((int)rectangle.getWidth() * (int)rectangle.getHeight())) : Array1DUtil.createArray((DataType)dataType, (int)(W * H));
        long[] planeIndexSpans = new long[stack.numDimensions() - 2];
        int i = 0;
        while (i < planeIndexSpans.length) {
            planeIndexSpans[i] = stack.dimension(i + 2);
            ++i;
        }
        Extents planeExtents = new Extents(planeIndexSpans);
        long[] planePos = new long[planeExtents.numDimensions()];
        Position pos = planeExtents.createPosition();
        pos.setIndex((long)z);
        pos.localize(planePos);
        long[] inputPos = new long[stack.numDimensions()];
        int i2 = 2;
        while (i2 < stack.numDimensions()) {
            inputPos[i2] = planePos[i2 - 2];
            ++i2;
        }
        inputPos[0] = X;
        inputPos[1] = Y;
        CellRandomAccess input = cachedStack.randomAccess();
        input.setPosition(inputPos);
        IntegerType inputRef = (IntegerType)input.get();
        int maxX = W - 1;
        int maxY = H - 1;
        int y = 0;
        while (y <= Math.min(H, maxY)) {
            int x = 0;
            while (x <= Math.min(W, maxX)) {
                int idx = x + W * y;
                switch (dataType.getJavaType()) {
                    case BYTE: {
                        ((byte[])ret)[idx] = Integer.valueOf(inputRef.getInteger()).byteValue();
                        break;
                    }
                    case SHORT: {
                        ((short[])ret)[idx] = Integer.valueOf(inputRef.getInteger()).shortValue();
                        break;
                    }
                    case INT: {
                        ((int[])ret)[idx] = inputRef.getInteger();
                        break;
                    }
                    case LONG: {
                        ((long[])ret)[idx] = inputRef.getIntegerLong();
                        break;
                    }
                    case FLOAT: {
                        ((float[])ret)[idx] = inputRef.getRealFloat();
                        break;
                    }
                    case DOUBLE: {
                        ((double[])ret)[idx] = inputRef.getRealDouble();
                        break;
                    }
                    default: {
                        throw new UnsupportedFormatException("Data type format is not suported.");
                    }
                }
                if (x != maxX) {
                    input.move(1, 0);
                }
                ++x;
            }
            if (y != maxY) {
                input.move(-maxX, 0);
                input.move(1, 1);
            }
            ++y;
        }
        return ret;
    }

    private DataType getDataType(int resolution) throws UnsupportedFormatException {
        int t = 0;
        int serie = 0;
        SourceAndConverter<?> source = this.sources_.get(serie);
        RandomAccessibleInterval stack = source.getSpimSource().getSource(t, resolution);
        CachedCellImg cachedStack = (CachedCellImg)stack;
        return this.getDataType(cachedStack.firstElement());
    }

    private DataType getDataType(Object element) throws UnsupportedFormatException {
        if (element instanceof ByteType) {
            return DataType.BYTE;
        }
        if (element instanceof UnsignedByteType) {
            return DataType.BYTE;
        }
        if (element instanceof ShortType) {
            return DataType.SHORT;
        }
        if (element instanceof UnsignedShortType) {
            return DataType.SHORT;
        }
        if (element instanceof IntType) {
            return DataType.INT;
        }
        if (element instanceof UnsignedIntType) {
            return DataType.INT;
        }
        if (element instanceof LongType) {
            return DataType.LONG;
        }
        if (element instanceof UnsignedLongType) {
            return DataType.LONG;
        }
        if (element instanceof FloatType) {
            return DataType.FLOAT;
        }
        if (element instanceof DoubleType) {
            return DataType.DOUBLE;
        }
        throw new UnsupportedFormatException("Data type is not supported");
    }

    private boolean getIsSigned(int serie, int t, int resolution) {
        boolean ret = false;
        if (this.sources_.size() == 0) {
            return ret;
        }
        SourceAndConverter<?> source = this.sources_.get(serie);
        RandomAccessibleInterval stack = source.getSpimSource().getSource(t, resolution);
        if (!(stack instanceof CachedCellImg)) {
            return ret;
        }
        Object element = ((CachedCellImg)stack).firstElement();
        if (element instanceof ByteType) {
            ret = true;
        } else if (element instanceof ShortType) {
            ret = true;
        } else if (element instanceof IntType) {
            ret = true;
        } else if (element instanceof LongType) {
            ret = true;
        } else if (element instanceof FloatType) {
            ret = true;
        } else if (element instanceof DoubleType) {
            ret = true;
        }
        return ret;
    }

    private final Object getPixels(int serie, int resolution, Rectangle rectangle, int z, int t, int c, boolean fullImage) throws UnsupportedFormatException, IOException {
        if (this.sources_.size() == 0) {
            throw new IOException("Not sources found");
        }
        SourceAndConverter<?> source = this.sources_.get(serie);
        Hdf5ImageLoader.SetupImgLoader setup = this.hdf5ImageLoader_.getSetupImgLoader(serie);
        MipmapInfo mipmapInfo = setup.getMipmapInfo();
        if (mipmapInfo.getNumLevels() <= resolution) {
            throw new UnsupportedFormatException("Invalid resolution level");
        }
        RandomAccessibleInterval stack = source.getSpimSource().getSource(t, resolution);
        int N = stack.numDimensions();
        if (fullImage) {
            rectangle = new Rectangle(0, 0, (int)stack.dimension(0), (int)stack.dimension(1));
        }
        if (N != 3) {
            new FailedAnnounceFrame("Expecting a three dimensions stack.");
            throw new UnsupportedFormatException("Number of dimensions found are not supported");
        }
        return this.StackToPlanarXY(stack, rectangle, z);
    }

    private final IcyBufferedImage getImage(int serie, int wishedResolution, Rectangle rectangle, int z, int t, int c, boolean fullImage) throws UnsupportedFormatException, IOException {
        if (rectangle == null) {
            fullImage = true;
        }
        int resolutionLevel = -1;
        double div = Math.pow(2.0, wishedResolution);
        double[][] res = this.getResolutions(serie);
        int r = 0;
        while (r < res.length) {
            if (res[r][0] == div) {
                resolutionLevel = r;
            }
            ++r;
        }
        SourceAndConverter<?> source = this.sources_.get(serie);
        double delta = Double.MAX_VALUE;
        if (resolutionLevel == -1) {
            int r2 = 0;
            while (r2 < res.length) {
                double d = res[r2][0];
                double dd = div - d;
                if (dd > 0.0 && dd < delta) {
                    resolutionLevel = r2;
                    delta = dd;
                }
                ++r2;
            }
            if (delta == Double.MAX_VALUE) {
                throw new UnsupportedFormatException("I could not find a valid resolution.");
            }
            RandomAccessibleInterval stack = source.getSpimSource().getSource(t, resolutionLevel);
            int zMax = (int)stack.dimension(2);
            int it = wishedResolution - (int)(Math.log(delta) / Math.log(2.0));
            int W = fullImage ? (int)stack.dimension(0) : (int)rectangle.getWidth();
            int H = fullImage ? (int)stack.dimension(1) : (int)rectangle.getHeight();
            Object imageArray = null;
            imageArray = z >= zMax ? Array1DUtil.createArray((DataType)this.getDataType(resolutionLevel), (int)(W * H)) : this.getPixels(serie, resolutionLevel, rectangle, z, t, c, fullImage);
            IcyBufferedImage image = new IcyBufferedImage(W, H, imageArray, this.getIsSigned(serie, t, resolutionLevel));
            while (it-- > 0) {
                image = IcyBufferedImageUtil.downscaleBy2((IcyBufferedImage)image, (boolean)true);
            }
            return image;
        }
        RandomAccessibleInterval stack = source.getSpimSource().getSource(t, resolutionLevel);
        int W = fullImage ? (int)stack.dimension(0) : (int)rectangle.getWidth();
        int H = fullImage ? (int)stack.dimension(1) : (int)rectangle.getHeight();
        int zMax = (int)stack.dimension(2);
        Object imageArray = null;
        imageArray = z >= zMax ? Array1DUtil.createArray((DataType)this.getDataType(resolutionLevel), (int)(W * H)) : this.getPixels(serie, resolutionLevel, rectangle, z, t, c, fullImage);
        return new IcyBufferedImage(W, H, imageArray, this.getIsSigned(serie, t, resolutionLevel));
    }

    public IcyBufferedImage getImage(int serie, int resolution, Rectangle rectangle, int z, int t, int c) throws UnsupportedFormatException, IOException {
        return this.getImage(serie, resolution, rectangle, z, t, c, false);
    }

    public IcyBufferedImage getImage(int serie, int resolution, Rectangle rectangle, int z, int t) throws UnsupportedFormatException, IOException {
        int sizeC = MetaDataUtil.getSizeC((OMEXMLMetadataImpl)this.getMetaData(), (int)serie);
        ArrayList<IcyBufferedImage> images = new ArrayList<IcyBufferedImage>();
        int c = 0;
        while (c < sizeC) {
            images.add(this.getImage(serie, resolution, rectangle, z, t, c, false));
            ++c;
        }
        return IcyBufferedImage.createFrom(images);
    }

    public IcyBufferedImage getImage(int serie, int resolution, int z, int t, int c) throws UnsupportedFormatException, IOException {
        return this.getImage(serie, resolution, new Rectangle(), z, t, c, true);
    }

    public IcyBufferedImage getImage(int serie, int resolution, int z, int t) throws UnsupportedFormatException, IOException {
        int sizeC = MetaDataUtil.getSizeC((OMEXMLMetadataImpl)this.getMetaData(), (int)serie);
        ArrayList<IcyBufferedImage> images = new ArrayList<IcyBufferedImage>();
        int c = 0;
        while (c < sizeC) {
            images.add(this.getImage(serie, resolution, new Rectangle(), z, t, c, true));
            ++c;
        }
        return IcyBufferedImage.createFrom(images);
    }

    public IcyBufferedImage getImage(int serie, int z, int t) throws UnsupportedFormatException, IOException {
        int sizeC = MetaDataUtil.getSizeC((OMEXMLMetadataImpl)this.getMetaData(), (int)serie);
        ArrayList<IcyBufferedImage> images = new ArrayList<IcyBufferedImage>();
        int c = 0;
        while (c < sizeC) {
            images.add(this.getImage(serie, 0, new Rectangle(), z, t, c, true));
            ++c;
        }
        return IcyBufferedImage.createFrom(images);
    }

    public IcyBufferedImage getImage(int z, int t) throws UnsupportedFormatException, IOException {
        int serie = 0;
        int sizeC = MetaDataUtil.getSizeC((OMEXMLMetadataImpl)this.getMetaData(), (int)serie);
        ArrayList<IcyBufferedImage> images = new ArrayList<IcyBufferedImage>();
        int c = 0;
        while (c < sizeC) {
            images.add(this.getImage(serie, 0, new Rectangle(), z, t, c, true));
            ++c;
        }
        return IcyBufferedImage.createFrom(images);
    }

    public String getOpened() {
        if (this.hdf5ImageLoader_ != null) {
            return this.hdf5ImageLoader_.getHdf5File().getAbsolutePath();
        }
        return "";
    }

    public boolean open(String path, int flags) throws UnsupportedFormatException, IOException {
        boolean isH5 = FileUtil.getFileExtension((String)path, (boolean)false).equals("h5");
        this.xmlFile_ = path;
        if (isH5) {
            this.xmlFile_ = String.valueOf(FileUtil.getDirectory((String)path)) + FileUtil.getFileName((String)path, (boolean)false) + ".xml";
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(PluginLoader.getLoader());
            this.spimData_ = new XmlIoSpimDataMinimal().load(this.xmlFile_);
            Thread.currentThread().setContextClassLoader(loader);
            BigDataViewer.initSetups((AbstractSpimData)this.spimData_, this.converterSetups_, this.sources_);
            BasicImgLoader basicImage = ((SequenceDescriptionMinimal)this.spimData_.getSequenceDescription()).getImgLoader();
            if (basicImage instanceof Hdf5ImageLoader) {
                this.hdf5ImageLoader_ = (Hdf5ImageLoader)basicImage;
                return true;
            }
            return false;
        }
        catch (SpimDataException e) {
            throw new IOException(e.getMessage());
        }
    }

    public boolean acceptFile(String path) {
        boolean isH5 = FileUtil.getFileExtension((String)path, (boolean)false).equals("h5");
        boolean isXML = FileUtil.getFileExtension((String)path, (boolean)false).equals("xml");
        boolean ret = false;
        if (isH5) {
            ret = isH5;
        } else if (isXML) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(PluginLoader.getLoader());
                SpimDataMinimal spimData = new XmlIoSpimDataMinimal().load(path);
                Thread.currentThread().setContextClassLoader(loader);
                if (spimData != null) {
                    ret = true;
                }
            }
            catch (SpimDataException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public List<FileFilter> getFileFilters() {
        ArrayList<FileFilter> result = new ArrayList<FileFilter>();
        result.add((FileFilter)new ExtensionFileFilter(new String[]{"h5"}, "HDF5 BigDataViewer's images"));
        result.add((FileFilter)new ExtensionFileFilter(new String[]{"xml"}, "HDF5 image's descriptor file"));
        return result;
    }

    public double[][] getResolutions(int setupId) {
        int size = ((SequenceDescriptionMinimal)this.spimData_.getSequenceDescription()).getViewSetups().size();
        if (setupId >= size) {
            return null;
        }
        return this.hdf5ImageLoader_.getSetupImgLoader(setupId).getMipmapResolutions();
    }

    public OMEXMLMetadata getOMEXMLMetaData() throws UnsupportedFormatException, IOException {
        return this.getMetaData();
    }
}

