/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Object3D_IJUtils;
import mcib3d.geom.Point3D;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.utils.ArrayUtil;
import mcib3d.utils.KDTreeC;
import mcib3d.utils.Logger.AbstractLog;

public class Objects3DPopulation {
    private final ArrayList<Object3D> objects = new ArrayList();
    AbstractLog log = null;
    private Object3D mask = null;
    @Deprecated
    private Calibration calibration = null;
    private double scaleXY = 1.0;
    private double scaleZ = 1.0;
    private String unit = "pix";
    private KDTreeC kdtree = null;
    private HashMap<Integer, Integer> hashValue = null;
    private HashMap<String, Integer> hashName = null;

    public Objects3DPopulation() {
    }

    public Objects3DPopulation(Object3D[] objs) {
        this.addObjects(objs);
    }

    public Objects3DPopulation(ArrayList<Object3D> objs) {
        this.addObjects(objs);
    }

    @Deprecated
    public Objects3DPopulation(Object3D[] objs, Calibration cal) {
        this.calibration = cal != null ? cal : new Calibration();
        this.addObjects(objs);
    }

    @Deprecated
    public Objects3DPopulation(ImagePlus plus) {
        this.addImagePlus(plus);
    }

    public Objects3DPopulation(ImageInt plus) {
        this.addImage(plus, 0);
    }

    public Objects3DPopulation(ImageInt plus, int threshold) {
        this.addImage(plus, threshold);
    }

    public AbstractLog getLog() {
        return this.log;
    }

    public void setLog(AbstractLog log) {
        this.log = log;
    }

    public double getScaleXY() {
        return this.scaleXY;
    }

    public void setScaleXY(double scaleXY) {
        this.scaleXY = scaleXY;
    }

    public double getScaleZ() {
        return this.scaleZ;
    }

    public void setScaleZ(double scaleZ) {
        this.scaleZ = scaleZ;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    @Deprecated
    public Calibration getCalibration() {
        return this.calibration;
    }

    @Deprecated
    public void setCalibration(Calibration cal) {
        this.calibration = cal;
        if (this.objects != null && this.objects.size() > 0) {
            for (Object3D obj : this.objects) {
                Object3D_IJUtils.setCalibration(obj, this.calibration);
            }
        }
    }

    public void setCalibration(double sxy, double sz, String u) {
        this.scaleXY = sxy;
        this.scaleZ = sz;
        this.unit = u;
    }

    public void createRandomPopulation(int nb, double hardcore) {
        Object3DVoxels maskVox = this.mask.getObject3DVoxels();
        Random ra = new Random();
        Point3D P = maskVox.getRandomvoxel(ra);
        Voxel3D v = new Voxel3D(P.getX(), P.getY(), P.getZ(), 1.0);
        ArrayList<Voxel3D> voxlist = new ArrayList<Voxel3D>(1);
        voxlist.add(v);
        Object3DVoxels ob = new Object3DVoxels(voxlist);
        ob.setCalibration(this.scaleXY, this.scaleZ, this.unit);
        this.addObject(ob);
        for (int i = 1; i < nb; ++i) {
            P = maskVox.getRandomvoxel(ra);
            Object3D closest = this.closestCenter(P);
            double dist = closest.distPixelCenter(P.getX(), P.getY(), P.getZ());
            while (dist < hardcore) {
                P = this.getRandomPointInMask();
                closest = this.closestCenter(P);
                dist = closest.distPixelCenter(P.getX(), P.getY(), P.getZ());
            }
            v = new Voxel3D(P.getX(), P.getY(), P.getZ(), (double)(i + 1));
            voxlist = new ArrayList(1);
            voxlist.add(v);
            ob = new Object3DVoxels(voxlist);
            ob.setCalibration(this.scaleXY, this.scaleZ, this.unit);
            this.addObject(ob);
        }
    }

    public void createRandomPopulationDistAbsMb(int nb, double r0, double r1) {
        for (int i = 0; i < nb; ++i) {
            ArrayList<Voxel3D> voxlist = new ArrayList<Voxel3D>(1);
            Point3D P = this.getRandomPointInMaskDistAbsMb(r0, r1);
            Voxel3D v = new Voxel3D(P.getX(), P.getY(), P.getZ(), (double)i);
            voxlist.add(v);
            Object3DVoxels ob = new Object3DVoxels(voxlist);
            this.addObject(ob);
        }
    }

    public void createKDTreeCenters() {
        this.kdtree = new KDTreeC(3, 64);
        double[] tmp = new double[]{this.scaleXY, this.scaleXY, this.scaleZ};
        this.kdtree.setScale(tmp);
        for (int i = 0; i < this.getNbObjects(); ++i) {
            this.kdtree.add(this.getObject(i).getCenterAsArray(), this.getObject(i));
        }
    }

    public void draw(ImageStack ima, int col) {
        Iterator<Object3D> iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            Object3D object;
            Object3D ob = object = iterator.next();
            Object3D_IJUtils.draw(ob, ima, col);
        }
    }

    public void draw(ImageHandler ima, int col) {
        Iterator<Object3D> iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            Object3D object;
            Object3D ob = object = iterator.next();
            ob.draw(ima, col);
        }
    }

    public void draw(ImageStack ima) {
        Iterator<Object3D> iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            Object3D object;
            Object3D ob = object = iterator.next();
            ob.draw(ima, ob.getValue());
        }
    }

    public void draw(ImageHandler ima) {
        Iterator<Object3D> iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            Object3D object;
            Object3D ob = object = iterator.next();
            ob.draw(ima, ob.getValue());
        }
    }

    public void addObject(Object3D obj) {
        if (this.getNbObjects() == 0) {
            this.scaleXY = obj.resXY;
            this.scaleZ = obj.resZ;
            this.unit = obj.getUnits();
        } else if (this.scaleXY != obj.resXY || this.scaleZ != obj.resZ) {
            if (this.log != null) {
                this.log.log("Calibration not consistent between population and object : (" + this.scaleXY + "," + this.scaleZ + ") (" + obj.resXY + "," + obj.resZ + ")");
            }
            obj.setCalibration(this.scaleXY, this.scaleZ, this.unit);
        }
        this.objects.add(obj);
        this.kdtree = null;
        this.hashValue = null;
        this.hashName = null;
    }

    public final void addObjects(Object3D[] objs) {
        for (Object3D obj : objs) {
            this.addObject(obj);
        }
        this.kdtree = null;
        this.hashValue = null;
        this.hashName = null;
    }

    public void addObjects(ArrayList<Object3D> list) {
        for (Object3D list1 : list) {
            this.addObject(list1);
        }
        this.kdtree = null;
        this.hashValue = null;
        this.hashName = null;
    }

    public void removeObjectsTouchingBorders(ImageHandler img, boolean Z) {
        ArrayList<Object3D> toRemove = new ArrayList<Object3D>();
        for (Object3D obj : this.objects) {
            if (!obj.touchBorders(img, Z)) continue;
            toRemove.add(obj);
        }
        for (Object3D obj : toRemove) {
            this.removeObject(obj);
        }
        this.kdtree = null;
        this.hashValue = null;
        this.hashName = null;
    }

    public void removeObjectsTouchingBorders(ImagePlus img, boolean Z) {
        ArrayList<Object3D> toRemove = new ArrayList<Object3D>();
        for (Object3D obj : this.objects) {
            if (!obj.touchBorders(img, Z)) continue;
            toRemove.add(obj);
        }
        for (Object3D obj : toRemove) {
            this.removeObject(obj);
        }
        this.kdtree = null;
        this.hashValue = null;
        this.hashName = null;
    }

    public void removeObject(int i) {
        this.kdtree = null;
        this.hashValue = null;
        this.hashName = null;
        this.objects.remove(i);
    }

    public void removeObject(Object3D obj) {
        this.kdtree = null;
        this.hashValue = null;
        this.hashName = null;
        if (!this.objects.remove(obj) && this.log != null) {
            this.log.log("Pb removing " + obj);
        }
    }

    @Deprecated
    private void buildHash() {
        this.hashName = new HashMap(this.getNbObjects());
        this.hashValue = new HashMap(this.getNbObjects());
        for (int i = 0; i < this.getNbObjects(); ++i) {
            Object3D O = this.getObject(i);
            this.hashName.put(O.getName(), i);
            this.hashValue.put(O.getValue(), i);
        }
    }

    public void updateNamesAndValues() {
        this.hashName = new HashMap(this.getNbObjects());
        this.hashValue = new HashMap(this.getNbObjects());
        for (int i = 0; i < this.getNbObjects(); ++i) {
            Object3D O = this.getObject(i);
            this.hashName.put(O.getName(), i);
            this.hashValue.put(O.getValue(), i);
        }
    }

    public void addPoints(Point3D[] points) {
        int inc = this.objects.size();
        for (int i = 0; i < points.length; ++i) {
            Point3D P = points[i];
            Voxel3D v = new Voxel3D(P.getX(), P.getY(), P.getZ(), (double)((float)i + (float)inc));
            ArrayList<Voxel3D> voxlist = new ArrayList<Voxel3D>(1);
            voxlist.add(v);
            Object3DVoxels ob = new Object3DVoxels(voxlist);
            ob.setCalibration(this.scaleXY, this.scaleZ, this.unit);
            ob.setName("Point-" + i);
            ob.setValue(i + 1);
            this.addObject(ob);
        }
        this.kdtree = null;
        this.hashValue = null;
        this.hashName = null;
    }

    @Deprecated
    public void addImage(ImageInt seg, int threshold, Calibration cali) {
        seg.resetStats(null);
        int min = (int)seg.getMinAboveValue(threshold);
        int max = (int)seg.getMax();
        if (max == 0) {
            if (this.log != null) {
                this.log.log("No objects found");
            }
            return;
        }
        this.calibration = cali;
        ArrayList[] objectstmp = new ArrayList[max - min + 1];
        for (int i = 0; i < max - min + 1; ++i) {
            objectstmp[i] = new ArrayList();
        }
        int sz = seg.sizeZ;
        int sy = seg.sizeY;
        int sx = seg.sizeX;
        for (int k = 0; k < sz; ++k) {
            for (int j = 0; j < sy; ++j) {
                for (int i = 0; i < sx; ++i) {
                    int pix = seg.getPixelInt(i, j, k);
                    if (pix <= threshold) continue;
                    objectstmp[pix - min].add(new Voxel3D(i, j, k, pix));
                }
            }
        }
        int c = 1;
        for (int i = 0; i < max - min + 1; ++i) {
            if (objectstmp[i].isEmpty()) continue;
            Object3DVoxels ob = new Object3DVoxels(objectstmp[i]);
            Object3D_IJUtils.setCalibration(ob, this.calibration);
            ob.setName("Obj" + c);
            this.addObject(ob);
            ++c;
        }
        this.kdtree = null;
        this.hashValue = null;
        this.hashName = null;
    }

    public void addImage(ImageInt seg, int threshold) {
        seg.resetStats(null);
        int min = (int)seg.getMinAboveValue(threshold);
        int max = (int)seg.getMax();
        if (max == 0) {
            if (this.log != null) {
                this.log.log("No objects found");
            }
            return;
        }
        ArrayList[] objectstmp = new ArrayList[max - min + 1];
        for (int i = 0; i < max - min + 1; ++i) {
            objectstmp[i] = new ArrayList();
        }
        int sz = seg.sizeZ;
        int sy = seg.sizeY;
        int sx = seg.sizeX;
        for (int k = 0; k < sz; ++k) {
            for (int j = 0; j < sy; ++j) {
                for (int i = 0; i < sx; ++i) {
                    int pix = seg.getPixelInt(i, j, k);
                    if (pix <= threshold) continue;
                    objectstmp[pix - min].add(new Voxel3D(i, j, k, pix));
                }
            }
        }
        int c = 1;
        for (int i = 0; i < max - min + 1; ++i) {
            if (objectstmp[i].isEmpty()) continue;
            Object3DVoxels ob = new Object3DVoxels(objectstmp[i]);
            ob.setCalibration(seg.getScaleXY(), seg.getScaleZ(), seg.getUnit());
            ob.setName("Obj-" + c + "-" + ob.getValue());
            this.addObject(ob);
            ++c;
        }
        this.kdtree = null;
        this.hashValue = null;
        this.hashName = null;
    }

    @Deprecated
    public void addImage(ImageInt seg, Calibration cali) {
        this.addImage(seg, 0, cali);
    }

    @Deprecated
    public void addImage(ImagePlus plus) {
        Calibration calplus = plus.getCalibration();
        if (calplus == null) {
            calplus = new Calibration();
            calplus.pixelWidth = 1.0;
            calplus.pixelHeight = 1.0;
            calplus.pixelDepth = 1.0;
            calplus.setUnit("pix");
        }
        this.setCalibration(calplus);
        ImageInt seg = ImageInt.wrap(plus);
        this.addImage(seg, calplus);
    }

    public Object3D getMask() {
        return this.mask;
    }

    public void setMask(Object3D mask) {
        this.mask = mask;
        mask.init();
    }

    public Object3D getObject(int i) {
        return this.objects.get(i);
    }

    public void setObject(int i, Object3D obj) {
        if (this.getNbObjects() == 0) {
            this.scaleXY = obj.resXY;
            this.scaleZ = obj.resZ;
            this.unit = obj.getUnits();
        } else if (this.scaleXY != obj.resXY || this.scaleZ != obj.resZ) {
            if (this.log != null) {
                this.log.log("Calibration not consistent between population and object : (" + this.scaleXY + "," + this.scaleZ + ") (" + obj.resXY + "," + obj.resZ + ")");
            }
            obj.setCalibration(this.scaleXY, this.scaleZ, this.unit);
        }
        this.objects.set(i, obj);
        this.kdtree = null;
        this.hashValue = null;
        this.hashName = null;
    }

    public Object3D getObjectByValue(int val) {
        Integer idxI;
        if (this.hashValue == null) {
            this.updateNamesAndValues();
        }
        if ((idxI = this.hashValue.get(val)) == null) {
            return null;
        }
        return this.objects.get(idxI);
    }

    public Object3D getObjectByName(String name) {
        Integer nb;
        if (this.hashName == null) {
            this.updateNamesAndValues();
        }
        if ((nb = this.hashName.get(name)) == null) {
            return null;
        }
        return this.objects.get(nb);
    }

    public int getIndexFromName(String name) {
        if (this.hashName == null) {
            this.updateNamesAndValues();
        }
        return this.hashName.get(name);
    }

    public int getIndexFromValue(int val) {
        if (this.hashValue == null) {
            this.updateNamesAndValues();
        }
        return this.hashValue.get(val);
    }

    public int getIndexOf(Object3D ob) {
        return this.objects.indexOf(ob);
    }

    public Object3D[] getObjectsArray() {
        return (Object3D[])this.objects.toArray();
    }

    public ArrayList<Object3D> getObjectsList() {
        return this.objects;
    }

    public int getNbObjects() {
        return this.objects.size();
    }

    public int[] getMaxSizeAllObjects() {
        int maxX = 0;
        int maxY = 0;
        int maxZ = 0;
        for (Object3D ob : this.objects) {
            if (ob.xmax > maxX) {
                maxX = ob.xmax;
            }
            if (ob.ymax > maxY) {
                maxY = ob.ymax;
            }
            if (ob.zmax <= maxZ) continue;
            maxZ = ob.zmax;
        }
        return new int[]{maxX, maxY, maxZ};
    }

    public Point3D getRandomPointInMask() {
        int xmin = this.mask.getXmin();
        int xmax = this.mask.getXmax();
        int ymin = this.mask.getYmin();
        int ymax = this.mask.getYmax();
        int zmin = this.mask.getZmin();
        int zmax = this.mask.getZmax();
        double x = Math.random() * (double)(xmax - xmin) + (double)xmin;
        double y = Math.random() * (double)(ymax - ymin) + (double)ymin;
        double z = Math.random() * (double)(zmax - zmin) + (double)zmin;
        while (!this.mask.inside(x, y, z)) {
            x = Math.random() * (double)(xmax - xmin) + (double)xmin;
            y = Math.random() * (double)(ymax - ymin) + (double)ymin;
            z = Math.random() * (double)(zmax - zmin) + (double)zmin;
        }
        return new Point3D(x, y, z);
    }

    private Point3D getRandomPointInMaskDistAbsMb(double r0, double r1) {
        int xmin = this.mask.getXmin();
        int xmax = this.mask.getXmax();
        int ymin = this.mask.getYmin();
        int ymax = this.mask.getYmax();
        int zmin = this.mask.getZmin();
        int zmax = this.mask.getZmax();
        double x = Math.random() * (double)(xmax - xmin) + (double)xmin;
        double y = Math.random() * (double)(ymax - ymin) + (double)ymin;
        double z = Math.random() * (double)(zmax - zmin) + (double)zmin;
        double dist = Double.MAX_VALUE;
        while (!this.mask.inside(x, y, z) || dist < r0 || dist > r1) {
            x = Math.random() * (double)(xmax - xmin) + (double)xmin;
            y = Math.random() * (double)(ymax - ymin) + (double)ymin;
            z = Math.random() * (double)(zmax - zmin) + (double)zmin;
            dist = this.mask.distPixelBorderUnit(x, y, z);
        }
        return new Point3D(x, y, z);
    }

    public ArrayUtil computeDistances(Point3D[] evaluationPoints) {
        int numPoints = evaluationPoints.length;
        ArrayUtil array = new ArrayUtil(numPoints);
        for (int i = 0; i < numPoints; ++i) {
            Point3D P = evaluationPoints[i];
            Object3D cl = this.closestCenter(P);
            array.putValue(i, cl.distPixelCenter(P.getX(), P.getY(), P.getZ()));
        }
        return array;
    }

    public double[][] distancesAllPairsCenter() {
        int s = this.objects.size();
        double[][] res = new double[s][s];
        for (int i = 0; i < s; ++i) {
            Object3D obj1 = this.objects.get(i);
            res[i][i] = 0.0;
            for (int j = i + 1; j < s; ++j) {
                double dist;
                Object3D obj2 = this.objects.get(j);
                res[i][j] = dist = obj1.distCenterUnit(obj2);
                res[j][i] = dist;
            }
        }
        return res;
    }

    public double[][] distancesAllPairsCenter(Objects3DPopulation pop) {
        int s = this.objects.size();
        int ss = pop.getNbObjects();
        double[][] res = new double[s][s];
        for (int i = 0; i < s; ++i) {
            Object3D obj1 = this.objects.get(i);
            res[i][i] = 0.0;
            for (int j = 0; j < ss; ++j) {
                double dist;
                Object3D obj2 = pop.getObject(j);
                res[i][j] = dist = obj1.distCenterUnit(obj2);
                res[j][i] = dist;
            }
        }
        return res;
    }

    public double[][] distancesAllPairsBorder(Objects3DPopulation pop) {
        int s = this.objects.size();
        int ss = pop.getNbObjects();
        double[][] res = new double[s][s];
        for (int i = 0; i < s; ++i) {
            Object3D obj1 = this.objects.get(i);
            res[i][i] = 0.0;
            for (int j = 0; j < ss; ++j) {
                double dist;
                Object3D obj2 = pop.getObject(j);
                res[i][j] = dist = obj1.distBorderUnit(obj2);
                res[j][i] = dist;
            }
        }
        return res;
    }

    public ArrayUtil distancesAllCenter() {
        double[] distances = new double[this.getNbObjects() * (this.getNbObjects() - 1) / 2];
        int nb = this.getNbObjects();
        int count = 0;
        for (int i = 0; i < nb; ++i) {
            Object3D ob1 = this.objects.get(i);
            for (int j = i + 1; j < nb; ++j) {
                Object3D ob2 = this.objects.get(j);
                distances[count] = ob1.distCenterUnit(ob2);
                ++count;
            }
        }
        return new ArrayUtil(distances);
    }

    public ArrayUtil distancesAllBorder() {
        double[] distances = new double[this.getNbObjects() * (this.getNbObjects() - 1) / 2];
        int nb = this.getNbObjects();
        int count = 0;
        for (int i = 0; i < nb; ++i) {
            Object3D ob1 = this.objects.get(i);
            for (int j = i + 1; j < nb; ++j) {
                Object3D ob2 = this.objects.get(j);
                distances[count] = ob1.distBorderUnit(ob2);
                ++count;
            }
        }
        return new ArrayUtil(distances);
    }

    public ArrayUtil distancesAllClosestCenter() {
        int nb = this.getNbObjects();
        ArrayUtil tab = new ArrayUtil(nb);
        for (int i = 0; i < nb; ++i) {
            Object3D cl = this.closestCenter(this.getObject(i), true);
            if (cl == null) continue;
            double d = cl.distCenterUnit(this.getObject(i));
            tab.putValue(i, d);
        }
        return tab;
    }

    public ArrayUtil distancesAllClosestBorder() {
        int nb = this.getNbObjects();
        ArrayUtil tab = new ArrayUtil(nb);
        for (int i = 0; i < nb; ++i) {
            Object3D cl = this.closestBorder(this.getObject(i));
            if (cl == null) continue;
            double d = cl.distBorderUnit(this.getObject(i));
            tab.putValue(i, d);
        }
        return tab;
    }

    public ArrayList<double[]> getMeasuresGeometrical() {
        ArrayList<double[]> al = new ArrayList<double[]>();
        for (Object3D ob : this.objects) {
            double[] mes = new double[]{ob.getValue(), ob.getVolumePixels(), ob.getVolumeUnit(), ob.getAreaPixels(), ob.getAreaUnit()};
            al.add(mes);
        }
        return al;
    }

    public ArrayList<double[]> getMeasuresStats(ImageHandler raw) {
        ArrayList<double[]> al = new ArrayList<double[]>();
        for (Object3D ob : this.objects) {
            double[] mes = new double[]{ob.getValue(), ob.getPixMeanValue(raw), ob.getPixStdDevValue(raw), ob.getPixMinValue(raw), ob.getPixMaxValue(raw), ob.getIntegratedDensity(raw)};
            al.add(mes);
        }
        return al;
    }

    public ArrayList<double[]> getMeasuresStats(ImageStack raw) {
        return this.getMeasuresStats(ImageHandler.wrap(raw));
    }

    public double[][] distancesAllPairsBorder() {
        int s = this.objects.size();
        double[][] res = new double[s][s];
        for (int i = 0; i < s; ++i) {
            Object3D obj1 = this.objects.get(i);
            res[i][i] = 0.0;
            for (int j = i + 1; j < s; ++j) {
                double dist;
                Object3D obj2 = this.objects.get(j);
                res[i][j] = dist = obj1.distBorderUnit(obj2);
                res[j][i] = dist;
            }
        }
        return res;
    }

    public double[][] histogramDistancesCenter(double step) {
        double[][] dists = this.distancesAllPairsCenter();
        return this.histogramDistances(dists, step);
    }

    public double[][] histogramDistancesBorder(double step) {
        double[][] dists = this.distancesAllPairsBorder();
        return this.histogramDistances(dists, step);
    }

    private double[][] histogramDistances(double[][] distances, double step) {
        int i;
        double d;
        double dmin;
        int s = this.objects.size();
        double dmax = dmin = distances[0][1];
        for (int i2 = 0; i2 < s; ++i2) {
            for (int j = i2 + 1; j < s; ++j) {
                d = distances[i2][j];
                if (d > dmax) {
                    dmax = d;
                }
                if (!(d < dmin)) continue;
                dmin = d;
            }
        }
        int nbins = (int)Math.ceil((dmax - dmin) / step);
        if (nbins < 1) {
            nbins = 1;
        }
        double[][] res = new double[2][nbins];
        for (i = 0; i < nbins; ++i) {
            res[0][i] = dmin + (double)i * step;
            res[1][i] = 0.0;
        }
        for (i = 0; i < s; ++i) {
            for (int j = i + 1; j < s; ++j) {
                d = distances[i][j];
                int idx = (int)Math.floor((d - dmin) / step);
                double[] dArray = res[1];
                int n = idx;
                dArray[n] = dArray[n] + 1.0;
            }
        }
        return res;
    }

    public Object3D closestCenter(double x, double y, double z, double dist) {
        Object3D res = null;
        double dmin = Double.MAX_VALUE;
        for (Object3D object : this.objects) {
            Object3D tmp = object;
            double d = tmp.distPixelCenter(x, y, z);
            if (!(d < dmin) || !(d > dist)) continue;
            dmin = d;
            res = tmp;
        }
        return res;
    }

    public Object3D closestBorder(double x, double y, double z, double dist) {
        Object3D res = null;
        double dmin = Double.MAX_VALUE;
        for (Object3D tmp : this.objects) {
            double d = tmp.distPixelBorderUnit(x, y, z);
            if (!(d < dmin) || !(d > dist)) continue;
            dmin = d;
            res = tmp;
        }
        return res;
    }

    public Object3D closestCenter(Object3D ob, ArrayList<Object3D> exclude) {
        Object3D res = null;
        double dmin = Double.MAX_VALUE;
        for (Object3D object : this.objects) {
            double d;
            Object3D tmp = object;
            if (exclude.contains(tmp) || !((d = ob.distCenterUnit(tmp)) < dmin)) continue;
            dmin = d;
            res = tmp;
        }
        return res;
    }

    public Object3D closestBorder(Object3D ob, ArrayList<Object3D> exclude) {
        Object3D res = null;
        double dmin = Double.MAX_VALUE;
        for (Object3D object : this.objects) {
            double d;
            Object3D tmp = object;
            if (exclude.contains(tmp) || !((d = ob.distBorderUnit(tmp)) < dmin)) continue;
            dmin = d;
            res = tmp;
        }
        return res;
    }

    public Object3D closestCenter(double x, double y, double z) {
        if (this.kdtree == null) {
            this.createKDTreeCenters();
        }
        double[] pos = new double[]{x, y, z};
        KDTreeC.Item clo = this.kdtree.getNearestNeighbor(pos, 1)[0];
        return (Object3D)clo.obj;
    }

    public Object3D closestCenter(Point3D P) {
        return this.closestCenter(P.getX(), P.getY(), P.getZ());
    }

    public Object3D closestCenter(Object3D O, double dist) {
        Point3D P = O.getCenterAsPoint();
        return this.closestCenter(P.getX(), P.getY(), P.getZ(), dist);
    }

    public Object3D closestBorder(Object3D O, double dist) {
        double distanceMinimum = Double.MAX_VALUE;
        Object3D res = null;
        for (Object3D object3D : this.objects) {
            double d = O.distBorderUnit(object3D);
            if (!(d > dist) || !(d < distanceMinimum)) continue;
            distanceMinimum = d;
            res = object3D;
        }
        return res;
    }

    public Object3D closestBorder(Object3D O, int[] allowed, double dist) {
        double distanceMinimum = Double.MAX_VALUE;
        Object3D res = null;
        if (allowed.length == 0) {
            return null;
        }
        for (int ob : allowed) {
            Object3D tmp = this.getObject(ob);
            double d = O.distBorderUnit(tmp);
            if (!(d > dist) || !(d < distanceMinimum)) continue;
            distanceMinimum = d;
            res = tmp;
        }
        return res;
    }

    public Object3D closestCenter(Object3D O, int[] allowed, double dist) {
        double distanceMinimum = Double.MAX_VALUE;
        Object3D res = null;
        if (allowed.length == 0) {
            return null;
        }
        for (int ob : allowed) {
            Object3D tmp = this.getObject(ob);
            double d = O.distCenterUnit(tmp);
            if (!(d > dist) || !(d < distanceMinimum)) continue;
            distanceMinimum = d;
            res = tmp;
        }
        return res;
    }

    public Object3D closestCenter(Object3D obj, boolean excludeInputObject) {
        return this.kClosestCenter(obj, 1, excludeInputObject);
    }

    public Object3D closestCenter(Object3D obj, int[] allowed, boolean excludeInputObject) {
        return this.closestCenter(obj, allowed, 0.0);
    }

    public Object3D closestBorder(Object3D O) {
        return this.closestBorder(O, 0.0);
    }

    public Object3D closestBorder(Object3D O, int[] allowed) {
        return this.closestBorder(O, allowed, 0.0);
    }

    public Object3D kClosestCenter(Object3D ob, int k, boolean excludeInputObject) {
        if (this.kdtree == null) {
            this.createKDTreeCenters();
        }
        if (excludeInputObject) {
            ++k;
        }
        KDTreeC.Item clo = this.kdtree.getNearestNeighbor(ob.getCenterAsArray(), k)[k - 1];
        return (Object3D)clo.obj;
    }

    public Object3D kClosestCenter(Object3D ob, int k, ArrayList<Object3D> exclude) {
        KDTreeC.Item[] items;
        if (this.kdtree == null) {
            this.createKDTreeCenters();
        }
        int nbClosest = 0;
        KDTreeC.Item kClosest = null;
        for (KDTreeC.Item item : items = this.kdtree.getNearestNeighbor(ob.getCenterAsArray(), this.getNbObjects())) {
            if (!exclude.contains(item)) {
                ++nbClosest;
                kClosest = item;
            }
            if (nbClosest == k) break;
        }
        return (Object3D)kClosest.obj;
    }

    public ArrayList<Object3D> getObjectsWithinDistanceCenter(Object3D ob, double dist) {
        ArrayList<Object3D> list = new ArrayList<Object3D>();
        for (Object3D object : this.objects) {
            double tmp = ob.distCenterUnit(object);
            if (!(tmp <= dist)) continue;
            list.add(object);
        }
        return list;
    }

    public ArrayList<Object3D> getObjectsWithinDistanceBorder(Object3D ob, double dist) {
        ArrayList<Object3D> list = new ArrayList<Object3D>();
        for (Object3D object : this.objects) {
            double tmp = ob.distBorderUnit(object);
            if (!(tmp <= dist)) continue;
            list.add(object);
        }
        return list;
    }

    public Object3D kClosestBorder(Object3D ob, int k) {
        ArrayList<Object3D> exclude = new ArrayList<Object3D>();
        exclude.add(ob);
        if (k == 1) {
            return this.closestBorder(ob, exclude);
        }
        Object3D clo = this.closestBorder(ob, exclude);
        exclude.add(clo);
        for (int kk = 1; clo != null && kk < k; ++kk) {
            clo = this.closestBorder(ob, exclude);
            if (clo == null) continue;
            exclude.add(clo);
        }
        return clo;
    }

    public Object3D secondClosestCenter(Object3D O, double dist) {
        Point3D P = O.getCenterAsPoint();
        Object3D OO = this.closestCenter(P.getX(), P.getY(), P.getZ(), dist);
        return this.closestCenter(P.getX(), P.getY(), P.getZ(), O.distCenterUnit(OO));
    }

    public Object3D secondClosestCenter(Object3D O, boolean ExcludeInputObject) {
        return this.kClosestCenter(O, 2, ExcludeInputObject);
    }

    public Object3D secondClosestCenter(Object3D ob, ArrayList<Object3D> exclude) {
        return this.kClosestCenter(ob, 2, exclude);
    }

    public Object3D closestBorder(double x, double y, double z) {
        Object3D res = null;
        double dmin = Double.MAX_VALUE;
        for (Object3D object : this.objects) {
            Object3D tmp = object;
            double d = tmp.distPixelBorderUnit(x, y, z);
            if (!(d < dmin)) continue;
            dmin = d;
            res = tmp;
        }
        return res;
    }

    public ArrayList<Object3D> shuffle() {
        ArrayList<Object3D> shuObj = new ArrayList<Object3D>();
        Random ra = new Random();
        ImageInt maskImage = this.mask.getMaxLabelImage(1);
        Object3DVoxels maskVox = this.mask.getObject3DVoxels();
        ArrayUtil shuffleIndex = new ArrayUtil(this.getNbObjects());
        shuffleIndex.fillRange(0, this.getNbObjects(), 1);
        shuffleIndex.shuffle();
        for (int i = 0; i < this.getNbObjects(); ++i) {
            Object3DVoxels obj = (Object3DVoxels)this.getObject(shuffleIndex.getValueInt(i));
            Point3D center = obj.getCenterAsPoint();
            boolean ok = false;
            int it = 0;
            int maxIt = 1000000;
            while (!ok) {
                Voxel3D vox = maskVox.getRandomvoxel(ra);
                obj.setNewCenter(vox.getX(), vox.getY(), vox.getZ());
                ok = true;
                ++it;
                obj.resetQuantifImage();
                if (maskVox.includesBox(obj)) {
                    if (obj.getPixMinValue(maskImage) < 1.0) {
                        ok = false;
                    }
                } else {
                    ok = false;
                }
                if (it < maxIt) continue;
                ok = true;
            }
            if (it == maxIt) {
                if (this.log != null) {
                    this.log.log("Could not shuffle " + obj);
                }
                obj.setNewCenter(center.x, center.y, center.z);
            }
            shuObj.add(obj);
            obj.draw(maskImage, 0);
        }
        return shuObj;
    }

    int[] k_Means(int k) {
        Object3D tmp;
        int s = this.objects.size();
        int[] res = new int[s];
        for (int i = 0; i < s; ++i) {
            res[i] = 0;
        }
        Point3D[] ck = new Point3D[k];
        double[] cx = new double[k];
        double[] cy = new double[k];
        double[] cz = new double[k];
        int[] nb = new int[k];
        double zmin = Double.MAX_VALUE;
        double ymin = Double.MAX_VALUE;
        double xmin = Double.MAX_VALUE;
        double zmax = -1.7976931348623157E308;
        double ymax = -1.7976931348623157E308;
        double xmax = -1.7976931348623157E308;
        for (Object3D object : this.objects) {
            tmp = object;
            if (tmp.getCenterX() < xmin) {
                xmin = tmp.getCenterX();
            }
            if (tmp.getCenterY() < ymin) {
                ymin = tmp.getCenterY();
            }
            if (tmp.getCenterZ() < zmin) {
                zmin = tmp.getCenterZ();
            }
            if (tmp.getCenterX() > xmax) {
                xmax = tmp.getCenterX();
            }
            if (tmp.getCenterY() > ymax) {
                ymax = tmp.getCenterY();
            }
            if (!(tmp.getCenterZ() > zmax)) continue;
            zmax = tmp.getCenterZ();
        }
        double dx = (xmax - xmin) / ((double)k - 1.0);
        double dy = (ymax - ymin) / ((double)k - 1.0);
        double dz = (zmax - zmin) / ((double)k - 1.0);
        for (int i = 0; i < k; ++i) {
            ck[i] = new Point3D(xmin + dx * (double)i, ymin + (double)i * dy, zmin + (double)i * dz);
        }
        boolean loop = true;
        while (loop) {
            int j;
            int idx;
            int i;
            loop = false;
            for (i = 0; i < s; ++i) {
                tmp = this.objects.get(i);
                idx = 0;
                double dmin = tmp.distPixelCenter(ck[0].getX(), ck[0].getY(), ck[0].getZ());
                for (int j2 = 1; j2 < k; ++j2) {
                    double d = tmp.distPixelCenter(ck[j2].getX(), ck[j2].getY(), ck[j2].getZ());
                    if (!(d < dmin)) continue;
                    dmin = d;
                    idx = j2;
                }
                if (idx == res[i]) continue;
                loop = true;
                res[i] = idx;
            }
            for (j = 0; j < k; ++j) {
                cx[k] = 0.0;
                cy[k] = 0.0;
                cz[k] = 0.0;
                nb[k] = 0;
            }
            for (i = 0; i < s; ++i) {
                tmp = this.objects.get(i);
                int n = idx = res[i];
                cx[n] = cx[n] + tmp.getCenterX();
                int n2 = idx;
                cy[n2] = cy[n2] + tmp.getCenterY();
                int n3 = idx;
                cz[n3] = cz[n3] + tmp.getCenterZ();
                int n4 = idx;
                nb[n4] = nb[n4] + 1;
            }
            for (j = 0; j < k; ++j) {
                ck[j] = new Point3D(cx[j] / (double)nb[j], cy[j] / (double)nb[j], cz[j] / (double)nb[j]);
            }
        }
        return res;
    }

    public ArrayList<double[]> getMeasureCentroid() {
        ArrayList<double[]> al = new ArrayList<double[]>();
        for (Object3D ob : this.objects) {
            double[] mes = new double[]{ob.getCenterX(), ob.getCenterY(), ob.getCenterZ()};
            al.add(mes);
        }
        return al;
    }

    public ArrayList<double[]> getMeasuresShape() {
        ArrayList<double[]> al = new ArrayList<double[]>();
        for (Object3D ob : this.objects) {
            double[] mes = new double[]{ob.getValue(), ob.getCompactness(true), ob.getSphericity(true), ob.getMainElongation(), ob.getMedianElongation(), ob.getRatioEllipsoid()};
            al.add(mes);
        }
        return al;
    }

    @Deprecated
    private void addImagePlus(ImagePlus plus) {
        this.addImage(plus);
    }

    public boolean saveObjects(String path) {
        int[] indexes = new int[this.getNbObjects()];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = i;
        }
        return this.saveObjects(path, indexes);
    }

    public boolean saveObjects(String path, int[] indexes) {
        File f = new File(path);
        String dir = f.getParent();
        String fs = File.separator;
        for (int i : indexes) {
            Object3D obj = this.getObject(i);
            obj.saveObject(dir + fs);
        }
        byte[] buf = new byte[1024];
        try {
            ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(path));
            for (int i : indexes) {
                int len;
                String name = this.getObject(i).getName();
                File file = new File(dir + fs + name + ".3droi");
                FileInputStream in = new FileInputStream(file);
                zip.putNextEntry(new ZipEntry(name + ".3droi"));
                while ((len = in.read(buf)) > 0) {
                    zip.write(buf, 0, len);
                }
                zip.closeEntry();
                in.close();
                file.delete();
            }
            zip.close();
        }
        catch (IOException ex) {
            if (this.log != null) {
                this.log.log("Pb saving population " + ex);
            }
            return false;
        }
        return true;
    }

    public void sortPopulation() {
        Collections.sort(this.objects);
        this.kdtree = null;
        this.hashValue = null;
        this.hashName = null;
    }

    public void loadObjects(String path) {
        block7: {
            byte[] buf = new byte[1024];
            if (this.log != null) {
                this.log.log("Loading objects from " + path);
            }
            File f = new File(path);
            String dir = f.getParent();
            String fs = File.separator;
            try {
                ZipInputStream zipinputstream = new ZipInputStream(new FileInputStream(path));
                ZipEntry zipentry = zipinputstream.getNextEntry();
                while (zipentry != null) {
                    int n;
                    String entryName = zipentry.getName();
                    FileOutputStream fileoutputstream = new FileOutputStream(dir + fs + entryName);
                    File file = new File(dir + fs + entryName);
                    while ((n = zipinputstream.read(buf, 0, 1024)) > -1) {
                        fileoutputstream.write(buf, 0, n);
                    }
                    fileoutputstream.close();
                    zipinputstream.closeEntry();
                    zipentry = zipinputstream.getNextEntry();
                    Object3DVoxels obj = new Object3DVoxels();
                    obj.setValue(1);
                    obj.loadObject(dir + fs, entryName);
                    obj.setName(entryName.substring(0, entryName.length() - 6));
                    this.addObject(obj);
                    file.delete();
                }
                zipinputstream.close();
            }
            catch (FileNotFoundException ex) {
                if (this.log != null) {
                    this.log.log("Pb loading " + ex);
                }
            }
            catch (IOException e) {
                if (this.log == null) break block7;
                this.log.log("Pb loading " + e);
            }
        }
    }
}

