/*
 * Decompiled with CFR 0.152.
 */
package plugins.ferreol.demics;

import icy.file.Loader;
import icy.gui.frame.progress.AnnounceFrame;
import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginInstaller;
import icy.plugin.PluginRepositoryLoader;
import icy.plugin.PluginUpdater;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.SwingUtilities;
import mitiv.array.ArrayUtils;
import mitiv.array.DoubleArray;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.jobs.DeconvolutionJob;
import mitiv.utils.FFTUtils;
import mitiv.utils.TiPiHook;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzButton;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarChannel;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarDoubleArrayNative;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;
import plugins.adufour.vars.lang.Var;
import plugins.ferreol.demics.DEMICSPlug;
import plugins.mitiv.io.DeconvHook;
import plugins.mitiv.io.Icy2TiPi;
import plugins.mitiv.io.IcyImager;

public class SimpleDEMIC
extends DEMICSPlug
implements Block,
EzStoppable {
    private EzVarSequence psf;
    private EzVarInteger paddingSizeX;
    private EzVarInteger paddingSizeY;
    private EzVarDouble epsilon;
    private EzVarBoolean showIteration;
    private EzButton saveParam;
    private EzButton loadParam;
    static boolean debug = false;
    private int psfSizeX = 1;
    private int psfSizeY = 1;
    private int psfSizeZ = 1;
    private static double[][] scaleDef = new double[][]{{1.0}, {1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}};
    private EzVarChannel channelpsf;
    private EzGroup ezPaddingGroup;
    private EzGroup ezWeightingGroup;
    private EzGroup ezDeconvolutionGroup;
    private EzGroup ezDeconvolutionGroup2;
    private DeconvolutionJob deconvolver;
    private ShapedArray badArray = null;

    protected void initialize() {
        PluginRepositoryLoader.waitLoaded();
        PluginDescriptor desc = PluginRepositoryLoader.getPlugin((String)"plugins.mitiv.deconv.MitivDeconvolution");
        if (desc != null && desc.isInstalled()) {
            if (!this.isHeadLess()) {
                new AnnounceFrame("Removing the now useless MitivDeconvolution plugin.");
            }
            PluginInstaller.desinstall((PluginDescriptor)desc, (boolean)false, (boolean)false);
            while (PluginUpdater.isCheckingForUpdate() || PluginInstaller.isProcessing() || PluginInstaller.isInstalling() || PluginInstaller.isDesinstalling()) {
                ThreadUtil.sleep((int)1);
            }
        }
        if (!this.isHeadLess()) {
            this.getUI().setParametersIOVisible(false);
            this.getUI().setActionPanelVisible(false);
        }
        this.data = new EzVarSequence("Data:");
        this.channel = new EzVarChannel("Data channel:", (Var)this.data.getVariable(), false);
        this.psf = new EzVarSequence("PSF:");
        this.channelpsf = new EzVarChannel("PSF channel :", (Var)this.psf.getVariable(), false);
        this.restart = new EzVarSequence("Starting point:");
        this.restart.setNoSequenceSelection();
        this.channelRestart = new EzVarChannel("Initialization channel :", (Var)this.restart.getVariable(), false);
        this.dataSize = new EzVarText("Data size:");
        this.outputSize = new EzVarText("Output size:");
        this.paddingSizeX = new EzVarInteger("padding x:", 0, Integer.MAX_VALUE, 1);
        this.paddingSizeY = new EzVarInteger("padding y:", 0, Integer.MAX_VALUE, 1);
        this.paddingSizeZ = new EzVarInteger("padding z :", 0, Integer.MAX_VALUE, 1);
        this.dataSize.setVisible(false);
        this.outputSize.setVisible(false);
        this.data.setNoSequenceSelection();
        this.psf.setNoSequenceSelection();
        this.ezPaddingGroup = new EzGroup("Padding", new EzComponent[]{this.paddingSizeX, this.paddingSizeY, this.paddingSizeZ});
        this.ezPaddingGroup.setFoldedState(true);
        EzVarListener<Integer> zeroPadActionListener = new EzVarListener<Integer>(){

            public void variableChanged(EzVar<Integer> source, Integer newValue) {
                SimpleDEMIC.this.updateImageSize();
                SimpleDEMIC.this.updatePaddedSize();
            }
        };
        this.paddingSizeX.addVarChangeListener((EzVarListener)zeroPadActionListener);
        this.paddingSizeY.addVarChangeListener((EzVarListener)zeroPadActionListener);
        this.paddingSizeZ.addVarChangeListener((EzVarListener)zeroPadActionListener);
        this.restart.addVarChangeListener((EzVarListener)new EzVarListener<Sequence>(){

            public void variableChanged(EzVar<Sequence> source, Sequence newValue) {
                newValue = (Sequence)SimpleDEMIC.this.restart.getValue();
                if (debug && (newValue != null || newValue != null && newValue.isEmpty())) {
                    System.out.println("restart changed:" + newValue.getName());
                }
            }
        });
        this.data.addVarChangeListener((EzVarListener)new EzVarListener<Sequence>(){

            public void variableChanged(EzVar<Sequence> source, Sequence newValue) {
                if (debug) {
                    System.out.println("Seq ch..." + SimpleDEMIC.this.data.getValue());
                }
                SimpleDEMIC.this.dataSize.setVisible(false);
                SimpleDEMIC.this.outputSize.setVisible(false);
                Sequence seq = (Sequence)SimpleDEMIC.this.data.getValue();
                if (seq != null || seq != null && seq.isEmpty()) {
                    SimpleDEMIC.this.sizeX = newValue.getSizeX();
                    SimpleDEMIC.this.sizeY = newValue.getSizeY();
                    SimpleDEMIC.this.sizeZ = newValue.getSizeZ();
                    SimpleDEMIC.this.dataSize.setVisible(true);
                    SimpleDEMIC.this.outputSize.setVisible(true);
                    SimpleDEMIC.this.updatePSFSize();
                    SimpleDEMIC.this.updateImageSize();
                    SimpleDEMIC.this.dataShape = new Shape(SimpleDEMIC.this.sizeX, SimpleDEMIC.this.sizeY, SimpleDEMIC.this.sizeZ);
                    if (debug) {
                        System.out.println("Seq changed:" + SimpleDEMIC.this.sizeX + "  " + SimpleDEMIC.this.Nx);
                    }
                    SimpleDEMIC.this.restart.setValue(newValue);
                    SimpleDEMIC.this.channelRestart.setValue(SimpleDEMIC.this.channel.getValue());
                }
            }
        });
        this.channel.addVarChangeListener((EzVarListener)new EzVarListener<Integer>(){

            public void variableChanged(EzVar<Integer> source, Integer newValue) {
                SimpleDEMIC.this.channelRestart.setValue((Object)newValue);
            }
        });
        this.psf.addVarChangeListener((EzVarListener)new EzVarListener<Sequence>(){

            public void variableChanged(EzVar<Sequence> source, Sequence newValue) {
                if (debug) {
                    System.out.println("PSF changed" + SimpleDEMIC.this.psf.getValue());
                }
                if (newValue != null || newValue != null && newValue.isEmpty()) {
                    SimpleDEMIC.this.psfSizeX = Math.max(1, newValue.getSizeX());
                    SimpleDEMIC.this.psfSizeY = Math.max(1, newValue.getSizeY());
                    SimpleDEMIC.this.psfSizeZ = Math.max(1, newValue.getSizeZ());
                    SimpleDEMIC.this.updatePSFSize();
                    SimpleDEMIC.this.updateImageSize();
                    if (debug) {
                        System.out.println("PSF changed:" + SimpleDEMIC.this.psfSizeX + "  " + SimpleDEMIC.this.psfSizeY);
                    }
                }
            }
        });
        this.weightsMethod = new EzVarText("Weighting:", this.weightOptions, 3, Boolean.valueOf(false));
        this.weights = new EzVarSequence("Map:");
        this.gain = new EzVarDouble("Gain:", 1.0, 0.01, Double.MAX_VALUE, 1.0);
        this.noise = new EzVarDouble("Readout Noise:", 10.0, 0.0, Double.MAX_VALUE, 0.1);
        this.deadPixel = new EzVarSequence("Bad data map:");
        this.weights.setNoSequenceSelection();
        this.weightsMethod.addVarChangeListener((EzVarListener)new EzVarListener<String>(){

            public void variableChanged(EzVar<String> source, String newValue) {
                if (debug) {
                    System.out.println("weight:" + (String)SimpleDEMIC.this.weightsMethod.getValue() + ".");
                    System.out.println("weight:" + newValue + ".");
                    System.out.println("weight:" + SimpleDEMIC.this.weightOptions[3] + ".");
                    System.out.println("weight:" + SimpleDEMIC.this.weightOptions[3] == newValue);
                }
                if (SimpleDEMIC.this.weightsMethod.getValue() == SimpleDEMIC.this.weightOptions[0]) {
                    SimpleDEMIC.this.weights.setVisible(false);
                    SimpleDEMIC.this.gain.setVisible(false);
                    SimpleDEMIC.this.noise.setVisible(false);
                } else if (SimpleDEMIC.this.weightsMethod.getValue() == SimpleDEMIC.this.weightOptions[1] || SimpleDEMIC.this.weightsMethod.getValue() == SimpleDEMIC.this.weightOptions[2]) {
                    SimpleDEMIC.this.weights.setVisible(true);
                    SimpleDEMIC.this.gain.setVisible(false);
                    SimpleDEMIC.this.noise.setVisible(false);
                    SimpleDEMIC.this.weights.setNoSequenceSelection();
                } else if (SimpleDEMIC.this.weightsMethod.getValue() == SimpleDEMIC.this.weightOptions[3]) {
                    SimpleDEMIC.this.weights.setVisible(false);
                    SimpleDEMIC.this.gain.setVisible(true);
                    SimpleDEMIC.this.noise.setVisible(true);
                    SimpleDEMIC.this.weights.setNoSequenceSelection();
                } else {
                    SimpleDEMIC.this.throwError("Invalid argument passed to weight method");
                    return;
                }
            }
        });
        this.weights.setVisible(false);
        this.gain.setVisible(false);
        this.noise.setVisible(false);
        this.deadPixel.setVisible(true);
        this.deadPixel.setNoSequenceSelection();
        this.showWeight = new EzButton("Show weight map", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sequence dataSeq = (Sequence)SimpleDEMIC.this.data.getValue();
                if (dataSeq != null) {
                    DoubleArray dataArray = Icy2TiPi.sequenceToArray(dataSeq, (Integer)SimpleDEMIC.this.channel.getValue()).toDouble();
                    SimpleDEMIC.this.wgtArray = SimpleDEMIC.this.createWeights((ShapedArray)dataArray, SimpleDEMIC.this.badArray).toDouble();
                    IcyImager.show(SimpleDEMIC.this.wgtArray, null, "Weight map", false);
                }
                if (debug) {
                    System.out.println("Weight compute");
                }
            }
        });
        this.ezWeightingGroup = new EzGroup("Weighting", new EzComponent[]{this.weightsMethod, this.weights, this.gain, this.noise, this.deadPixel, this.showWeight});
        this.ezWeightingGroup.setFoldedState(true);
        this.mu = new EzVarDouble("Regularization level:", 1.0E-5, 0.0, Double.MAX_VALUE, 0.01);
        this.logmu = new EzVarDouble("Log10 of the Regularization level:", -5.0, -1.7976931348623157E308, Double.MAX_VALUE, 1.0);
        this.epsilon = new EzVarDouble("Threshold level:", 0.01, 0.0, Double.MAX_VALUE, 1.0);
        this.nbIterDeconv = new EzVarInteger("Number of iterations: ", 10, 1, Integer.MAX_VALUE, 1);
        this.positivity = new EzVarBoolean("Enforce nonnegativity:", true);
        this.singlePrecision = new EzVarBoolean("Compute in single precision:", false);
        this.showIteration = new EzVarBoolean("Show intermediate results:", true);
        if (this.isHeadLess()) {
            this.showIteration.setValue((Object)false);
        }
        this.scale = new EzVarDoubleArrayNative("Aspect ratio of a voxel", scaleDef, 2, true);
        this.ezDeconvolutionGroup2 = new EzGroup("More  parameters", new EzComponent[]{this.epsilon, this.scale, this.positivity, this.singlePrecision});
        this.ezDeconvolutionGroup2.setFoldedState(true);
        this.ezDeconvolutionGroup = new EzGroup("Deconvolution parameters", new EzComponent[]{this.logmu, this.mu, this.nbIterDeconv, this.ezDeconvolutionGroup2});
        this.startDec = new EzButton("Start Deconvolution", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SimpleDEMIC.this.deconvolver != null && SimpleDEMIC.this.deconvolver.isRunning()) {
                    SimpleDEMIC.this.stopExecution();
                } else {
                    Thread workerThread = new Thread(){

                        @Override
                        public void run() {
                            SimpleDEMIC.this.launch();
                        }
                    };
                    workerThread.start();
                }
            }
        });
        this.showFullObject = new EzButton("Show the full (padded) object", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (debug) {
                    System.out.println("showFullObject");
                }
                Sequence fSeq = new Sequence("Deconvolved image");
                fSeq.copyMetaDataFrom((Sequence)SimpleDEMIC.this.data.getValue(), false);
                if (SimpleDEMIC.this.objArray != null) {
                    IcyImager.show(SimpleDEMIC.this.objArray, fSeq, "Deconvolved " + ((Sequence)SimpleDEMIC.this.data.getValue()).getName() + "with padding. mu=" + SimpleDEMIC.this.mu.getValue(), SimpleDEMIC.this.isHeadLess());
                } else {
                    IcyImager.show(ArrayUtils.extract((ShapedArray)SimpleDEMIC.this.dataArray, (Shape)SimpleDEMIC.this.outputShape), fSeq, "Deconvolved " + ((Sequence)SimpleDEMIC.this.data.getValue()).getName() + "with padding. mu=" + SimpleDEMIC.this.mu.getValue(), SimpleDEMIC.this.isHeadLess());
                }
            }
        });
        EzVarListener<Double> logmuActionListener = new EzVarListener<Double>(){

            public void variableChanged(EzVar<Double> source, Double newValue) {
                SimpleDEMIC.this.mu.setValue((Object)Math.pow(10.0, (Double)SimpleDEMIC.this.logmu.getValue()));
            }
        };
        this.logmu.addVarChangeListener((EzVarListener)logmuActionListener);
        EzGroup groupVisu = new EzGroup("Visualization", new EzComponent[]{this.showIteration, this.showFullObject});
        groupVisu.setFoldedState(true);
        this.saveFile = new EzVarFile("Save parameters in", "");
        this.saveParam = new EzButton("Save parameters", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleDEMIC.this.saveParamClicked();
                if (debug) {
                    System.out.println("Save parameters");
                }
            }
        });
        this.loadParam = new EzButton("Load parameters", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SimpleDEMIC.this.saveFile.getValue() != null) {
                    SimpleDEMIC.this.loadParameters((File)SimpleDEMIC.this.saveFile.getValue());
                    Sequence dataSeq = (Sequence)SimpleDEMIC.this.data.getValue();
                    if (dataSeq != null) {
                        SimpleDEMIC.this.sizeX = dataSeq.getSizeX();
                        SimpleDEMIC.this.sizeY = dataSeq.getSizeY();
                        SimpleDEMIC.this.sizeZ = dataSeq.getSizeZ();
                        if (SimpleDEMIC.this.sizeZ == 1) {
                            SimpleDEMIC.this.throwError("Input data must be 3D");
                            return;
                        }
                        SimpleDEMIC.this.updatePaddedSize();
                        SimpleDEMIC.this.updateOutputSize();
                        SimpleDEMIC.this.updateImageSize();
                        SimpleDEMIC.this.dataShape = new Shape(SimpleDEMIC.this.sizeX, SimpleDEMIC.this.sizeY, SimpleDEMIC.this.sizeZ);
                    }
                }
                if (debug) {
                    System.out.println("Load parameters");
                }
            }
        });
        this.addEzComponent((EzComponent)this.data);
        this.addEzComponent((EzComponent)this.channel);
        this.addEzComponent((EzComponent)this.psf);
        this.addEzComponent((EzComponent)this.channelpsf);
        this.addEzComponent((EzComponent)this.restart);
        this.addEzComponent((EzComponent)this.channelRestart);
        this.addEzComponent((EzComponent)this.dataSize);
        this.addEzComponent((EzComponent)this.outputSize);
        this.addEzComponent((EzComponent)this.ezPaddingGroup);
        this.addEzComponent((EzComponent)this.ezWeightingGroup);
        this.addEzComponent((EzComponent)this.ezDeconvolutionGroup);
        this.addEzComponent((EzComponent)this.startDec);
        this.addEzComponent((EzComponent)groupVisu);
        this.addEzComponent((EzComponent)this.saveFile);
        this.addEzComponent((EzComponent)this.saveParam);
        this.addEzComponent((EzComponent)this.loadParam);
        this.setDefaultValue();
        this.updatePaddedSize();
        this.updateOutputSize();
        this.updateImageSize();
        if (!this.isHeadLess()) {
            this.outputSize.setEnabled(false);
            this.dataSize.setEnabled(false);
            this.mu.setEnabled(false);
        } else {
            this.outputHeadlessImage = new EzVarSequence("Output Image");
            this.outputHeadlessWght = new EzVarSequence("Computed weight");
        }
    }

    private void saveParamClicked() {
        File pathName = (File)this.saveFile.getValue();
        if (pathName != null) {
            if (!pathName.getName().endsWith(".xml")) {
                pathName = new File(pathName.getAbsolutePath() + ".xml");
            }
            this.saveParameters(pathName);
        }
    }

    @Override
    protected void updateOutputSize() {
        String text;
        if (this.Nz == 1) {
            text = this.Nx + "x" + this.Ny;
            this.scale.setValue((Object)scaleDef[1]);
        } else {
            this.scale.setValue((Object)scaleDef[2]);
            text = this.Nx + "x" + this.Ny + "x" + this.Nz;
        }
        this.outputSize.setValue((Object)text);
        if (1.0 * (double)this.Nx * (double)this.Ny * (double)this.Nz > Math.pow(2.0, 31.0)) {
            this.throwError("Padded image is too large (>2^31)");
        }
    }

    @Override
    protected void updatePaddedSize() {
        this.Nx = FFTUtils.bestDimension((int)(this.sizeX + (Integer)this.paddingSizeX.getValue()));
        this.Ny = FFTUtils.bestDimension((int)(this.sizeY + (Integer)this.paddingSizeY.getValue()));
        if (this.Nz == 1 && (Integer)this.paddingSizeZ.getValue() == 0) {
            this.outputShape = new Shape(this.Nx, this.Ny);
        } else {
            this.Nz = FFTUtils.bestDimension((int)(this.sizeZ + (Integer)this.paddingSizeZ.getValue()));
            this.outputShape = new Shape(this.Nx, this.Ny, this.Nz);
        }
        this.updateOutputSize();
        if (debug) {
            System.out.println(" UpdatePaddedSize" + this.paddingSizeX.getValue() + this.outputShape.toString());
        }
    }

    protected void updatePSFSize() {
        this.paddingSizeX.setValue((Object)this.psfSizeX);
        this.paddingSizeY.setValue((Object)this.psfSizeY);
        if (this.psfSizeZ == 1) {
            this.paddingSizeZ.setValue((Object)0);
        } else {
            this.paddingSizeZ.setValue((Object)this.psfSizeZ);
        }
        this.updatePaddedSize();
        if (debug) {
            System.out.println(" UpdatePaddedSize " + this.paddingSizeX.getValue() + this.outputShape.toString());
        }
    }

    protected void execute() {
        if (this.isHeadLess()) {
            if (Icy.getCommandLinePluginArgs().length != 0) {
                this.initialize();
                this.parseCmdLine();
            }
            this.showIteration.setValue((Object)false);
            if (debug) {
                System.out.println("Launch it:" + this.nbIterDeconv.getValue());
            }
        }
        this.launch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void launch() {
        try {
            this.startDec.setText("Emergency stop");
            this.dataSeq = (Sequence)this.data.getValue();
            Sequence psfSeq = (Sequence)this.psf.getValue();
            Sequence restartSeq = (Sequence)this.restart.getValue();
            if (this.dataSeq == null) {
                this.throwError("An image should be given");
                return;
            }
            if (psfSeq == null) {
                this.throwError("A psf should be given");
                return;
            }
            if (this.sizeZ == 1 && this.sizeY == 1) {
                this.throwError("Input data must be 2D or 3D");
                return;
            }
            if ((double)((Integer)this.paddingSizeX.getValue()).intValue() < 0.0) {
                this.throwError("Padding value cannot be negative");
                return;
            }
            if ((double)((Integer)this.paddingSizeY.getValue()).intValue() < 0.0) {
                this.throwError("Padding value cannot be negative");
                return;
            }
            if ((double)((Integer)this.paddingSizeZ.getValue()).intValue() < 0.0) {
                this.throwError("Padding value cannot be negative");
                return;
            }
            this.dataArray = Icy2TiPi.sequenceToArray(this.dataSeq, (Integer)this.channel.getValue());
            this.psfArray = Icy2TiPi.sequenceToArray(psfSeq, (Integer)this.channelpsf.getValue());
            this.dataShape = this.dataArray.getShape();
            if (this.restart.getValue() != null && restartSeq != null) {
                this.objArray = Icy2TiPi.sequenceToArray(restartSeq, (Integer)this.channelRestart.getValue());
                if (debug) {
                    System.out.println("restart seq:" + restartSeq.getName());
                }
            } else {
                this.objArray = Icy2TiPi.sequenceToArray(this.dataSeq, (Integer)this.channel.getValue());
                if (debug) {
                    System.out.println("restart seq is null:");
                }
            }
            this.wgtArray = (Boolean)this.singlePrecision.getValue() != false ? this.createWeights((ShapedArray)this.dataArray.toFloat(), this.badArray).toFloat() : this.createWeights((ShapedArray)this.dataArray.toDouble(), this.badArray).toDouble();
            this.cursequence = new Sequence("Current Iterate");
            this.cursequence.copyMetaDataFrom(this.dataSeq, false);
            if (this.Nz == 1) {
                if (((double[])this.scale.getValue()).length != 2) {
                    this.throwError("Pixel scale must have 2 elements");
                    return;
                }
            } else if (((double[])this.scale.getValue()).length != 3) {
                this.throwError("Pixel scale must have 3 elements");
                return;
            }
            if (debug) {
                System.out.println("Launch it:" + this.nbIterDeconv.getValue());
            }
            IcyImager curImager = new IcyImager(this.cursequence, this.isHeadLess());
            DeconvHook dHook = new DeconvHook(curImager, this.dataShape, null, debug);
            DeconvHook dHookfinal = new DeconvHook(curImager, this.dataShape, "Deconvolved " + this.dataSeq.getName(), debug);
            this.deconvolver = new DeconvolutionJob(this.dataArray, this.psfArray, this.wgtArray, this.outputShape, ((Double)this.mu.getValue()).doubleValue(), ((Double)this.epsilon.getValue()).doubleValue(), (double[])this.scale.getValue(), ((Boolean)this.positivity.getValue()).booleanValue(), ((Boolean)this.singlePrecision.getValue()).booleanValue(), ((Integer)this.nbIterDeconv.getValue()).intValue(), (TiPiHook)dHook, (TiPiHook)dHookfinal);
            this.objArray = this.deconvolver.deconv(this.objArray);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (debug) {
                        System.out.println("invoke later");
                    }
                    SimpleDEMIC.this.restart.setValue(SimpleDEMIC.this.cursequence);
                    SimpleDEMIC.this.channelRestart.setValue((Object)0);
                    if (SimpleDEMIC.this.isHeadLess()) {
                        if (SimpleDEMIC.this.outputHeadlessImage == null) {
                            SimpleDEMIC.this.outputHeadlessImage = new EzVarSequence("Output Image");
                        }
                        SimpleDEMIC.this.outputHeadlessImage.setValue(SimpleDEMIC.this.cursequence);
                        if (SimpleDEMIC.this.outputHeadlessWght == null) {
                            SimpleDEMIC.this.outputHeadlessWght = new EzVarSequence("Computed weights");
                        }
                        SimpleDEMIC.this.outputHeadlessWght.setValue(Icy2TiPi.arrayToSequence(SimpleDEMIC.this.wgtArray));
                        if (SimpleDEMIC.this.outputPath != null) {
                            IcyImager.save(SimpleDEMIC.this.cursequence, SimpleDEMIC.this.outputPath);
                        }
                        if (SimpleDEMIC.this.saveFile.getValue() != null) {
                            SimpleDEMIC.this.saveParamClicked();
                        }
                    }
                }
            });
        }
        catch (IllegalArgumentException e) {
            new AnnounceFrame("Oops, Error: " + e.getMessage());
            if (debug) {
                e.printStackTrace();
            }
        }
        finally {
            this.startDec.setText("Start Deconvolution");
        }
    }

    public void stopExecution() {
        if (this.deconvolver != null) {
            this.deconvolver.abort();
        }
    }

    @Override
    protected void setDefaultValue() {
        super.setDefaultValue();
        this.paddingSizeX.setValue((Object)10);
        this.paddingSizeY.setValue((Object)10);
    }

    @Override
    public void declareInput(VarList inputMap) {
        this.initialize();
        super.declareInput(inputMap);
        inputMap.add("psf", (Var)this.psf.getVariable());
        inputMap.add("psf channel", this.channelpsf.getVariable());
        inputMap.add("Padding X", this.paddingSizeX.getVariable());
        inputMap.add("Padding Y", this.paddingSizeY.getVariable());
        inputMap.add("Padding Z", this.paddingSizeZ.getVariable());
        inputMap.add("espilon", this.epsilon.getVariable());
    }

    public void clean() {
        this.stopExecution();
    }

    private void parseCmdLine() {
        String[] args = Icy.getCommandLinePluginArgs();
        this.loadParameters(new File(args[0]));
        block16: for (int i = 1; i < args.length; ++i) {
            switch (args[i]) {
                case "-i": {
                    if (i + 1 >= args.length) continue block16;
                    System.out.println("load image:" + args[i + 1]);
                    this.data.setValue(Loader.loadSequence((String)args[i + 1], (int)0, (boolean)false));
                    this.data.valueChanged((Var)this.data.getVariable(), null, this.data.getValue());
                    if (i + 3 >= args.length || args[i + 1].startsWith("-")) continue block16;
                    if (args[i + 2].equalsIgnoreCase("-c")) {
                        this.channel.setValue((Object)Integer.parseInt(args[i + 3]));
                        i += 3;
                        continue block16;
                    }
                    ++i;
                    continue block16;
                }
                case "-p": {
                    if (i + 1 >= args.length || args[i + 1].startsWith("-")) continue block16;
                    System.out.println("load psf:" + args[i + 1]);
                    this.psf.setValue(Loader.loadSequence((String)args[i + 1], (int)0, (boolean)false));
                    if (i + 3 >= args.length) continue block16;
                    if (args[i + 2].equalsIgnoreCase("-c")) {
                        this.channelpsf.setValue((Object)Integer.parseInt(args[i + 3]));
                        i += 3;
                        continue block16;
                    }
                    ++i;
                    continue block16;
                }
                case "-r": {
                    if (i + 1 >= args.length || args[i + 1].startsWith("-")) continue block16;
                    System.out.println("load restart:" + args[i + 1]);
                    this.restart.setValue(Loader.loadSequence((String)args[i + 1], (int)0, (boolean)false));
                    if (i + 3 >= args.length) continue block16;
                    if (args[i + 2].equalsIgnoreCase("-c")) {
                        System.out.println("channel restart:" + Integer.parseInt(args[i + 3]));
                        this.channelRestart.setValue((Object)Integer.parseInt(args[i + 3]));
                        i += 3;
                        continue block16;
                    }
                    ++i;
                    continue block16;
                }
                case "-o": {
                    if (i + 1 >= args.length) continue block16;
                    this.outputPath = args[i + 1];
                    ++i;
                    continue block16;
                }
                case "-badpix": {
                    if (i + 1 >= args.length || args[i + 1].startsWith("-")) continue block16;
                    this.deadPixel.setValue(Loader.loadSequence((String)args[i + 1], (int)0, (boolean)false));
                    ++i;
                    continue block16;
                }
                case "-wghtmap": {
                    if (i + 1 >= args.length || args[i + 1].startsWith("-")) continue block16;
                    this.weights.setValue(Loader.loadSequence((String)args[i + 1], (int)0, (boolean)false));
                    ++i;
                    continue block16;
                }
                default: {
                    System.out.println("Wrong command line");
                    System.out.println("-i input data file");
                    System.out.println("-p psf file");
                    System.out.println("-r restart file");
                    System.out.println("-o deconvolved output file");
                    System.out.println("-badpix bad pixels file");
                    System.out.println("-wghtmap weight or variance map file");
                }
            }
        }
    }
}

