/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.processing;

import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.distanceMap3d.EDT;
import mcib3d.image3d.processing.FastFilters3D;
import mcib3d.utils.ThreadRunner;
import mcib3d.utils.ThreadUtil;
import mcib3d.utils.exceptionPrinter;

public class BinaryMorpho {
    public static final byte MORPHO_DILATE = 1;
    public static final byte MORPHO_ERODE = 2;
    public static final byte MORPHO_CLOSE = 3;
    public static final byte MORPHO_OPEN = 4;

    public static ImageByte binaryMorpho(ImageInt in, int op, float radius, float radiusZ) {
        return BinaryMorpho.binaryMorpho(in, op, radius, radiusZ, 0);
    }

    public static ImageByte binaryMorpho(ImageInt in, int op, float radius, float radiusZ, int nbCPUs) {
        switch (op) {
            case 1: {
                return BinaryMorpho.binaryDilate(in, radius, radiusZ, nbCPUs);
            }
            case 3: {
                return BinaryMorpho.binaryClose(in, radius, radiusZ, nbCPUs);
            }
            case 2: {
                return BinaryMorpho.binaryErode(in, radius, radiusZ, nbCPUs);
            }
            case 4: {
                return BinaryMorpho.binaryOpen(in, radius, radiusZ, nbCPUs);
            }
        }
        return null;
    }

    public static ImageByte binaryOpen(ImageInt in, float radius, float radiusZ) {
        return BinaryMorpho.binaryOpen(in, radius, radiusZ, 0);
    }

    public static ImageByte binaryOpen(ImageInt in, float radius, float radiusZ, int nbCPUs) {
        try {
            if (nbCPUs == 0) {
                nbCPUs = ThreadUtil.getNbCpus();
            }
            ImageFloat edm = EDT.run(in, 0.0f, 1.0f, radius / radiusZ, false, nbCPUs);
            ImageByte temp = edm.threshold(radius, false, true);
            edm.closeImagePlus();
            edm = EDT.run(temp, 0.0f, 1.0f, radius / radiusZ, true, nbCPUs);
            temp.closeImagePlus();
            temp = edm.threshold(radius, true, false);
            edm.closeImagePlus();
            edm = null;
            System.gc();
            temp.setOffset(in);
            temp.setScale(in);
            return temp;
        }
        catch (Exception e) {
            exceptionPrinter.print(e, null, true);
            return null;
        }
    }

    public static ImageByte binaryErode(ImageInt in, float radius, float radiusZ) {
        return BinaryMorpho.binaryErode(in, radius, radiusZ, 0);
    }

    public static ImageByte binaryErode(ImageInt in, float radius, float radiusZ, int nbCPUs) {
        try {
            if (nbCPUs == 0) {
                nbCPUs = ThreadUtil.getNbCpus();
            }
            ImageFloat edm = EDT.run(in, 0.0f, 1.0f, radius / radiusZ, false, nbCPUs);
            ImageByte temp = edm.threshold(radius, false, true);
            edm.flush();
            edm = null;
            temp.setOffset(in);
            temp.setScale(in);
            return temp;
        }
        catch (Exception e) {
            exceptionPrinter.print(e, null, true);
            return null;
        }
    }

    public static ImageByte binaryDilate2D(ImageByte in, float radius, boolean enlarge) {
        ImageInt resize = in;
        int reX = (int)(radius + 1.0f);
        int reY = (int)(radius + 1.0f);
        int reZ = 0;
        if (enlarge) {
            resize = (ImageInt)in.enlarge(reX, reY, reZ);
        }
        ImageByte temp = (ImageByte)FastFilters3D.filterIntImage(resize, 3, radius, radius, 0.0f, 1, false);
        temp.setScale(in);
        if (enlarge) {
            temp.setOffset(in.offsetX - reX, in.offsetY - reY, in.offsetZ - reZ);
        } else {
            temp.setOffset(in);
        }
        return temp;
    }

    public static ImageByte binaryErode2D(ImageByte in, float radius) {
        ImageByte temp = (ImageByte)FastFilters3D.filterIntImage(in, 2, radius, radius, 0.0f, 1, false);
        temp.setOffset(in);
        temp.setScale(in);
        return temp;
    }

    public static ImageByte binaryDilate(ImageInt in, float radius, float radiusZ) {
        return BinaryMorpho.binaryDilate(in, radius, radiusZ, 0);
    }

    public static ImageByte binaryDilate(ImageInt in, float radius, float radiusZ, int nbCPUs, boolean enlarge) {
        try {
            if (nbCPUs == 0) {
                nbCPUs = ThreadUtil.getNbCpus();
            }
            ImageInt resize = in;
            int reX = (int)(radius + 1.0f);
            int reY = (int)(radius + 1.0f);
            int reZ = (int)(radiusZ + 1.0f);
            if (enlarge) {
                resize = (ImageInt)in.enlarge(reX, reY, reZ);
            }
            ImageFloat edm = EDT.run(resize, 0.0f, 1.0f, radius / radiusZ, true, nbCPUs);
            ImageByte temp = edm.threshold(radius, true, false);
            edm.flush();
            edm = null;
            if (enlarge) {
                temp.setOffset(in.offsetX - reX, in.offsetY - reY, in.offsetZ - reZ);
            } else {
                temp.setOffset(in);
            }
            temp.setScale(in);
            return temp;
        }
        catch (Exception e) {
            exceptionPrinter.print(e, null, true);
            return null;
        }
    }

    public static ImageByte binaryDilate(ImageInt in, float radius, float radiusZ, int nbCPUs) {
        return BinaryMorpho.binaryDilate(in, radius, radiusZ, nbCPUs, false);
    }

    public static ImageByte binaryClose(ImageInt in, float radius, float radiusZ) {
        return BinaryMorpho.binaryClose(in, radius, radiusZ, 0);
    }

    private static ImageByte binaryClose2D(ImageByte in, float radius) {
        ImageByte dilated = BinaryMorpho.binaryDilate2D(in, radius, true);
        ImageByte close = BinaryMorpho.binaryErode2D(dilated, radius);
        int ox = in.offsetX - dilated.offsetX;
        int oy = in.offsetY - dilated.offsetY;
        int oz = in.offsetZ - dilated.offsetZ;
        return close.crop3D("binaryClose", ox, ox + in.sizeX - 1, oy, oy + in.sizeY - 1, oz, oz + in.sizeZ - 1);
    }

    public static ImageByte binaryClose(ImageInt in, float radius, float radiusZ, int nbCPUs) {
        ImageByte dilated = BinaryMorpho.binaryDilate(in, radius, radiusZ, nbCPUs, true);
        ImageByte close = BinaryMorpho.binaryErode(dilated, radius, radiusZ, nbCPUs);
        int ox = in.offsetX - dilated.offsetX;
        int oy = in.offsetY - dilated.offsetY;
        int oz = in.offsetZ - dilated.offsetZ;
        return close.crop3D("binaryClose", ox, ox + in.sizeX - 1, oy, oy + in.sizeY - 1, oz, oz + in.sizeZ - 1);
    }

    private static ImageByte binaryOpenRad1(final ImageInt in, final float thld, int nbCPUs) {
        if (nbCPUs == 0) {
            nbCPUs = ThreadUtil.getNbCpus();
        }
        final ImageByte min = new ImageByte("min", in.sizeX, in.sizeY, in.sizeZ);
        final ThreadRunner tr = new ThreadRunner(0, in.sizeZ, nbCPUs);
        for (int i = 0; i < tr.threads.length; ++i) {
            tr.threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int z = tr.ai.getAndIncrement();
                    while (z < tr.end) {
                        for (int y = 0; y < in.sizeY; ++y) {
                            for (int x = 0; x < in.sizeX; ++x) {
                                if (!BinaryMorpho.minRad1(in, thld, x, y, z)) continue;
                                min.pixels[z][x + y * in.sizeX] = -1;
                            }
                        }
                        z = tr.ai.getAndIncrement();
                    }
                }
            });
        }
        tr.startAndJoin();
        final ImageByte open = new ImageByte(in.getTitle() + "::open", in.sizeX, in.sizeY, in.sizeZ);
        final ThreadRunner tr2 = new ThreadRunner(0, in.sizeZ, nbCPUs);
        for (int i = 0; i < tr2.threads.length; ++i) {
            tr2.threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int z = tr2.ai.getAndIncrement();
                    while (z < tr2.end) {
                        for (int y = 0; y < in.sizeY; ++y) {
                            for (int x = 0; x < in.sizeX; ++x) {
                                if (!BinaryMorpho.maxRad1(min, 1.0f, x, y, z)) continue;
                                open.pixels[z][x + y * in.sizeX] = -1;
                            }
                        }
                        z = tr2.ai.getAndIncrement();
                    }
                }
            });
        }
        tr2.startAndJoin();
        min.closeImagePlus();
        open.setScale(in);
        open.setOffset(in);
        return open;
    }

    private static ImageByte binaryErodeRad1(final ImageInt in, final float thld, int nbCPUs) {
        if (nbCPUs == 0) {
            nbCPUs = ThreadUtil.getNbCpus();
        }
        final ImageByte min = new ImageByte("min", in.sizeX, in.sizeY, in.sizeZ);
        final ThreadRunner tr = new ThreadRunner(0, in.sizeZ, nbCPUs);
        for (int i = 0; i < tr.threads.length; ++i) {
            tr.threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int z = tr.ai.getAndIncrement();
                    while (z < tr.end) {
                        for (int y = 0; y < in.sizeY; ++y) {
                            for (int x = 0; x < in.sizeX; ++x) {
                                if (!BinaryMorpho.minRad1(in, thld, x, y, z)) continue;
                                min.pixels[z][x + y * in.sizeX] = -1;
                            }
                        }
                        z = tr.ai.getAndIncrement();
                    }
                }
            });
        }
        tr.startAndJoin();
        min.setScale(in);
        min.setOffset(in);
        return min;
    }

    private static ImageByte binaryDilateRad1(ImageInt in_, final float thld, int nbCPUs) {
        if (nbCPUs == 0) {
            nbCPUs = ThreadUtil.getNbCpus();
        }
        final ImageInt in = (ImageInt)in_.resize(1, 1, 1);
        final ImageByte max = new ImageByte("max", in.sizeX, in.sizeY, in.sizeZ);
        final ThreadRunner tr = new ThreadRunner(0, in.sizeZ, nbCPUs);
        for (int i = 0; i < tr.threads.length; ++i) {
            tr.threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int z = tr.ai.getAndIncrement();
                    while (z < tr.end) {
                        for (int y = 0; y < in.sizeY; ++y) {
                            for (int x = 0; x < in.sizeX; ++x) {
                                if (!BinaryMorpho.maxRad1(in, thld, x, y, z)) continue;
                                max.pixels[z][x + y * in.sizeX] = -1;
                            }
                        }
                        z = tr.ai.getAndIncrement();
                    }
                }
            });
        }
        tr.startAndJoin();
        max.setScale(in);
        max.setOffset(in);
        return max;
    }

    private static ImageByte binaryDilateRad1diag(ImageInt in_, final float thld, int nbCPUs) {
        if (nbCPUs == 0) {
            nbCPUs = ThreadUtil.getNbCpus();
        }
        final ImageInt in = (ImageInt)in_.resize(1, 1, 1);
        final ImageByte max = new ImageByte("max", in.sizeX, in.sizeY, in.sizeZ);
        final ThreadRunner tr = new ThreadRunner(0, in.sizeZ, nbCPUs);
        for (int i = 0; i < tr.threads.length; ++i) {
            tr.threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int z = tr.ai.getAndIncrement();
                    while (z < tr.end) {
                        for (int y = 0; y < in.sizeY; ++y) {
                            for (int x = 0; x < in.sizeX; ++x) {
                                if (!BinaryMorpho.maxRad15(in, thld, x, y, z)) continue;
                                max.pixels[z][x + y * in.sizeX] = -1;
                            }
                        }
                        z = tr.ai.getAndIncrement();
                    }
                }
            });
        }
        tr.startAndJoin();
        max.setScale(in);
        max.setOffset(in);
        return max;
    }

    private static ImageByte binaryCloseRad1(ImageInt in_, final float thld, int nbCPUs) {
        if (nbCPUs == 0) {
            nbCPUs = ThreadUtil.getNbCpus();
        }
        final ImageInt in = (ImageInt)in_.resize(1, 1, 1);
        final ImageByte max = new ImageByte("max", in.sizeX, in.sizeY, in.sizeZ);
        final ThreadRunner tr = new ThreadRunner(0, max.sizeZ, nbCPUs);
        for (int i = 0; i < tr.threads.length; ++i) {
            tr.threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int z = tr.ai.getAndIncrement();
                    while (z < tr.end) {
                        for (int y = 0; y < max.sizeY; ++y) {
                            for (int x = 0; x < max.sizeX; ++x) {
                                if (!BinaryMorpho.maxRad1(in, thld, x, y, z)) continue;
                                max.pixels[z][x + y * in.sizeX] = -1;
                            }
                        }
                        z = tr.ai.getAndIncrement();
                    }
                }
            });
        }
        tr.startAndJoin();
        final ThreadRunner tr2 = new ThreadRunner(0, in.sizeZ, nbCPUs);
        final ImageByte close = new ImageByte(in.getTitle() + "::close", in.sizeX, in.sizeY, in.sizeZ);
        for (int i = 0; i < tr2.threads.length; ++i) {
            tr2.threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int z = tr2.ai.getAndIncrement();
                    while (z < tr2.end) {
                        for (int y = 0; y < in.sizeY; ++y) {
                            for (int x = 0; x < in.sizeX; ++x) {
                                if (!BinaryMorpho.minRad1(max, 1.0f, x, y, z)) continue;
                                close.pixels[z][x + y * in.sizeX] = -1;
                            }
                        }
                        z = tr2.ai.getAndIncrement();
                    }
                }
            });
        }
        tr2.startAndJoin();
        max.closeImagePlus();
        close.setOffset(in);
        close.setScale(in);
        return close;
    }

    private static ImageByte binaryCloseRad1diag(ImageInt in_, final float thld, int nbCPUs) {
        if (nbCPUs == 0) {
            nbCPUs = ThreadUtil.getNbCpus();
        }
        final ImageInt in = (ImageInt)in_.resize(1, 1, 1);
        final ImageByte max = new ImageByte("max", in.sizeX, in.sizeY, in.sizeZ);
        final ThreadRunner tr = new ThreadRunner(0, max.sizeZ, nbCPUs);
        for (int i = 0; i < tr.threads.length; ++i) {
            tr.threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int z = tr.ai.getAndIncrement();
                    while (z < tr.end) {
                        for (int y = 0; y < max.sizeY; ++y) {
                            for (int x = 0; x < max.sizeX; ++x) {
                                if (!BinaryMorpho.maxRad15(in, thld, x, y, z)) continue;
                                max.pixels[z][x + y * in.sizeX] = -1;
                            }
                        }
                        z = tr.ai.getAndIncrement();
                    }
                }
            });
        }
        tr.startAndJoin();
        final ThreadRunner tr2 = new ThreadRunner(0, in.sizeZ, nbCPUs);
        final ImageByte close = new ImageByte(in.getTitle() + "::close", in.sizeX, in.sizeY, in.sizeZ);
        for (int i = 0; i < tr2.threads.length; ++i) {
            tr2.threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int z = tr2.ai.getAndIncrement();
                    while (z < tr2.end) {
                        for (int y = 0; y < in.sizeY; ++y) {
                            for (int x = 0; x < in.sizeX; ++x) {
                                if (!BinaryMorpho.minRad15(max, 1.0f, x, y, z)) continue;
                                close.pixels[z][x + y * in.sizeX] = -1;
                            }
                        }
                        z = tr2.ai.getAndIncrement();
                    }
                }
            });
        }
        tr2.startAndJoin();
        max.closeImagePlus();
        close.setOffset(in);
        close.setScale(in);
        return close;
    }

    private static boolean minRad1(ImageInt in, float thld, int x, int y, int z) {
        if (in.getPixel(x, y, z) >= thld) {
            if (in.touchBorders(x, y, z)) {
                return false;
            }
            if (in.getPixel(x - 1, y, z) < thld) {
                return false;
            }
            if (in.getPixel(x + 1, y, z) < thld) {
                return false;
            }
            if (in.getPixel(x, y - 1, z) < thld) {
                return false;
            }
            if (in.getPixel(x, y + 1, z) < thld) {
                return false;
            }
            if (in.getPixel(x, y, z - 1) < thld) {
                return false;
            }
            return !(in.getPixel(x, y, z + 1) < thld);
        }
        return false;
    }

    private static boolean minRad15(ImageInt in, float thld, int x, int y, int z) {
        if (in.getPixel(x, y, z) >= thld) {
            if (in.touchBorders(x, y, z)) {
                return false;
            }
            for (int zz = z - 1; zz <= z + 1; ++zz) {
                for (int yy = y - 1; yy <= y + 1; ++yy) {
                    for (int xx = x - 1; xx <= x + 1; ++xx) {
                        if (!(in.getPixel(xx, yy, zz) < thld)) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private static boolean maxRad15(ImageInt in, float thld, int x, int y, int z) {
        if (in.getPixel(x, y, z) < thld) {
            for (int zz = z - 1; zz <= z + 1; ++zz) {
                for (int yy = y - 1; yy <= y + 1; ++yy) {
                    for (int xx = x - 1; xx <= x + 1; ++xx) {
                        if (!in.contains(xx, yy, zz) || !(in.getPixel(xx, yy, zz) >= thld)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        return true;
    }

    private static boolean maxRad1(ImageInt in, float thld, int x, int y, int z) {
        if (in.getPixel(x, y, z) < thld) {
            if (x > 0 && in.getPixel(x - 1, y, z) >= thld) {
                return true;
            }
            if (x + 1 < in.sizeX && in.getPixel(x + 1, y, z) >= thld) {
                return true;
            }
            if (y > 0 && in.getPixel(x, y - 1, z) >= thld) {
                return true;
            }
            if (y + 1 < in.sizeY && in.getPixel(x, y + 1, z) >= thld) {
                return true;
            }
            if (z > 0 && in.getPixel(x, y, z - 1) >= thld) {
                return true;
            }
            return z + 1 < in.sizeZ && in.getPixel(x, y, z + 1) >= thld;
        }
        return true;
    }

    public static ImageInt binaryOpenMultilabel(ImageInt in, float radius, float radiusZ) {
        return BinaryMorpho.binaryOpenMultilabel(in, radius, radiusZ, 0);
    }

    public static ImageInt binaryOpenMultilabel(ImageInt in, float radius, float radiusZ, int nbCPUs) {
        ImageInt[] ihs = in.crop3DBinary();
        if (ihs != null) {
            for (int idx = 0; idx < ihs.length; ++idx) {
                ihs[idx] = BinaryMorpho.binaryOpen(ihs[idx], radius, radiusZ, nbCPUs);
            }
            ImageShort temp = ImageShort.merge3DBinary(ihs, in.sizeX, in.sizeY, in.sizeZ);
            temp.setScale(in);
            temp.setOffset(in);
            return temp;
        }
        return in;
    }

    public static ImageInt binaryCloseMultilabel(ImageInt in, float radiusXY, float radiusZ) {
        return BinaryMorpho.binaryCloseMultilabel(in, radiusXY, radiusZ, 0);
    }

    public static ImageInt binaryCloseMultilabel(ImageInt in, float radiusXY, float radiusZ, int nbCPUs) {
        ImageInt[] ihs = in.crop3DBinary();
        if (ihs != null) {
            for (int idx = 0; idx < ihs.length; ++idx) {
                ihs[idx] = radiusXY < 1.0f && radiusZ < 1.0f ? BinaryMorpho.binaryCloseRad1(ihs[idx], 1.0f, nbCPUs) : (radiusXY < 2.0f && radiusZ < 2.0f ? BinaryMorpho.binaryCloseRad1diag(ihs[idx], 1.0f, nbCPUs) : (radiusZ == 0.0f ? BinaryMorpho.binaryClose2D((ImageByte)ihs[idx], radiusXY) : BinaryMorpho.binaryClose(ihs[idx], radiusXY, radiusZ, nbCPUs)));
            }
            ImageShort temp = ImageShort.merge3DBinary(ihs, in.sizeX, in.sizeY, in.sizeZ);
            temp.setScale(in);
            temp.setOffset(in);
            return temp;
        }
        return in;
    }

    public static ImageInt binaryDilateMultilabel(ImageInt in, float radiusXY, float radiusZ) {
        return BinaryMorpho.binaryDilateMultilabel(in, radiusXY, radiusZ, 0);
    }

    public static ImageInt binaryDilateMultilabel(ImageInt in, float radiusXY, float radiusZ, int nbCPUs) {
        ImageInt[] ihs = in.crop3DBinary();
        if (ihs != null) {
            int end = ihs.length;
            for (int idx = 0; idx < end; ++idx) {
                ihs[idx] = radiusXY < 1.0f && radiusZ < 1.0f ? BinaryMorpho.binaryDilateRad1(ihs[idx], 1.0f, nbCPUs) : (radiusXY < 2.0f && radiusZ < 2.0f ? BinaryMorpho.binaryDilateRad1diag(ihs[idx], 1.0f, nbCPUs) : BinaryMorpho.binaryDilate(ihs[idx], radiusXY, radiusZ, nbCPUs));
            }
            ImageShort temp = ImageShort.merge3DBinary(ihs, in.sizeX, in.sizeY, in.sizeZ);
            temp.setScale(in);
            temp.setOffset(in);
            return temp;
        }
        return in;
    }

    public static ImageInt binaryCloseMultilabel(ImageInt in, float[] radiusXY, float[] radiusZ, int nbCPUs) {
        ImageInt[] ihs = in.crop3DBinary();
        if (radiusXY.length != ihs.length || radiusZ.length != ihs.length) {
            return null;
        }
        if (ihs != null) {
            for (int idx = 0; idx < ihs.length; ++idx) {
                ihs[idx] = radiusXY[idx] <= 1.0f && radiusZ[idx] <= 1.0f ? BinaryMorpho.binaryCloseRad1(ihs[idx], 1.0f, nbCPUs) : BinaryMorpho.binaryClose(ihs[idx], radiusXY[idx], radiusZ[idx], nbCPUs);
                ihs[idx] = BinaryMorpho.binaryClose(ihs[idx], radiusXY[idx], radiusZ[idx], nbCPUs);
            }
            ImageShort temp = ImageShort.merge3DBinary(ihs, in.sizeX, in.sizeY, in.sizeZ);
            temp.setScale(in);
            temp.setOffset(in);
            return temp;
        }
        return in;
    }

    public static ImageInt binaryDilateMultilabel(ImageInt in, float[] radiusXY, float[] radiusZ, int nbCPUs) {
        ImageInt[] ihs = in.crop3DBinary();
        if (radiusXY.length != ihs.length || radiusZ.length != ihs.length) {
            return null;
        }
        if (ihs != null) {
            for (int idx = 0; idx < ihs.length; ++idx) {
                ihs[idx] = BinaryMorpho.binaryDilate(ihs[idx], radiusXY[idx], radiusZ[idx], nbCPUs);
            }
            ImageShort temp = ImageShort.merge3DBinary(ihs, in.sizeX, in.sizeY, in.sizeZ);
            temp.setScale(in);
            temp.setOffset(in);
            return temp;
        }
        return in;
    }
}

