/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.multi;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jets3t.service.ServiceException;
import org.jets3t.service.StorageService;
import org.jets3t.service.model.StorageBucket;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.multi.DownloadPackage;
import org.jets3t.service.multi.ErrorPermitter;
import org.jets3t.service.multi.StorageServiceEventAdaptor;
import org.jets3t.service.multi.ThreadedStorageService;
import org.jets3t.service.multi.event.CopyObjectsEvent;
import org.jets3t.service.multi.event.CreateBucketsEvent;
import org.jets3t.service.multi.event.CreateObjectsEvent;
import org.jets3t.service.multi.event.DeleteObjectsEvent;
import org.jets3t.service.multi.event.DownloadObjectsEvent;
import org.jets3t.service.multi.event.GetObjectHeadsEvent;
import org.jets3t.service.multi.event.LookupACLEvent;
import org.jets3t.service.multi.event.UpdateACLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleThreadedStorageService {
    private StorageService service = null;

    public SimpleThreadedStorageService(StorageService service) {
        this.service = service;
    }

    protected void throwError(StorageServiceEventAdaptor adaptor) throws ServiceException {
        if (adaptor.wasErrorThrown()) {
            Throwable thrown = adaptor.getErrorThrown();
            if (thrown instanceof ServiceException) {
                throw (ServiceException)thrown;
            }
            throw new ServiceException(thrown);
        }
    }

    public StorageBucket[] createBuckets(String[] bucketNames) throws ServiceException {
        final ArrayList bucketList = new ArrayList();
        StorageServiceEventAdaptor adaptor = new StorageServiceEventAdaptor(){

            public void event(CreateBucketsEvent event) {
                super.event(event);
                if (3 == event.getEventCode()) {
                    bucketList.addAll(Arrays.asList(event.getCreatedBuckets()));
                }
            }
        };
        new ThreadedStorageService(this.service, adaptor).createBuckets(bucketNames);
        this.throwError(adaptor);
        return bucketList.toArray(new StorageBucket[bucketList.size()]);
    }

    public StorageObject[] putObjects(String bucketName, StorageObject[] objects) throws ServiceException {
        final ArrayList objectList = new ArrayList();
        StorageServiceEventAdaptor adaptor = new StorageServiceEventAdaptor(){

            public void event(CreateObjectsEvent event) {
                super.event(event);
                if (3 == event.getEventCode()) {
                    objectList.addAll(Arrays.asList(event.getCreatedObjects()));
                }
            }
        };
        new ThreadedStorageService(this.service, adaptor).putObjects(bucketName, objects);
        this.throwError(adaptor);
        return objectList.toArray(new StorageObject[objectList.size()]);
    }

    public Map[] copyObjects(String sourceBucketName, String destinationBucketName, String[] sourceObjectKeys, StorageObject[] destinationObjects, boolean replaceMetadata) throws ServiceException {
        final ArrayList resultsList = new ArrayList();
        StorageServiceEventAdaptor adaptor = new StorageServiceEventAdaptor(){

            public void event(CopyObjectsEvent event) {
                super.event(event);
                if (3 == event.getEventCode()) {
                    resultsList.addAll(Arrays.asList(event.getCopyResults()));
                }
            }
        };
        new ThreadedStorageService(this.service, adaptor).copyObjects(sourceBucketName, destinationBucketName, sourceObjectKeys, destinationObjects, replaceMetadata);
        this.throwError(adaptor);
        return resultsList.toArray(new Map[resultsList.size()]);
    }

    public void deleteObjects(String bucketName, StorageObject[] objects) throws ServiceException {
        final ArrayList objectList = new ArrayList();
        StorageServiceEventAdaptor adaptor = new StorageServiceEventAdaptor(){

            public void event(DeleteObjectsEvent event) {
                super.event(event);
                if (3 == event.getEventCode()) {
                    objectList.addAll(Arrays.asList(event.getDeletedObjects()));
                }
            }
        };
        new ThreadedStorageService(this.service, adaptor).deleteObjects(bucketName, objects);
        this.throwError(adaptor);
    }

    public StorageObject[] getObjects(String bucketName, StorageObject[] objects) throws ServiceException {
        return this.getObjects(bucketName, objects, null);
    }

    public StorageObject[] getObjects(String bucketName, StorageObject[] objects, ErrorPermitter errorPermitter) throws ServiceException {
        String[] originalObjectKeyNames = new String[objects.length];
        DownloadPackage[] downloadPackages = new DownloadPackage[objects.length];
        try {
            for (int i = 0; i < downloadPackages.length; ++i) {
                File tempFile = File.createTempFile("jets3t-", ".tmp");
                tempFile.deleteOnExit();
                downloadPackages[i] = new DownloadPackage(objects[i], tempFile);
                originalObjectKeyNames[i] = objects[i].getName();
            }
        }
        catch (IOException e) {
            throw new ServiceException("Unable to create temporary file to store object data", e);
        }
        final ArrayList<StorageObject> objectList = new ArrayList<StorageObject>();
        StorageServiceEventAdaptor adaptor = new StorageServiceEventAdaptor(){

            public void event(DownloadObjectsEvent event) {
                super.event(event);
                if (3 == event.getEventCode()) {
                    objectList.addAll(Arrays.asList(event.getDownloadedObjects()));
                }
            }
        };
        new ThreadedStorageService(this.service, adaptor).downloadObjects(bucketName, downloadPackages);
        this.throwError(adaptor);
        return SimpleThreadedStorageService.reorderStorageObjects(originalObjectKeyNames, objectList);
    }

    public StorageObject[] getObjects(String bucketName, String[] objectKeys) throws ServiceException {
        StorageObject[] objects = new StorageObject[objectKeys.length];
        for (int i = 0; i < objectKeys.length; ++i) {
            objects[i] = new StorageObject(objectKeys[i]);
        }
        return this.getObjects(bucketName, objects);
    }

    public StorageObject[] getObjectsHeads(String bucketName, StorageObject[] objects) throws ServiceException {
        String[] objectKeys = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            objectKeys[i] = objects[i].getKey();
        }
        return this.getObjectsHeads(bucketName, objectKeys);
    }

    public StorageObject[] getObjectsHeads(String bucketName, String[] objectKeys) throws ServiceException {
        return this.getObjectsHeads(bucketName, objectKeys, null);
    }

    public StorageObject[] getObjectsHeads(String bucketName, String[] objectKeys, ErrorPermitter errorPermitter) throws ServiceException {
        final ArrayList<StorageObject> objectList = new ArrayList<StorageObject>();
        StorageServiceEventAdaptor adaptor = new StorageServiceEventAdaptor(){

            public void event(GetObjectHeadsEvent event) {
                super.event(event);
                if (3 == event.getEventCode()) {
                    objectList.addAll(Arrays.asList(event.getCompletedObjects()));
                }
            }
        };
        new ThreadedStorageService(this.service, adaptor).getObjectsHeads(bucketName, objectKeys, errorPermitter);
        this.throwError(adaptor);
        return SimpleThreadedStorageService.reorderStorageObjects(objectKeys, objectList);
    }

    public StorageObject[] getObjectACLs(String bucketName, StorageObject[] objects) throws ServiceException {
        final ArrayList objectList = new ArrayList();
        StorageServiceEventAdaptor adaptor = new StorageServiceEventAdaptor(){

            public void event(LookupACLEvent event) {
                super.event(event);
                if (3 == event.getEventCode()) {
                    objectList.addAll(Arrays.asList(event.getObjectsWithACL()));
                }
            }
        };
        new ThreadedStorageService(this.service, adaptor).getObjectACLs(bucketName, objects);
        this.throwError(adaptor);
        return objectList.toArray(new StorageObject[objectList.size()]);
    }

    public StorageObject[] putACLs(String bucketName, StorageObject[] objects) throws ServiceException {
        final ArrayList objectList = new ArrayList();
        StorageServiceEventAdaptor adaptor = new StorageServiceEventAdaptor(){

            public void event(UpdateACLEvent event) {
                super.event(event);
                if (3 == event.getEventCode()) {
                    objectList.addAll(Arrays.asList(event.getObjectsWithUpdatedACL()));
                }
            }
        };
        new ThreadedStorageService(this.service, adaptor).putACLs(bucketName, objects);
        this.throwError(adaptor);
        return objectList.toArray(new StorageObject[objectList.size()]);
    }

    public void downloadObjects(String bucketName, DownloadPackage[] downloadPackages) throws ServiceException {
        this.downloadObjects(bucketName, downloadPackages, null);
    }

    public void downloadObjects(String bucketName, DownloadPackage[] downloadPackages, ErrorPermitter errorPermitter) throws ServiceException {
        StorageServiceEventAdaptor adaptor = new StorageServiceEventAdaptor();
        new ThreadedStorageService(this.service, adaptor).downloadObjects(bucketName, downloadPackages, errorPermitter);
        this.throwError(adaptor);
    }

    public static StorageObject[] reorderStorageObjects(String[] objectKeys, List<StorageObject> unorderedObjects) {
        assert (objectKeys.length == unorderedObjects.size());
        HashMap<String, StorageObject> hm = new HashMap<String, StorageObject>(unorderedObjects.size());
        for (StorageObject so : unorderedObjects) {
            hm.put(so.getName(), so);
        }
        StorageObject[] orderedObjects = new StorageObject[unorderedObjects.size()];
        for (int i = 0; i < orderedObjects.length; ++i) {
            orderedObjects[i] = (StorageObject)hm.get(objectKeys[i]);
        }
        return orderedObjects;
    }
}

