/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.processing;

import ij.IJ;
import java.util.ArrayList;
import mcib3d.geom.IntCoord3D;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageShort;

public class Flood3D {
    public static void flood3d6(ImageInt img, int seedX, int seedY, int seedZ, int newVal) {
        IntCoord3D seed = new IntCoord3D(seedX, seedY, seedZ);
        if (img instanceof ImageShort) {
            Flood3D.flood3DShort6((ImageShort)img, seed, (short)newVal);
        } else if (img instanceof ImageByte) {
            Flood3D.flood3DByte6((ImageByte)img, seed, (byte)newVal);
        }
    }

    public static void flood3d26(ImageInt img, int seedX, int seedY, int seedZ, int newVal) {
        IntCoord3D seed = new IntCoord3D(seedX, seedY, seedZ);
        if (img instanceof ImageShort) {
            Flood3D.flood3DShort26((ImageShort)img, seed, (short)newVal);
        } else if (img instanceof ImageByte) {
            Flood3D.flood3DByte26((ImageByte)img, seed, (byte)newVal);
        }
    }

    private static void flood3DShort6(ImageShort img, IntCoord3D seed, short newVal) {
        short[][] pixels = img.pixels;
        int sizeX = img.sizeX;
        int sizeY = img.sizeY;
        int sizeZ = img.sizeZ;
        short oldVal = pixels[seed.z][seed.x + seed.y * sizeX];
        ArrayList<IntCoord3D> queue = new ArrayList<IntCoord3D>();
        queue.add(seed);
        while (!queue.isEmpty()) {
            IntCoord3D curCoord = (IntCoord3D)queue.remove(0);
            int xy = curCoord.x + curCoord.y * sizeX;
            if (pixels[curCoord.z][xy] != oldVal) continue;
            pixels[curCoord.z][xy] = newVal;
            if (curCoord.x > 0 && pixels[curCoord.z][xy - 1] == oldVal) {
                queue.add(new IntCoord3D(curCoord.x - 1, curCoord.y, curCoord.z));
            }
            if (curCoord.x < sizeX - 1 && pixels[curCoord.z][xy + 1] == oldVal) {
                queue.add(new IntCoord3D(curCoord.x + 1, curCoord.y, curCoord.z));
            }
            if (curCoord.y > 0 && pixels[curCoord.z][xy - sizeX] == oldVal) {
                queue.add(new IntCoord3D(curCoord.x, curCoord.y - 1, curCoord.z));
            }
            if (curCoord.y < sizeY - 1 && pixels[curCoord.z][xy + sizeX] == oldVal) {
                queue.add(new IntCoord3D(curCoord.x, curCoord.y + 1, curCoord.z));
            }
            if (curCoord.z > 0 && pixels[curCoord.z - 1][xy] == oldVal) {
                queue.add(new IntCoord3D(curCoord.x, curCoord.y, curCoord.z - 1));
            }
            if (curCoord.z >= sizeZ - 1 || pixels[curCoord.z + 1][xy] != oldVal) continue;
            queue.add(new IntCoord3D(curCoord.x, curCoord.y, curCoord.z + 1));
        }
    }

    public static void flood3DNoiseShort6(ImageShort img, IntCoord3D seed, short limit, short newVal) {
        short[][] pixels = img.pixels;
        int sizeX = img.sizeX;
        int sizeY = img.sizeY;
        int sizeZ = img.sizeZ;
        short oldVal = pixels[seed.z][seed.x + seed.y * sizeX];
        ArrayList<IntCoord3D> queue = new ArrayList<IntCoord3D>();
        queue.add(seed);
        while (!queue.isEmpty()) {
            IntCoord3D curCoord = (IntCoord3D)queue.remove(0);
            IJ.log((String)("processing " + curCoord.x + " " + curCoord.y + " " + curCoord.z + " " + oldVal + " " + limit));
            int xy = curCoord.x + curCoord.y * sizeX;
            if (pixels[curCoord.z][xy] < limit) continue;
            pixels[curCoord.z][xy] = newVal;
            if (curCoord.x > 0 && pixels[curCoord.z][xy - 1] >= limit) {
                queue.add(new IntCoord3D(curCoord.x - 1, curCoord.y, curCoord.z));
            }
            if (curCoord.x < sizeX - 1 && pixels[curCoord.z][xy + 1] >= limit) {
                queue.add(new IntCoord3D(curCoord.x + 1, curCoord.y, curCoord.z));
            }
            if (curCoord.y > 0 && pixels[curCoord.z][xy - sizeX] >= limit) {
                queue.add(new IntCoord3D(curCoord.x, curCoord.y - 1, curCoord.z));
            }
            if (curCoord.y < sizeY - 1 && pixels[curCoord.z][xy + sizeX] >= limit) {
                queue.add(new IntCoord3D(curCoord.x, curCoord.y + 1, curCoord.z));
            }
            if (curCoord.z > 0 && pixels[curCoord.z - 1][xy] >= limit) {
                queue.add(new IntCoord3D(curCoord.x, curCoord.y, curCoord.z - 1));
            }
            if (curCoord.z >= sizeZ - 1 || pixels[curCoord.z + 1][xy] < limit) continue;
            queue.add(new IntCoord3D(curCoord.x, curCoord.y, curCoord.z + 1));
        }
    }

    private static void flood3DByte6(ImageByte img, IntCoord3D seed, byte newVal) {
        byte[][] pixels = img.pixels;
        int sizeX = img.sizeX;
        int sizeY = img.sizeY;
        int sizeZ = img.sizeZ;
        short oldVal = pixels[seed.z][seed.x + seed.y * sizeX];
        ArrayList<IntCoord3D> queue = new ArrayList<IntCoord3D>();
        queue.add(seed);
        while (!queue.isEmpty()) {
            IntCoord3D curCoord = (IntCoord3D)queue.remove(0);
            int xy = curCoord.x + curCoord.y * sizeX;
            if (pixels[curCoord.z][xy] != oldVal) continue;
            pixels[curCoord.z][xy] = newVal;
            if (curCoord.x > 0 && pixels[curCoord.z][xy - 1] == oldVal) {
                queue.add(new IntCoord3D(curCoord.x - 1, curCoord.y, curCoord.z));
            }
            if (curCoord.x < sizeX - 1 && pixels[curCoord.z][xy + 1] == oldVal) {
                queue.add(new IntCoord3D(curCoord.x + 1, curCoord.y, curCoord.z));
            }
            if (curCoord.y > 0 && pixels[curCoord.z][xy - sizeX] == oldVal) {
                queue.add(new IntCoord3D(curCoord.x, curCoord.y - 1, curCoord.z));
            }
            if (curCoord.y < sizeY - 1 && pixels[curCoord.z][xy + sizeX] == oldVal) {
                queue.add(new IntCoord3D(curCoord.x, curCoord.y + 1, curCoord.z));
            }
            if (curCoord.z > 0 && pixels[curCoord.z - 1][xy] == oldVal) {
                queue.add(new IntCoord3D(curCoord.x, curCoord.y, curCoord.z - 1));
            }
            if (curCoord.z >= sizeZ - 1 || pixels[curCoord.z + 1][xy] != oldVal) continue;
            queue.add(new IntCoord3D(curCoord.x, curCoord.y, curCoord.z + 1));
        }
    }

    private static void flood3DShort26(ImageShort img, IntCoord3D seed, short newVal) {
        short[][] pixels = img.pixels;
        int sizeX = img.sizeX;
        int sizeY = img.sizeY;
        int sizeZ = img.sizeZ;
        short oldVal = pixels[seed.z][seed.x + seed.y * sizeX];
        ArrayList<IntCoord3D> queue = new ArrayList<IntCoord3D>();
        queue.add(seed);
        while (!queue.isEmpty()) {
            IntCoord3D curCoord = (IntCoord3D)queue.remove(0);
            int xy = curCoord.x + curCoord.y * sizeX;
            if (pixels[curCoord.z][xy] != oldVal) continue;
            pixels[curCoord.z][xy] = newVal;
            for (int zz = -1; zz < 2; ++zz) {
                int curZ = curCoord.z + zz;
                if (curZ <= 0 || curZ >= sizeZ - 1) continue;
                for (int yy = -1; yy < 2; ++yy) {
                    int curY = curCoord.y + yy;
                    if (curY <= 0 || curY >= sizeY - 1) continue;
                    for (int xx = -1; xx < 2; ++xx) {
                        int curX = curCoord.x + xx;
                        if (curX <= 0 || curX >= sizeX - 1 || xx == 0 && yy == 0 && zz == 0 || pixels[curZ][curX + curY * sizeX] != oldVal) continue;
                        queue.add(new IntCoord3D(curX, curY, curZ));
                    }
                }
            }
        }
    }

    public static void flood3DNoise26(ImageHandler img, IntCoord3D seed, int limit, int newVal) {
        int sizeX = img.sizeX;
        int sizeY = img.sizeY;
        int sizeZ = img.sizeZ;
        ArrayList<IntCoord3D> queue = new ArrayList<IntCoord3D>();
        queue.add(seed);
        while (!queue.isEmpty()) {
            IntCoord3D curCoord = (IntCoord3D)queue.remove(0);
            if (!(img.getPixel(curCoord.x, curCoord.y, curCoord.z) >= (float)limit)) continue;
            img.setPixel(curCoord.x, curCoord.y, curCoord.z, newVal);
            for (int zz = -1; zz < 2; ++zz) {
                int curZ = curCoord.z + zz;
                if (curZ < 0 || curZ > sizeZ - 1) continue;
                for (int yy = -1; yy < 2; ++yy) {
                    int curY = curCoord.y + yy;
                    if (curY < 0 || curY > sizeY - 1) continue;
                    for (int xx = -1; xx < 2; ++xx) {
                        int curX = curCoord.x + xx;
                        if (curX < 0 || curX > sizeX - 1 || !(img.getPixel(curX, curY, curZ) >= (float)limit)) continue;
                        queue.add(new IntCoord3D(curX, curY, curZ));
                    }
                }
            }
        }
    }

    private static void flood3DByte26(ImageByte img, IntCoord3D seed, byte newVal) {
        byte[][] pixels = img.pixels;
        int sizeX = img.sizeX;
        int sizeY = img.sizeY;
        int sizeZ = img.sizeZ;
        short oldVal = pixels[seed.z][seed.x + seed.y * sizeX];
        ArrayList<IntCoord3D> queue = new ArrayList<IntCoord3D>();
        queue.add(seed);
        while (!queue.isEmpty()) {
            IntCoord3D curCoord = (IntCoord3D)queue.remove(0);
            int xy = curCoord.x + curCoord.y * sizeX;
            if (pixels[curCoord.z][xy] != oldVal) continue;
            pixels[curCoord.z][xy] = newVal;
            for (int zz = -1; zz < 2; ++zz) {
                int curZ = curCoord.z + zz;
                if (curZ <= 0 || curZ >= sizeZ - 1) continue;
                for (int yy = -1; yy < 2; ++yy) {
                    int curY = curCoord.y + yy;
                    if (curY <= 0 || curY >= sizeY - 1) continue;
                    for (int xx = -1; xx < 2; ++xx) {
                        int curX = curCoord.x + xx;
                        if (curX <= 0 || curX >= sizeX - 1 || xx == 0 && yy == 0 && zz == 0 || pixels[curZ][curX + curY * sizeX] != oldVal) continue;
                        queue.add(new IntCoord3D(curX, curY, curZ));
                    }
                }
            }
        }
    }
}

