/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.InvalidCredentialsException;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.auth.NTCredentials;
import org.apache.http.impl.auth.AuthSchemeBase;
import org.apache.http.impl.auth.DebugUtil;
import org.apache.http.impl.auth.NTLMEngineException;
import org.apache.http.impl.auth.NTLMEngineImpl;
import org.apache.http.message.BufferedHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.CharsetUtils;

public class CredSspScheme
extends AuthSchemeBase {
    private static final Charset UNICODE_LITTLE_UNMARKED = CharsetUtils.lookup("UnicodeLittleUnmarked");
    public static final String SCHEME_NAME = "CredSSP";
    private final Log log = LogFactory.getLog(CredSspScheme.class);
    private State state = State.UNINITIATED;
    private SSLEngine sslEngine;
    private NTLMEngineImpl.Type1Message type1Message;
    private NTLMEngineImpl.Type2Message type2Message;
    private NTLMEngineImpl.Type3Message type3Message;
    private CredSspTsRequest lastReceivedTsRequest;
    private NTLMEngineImpl.Handle ntlmOutgoingHandle;
    private NTLMEngineImpl.Handle ntlmIncomingHandle;
    private byte[] peerPublicKey;
    private static final byte[] EMPTYBUFFER = new byte[0];

    @Override
    public String getSchemeName() {
        return SCHEME_NAME;
    }

    @Override
    public String getParameter(String name) {
        return null;
    }

    @Override
    public String getRealm() {
        return null;
    }

    @Override
    public boolean isConnectionBased() {
        return true;
    }

    private SSLEngine getSSLEngine() {
        if (this.sslEngine == null) {
            this.sslEngine = this.createSSLEngine();
        }
        return this.sslEngine;
    }

    private SSLEngine createSSLEngine() {
        SSLContext sslContext;
        try {
            sslContext = SSLContexts.custom().build();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error creating SSL Context: " + e.getMessage(), e);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException("Error creating SSL Context: " + e.getMessage(), e);
        }
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        try {
            sslContext.init(null, new TrustManager[]{tm}, null);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException("SSL Context initialization error: " + e.getMessage(), e);
        }
        SSLEngine sslEngine = sslContext.createSSLEngine();
        sslEngine.setUseClientMode(true);
        return sslEngine;
    }

    @Override
    protected void parseChallenge(CharArrayBuffer buffer, int beginIndex, int endIndex) throws MalformedChallengeException {
        ByteBuffer buf;
        String inputString = buffer.substringTrimmed(beginIndex, endIndex);
        if (inputString.isEmpty() && this.state != State.UNINITIATED) {
            String msg = "Received unexpected empty input in state " + (Object)((Object)this.state);
            this.log.error((Object)msg);
            throw new MalformedChallengeException(msg);
        }
        if (this.state == State.TLS_HANDSHAKE) {
            this.unwrapHandshake(inputString);
            if (this.getSSLEngine().getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                this.log.trace((Object)"TLS handshake finished");
                this.state = State.TLS_HANDSHAKE_FINISHED;
            }
        }
        if (this.state == State.NEGO_TOKEN_SENT) {
            buf = this.unwrap(inputString);
            this.state = State.NEGO_TOKEN_RECEIVED;
            this.lastReceivedTsRequest = CredSspTsRequest.createDecoded(buf);
        }
        if (this.state == State.PUB_KEY_AUTH_SENT) {
            buf = this.unwrap(inputString);
            this.state = State.PUB_KEY_AUTH_RECEIVED;
            this.lastReceivedTsRequest = CredSspTsRequest.createDecoded(buf);
        }
    }

    @Override
    @Deprecated
    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        return this.authenticate(credentials, request, null);
    }

    @Override
    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        NTCredentials ntcredentials = null;
        try {
            ntcredentials = (NTCredentials)credentials;
        }
        catch (ClassCastException e) {
            throw new InvalidCredentialsException("Credentials cannot be used for CredSSP authentication: " + credentials.getClass().getName());
        }
        String outputString = null;
        if (this.state == State.UNINITIATED) {
            this.beginTlsHandshake();
            outputString = this.wrapHandshake();
            this.state = State.TLS_HANDSHAKE;
        } else if (this.state == State.TLS_HANDSHAKE) {
            outputString = this.wrapHandshake();
        } else if (this.state == State.TLS_HANDSHAKE_FINISHED) {
            int ntlmFlags = this.getNtlmFlags();
            ByteBuffer buf = this.allocateOutBuffer();
            this.type1Message = new NTLMEngineImpl.Type1Message(ntcredentials.getDomain(), ntcredentials.getWorkstation(), ntlmFlags);
            byte[] ntlmNegoMessageEncoded = this.type1Message.getBytes();
            CredSspTsRequest req = CredSspTsRequest.createNegoToken(ntlmNegoMessageEncoded);
            req.encode(buf);
            buf.flip();
            outputString = this.wrap(buf);
            this.state = State.NEGO_TOKEN_SENT;
        } else if (this.state == State.NEGO_TOKEN_RECEIVED) {
            ByteBuffer buf = this.allocateOutBuffer();
            this.type2Message = new NTLMEngineImpl.Type2Message(this.lastReceivedTsRequest.getNegoToken());
            Certificate peerServerCertificate = this.getPeerServerCertificate();
            this.type3Message = new NTLMEngineImpl.Type3Message(ntcredentials.getDomain(), ntcredentials.getWorkstation(), ntcredentials.getUserName(), ntcredentials.getPassword(), this.type2Message.getChallenge(), this.type2Message.getFlags(), this.type2Message.getTarget(), this.type2Message.getTargetInfo(), peerServerCertificate, this.type1Message.getBytes(), this.type2Message.getBytes());
            byte[] ntlmAuthenticateMessageEncoded = this.type3Message.getBytes();
            byte[] exportedSessionKey = this.type3Message.getExportedSessionKey();
            this.ntlmOutgoingHandle = new NTLMEngineImpl.Handle(exportedSessionKey, NTLMEngineImpl.Mode.CLIENT, true);
            this.ntlmIncomingHandle = new NTLMEngineImpl.Handle(exportedSessionKey, NTLMEngineImpl.Mode.SERVER, true);
            CredSspTsRequest req = CredSspTsRequest.createNegoToken(ntlmAuthenticateMessageEncoded);
            this.peerPublicKey = this.getSubjectPublicKeyDer(peerServerCertificate.getPublicKey());
            byte[] pubKeyAuth = this.createPubKeyAuth();
            req.setPubKeyAuth(pubKeyAuth);
            req.encode(buf);
            buf.flip();
            outputString = this.wrap(buf);
            this.state = State.PUB_KEY_AUTH_SENT;
        } else if (this.state == State.PUB_KEY_AUTH_RECEIVED) {
            this.verifyPubKeyAuthResponse(this.lastReceivedTsRequest.getPubKeyAuth());
            byte[] authInfo = this.createAuthInfo(ntcredentials);
            CredSspTsRequest req = CredSspTsRequest.createAuthInfo(authInfo);
            ByteBuffer buf = this.allocateOutBuffer();
            req.encode(buf);
            buf.flip();
            outputString = this.wrap(buf);
            this.state = State.CREDENTIALS_SENT;
        } else {
            throw new AuthenticationException("Wrong state " + (Object)((Object)this.state));
        }
        CharArrayBuffer buffer = new CharArrayBuffer(32);
        if (this.isProxy()) {
            buffer.append("Proxy-Authorization");
        } else {
            buffer.append("Authorization");
        }
        buffer.append(": CredSSP ");
        buffer.append(outputString);
        return new BufferedHeader(buffer);
    }

    private int getNtlmFlags() {
        return -494366670;
    }

    private Certificate getPeerServerCertificate() throws AuthenticationException {
        Certificate[] peerCertificates;
        try {
            peerCertificates = this.sslEngine.getSession().getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException e) {
            throw new AuthenticationException(e.getMessage(), e);
        }
        for (Certificate peerCertificate : peerCertificates) {
            X509Certificate peerX509Cerificate;
            if (!(peerCertificate instanceof X509Certificate) || (peerX509Cerificate = (X509Certificate)peerCertificate).getBasicConstraints() != -1) continue;
            return peerX509Cerificate;
        }
        return null;
    }

    private byte[] createPubKeyAuth() throws AuthenticationException {
        return this.ntlmOutgoingHandle.signAndEncryptMessage(this.peerPublicKey);
    }

    private void verifyPubKeyAuthResponse(byte[] pubKeyAuthResponse) throws AuthenticationException {
        byte[] pubKeyReceived = this.ntlmIncomingHandle.decryptAndVerifySignedMessage(pubKeyAuthResponse);
        if (this.peerPublicKey.length != pubKeyReceived.length) {
            throw new AuthenticationException("Public key mismatch in pubKeyAuth response");
        }
        if (this.peerPublicKey[0] + 1 != pubKeyReceived[0]) {
            throw new AuthenticationException("Public key mismatch in pubKeyAuth response");
        }
        for (int i = 1; i < this.peerPublicKey.length; ++i) {
            if (this.peerPublicKey[i] == pubKeyReceived[i]) continue;
            throw new AuthenticationException("Public key mismatch in pubKeyAuth response");
        }
        this.log.trace((Object)"Received public key response is valid");
    }

    private byte[] createAuthInfo(NTCredentials ntcredentials) throws AuthenticationException {
        byte[] domainBytes = this.encodeUnicode(ntcredentials.getDomain());
        byte[] domainOctetStringBytesLengthBytes = CredSspScheme.encodeLength(domainBytes.length);
        int domainNameLength = 1 + domainOctetStringBytesLengthBytes.length + domainBytes.length;
        byte[] domainNameLengthBytes = CredSspScheme.encodeLength(domainNameLength);
        byte[] usernameBytes = this.encodeUnicode(ntcredentials.getUserName());
        byte[] usernameOctetStringBytesLengthBytes = CredSspScheme.encodeLength(usernameBytes.length);
        int userNameLength = 1 + usernameOctetStringBytesLengthBytes.length + usernameBytes.length;
        byte[] userNameLengthBytes = CredSspScheme.encodeLength(userNameLength);
        byte[] passwordBytes = this.encodeUnicode(ntcredentials.getPassword());
        byte[] passwordOctetStringBytesLengthBytes = CredSspScheme.encodeLength(passwordBytes.length);
        int passwordLength = 1 + passwordOctetStringBytesLengthBytes.length + passwordBytes.length;
        byte[] passwordLengthBytes = CredSspScheme.encodeLength(passwordLength);
        int tsPasswordLength = 1 + domainNameLengthBytes.length + domainNameLength + 1 + userNameLengthBytes.length + userNameLength + 1 + passwordLengthBytes.length + passwordLength;
        byte[] tsPasswordLengthBytes = CredSspScheme.encodeLength(tsPasswordLength);
        int credentialsOctetStringLength = 1 + tsPasswordLengthBytes.length + tsPasswordLength;
        byte[] credentialsOctetStringLengthBytes = CredSspScheme.encodeLength(credentialsOctetStringLength);
        int credentialsLength = 1 + credentialsOctetStringLengthBytes.length + credentialsOctetStringLength;
        byte[] credentialsLengthBytes = CredSspScheme.encodeLength(credentialsLength);
        int tsCredentialsLength = 6 + credentialsLengthBytes.length + credentialsLength;
        byte[] tsCredentialsLengthBytes = CredSspScheme.encodeLength(tsCredentialsLength);
        ByteBuffer buf = ByteBuffer.allocate(1 + tsCredentialsLengthBytes.length + tsCredentialsLength);
        buf.put((byte)48);
        buf.put(tsCredentialsLengthBytes);
        buf.put((byte)-96);
        buf.put((byte)3);
        buf.put((byte)2);
        buf.put((byte)1);
        buf.put((byte)1);
        buf.put((byte)-95);
        buf.put(credentialsLengthBytes);
        buf.put((byte)4);
        buf.put(credentialsOctetStringLengthBytes);
        buf.put((byte)48);
        buf.put(tsPasswordLengthBytes);
        buf.put((byte)-96);
        buf.put(domainNameLengthBytes);
        buf.put((byte)4);
        buf.put(domainOctetStringBytesLengthBytes);
        buf.put(domainBytes);
        buf.put((byte)-95);
        buf.put(userNameLengthBytes);
        buf.put((byte)4);
        buf.put(usernameOctetStringBytesLengthBytes);
        buf.put(usernameBytes);
        buf.put((byte)-94);
        buf.put(passwordLengthBytes);
        buf.put((byte)4);
        buf.put(passwordOctetStringBytesLengthBytes);
        buf.put(passwordBytes);
        byte[] authInfo = buf.array();
        try {
            return this.ntlmOutgoingHandle.signAndEncryptMessage(authInfo);
        }
        catch (NTLMEngineException e) {
            throw new AuthenticationException(e.getMessage(), e);
        }
    }

    private byte[] encodeUnicode(String string) {
        if (string == null) {
            return EMPTYBUFFER;
        }
        return string.getBytes(UNICODE_LITTLE_UNMARKED);
    }

    private byte[] getSubjectPublicKeyDer(PublicKey publicKey) throws AuthenticationException {
        try {
            byte[] encodedPubKeyInfo = publicKey.getEncoded();
            ByteBuffer buf = ByteBuffer.wrap(encodedPubKeyInfo);
            CredSspScheme.getByteAndAssert(buf, 48, "initial sequence");
            CredSspScheme.parseLength(buf);
            CredSspScheme.getByteAndAssert(buf, 48, "AlgorithmIdentifier sequence");
            int algIdSeqLength = CredSspScheme.parseLength(buf);
            buf.position(buf.position() + algIdSeqLength);
            CredSspScheme.getByteAndAssert(buf, 3, "subjectPublicKey type");
            int subjectPublicKeyLegth = CredSspScheme.parseLength(buf);
            byte b = buf.get();
            if (b == 0) {
                --subjectPublicKeyLegth;
            } else {
                buf.position(buf.position() - 1);
            }
            byte[] subjectPublicKey = new byte[subjectPublicKeyLegth];
            buf.get(subjectPublicKey);
            return subjectPublicKey;
        }
        catch (MalformedChallengeException e) {
            throw new AuthenticationException(e.getMessage(), e);
        }
    }

    private void beginTlsHandshake() throws AuthenticationException {
        try {
            this.getSSLEngine().beginHandshake();
        }
        catch (SSLException e) {
            throw new AuthenticationException("SSL Engine error: " + e.getMessage(), e);
        }
    }

    private ByteBuffer allocateOutBuffer() {
        SSLEngine sslEngine = this.getSSLEngine();
        SSLSession sslSession = sslEngine.getSession();
        return ByteBuffer.allocate(sslSession.getApplicationBufferSize());
    }

    private String wrapHandshake() throws AuthenticationException {
        ByteBuffer src = this.allocateOutBuffer();
        src.flip();
        SSLEngine sslEngine = this.getSSLEngine();
        SSLSession sslSession = sslEngine.getSession();
        ByteBuffer dst = ByteBuffer.allocate(sslSession.getPacketBufferSize() * 2);
        while (sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            this.wrap(src, dst);
        }
        dst.flip();
        return this.encodeBase64(dst);
    }

    private String wrap(ByteBuffer src) throws AuthenticationException {
        SSLEngine sslEngine = this.getSSLEngine();
        SSLSession sslSession = sslEngine.getSession();
        ByteBuffer dst = ByteBuffer.allocate(sslSession.getPacketBufferSize());
        this.wrap(src, dst);
        dst.flip();
        return this.encodeBase64(dst);
    }

    private void wrap(ByteBuffer src, ByteBuffer dst) throws AuthenticationException {
        SSLEngine sslEngine = this.getSSLEngine();
        try {
            SSLEngineResult engineResult = sslEngine.wrap(src, dst);
            if (engineResult.getStatus() != SSLEngineResult.Status.OK) {
                throw new AuthenticationException("SSL Engine error status: " + (Object)((Object)engineResult.getStatus()));
            }
        }
        catch (SSLException e) {
            throw new AuthenticationException("SSL Engine wrap error: " + e.getMessage(), e);
        }
    }

    private void unwrapHandshake(String inputString) throws MalformedChallengeException {
        SSLEngine sslEngine = this.getSSLEngine();
        SSLSession sslSession = sslEngine.getSession();
        ByteBuffer src = this.decodeBase64(inputString);
        ByteBuffer dst = ByteBuffer.allocate(sslSession.getApplicationBufferSize());
        while (sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            this.unwrap(src, dst);
        }
    }

    private ByteBuffer unwrap(String inputString) throws MalformedChallengeException {
        SSLEngine sslEngine = this.getSSLEngine();
        SSLSession sslSession = sslEngine.getSession();
        ByteBuffer src = this.decodeBase64(inputString);
        ByteBuffer dst = ByteBuffer.allocate(sslSession.getApplicationBufferSize());
        this.unwrap(src, dst);
        dst.flip();
        return dst;
    }

    private void unwrap(ByteBuffer src, ByteBuffer dst) throws MalformedChallengeException {
        try {
            SSLEngineResult engineResult = this.sslEngine.unwrap(src, dst);
            if (engineResult.getStatus() != SSLEngineResult.Status.OK) {
                throw new MalformedChallengeException("SSL Engine error status: " + (Object)((Object)engineResult.getStatus()));
            }
            if (this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                Runnable task = this.sslEngine.getDelegatedTask();
                task.run();
            }
        }
        catch (SSLException e) {
            throw new MalformedChallengeException("SSL Engine unwrap error: " + e.getMessage(), e);
        }
    }

    private String encodeBase64(ByteBuffer buffer) {
        int limit = buffer.limit();
        byte[] bytes = new byte[limit];
        buffer.get(bytes);
        return new String(Base64.encodeBase64(bytes), Consts.ASCII);
    }

    private ByteBuffer decodeBase64(String inputString) {
        byte[] inputBytes = Base64.decodeBase64(inputString.getBytes(Consts.ASCII));
        ByteBuffer buffer = ByteBuffer.wrap(inputBytes);
        return buffer;
    }

    @Override
    public boolean isComplete() {
        return this.state == State.CREDENTIALS_SENT;
    }

    static void getByteAndAssert(ByteBuffer buf, int expectedValue, String errorMessage) throws MalformedChallengeException {
        byte bufByte = buf.get();
        if (bufByte != expectedValue) {
            CredSspScheme.parseError(buf, errorMessage + CredSspScheme.expectMessage(expectedValue, bufByte));
        }
    }

    private static String expectMessage(int expectedValue, int realValue) {
        return "(expected " + String.format("%02X", expectedValue) + ", got " + String.format("%02X", realValue) + ")";
    }

    static int parseLength(ByteBuffer buf) {
        byte bufByte = buf.get();
        if (bufByte == 128) {
            return -1;
        }
        if ((bufByte & 0x80) == 128) {
            int size = bufByte & 0x7F;
            int length = 0;
            for (int i = 0; i < size; ++i) {
                bufByte = buf.get();
                length = (length << 8) + (bufByte & 0xFF);
            }
            return length;
        }
        return bufByte;
    }

    static void getLengthAndAssert(ByteBuffer buf, int expectedValue, String errorMessage) throws MalformedChallengeException {
        int bufLength = CredSspScheme.parseLength(buf);
        if (expectedValue != bufLength) {
            CredSspScheme.parseError(buf, errorMessage + CredSspScheme.expectMessage(expectedValue, bufLength));
        }
    }

    static int getAndAssertContentSpecificTag(ByteBuffer buf, String errorMessage) throws MalformedChallengeException {
        byte bufByte = buf.get();
        if ((bufByte & 0xE0) != 160) {
            CredSspScheme.parseError(buf, errorMessage + ": wrong content-specific tag " + String.format("%02X", bufByte));
        }
        int tag = bufByte & 0x1F;
        return tag;
    }

    static void parseError(ByteBuffer buf, String errorMessage) throws MalformedChallengeException {
        throw new MalformedChallengeException("Error parsing TsRequest (position:" + buf.position() + "): " + errorMessage);
    }

    static byte[] encodeLength(int length) {
        if (length < 128) {
            byte[] encoded = new byte[]{(byte)length};
            return encoded;
        }
        int size = 1;
        int val = length;
        while ((val >>>= 8) != 0) {
            ++size;
        }
        byte[] encoded = new byte[1 + size];
        encoded[0] = (byte)(size | 0x80);
        int shift = (size - 1) * 8;
        for (int i = 0; i < size; ++i) {
            encoded[i + 1] = (byte)(length >> shift);
            shift -= 8;
        }
        return encoded;
    }

    static class CredSspTsRequest {
        private static final int VERSION = 3;
        private byte[] negoToken;
        private byte[] authInfo;
        private byte[] pubKeyAuth;

        protected CredSspTsRequest() {
        }

        public static CredSspTsRequest createNegoToken(byte[] negoToken) {
            CredSspTsRequest req = new CredSspTsRequest();
            req.negoToken = negoToken;
            return req;
        }

        public static CredSspTsRequest createAuthInfo(byte[] authInfo) {
            CredSspTsRequest req = new CredSspTsRequest();
            req.authInfo = authInfo;
            return req;
        }

        public static CredSspTsRequest createDecoded(ByteBuffer buf) throws MalformedChallengeException {
            CredSspTsRequest req = new CredSspTsRequest();
            req.decode(buf);
            return req;
        }

        public byte[] getNegoToken() {
            return this.negoToken;
        }

        public void setNegoToken(byte[] negoToken) {
            this.negoToken = negoToken;
        }

        public byte[] getAuthInfo() {
            return this.authInfo;
        }

        public void setAuthInfo(byte[] authInfo) {
            this.authInfo = authInfo;
        }

        public byte[] getPubKeyAuth() {
            return this.pubKeyAuth;
        }

        public void setPubKeyAuth(byte[] pubKeyAuth) {
            this.pubKeyAuth = pubKeyAuth;
        }

        public void decode(ByteBuffer buf) throws MalformedChallengeException {
            this.negoToken = null;
            this.authInfo = null;
            this.pubKeyAuth = null;
            CredSspScheme.getByteAndAssert(buf, 48, "initial sequence");
            CredSspScheme.parseLength(buf);
            block7: while (buf.hasRemaining()) {
                int contentTag = CredSspScheme.getAndAssertContentSpecificTag(buf, "content tag");
                CredSspScheme.parseLength(buf);
                switch (contentTag) {
                    case 0: {
                        this.processVersion(buf);
                        continue block7;
                    }
                    case 1: {
                        this.parseNegoTokens(buf);
                        continue block7;
                    }
                    case 2: {
                        this.parseAuthInfo(buf);
                        continue block7;
                    }
                    case 3: {
                        this.parsePubKeyAuth(buf);
                        continue block7;
                    }
                    case 4: {
                        this.processErrorCode(buf);
                        continue block7;
                    }
                }
                CredSspScheme.parseError(buf, "unexpected content tag " + contentTag);
            }
        }

        private void processVersion(ByteBuffer buf) throws MalformedChallengeException {
            CredSspScheme.getByteAndAssert(buf, 2, "version type");
            CredSspScheme.getLengthAndAssert(buf, 1, "version length");
            CredSspScheme.getByteAndAssert(buf, 3, "wrong protocol version");
        }

        private void parseNegoTokens(ByteBuffer buf) throws MalformedChallengeException {
            CredSspScheme.getByteAndAssert(buf, 48, "negoTokens sequence");
            CredSspScheme.parseLength(buf);
            byte bufByte = buf.get();
            if (bufByte == 48) {
                CredSspScheme.parseLength(buf);
                bufByte = buf.get();
            }
            if ((bufByte & 0xFF) != 160) {
                CredSspScheme.parseError(buf, "negoTokens: wrong content-specific tag " + String.format("%02X", bufByte));
            }
            CredSspScheme.parseLength(buf);
            CredSspScheme.getByteAndAssert(buf, 4, "negoToken type");
            int tokenLength = CredSspScheme.parseLength(buf);
            this.negoToken = new byte[tokenLength];
            buf.get(this.negoToken);
        }

        private void parseAuthInfo(ByteBuffer buf) throws MalformedChallengeException {
            CredSspScheme.getByteAndAssert(buf, 4, "authInfo type");
            int length = CredSspScheme.parseLength(buf);
            this.authInfo = new byte[length];
            buf.get(this.authInfo);
        }

        private void parsePubKeyAuth(ByteBuffer buf) throws MalformedChallengeException {
            CredSspScheme.getByteAndAssert(buf, 4, "pubKeyAuth type");
            int length = CredSspScheme.parseLength(buf);
            this.pubKeyAuth = new byte[length];
            buf.get(this.pubKeyAuth);
        }

        private void processErrorCode(ByteBuffer buf) throws MalformedChallengeException {
            CredSspScheme.getLengthAndAssert(buf, 3, "error code length");
            CredSspScheme.getByteAndAssert(buf, 2, "error code type");
            CredSspScheme.getLengthAndAssert(buf, 1, "error code length");
            byte errorCode = buf.get();
            CredSspScheme.parseError(buf, "Error code " + errorCode);
        }

        public void encode(ByteBuffer buf) {
            ByteBuffer inner = ByteBuffer.allocate(buf.capacity());
            inner.put((byte)-96);
            inner.put((byte)3);
            inner.put((byte)2);
            inner.put((byte)1);
            inner.put((byte)3);
            if (this.negoToken != null) {
                int len = this.negoToken.length;
                byte[] negoTokenLengthBytes = CredSspScheme.encodeLength(len);
                byte[] negoTokenLength1Bytes = CredSspScheme.encodeLength(len += 1 + negoTokenLengthBytes.length);
                byte[] negoTokenLength2Bytes = CredSspScheme.encodeLength(len += 1 + negoTokenLength1Bytes.length);
                byte[] negoTokenLength3Bytes = CredSspScheme.encodeLength(len += 1 + negoTokenLength2Bytes.length);
                byte[] negoTokenLength4Bytes = CredSspScheme.encodeLength(len += 1 + negoTokenLength3Bytes.length);
                inner.put((byte)-95);
                inner.put(negoTokenLength4Bytes);
                inner.put((byte)48);
                inner.put(negoTokenLength3Bytes);
                inner.put((byte)48);
                inner.put(negoTokenLength2Bytes);
                inner.put((byte)-96);
                inner.put(negoTokenLength1Bytes);
                inner.put((byte)4);
                inner.put(negoTokenLengthBytes);
                inner.put(this.negoToken);
            }
            if (this.authInfo != null) {
                byte[] authInfoEncodedLength = CredSspScheme.encodeLength(this.authInfo.length);
                inner.put((byte)-94);
                inner.put(CredSspScheme.encodeLength(1 + authInfoEncodedLength.length + this.authInfo.length));
                inner.put((byte)4);
                inner.put(authInfoEncodedLength);
                inner.put(this.authInfo);
            }
            if (this.pubKeyAuth != null) {
                byte[] pubKeyAuthEncodedLength = CredSspScheme.encodeLength(this.pubKeyAuth.length);
                inner.put((byte)-93);
                inner.put(CredSspScheme.encodeLength(1 + pubKeyAuthEncodedLength.length + this.pubKeyAuth.length));
                inner.put((byte)4);
                inner.put(pubKeyAuthEncodedLength);
                inner.put(this.pubKeyAuth);
            }
            inner.flip();
            buf.put((byte)48);
            buf.put(CredSspScheme.encodeLength(inner.limit()));
            buf.put(inner);
        }

        public String debugDump() {
            StringBuilder sb = new StringBuilder("TsRequest\n");
            sb.append("  negoToken:\n");
            sb.append("    ");
            DebugUtil.dump(sb, this.negoToken);
            sb.append("\n");
            sb.append("  authInfo:\n");
            sb.append("    ");
            DebugUtil.dump(sb, this.authInfo);
            sb.append("\n");
            sb.append("  pubKeyAuth:\n");
            sb.append("    ");
            DebugUtil.dump(sb, this.pubKeyAuth);
            return sb.toString();
        }

        public String toString() {
            return "TsRequest(negoToken=" + Arrays.toString(this.negoToken) + ", authInfo=" + Arrays.toString(this.authInfo) + ", pubKeyAuth=" + Arrays.toString(this.pubKeyAuth) + ")";
        }
    }

    static enum State {
        UNINITIATED,
        TLS_HANDSHAKE,
        TLS_HANDSHAKE_FINISHED,
        NEGO_TOKEN_SENT,
        NEGO_TOKEN_RECEIVED,
        PUB_KEY_AUTH_SENT,
        PUB_KEY_AUTH_RECEIVED,
        CREDENTIALS_SENT;

    }
}

