/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.multi.event;

import java.util.Map;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.multi.ThreadWatcher;
import org.jets3t.service.multi.event.ServiceEvent;

public final class CopyObjectsEvent
extends ServiceEvent {
    private Map[] results = null;
    private StorageObject[] copyCancelledObjects = null;
    private StorageObject[] destinationObjects = null;
    private String[] sourceObjectKeys = null;

    private CopyObjectsEvent(int eventCode, Object uniqueOperationId) {
        super(eventCode, uniqueOperationId);
    }

    public static CopyObjectsEvent newErrorEvent(Throwable t, Object uniqueOperationId) {
        CopyObjectsEvent event = new CopyObjectsEvent(0, uniqueOperationId);
        event.setErrorCause(t);
        return event;
    }

    public static CopyObjectsEvent newStartedEvent(ThreadWatcher threadWatcher, Object uniqueOperationId) {
        CopyObjectsEvent event = new CopyObjectsEvent(1, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        return event;
    }

    public static CopyObjectsEvent newInProgressEvent(ThreadWatcher threadWatcher, Map[] completedResults, Object uniqueOperationId) {
        CopyObjectsEvent event = new CopyObjectsEvent(3, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        event.setResults(completedResults);
        return event;
    }

    public static CopyObjectsEvent newCompletedEvent(Object uniqueOperationId, String[] sourceObjectKeys, StorageObject[] destinationObjects) {
        CopyObjectsEvent event = new CopyObjectsEvent(2, uniqueOperationId);
        event.setDestinationObjects(destinationObjects);
        event.setSourceObjectKeys(sourceObjectKeys);
        return event;
    }

    public static CopyObjectsEvent newCancelledEvent(StorageObject[] incompletedObjects, Object uniqueOperationId) {
        CopyObjectsEvent event = new CopyObjectsEvent(4, uniqueOperationId);
        event.setCopyCancelledObjects(incompletedObjects);
        return event;
    }

    public static CopyObjectsEvent newIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors, Object uniqueOperationId) {
        CopyObjectsEvent event = new CopyObjectsEvent(5, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        event.setIgnoredErrors(ignoredErrors);
        return event;
    }

    private void setResults(Map[] results) {
        this.results = results;
    }

    private void setSourceObjectKeys(String[] sourceObjectKeys) {
        this.sourceObjectKeys = sourceObjectKeys;
    }

    private void setCopyCancelledObjects(StorageObject[] objects) {
        this.copyCancelledObjects = objects;
    }

    private void setDestinationObjects(StorageObject[] objects) {
        this.destinationObjects = objects;
    }

    public Map[] getCopyResults() throws IllegalStateException {
        if (this.getEventCode() != 3) {
            throw new IllegalStateException("Copy results are only available from EVENT_IN_PROGRESS events");
        }
        return this.results;
    }

    public StorageObject[] getCancelledObjects() throws IllegalStateException {
        if (this.getEventCode() != 4) {
            throw new IllegalStateException("Cancelled Objects are only available from EVENT_CANCELLED events");
        }
        return this.copyCancelledObjects;
    }

    public StorageObject[] getCopiedObjects() throws IllegalStateException {
        if (this.getEventCode() != 2) {
            throw new IllegalStateException("Cancelled Objects are only available from EVENT_COMPLETED events");
        }
        return this.destinationObjects;
    }

    public String[] getSourceObjectKeys() throws IllegalStateException {
        if (this.getEventCode() != 2) {
            throw new IllegalStateException("Source Objects are only available from EVENT_COMPLETED events");
        }
        return this.sourceObjectKeys;
    }
}

