/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.utils;

import ij.gui.Plot;
import mcib3d.utils.ArrayUtil;

public class HistogramUtil
extends ArrayUtil {
    double[] xbin = null;
    double[] ynumber = null;
    double[] ycumul = null;

    public HistogramUtil(double[] val) {
        super(val);
        this.ynumber = val;
        this.setIntegerBins();
    }

    private void setIntegerBins() {
        this.xbin = new double[this.ynumber.length];
        for (int i = 0; i < this.xbin.length; ++i) {
            this.xbin[i] = i;
        }
    }

    private void computeCumulHistogram() {
        this.ycumul = new double[this.xbin.length];
        this.ycumul[0] = this.ynumber[0];
        for (int i = 1; i < this.xbin.length; ++i) {
            this.ycumul[i] = this.ycumul[i - 1] + this.ynumber[i];
        }
    }

    private void computeInverseCumulHistogram() {
        int le = this.xbin.length;
        this.ycumul = new double[le];
        this.ycumul[le - 1] = this.ynumber[le - 1];
        for (int i = le - 2; i >= 0; --i) {
            this.ycumul[i] = this.ycumul[i + 1] + this.ynumber[i];
        }
    }

    public void plotHistogram(String title) {
        Plot plot = new Plot(title, "values", "nb", this.xbin, this.ynumber);
        plot.show();
    }

    public void plotCumulHistogram(String title) {
        if (this.ycumul == null) {
            this.computeCumulHistogram();
        }
        Plot plot = new Plot(title, "values", "nb", this.xbin, this.ycumul);
        plot.show();
    }

    public int getNbBins() {
        return this.xbin.length;
    }

    public double[] getBins() {
        return this.xbin;
    }

    public void setBins(double[] bi) {
        this.xbin = bi;
    }

    public double[] getYnumbers() {
        return this.ynumber;
    }

    public double[] getCumulNumbers() {
        if (this.ycumul == null) {
            this.computeCumulHistogram();
        }
        return this.ycumul;
    }

    public double[] getInverseCumulNumbers() {
        if (this.ycumul == null) {
            this.computeInverseCumulHistogram();
        }
        return this.ycumul;
    }

    public void setYnumber(double[] ynumber) {
        this.ynumber = ynumber;
    }

    public double getNumber(int bi) {
        return this.ynumber[bi];
    }

    public double getCumulNumber(int bi) {
        if (this.ycumul == null) {
            this.computeCumulHistogram();
        }
        return this.ycumul[bi];
    }
}

