/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.distanceMap3d;

import ij.ImagePlus;
import ij.ImageStack;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class CleanUpLocalThickness {
    public float[][] s;
    public float[][] sNew;
    public int w;
    public int h;
    public int d;

    public ImagePlus run(ImagePlus imp) {
        int ind;
        int i;
        int k;
        ImageStack stack = imp.getStack();
        this.w = stack.getWidth();
        this.h = stack.getHeight();
        this.d = imp.getStackSize();
        ImageStack newStack = new ImageStack(this.w, this.h);
        this.sNew = new float[this.d][];
        for (k = 0; k < this.d; ++k) {
            FloatProcessor ipk = new FloatProcessor(this.w, this.h);
            newStack.addSlice(null, (ImageProcessor)ipk);
            this.sNew[k] = (float[])ipk.getPixels();
        }
        this.s = new float[this.d][];
        for (k = 0; k < this.d; ++k) {
            this.s[k] = (float[])stack.getPixels(k + 1);
        }
        for (k = 0; k < this.d; ++k) {
            for (int j = 0; j < this.h; ++j) {
                for (i = 0; i < this.w; ++i) {
                    this.sNew[k][i + this.w * j] = this.setFlag(i, j, k);
                }
            }
        }
        for (k = 0; k < this.d; ++k) {
            for (int j = 0; j < this.h; ++j) {
                for (i = 0; i < this.w; ++i) {
                    ind = i + this.w * j;
                    if (this.sNew[k][ind] != -1.0f) continue;
                    this.sNew[k][ind] = -this.averageInteriorNeighbors(i, j, k);
                }
            }
        }
        for (k = 0; k < this.d; ++k) {
            for (int j = 0; j < this.h; ++j) {
                for (i = 0; i < this.w; ++i) {
                    ind = i + this.w * j;
                    this.sNew[k][ind] = Math.abs(this.sNew[k][ind]);
                }
            }
        }
        String title = this.stripExtension(imp.getTitle());
        ImagePlus impOut = new ImagePlus(title + "_CL", newStack);
        impOut.getProcessor().setMinAndMax(0.0, 2.0 * imp.getProcessor().getMax());
        return impOut;
    }

    float setFlag(int i, int j, int k) {
        if (this.s[k][i + this.w * j] == 0.0f) {
            return 0.0f;
        }
        if (this.look(i, j, k - 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i, j, k + 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i, j - 1, k) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i, j + 1, k) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i - 1, j, k) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i + 1, j, k) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i, j + 1, k - 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i, j + 1, k + 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i + 1, j - 1, k) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i + 1, j + 1, k) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i - 1, j, k + 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i + 1, j, k + 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i, j - 1, k - 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i, j - 1, k + 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i - 1, j - 1, k) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i - 1, j + 1, k) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i - 1, j, k - 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i + 1, j, k - 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i + 1, j + 1, k + 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i + 1, j - 1, k + 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i - 1, j + 1, k + 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i - 1, j - 1, k + 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i + 1, j + 1, k - 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i + 1, j - 1, k - 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i - 1, j + 1, k - 1) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i - 1, j - 1, k - 1) == 0.0f) {
            return -1.0f;
        }
        return this.s[k][i + this.w * j];
    }

    float averageInteriorNeighbors(int i, int j, int k) {
        int n = 0;
        float sum = 0.0f;
        float value = this.lookNew(i, j, k - 1);
        if (value > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i, j, k + 1)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i, j - 1, k)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i, j + 1, k)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i - 1, j, k)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i + 1, j, k)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i, j + 1, k - 1)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i, j + 1, k + 1)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i + 1, j - 1, k)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i + 1, j + 1, k)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i - 1, j, k + 1)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i + 1, j, k + 1)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i, j - 1, k - 1)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i, j - 1, k + 1)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i - 1, j - 1, k)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i - 1, j + 1, k)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i - 1, j, k - 1)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i + 1, j, k - 1)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i + 1, j + 1, k + 1)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i + 1, j - 1, k + 1)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i - 1, j + 1, k + 1)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i - 1, j - 1, k + 1)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i + 1, j + 1, k - 1)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i + 1, j - 1, k - 1)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i - 1, j + 1, k - 1)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i - 1, j - 1, k - 1)) > 0.0f) {
            ++n;
            sum += value;
        }
        if (n > 0) {
            return sum / (float)n;
        }
        return this.s[k][i + this.w * j];
    }

    float look(int i, int j, int k) {
        if (i < 0 || i >= this.w) {
            return -1.0f;
        }
        if (j < 0 || j >= this.h) {
            return -1.0f;
        }
        if (k < 0 || k >= this.d) {
            return -1.0f;
        }
        return this.s[k][i + this.w * j];
    }

    float lookNew(int i, int j, int k) {
        if (i < 0 || i >= this.w) {
            return -1.0f;
        }
        if (j < 0 || j >= this.h) {
            return -1.0f;
        }
        if (k < 0 || k >= this.d) {
            return -1.0f;
        }
        return this.sNew[k][i + this.w * j];
    }

    String stripExtension(String name) {
        int dotIndex;
        if (name != null && (dotIndex = name.lastIndexOf(".")) >= 0) {
            name = name.substring(0, dotIndex);
        }
        return name;
    }
}

