/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import java.util.ArrayList;
import mcib3d.geom.Object3DVoxels;

public class RDAR {
    private Object3DVoxels volume;
    private Object3DVoxels ellipsoid;
    private ArrayList<Object3DVoxels> partsIn = null;
    private ArrayList<Object3DVoxels> partsOut = null;

    public RDAR(Object3DVoxels volume) {
        this.volume = volume;
        this.ellipsoid = null;
    }

    private void compute() {
        this.ellipsoid = this.volume.getEllipsoid();
        Object3DVoxels object3DVoxels = new Object3DVoxels(this.volume);
        object3DVoxels.substractObject(this.ellipsoid);
        if (object3DVoxels.getVolumePixels() > 0) {
            this.partsOut = object3DVoxels.getConnexComponents();
        }
        object3DVoxels = new Object3DVoxels(this.ellipsoid);
        object3DVoxels.substractObject(this.volume);
        if (object3DVoxels.getVolumePixels() > 0) {
            this.partsIn = object3DVoxels.getConnexComponents();
        }
    }

    public ArrayList<Object3DVoxels> getPartsIn() {
        return this.getPartsIn(0);
    }

    public ArrayList<Object3DVoxels> getPartsOut() {
        return this.getPartsOut(0);
    }

    public int getPartsInNumber() {
        if (this.getPartsIn() == null) {
            return 0;
        }
        return this.getPartsIn().size();
    }

    public int getPartsOutNumber() {
        if (this.getPartsOut() == null) {
            return 0;
        }
        return this.getPartsOut().size();
    }

    public int getPartsOutVolumePixels() {
        return this.getPartsOutVolumePixels(0);
    }

    public int getPartsOutVolumePixels(int minVolume) {
        if (this.getPartsOut(minVolume) == null) {
            return 0;
        }
        int volume = 0;
        for (Object3DVoxels object3DVoxels : this.getPartsOut(minVolume)) {
            volume += object3DVoxels.getVolumePixels();
        }
        return volume;
    }

    public double getPartsInVolumeUnit() {
        return this.getPartsInVolumeUnit(0);
    }

    public double getPartsInVolumeUnit(int minVolume) {
        if (this.getPartsIn(minVolume) == null) {
            return 0.0;
        }
        double volume = 0.0;
        for (Object3DVoxels object3DVoxels : this.getPartsIn(minVolume)) {
            volume += object3DVoxels.getVolumeUnit();
        }
        return volume;
    }

    public double getPartsOutVolumeUnit() {
        return this.getPartsOutVolumeUnit(0);
    }

    public double getPartsOutVolumeUnit(int minVolume) {
        if (this.getPartsOut(minVolume) == null) {
            return 0.0;
        }
        double volume = 0.0;
        for (Object3DVoxels object3DVoxels : this.getPartsOut(minVolume)) {
            volume += object3DVoxels.getVolumeUnit();
        }
        return volume;
    }

    public int getPartsInVolumePixels() {
        return this.getPartsInVolumePixels(0);
    }

    public int getPartsInVolumePixels(int minVolume) {
        if (this.getPartsIn(minVolume) == null) {
            return 0;
        }
        int volume = 0;
        for (Object3DVoxels object3DVoxels : this.getPartsIn(minVolume)) {
            volume += object3DVoxels.getVolumePixels();
        }
        return volume;
    }

    public ArrayList<Object3DVoxels> getPartsIn(int minVolume) {
        if (this.ellipsoid == null) {
            this.compute();
        }
        if (this.partsIn == null) {
            return null;
        }
        ArrayList<Object3DVoxels> result = new ArrayList<Object3DVoxels>();
        for (Object3DVoxels part : this.partsIn) {
            if (part.getVolumePixels() <= minVolume) continue;
            result.add(part);
        }
        return result;
    }

    public ArrayList<Object3DVoxels> getPartsOut(int minVolume) {
        if (this.ellipsoid == null) {
            this.compute();
        }
        if (this.partsOut == null) {
            return null;
        }
        ArrayList<Object3DVoxels> result = new ArrayList<Object3DVoxels>();
        for (Object3DVoxels part : this.partsOut) {
            if (part.getVolumePixels() <= minVolume) continue;
            result.add(part);
        }
        return result;
    }

    public int getPartsInNumber(int minVolume) {
        if (this.getPartsIn(minVolume) == null) {
            return 0;
        }
        return this.getPartsIn(minVolume).size();
    }

    public int getPartsOutNumber(int minVolume) {
        if (this.getPartsOut(minVolume) == null) {
            return 0;
        }
        return this.getPartsOut(minVolume).size();
    }

    public Object3DVoxels getEllipsoid() {
        return this.ellipsoid;
    }

    public void setVolume(Object3DVoxels volume) {
        this.volume = volume;
        this.ellipsoid = null;
    }
}

