/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.processing;

import ij.IJ;
import ij.ImagePlus;
import ij.plugin.GaussianBlur3D;
import mcib3d.geom.Vector3D;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;

public class SymmetryFilter {
    ImageHandler[] edges = null;
    int radius = 0;
    double normalize = 10.0;
    double scaling = 2.0;
    ImageHandler bin1 = null;
    ImageHandler bin2 = null;
    boolean improved = false;
    ImageHandler sym = null;
    ImageHandler sym2 = null;

    public SymmetryFilter(ImageHandler[] edges, int radius, boolean improved) {
        this.edges = edges;
        this.radius = radius;
        this.improved = improved;
    }

    private void computeBins() {
        ImageHandler img = this.edges[0];
        this.bin1 = new ImageFloat("bin1", img.sizeX, img.sizeY, img.sizeZ);
        this.bin2 = new ImageFloat("bin2", img.sizeX, img.sizeY, img.sizeZ);
        for (int z = 0; z < img.sizeZ; ++z) {
            IJ.showStatus((String)("Symmetry " + z + "/" + img.sizeZ));
            for (int x = 0; x < img.sizeX; ++x) {
                for (int y = 0; y < img.sizeY; ++y) {
                    double ex = this.edges[0].getPixel(x, y, z);
                    double ey = this.edges[1].getPixel(x, y, z);
                    double ez = this.edges[2].getPixel(x, y, z);
                    double ee = Math.sqrt(ex * ex + ey * ey + ez * ez);
                    Vector3D grad = new Vector3D(ex, ey, ez);
                    grad.normalize();
                    if (grad.getLength() == 0.0) continue;
                    Vector3D pos = new Vector3D(x, y, z);
                    for (int d = 0; d < this.radius; ++d) {
                        pos.translate(grad);
                        if (d <= 0 || !img.contains(pos.getRoundX(), pos.getRoundY(), pos.getRoundZ())) continue;
                        this.bin1.setPixelIncrement(pos, 1.0f);
                        if (this.improved) {
                            this.bin2.setPixelIncrement(pos, (float)((double)d * ee));
                            continue;
                        }
                        this.bin2.setPixelIncrement(pos, (float)ee);
                    }
                }
            }
        }
    }

    private void computeSymmetry() {
        if (this.bin1 == null) {
            this.computeBins();
        }
        ImageHandler bin22 = this.bin2.duplicate();
        ImageHandler bin11 = this.bin1.duplicate();
        bin22.multiplyByValue((float)this.scaling);
        bin11.multiplyByValue((float)Math.pow(this.normalize, this.scaling));
        this.sym = bin11.addImage(bin22, 1, 1);
        this.sym.setTitle("Symmetry_" + this.radius);
        this.sym2 = this.sym.duplicate();
        GaussianBlur3D.blur((ImagePlus)this.sym2.getImagePlus(), (double)2.0, (double)2.0, (double)2.0);
        this.sym2.setTitle("Symmetry_" + this.radius + "_smoothed");
    }

    public ImageHandler[] getIntermediates() {
        if (this.bin1 == null) {
            this.computeBins();
        }
        return new ImageHandler[]{this.bin1, this.bin2};
    }

    public ImageHandler getSymmetry(boolean smoothed) {
        if (this.sym == null) {
            this.computeSymmetry();
        }
        if (smoothed) {
            return this.sym2;
        }
        return this.sym;
    }

    public ImageHandler[] getEdges() {
        return this.edges;
    }

    public void setEdges(ImageHandler[] edges) {
        this.edges = edges;
        this.bin1 = null;
        this.sym = null;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.bin1 = null;
        this.sym = null;
    }

    public void setNormalize(double normalize) {
        this.normalize = normalize;
        this.sym = null;
    }

    public void setScaling(double scaling) {
        this.scaling = scaling;
        this.sym = null;
    }

    public void setImproved(boolean improved) {
        this.improved = improved;
        this.bin1 = null;
        this.sym = null;
    }
}

