package plugins.adufour.blocks.tools.roi;

import java.util.ArrayList;

import icy.plugin.abstract_.Plugin;
import icy.roi.ROI;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarROIArray;

public class SubtractROI extends Plugin implements ROIBlock
{
    VarROIArray roiA = new VarROIArray("List of ROI #1");
    
    VarROIArray roiB = new VarROIArray("List of ROI #2");
    
    VarROIArray roiOut = new VarROIArray("Subtracted ROI");
    
    @Override
    public void run()
    {
        roiOut.setValue(subtractROI(roiA.getValue(true), roiB.getValue(true)));
    }
    
    @Override
    public void declareInput(VarList inputMap)
    {
        inputMap.add("List of ROI #1", roiA);
        inputMap.add("List of ROI #2", roiB);
    }
    
    @Override
    public void declareOutput(VarList outputMap)
    {
        outputMap.add("subtraction output ROI", roiOut);
    }
    
    /**
     * Subtracts a set of ROI from another
     * 
     * @param roiA
     * @param roiB
     * @return A - B
     */
    public static ROI[] subtractROI(ROI[] roiA, ROI[] roiB)
    {
        ArrayList<ROI> out = new ArrayList<ROI>(roiA.length);
        
        for (ROI a : roiA)
        {
            ROI subtraction = a.getCopy();
            
            for (ROI b : roiB)
                subtraction = subtraction.getSubtraction(b);
            
            if (subtraction == null || subtraction.isEmpty()) continue;
            
            if (!subtraction.getBounds5D().isEmpty()) out.add(subtraction);
        }
        
        return out.toArray(new ROI[out.size()]);
    }
}
