/*
 * Decompiled with CFR 0.152.
 */
package plugins.fantm.fpbioimagehelper;

import icy.file.FileUtil;
import icy.file.Saver;
import icy.gui.dialog.ConfirmDialog;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.progress.ProgressFrame;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.image.lut.LUT;
import icy.math.Scaler;
import icy.plugin.PluginLoader;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import java.awt.Desktop;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.model.S3Object;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDimensionPicker;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;
import plugins.fantm.fpbioimagehelper.Bucket;

public class FpBioimageHelper
extends EzPlug {
    public static String bucketName = "fpbhost";
    EzVarSequence seqVar = new EzVarSequence("Sequence");
    EzVarDimensionPicker timeSlice = new EzVarDimensionPicker("Time point", DimensionId.T, this.seqVar);
    EzVarDouble voxelSizeXVar = new EzVarDouble("Voxel size x", 0.0, 0.0, 10000.0, 1.0);
    EzVarDouble voxelSizeYVar = new EzVarDouble("Voxel size y", 0.0, 0.0, 10000.0, 1.0);
    EzVarDouble voxelSizeZVar = new EzVarDouble("Voxel size z", 0.0, 0.0, 10000.0, 1.0);
    EzVarText uniqueNameVar = new EzVarText("Unique Name", "", 1);
    EzVarDouble scaleXVar = new EzVarDouble("X-scale", 1.0, 0.0, 100.0, 0.25);
    EzVarDouble scaleYVar = new EzVarDouble("Y-scale", 1.0, 0.0, 100.0, 0.25);
    EzVarDouble scaleZVar = new EzVarDouble("Z-scale", 1.0, 0.0, 100.0, 0.25);
    EzVarBoolean uploadToAWSVar = new EzVarBoolean("Upload to FPB Host?", false);

    protected void initialize() {
        this.addEzComponent((EzComponent)this.seqVar);
        this.addEzComponent((EzComponent)this.timeSlice);
        this.addEzComponent((EzComponent)this.uniqueNameVar);
        EzGroup voxelRatioGroup = new EzGroup("Voxel Ratio (before scaling)", new EzComponent[]{this.voxelSizeXVar, this.voxelSizeYVar, this.voxelSizeZVar});
        this.addEzComponent((EzComponent)voxelRatioGroup);
        EzGroup scaleGroup = new EzGroup("Scaling (<1 to reduce file size)", new EzComponent[]{this.scaleXVar, this.scaleYVar, this.scaleZVar});
        this.addEzComponent((EzComponent)scaleGroup);
        this.addEzComponent((EzComponent)this.uploadToAWSVar);
        Sequence seq = (Sequence)this.seqVar.getValue();
        if (seq != null) {
            this.voxelSizeXVar.setValue((Object)seq.getPixelSizeX());
            this.voxelSizeYVar.setValue((Object)seq.getPixelSizeY());
            this.voxelSizeZVar.setValue((Object)seq.getPixelSizeZ());
            this.uniqueNameVar.setValue((Object)seq.getName());
            if (seq.getSizeX() > 500 || seq.getSizeY() > 500) {
                double scale = Math.min(400.0 / (double)seq.getSizeX(), 400.0 / (double)seq.getSizeY());
                this.scaleXVar.setValue((Object)scale);
                this.scaleYVar.setValue((Object)scale);
            }
            if (seq.getSizeZ() > 500) {
                double zScale = 400.0 / (double)seq.getSizeZ();
                this.scaleZVar.setValue((Object)zScale);
            }
        }
        this.seqVar.addVarChangeListener((EzVarListener)new EzVarListener<Sequence>(){

            public void variableChanged(EzVar<Sequence> source, Sequence newSeq) {
                if (newSeq != null) {
                    FpBioimageHelper.this.voxelSizeXVar.setValue((Object)newSeq.getPixelSizeX());
                    FpBioimageHelper.this.voxelSizeYVar.setValue((Object)newSeq.getPixelSizeY());
                    FpBioimageHelper.this.voxelSizeZVar.setValue((Object)newSeq.getPixelSizeZ());
                    FpBioimageHelper.this.uniqueNameVar.setValue((Object)newSeq.getName());
                    if (newSeq.getSizeX() > 500 || newSeq.getSizeY() > 500) {
                        double scale = Math.min(400.0 / (double)newSeq.getSizeX(), 400.0 / (double)newSeq.getSizeY());
                        FpBioimageHelper.this.scaleXVar.setValue((Object)scale);
                        FpBioimageHelper.this.scaleYVar.setValue((Object)scale);
                    } else {
                        FpBioimageHelper.this.scaleXVar.setValue((Object)1.0);
                        FpBioimageHelper.this.scaleYVar.setValue((Object)1.0);
                    }
                    if (newSeq.getSizeZ() > 500) {
                        double zScale = 400.0 / (double)newSeq.getSizeZ();
                        FpBioimageHelper.this.scaleZVar.setValue((Object)zScale);
                    } else {
                        FpBioimageHelper.this.scaleZVar.setValue((Object)1.0);
                    }
                } else {
                    FpBioimageHelper.this.voxelSizeXVar.setValue((Object)0.0);
                    FpBioimageHelper.this.voxelSizeYVar.setValue((Object)0.0);
                    FpBioimageHelper.this.voxelSizeZVar.setValue((Object)0.0);
                    FpBioimageHelper.this.uniqueNameVar.setValue((Object)"");
                    FpBioimageHelper.this.scaleXVar.setValue((Object)1.0);
                    FpBioimageHelper.this.scaleYVar.setValue((Object)1.0);
                    FpBioimageHelper.this.scaleZVar.setValue((Object)1.0);
                }
            }
        });
    }

    protected void execute() {
        Sequence sliceArray;
        Boolean dlg;
        Boolean dlg2;
        if ((Double)this.scaleZVar.getValue() < 0.999 && !(dlg2 = Boolean.valueOf(ConfirmDialog.confirm((String)"Warning", (String)"Note that the z-scaling algorithm built-in to this helper is slow. I suggest you use another tool to scale in z. Continue anyway?"))).booleanValue()) {
            return;
        }
        Sequence seq = (Sequence)this.seqVar.getValue();
        if (seq == null) {
            return;
        }
        if ((double)seq.getSizeX() * (Double)this.scaleXVar.getValue() > 500.0) {
            MessageDialog.showDialog((String)"Maximum X, Y or Z size after scaling is 500. Please check X dimension.", (int)0);
            return;
        }
        if ((double)seq.getSizeY() * (Double)this.scaleYVar.getValue() > 500.0) {
            MessageDialog.showDialog((String)"Maximum X, Y or Z size after scaling is 500. Please check Y dimension.", (int)0);
            return;
        }
        if ((double)seq.getSizeZ() * (Double)this.scaleZVar.getValue() > 500.0) {
            MessageDialog.showDialog((String)"Maximum X, Y or Z size after scaling is 500. Please check Z dimension.", (int)0);
            return;
        }
        String uniqueName = (String)this.uniqueNameVar.getValue();
        uniqueName = this.validateName(uniqueName);
        String savepath = this.DirectoryChooser("fpsavepath", "Choose a folder to save webpage and image data");
        if (savepath == null) {
            return;
        }
        savepath = String.valueOf(savepath) + "/" + uniqueName;
        this.getPreferencesRoot().put("fpsavepath", FileUtil.getDirectory((String)savepath));
        Viewer view = seq.getFirstViewer();
        view.setCanvas("plugins.kernel.canvas.Canvas2DPlugin");
        if (seq.getSizeZ() == 1 && seq.getSizeT() > 1 && (dlg = Boolean.valueOf(ConfirmDialog.confirm((String)"Swap Z & T", (String)"Image appears to only have 1 z-slice. Would you like to swap Z and T dimensions?"))).booleanValue()) {
            SequenceUtil.adjustZT((Sequence)seq, (int)seq.getSizeT(), (int)seq.getSizeZ(), (boolean)true);
        }
        if ((sliceArray = SequenceUtil.extractFrame((Sequence)seq, (int)((Integer)this.timeSlice.getValue()))) == null) {
            System.out.println("Selected frame does not exist for this sequence: using frame 0.");
            sliceArray = SequenceUtil.extractFrame((Sequence)seq, (int)0);
        }
        ProgressFrame prog = new ProgressFrame("Converting colorspace...");
        prog.setLength(1.0);
        prog.setPosition(0.1);
        sliceArray = SequenceUtil.convertColor((Sequence)sliceArray, (int)2, (LUT)seq.getFirstViewer().getLut());
        prog.setPosition(0.175);
        prog.setMessage("FP Helper: Scaling Image");
        sliceArray = SequenceUtil.scale((Sequence)sliceArray, (int)((int)Math.round((double)sliceArray.getSizeX() * (Double)this.scaleXVar.getValue())), (int)((int)Math.round((double)sliceArray.getSizeY() * (Double)this.scaleYVar.getValue())));
        if ((Double)this.scaleZVar.getValue() < 0.999) {
            sliceArray = this.scaleZ(sliceArray, (Double)this.scaleZVar.getValue());
        }
        prog.setPosition(0.25);
        prog.setMessage("FP Helper: Composing texture atlases...");
        int sliceWidth = sliceArray.getSizeX();
        int sliceHeight = sliceArray.getSizeY();
        int numberOfImages = sliceArray.getSizeZ();
        int numberOfAtlases = 8;
        int zPadding = 0;
        int paddedSliceDepth = numberOfImages + zPadding;
        int paddedSliceWidth = this.ceil2(sliceWidth);
        int paddedSliceHeight = this.ceil2(sliceHeight);
        int xOffset = (int)Math.floor((paddedSliceWidth - sliceWidth) / 2);
        int yOffset = (int)Math.floor((paddedSliceHeight - sliceHeight) / 2);
        int slicesPerAtlas = (int)Math.ceil((float)paddedSliceDepth / (float)numberOfAtlases);
        int atlasWidth = this.ceil2(paddedSliceWidth);
        int atlasHeight = this.ceil2(paddedSliceHeight * slicesPerAtlas);
        while (atlasHeight > 2 * atlasWidth && atlasHeight > sliceHeight) {
            atlasHeight /= 2;
            atlasWidth *= 2;
        }
        BufferedImage[] atlasArray = new BufferedImage[8];
        int i = 0;
        while (i < numberOfAtlases) {
            atlasArray[i] = new BufferedImage(atlasWidth, atlasHeight, 2);
            ++i;
        }
        LUT argbLUT = sliceArray.createCompatibleLUT();
        argbLUT.setAlphaToLinear();
        Scaler[] scalers = argbLUT.getScalers();
        double maxRightIn = 0.0;
        int i2 = 0;
        while (i2 < 3) {
            double thisRightIn = scalers[i2].getRightIn();
            if (thisRightIn > maxRightIn) {
                maxRightIn = thisRightIn;
            }
            ++i2;
        }
        scalers[3].setRightIn(maxRightIn);
        argbLUT.getLutChannel(3).setScaler(scalers[3]);
        int slicesPerRow = (int)Math.floor((float)atlasWidth / (float)paddedSliceWidth);
        int i3 = 0;
        while (i3 < numberOfImages) {
            int j = i3 + (int)Math.floor((double)zPadding / 2.0);
            int atlasNumber = (int)((float)j % (float)numberOfAtlases);
            int locationIndex = (int)Math.floor((float)j / (float)numberOfAtlases);
            BufferedImage sliceTexture = IcyBufferedImageUtil.getARGBImage((IcyBufferedImage)sliceArray.getImage(0, i3), (LUT)argbLUT);
            int xStartPixel = (int)((float)locationIndex % (float)slicesPerRow) * paddedSliceWidth + xOffset;
            int yStartPixel = (int)Math.floor((float)locationIndex / (float)slicesPerRow) * paddedSliceHeight;
            yStartPixel = atlasHeight - yStartPixel - paddedSliceHeight + yOffset;
            FpBioimageHelper.copySubImage(sliceTexture, atlasArray[atlasNumber], xStartPixel, yStartPixel);
            ++i3;
        }
        Sequence atlasSequence = new Sequence("Atlas Array");
        int i4 = 0;
        while (i4 < numberOfAtlases) {
            atlasSequence.addImage(atlasArray[i4]);
            ++i4;
        }
        prog.setMessage("FP Helper: Saving images...");
        prog.setPosition(0.5);
        String imageFilename = String.valueOf(savepath) + "/" + uniqueName + ".png";
        Saver.save((Sequence)atlasSequence, (File)new File(imageFilename), (boolean)true, (boolean)true);
        String pathTohtmlFile = "/templateWebpage.html";
        int numLines = 57;
        String[] webpageAsString = new String[numLines];
        try {
            webpageAsString = this.readFileToString(pathTohtmlFile, numLines);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            savepath = new File(savepath).getCanonicalPath();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        String relativePathToImages = ".";
        int i5 = 0;
        while (i5 < numLines) {
            webpageAsString[i5] = webpageAsString[i5].replace("templateTitle", String.valueOf(uniqueName) + " - FPBioimage Viewer");
            webpageAsString[i5] = webpageAsString[i5].replace("templateImagePath", relativePathToImages);
            webpageAsString[i5] = webpageAsString[i5].replace("templateUniqueName", uniqueName);
            webpageAsString[i5] = webpageAsString[i5].replace("templateNumberOfImages", Integer.toString(numberOfImages));
            webpageAsString[i5] = webpageAsString[i5].replace("templateImagePrefix", String.valueOf(uniqueName) + "_z");
            webpageAsString[i5] = webpageAsString[i5].replace("templateNumberingFormat", "0000");
            webpageAsString[i5] = webpageAsString[i5].replace("templateVoxelX", Double.toString((Double)this.voxelSizeXVar.getValue() / (Double)this.scaleXVar.getValue()));
            webpageAsString[i5] = webpageAsString[i5].replace("templateVoxelY", Double.toString((Double)this.voxelSizeYVar.getValue() / (Double)this.scaleYVar.getValue()));
            webpageAsString[i5] = webpageAsString[i5].replace("templateVoxelZ", Double.toString((Double)this.voxelSizeZVar.getValue() / (Double)this.scaleZVar.getValue()));
            webpageAsString[i5] = webpageAsString[i5].replace("templateSliceWidth", Integer.toString(sliceWidth));
            webpageAsString[i5] = webpageAsString[i5].replace("templateSliceHeight", Integer.toString(sliceHeight));
            ++i5;
        }
        String htmlSavePath = String.valueOf(savepath) + "/index.html";
        try {
            FpBioimageHelper.writeStringToFile(htmlSavePath, webpageAsString);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (((Boolean)this.uploadToAWSVar.getValue()).booleanValue()) {
            prog.setPosition(0.75);
            prog.setMessage("FP Helper: Uploading to FP Host...");
            ClassLoader goodCl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(PluginLoader.getLoader());
            S3Service s3Service = Bucket.getS3Service();
            String keyPrefix = uniqueName;
            boolean confirmUpload = true;
            boolean fileAlreadyExists = true;
            try {
                fileAlreadyExists = s3Service.isObjectInBucket(bucketName, String.valueOf(keyPrefix) + "/index.html");
            }
            catch (ServiceException e2) {
                e2.printStackTrace();
            }
            while (fileAlreadyExists) {
                S3Object existingObject = null;
                try {
                    existingObject = s3Service.getObject(bucketName, String.valueOf(keyPrefix) + "/index.html");
                }
                catch (S3ServiceException e) {
                    e.printStackTrace();
                }
                Date lastModified = existingObject.getLastModifiedDate();
                Instant then = lastModified.toInstant();
                Instant now = Instant.now();
                Instant twentyFourHoursAgo = now.minus(24L, ChronoUnit.HOURS);
                Boolean within24Hours = !then.isBefore(twentyFourHoursAgo) && then.isBefore(now);
                if (within24Hours.booleanValue()) {
                    String msgStr = "File already exists, but is less than 24 hours old. Do you want to overwrite? (Press No to rename then upload.)";
                    int overwrite = JOptionPane.showConfirmDialog(null, msgStr, "File exists!", 1);
                    if (overwrite == 2) {
                        confirmUpload = false;
                        fileAlreadyExists = false;
                        continue;
                    }
                    if (overwrite == 0) {
                        fileAlreadyExists = false;
                        continue;
                    }
                    if (overwrite != 1) continue;
                    String newPrefix = JOptionPane.showInputDialog("New unique name:");
                    if (newPrefix != null) {
                        keyPrefix = this.validateName(newPrefix);
                        try {
                            fileAlreadyExists = s3Service.isObjectInBucket(bucketName, String.valueOf(keyPrefix) + "/index.html");
                        }
                        catch (ServiceException e2) {
                            e2.printStackTrace();
                        }
                        continue;
                    }
                    confirmUpload = false;
                    fileAlreadyExists = false;
                    continue;
                }
                String newPrefix = JOptionPane.showInputDialog("File already exists, and is over 24 hours old so can't be overwritten. Either rename, or cancel:");
                if (newPrefix != null) {
                    keyPrefix = this.validateName(newPrefix);
                    try {
                        fileAlreadyExists = s3Service.isObjectInBucket(bucketName, String.valueOf(keyPrefix) + "/index.html");
                    }
                    catch (ServiceException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
                confirmUpload = false;
                fileAlreadyExists = false;
            }
            if (confirmUpload) {
                String[] filelist = new String[9];
                String[] keylist = new String[9];
                filelist[8] = htmlSavePath;
                keylist[8] = String.valueOf(keyPrefix) + "/index.html";
                int i6 = 0;
                while (i6 < 8) {
                    filelist[i6] = String.valueOf(savepath) + "/" + uniqueName + "_z" + String.format("%04d", i6) + ".png";
                    keylist[i6] = String.valueOf(keyPrefix) + "/" + uniqueName + "_z" + String.format("%04d", i6) + ".png";
                    ++i6;
                }
                i6 = 0;
                while (i6 < filelist.length) {
                    File file = new File(filelist[i6]);
                    try {
                        S3Object uploadThis = new S3Object(file);
                        uploadThis.setKey(keylist[i6]);
                        uploadThis.addMetadata("Content-Type", "text/html");
                        uploadThis.setAcl(AccessControlList.REST_CANNED_PUBLIC_READ);
                        s3Service.putObject(bucketName, uploadThis);
                    }
                    catch (IOException | NoSuchAlgorithmException e) {
                        e.printStackTrace();
                    }
                    catch (S3ServiceException e) {
                        e.printStackTrace();
                    }
                    ++i6;
                }
                int showWebDlg = JOptionPane.showConfirmDialog(null, "Would you like to view the webpage now?", "Upload complete!", 0);
                if (showWebDlg == 0) {
                    try {
                        Desktop.getDesktop().browse(new URI("http://s3.amazonaws.com/fpbhost/" + keyPrefix + "/index.html"));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                JOptionPane.showConfirmDialog(null, "Data saved locally to " + htmlSavePath, "Complete!", -1, -1);
            }
            Thread.currentThread().setContextClassLoader(goodCl);
        } else {
            JOptionPane.showConfirmDialog(null, "Data saved locally to " + htmlSavePath, "Complete!", -1, -1);
        }
        prog.close();
    }

    public void clean() {
    }

    private String validateName(String inputName) {
        Pattern special = Pattern.compile("[!@#\u00c2\u00a3$%&*()+=|<>?{}\\[\\]~.,\\s]");
        boolean hasSpecial = special.matcher(inputName).find();
        if (inputName.length() < 4) {
            hasSpecial = true;
        }
        if (!hasSpecial) {
            return inputName;
        }
        String newName = null;
        while (hasSpecial) {
            newName = JOptionPane.showInputDialog("Unique name can't contain spaces or special characters, with minimum length 3. Please choose a valid unique name:");
            hasSpecial = newName == null || newName.length() < 4 || newName == "" ? true : special.matcher(newName).find();
        }
        return newName;
    }

    private static void copySubImage(BufferedImage src, BufferedImage dst, int dx, int dy) {
        int[] srcbuf = ((DataBufferInt)src.getRaster().getDataBuffer()).getData();
        int[] dstbuf = ((DataBufferInt)dst.getRaster().getDataBuffer()).getData();
        int width = src.getWidth();
        int height = src.getHeight();
        int dstoffs = dx + dy * dst.getWidth();
        int srcoffs = 0;
        int y = 0;
        while (y < height) {
            System.arraycopy(srcbuf, srcoffs, dstbuf, dstoffs, width);
            ++y;
            dstoffs += dst.getWidth();
            srcoffs += width;
        }
    }

    public String DirectoryChooser(String icyprefname, String dialogTitle) {
        String defaultPath = this.getPreferencesRoot().get(icyprefname, null);
        JFileChooser chooser = new JFileChooser();
        if (defaultPath != null) {
            chooser.setCurrentDirectory(new File(defaultPath));
        }
        chooser.setDialogTitle(dialogTitle);
        chooser.setFileSelectionMode(1);
        int chooserReturn = chooser.showSaveDialog(null);
        if (chooserReturn == 0) {
            String path = chooser.getSelectedFile().toString();
            this.getPreferencesRoot().put(icyprefname, FileUtil.getDirectory((String)path));
            return path;
        }
        return null;
    }

    public String DirectoryChooser(String icyprefname) {
        return this.DirectoryChooser(icyprefname, "Chooser folder...");
    }

    public int ceil2(int x) {
        double log = Math.log(x) / Math.log(2.0);
        double roundLog = Math.ceil(log);
        int powerOfTwo = (int)Math.pow(2.0, roundLog);
        return powerOfTwo;
    }

    public String[] readFileToString(String pathToFile, int numLines) throws IOException {
        InputStream fr = ((Object)((Object)this)).getClass().getResourceAsStream(pathToFile);
        BufferedReader textReader = new BufferedReader(new InputStreamReader(fr));
        String[] textData = new String[numLines];
        int i = 0;
        while (i < numLines) {
            textData[i] = textReader.readLine();
            ++i;
        }
        textReader.close();
        return textData;
    }

    public static void writeStringToFile(String filename, String[] stringToWrite) throws IOException {
        BufferedWriter outputWriter = null;
        outputWriter = new BufferedWriter(new FileWriter(filename));
        int i = 0;
        while (i < stringToWrite.length) {
            outputWriter.write(stringToWrite[i]);
            outputWriter.newLine();
            ++i;
        }
        outputWriter.flush();
        outputWriter.close();
    }

    public Sequence scaleZ(Sequence seq, double scaleFactor) {
        int oldDepth = seq.getSizeZ();
        double idealNewDepth = (double)oldDepth * scaleFactor;
        Sequence output = new Sequence();
        double mixA = idealNewDepth / (double)oldDepth;
        double mixB = 1.0 - mixA;
        int newDepth = (int)Math.ceil(idealNewDepth);
        int newZCount = 0;
        while (newZCount < newDepth) {
            IcyBufferedImage newSlice = new IcyBufferedImage(seq.getSizeX(), seq.getSizeY(), seq.getSizeC(), seq.getDataType_());
            int oldZSlice = (int)Math.floor((double)newZCount / scaleFactor);
            if (oldZSlice + 1 >= seq.getSizeZ()) {
                oldZSlice = seq.getSizeZ() - 2;
            }
            int x = 0;
            while (x < seq.getSizeX()) {
                int y = 0;
                while (y < seq.getSizeY()) {
                    byte[] oldZa = seq.getDataCopyCAsByte(((Integer)this.timeSlice.getValue()).intValue(), oldZSlice, x, y);
                    byte[] oldZb = seq.getDataCopyCAsByte(((Integer)this.timeSlice.getValue()).intValue(), oldZSlice + 1, x, y);
                    int c = 0;
                    while (c < oldZa.length) {
                        double newZ = mixA * (double)oldZa[c] + mixB * (double)oldZb[c];
                        newSlice.setDataAsByte(x, y, c, (byte)newZ);
                        ++c;
                    }
                    ++y;
                }
                ++x;
            }
            output.addImage((BufferedImage)newSlice);
            ++newZCount;
        }
        return output;
    }
}

