/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.qr;

import org.ejml.alg.dense.decomposition.TriangularSolver;
import org.ejml.alg.dense.decomposition.qr.QRDecompositionHouseholderColumn;
import org.ejml.alg.dense.linsol.LinearSolverAbstract;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.SpecializedOps;

public class LinearSolverQrHouseCol
extends LinearSolverAbstract {
    private QRDecompositionHouseholderColumn decomposer = new QRDecompositionHouseholderColumn();
    private double[] a;
    protected int maxRows = -1;
    protected int maxCols = -1;
    private double[][] QR;
    private DenseMatrix64F R;
    private double[] gammas;

    public void setMaxSize(int n, int n2) {
        this.maxRows = n;
        this.maxCols = n2;
        this.a = new double[n];
        this.R = new DenseMatrix64F(n2, n2);
    }

    @Override
    public boolean setA(DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F.numRows > this.maxRows || denseMatrix64F.numCols > this.maxCols) {
            this.setMaxSize(denseMatrix64F.numRows, denseMatrix64F.numCols);
        }
        this._setA(denseMatrix64F);
        if (!this.decomposer.decompose(denseMatrix64F)) {
            return false;
        }
        this.gammas = this.decomposer.getGammas();
        this.QR = this.decomposer.getQR();
        this.decomposer.getR(this.R, true);
        return true;
    }

    @Override
    public double quality() {
        return SpecializedOps.qualityTriangular(true, this.R);
    }

    @Override
    public void solve(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        if (denseMatrix64F2.numRows != this.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for X: X rows = " + denseMatrix64F2.numRows + " expected = " + this.numCols);
        }
        if (denseMatrix64F.numRows != this.numRows || denseMatrix64F.numCols != denseMatrix64F2.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for B");
        }
        int n = denseMatrix64F.numCols;
        for (int i = 0; i < n; ++i) {
            int n2;
            for (n2 = 0; n2 < this.numRows; ++n2) {
                this.a[n2] = denseMatrix64F.data[n2 * n + i];
            }
            for (n2 = 0; n2 < this.numCols; ++n2) {
                int n3;
                double[] dArray = this.QR[n2];
                double d = this.a[n2];
                for (n3 = n2 + 1; n3 < this.numRows; ++n3) {
                    d += dArray[n3] * this.a[n3];
                }
                int n4 = n2;
                this.a[n4] = this.a[n4] - (d *= this.gammas[n2]);
                for (n3 = n2 + 1; n3 < this.numRows; ++n3) {
                    int n5 = n3;
                    this.a[n5] = this.a[n5] - dArray[n3] * d;
                }
            }
            TriangularSolver.solveU(this.R.data, this.a, this.numCols);
            for (n2 = 0; n2 < this.numCols; ++n2) {
                denseMatrix64F2.data[n2 * denseMatrix64F2.numCols + i] = this.a[n2];
            }
        }
    }

    @Override
    public boolean modifiesA() {
        return false;
    }

    @Override
    public boolean modifiesB() {
        return false;
    }
}

