/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.xml.BaseHandler;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.TiffParser;
import ome.units.UNITS;
import ome.units.quantity.ElectricPotential;
import ome.units.quantity.Length;
import ome.units.quantity.Temperature;
import ome.units.quantity.Time;
import ome.xml.model.primitives.Timestamp;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class MicromanagerReader
extends FormatReader {
    public static final String DATE_FORMAT = "EEE MMM dd HH:mm:ss zzz yyyy";
    private static final String METADATA = "metadata.txt";
    private static final int JSON_TAG = 50839;
    private static final int MM_JSON_TAG = 51123;
    private static final int MAX_MAJOR_VERSION = 1;
    private static final String MAX_VERSION = "1.4.22";
    private static final String XML = "Acqusition.xml";
    private MinimalTiffReader tiffReader;
    private Vector<Position> positions;

    public MicromanagerReader() {
        super("Micro-Manager", new String[]{"tif", "tiff", "txt", "xml"});
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "A file ending in 'metadata.txt' plus one or more .tif files";
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (!open) {
            return false;
        }
        if (name.equals(METADATA) || name.endsWith(File.separator + METADATA) || name.equals(XML) || name.endsWith(File.separator + XML) || name.endsWith("_metadata.txt")) {
            int blockSize = 0x100000;
            try {
                RandomAccessInputStream stream = new RandomAccessInputStream(name);
                long length = stream.length();
                String data = stream.readString((int)Math.min(0x100000L, length));
                data = data.toLowerCase();
                stream.close();
                return length > 0L && (data.indexOf("micro-manager") >= 0 || data.indexOf("micromanager") >= 0);
            }
            catch (IOException e) {
                return false;
            }
        }
        if (!this.isGroupFiles()) {
            return false;
        }
        try {
            Location thisFile = new Location(name).getAbsoluteFile();
            Location parent = thisFile.getParentFile();
            Location metaFile = new Location(parent, METADATA);
            if (!metaFile.exists()) {
                metaFile = new Location(parent, this.getPrefixMetadataName(thisFile.getName()));
            }
            RandomAccessInputStream s = new RandomAccessInputStream(name);
            boolean validTIFF = this.isThisType(s);
            s.close();
            return validTIFF && this.isThisType(metaFile.getAbsolutePath(), open);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        if (this.tiffReader == null) {
            this.tiffReader = new MinimalTiffReader();
        }
        return this.tiffReader.isThisType(stream);
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> files = new Vector<String>();
        for (Position pos : this.positions) {
            files.add(pos.metadataFile);
            if (pos.xmlFile != null) {
                files.add(pos.xmlFile);
            }
            if (noPixels) continue;
            for (String tiff : pos.tiffs) {
                if (!new Location(tiff).exists() || files.contains(tiff)) continue;
                files.add(tiff);
            }
        }
        return files.toArray(new String[files.size()]);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        String file2 = this.positions.get(this.getSeries()).getFile(this.getDimensionOrder(), this.getSizeZ(), this.getSizeC(), this.getSizeT(), this.getImageCount(), no);
        if (file2 != null && new Location(file2).exists()) {
            this.tiffReader.setId(file2);
            int index = no % this.tiffReader.getImageCount();
            return this.tiffReader.openBytes(index, buf, x, y, w, h);
        }
        LOGGER.warn("File for image #{} ({}) is missing.", (Object)no, (Object)file2);
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.tiffReader != null) {
            this.tiffReader.close(fileOnly);
        }
        if (!fileOnly) {
            this.positions = null;
        }
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.tiffReader.getCurrentFile() == null) {
            this.setupReader();
        }
        return this.tiffReader.getOptimalTileWidth();
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.tiffReader.getCurrentFile() == null) {
            this.setupReader();
        }
        return this.tiffReader.getOptimalTileHeight();
    }

    @Override
    public void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.tiffReader = new MinimalTiffReader();
        this.positions = new Vector();
        LOGGER.info("Reading metadata file");
        Location file2 = new Location(this.currentId).getAbsoluteFile();
        Location parentFile = file2.getParentFile();
        if (file2.exists()) {
            if (parentFile.getName().indexOf("Pos_") >= 0) {
                parentFile = parentFile.getParentFile();
                Object[] dirs = parentFile.list(true);
                Arrays.sort(dirs);
                for (Object dir : dirs) {
                    if (((String)dir).indexOf("Pos_") < 0) continue;
                    Position pos = new Position();
                    Location posDir = new Location(parentFile, (String)dir);
                    pos.metadataFile = new Location(posDir, METADATA).getAbsolutePath();
                    this.positions.add(pos);
                }
            } else {
                Position pos = new Position();
                Location metadata = new Location(parentFile, METADATA);
                if (!metadata.exists()) {
                    metadata = file2.getName().endsWith(METADATA) ? file2 : new Location(parentFile, this.getPrefixMetadataName(file2.getName()));
                }
                pos.metadataFile = metadata.getAbsolutePath();
                this.positions.add(pos);
            }
        }
        int seriesCount = this.positions.size();
        this.core.clear();
        for (int i = 0; i < seriesCount; ++i) {
            this.core.add(new CoreMetadata());
            this.setSeries(i);
            this.parsePosition(i);
        }
        this.setSeries(0);
        this.populateMetadata();
    }

    private void populateMetadata() throws FormatException, IOException {
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrumentID, 0);
        for (int i = 0; i < this.positions.size(); ++i) {
            String date;
            Position p = this.positions.get(i);
            if (p.time != null && (date = DateTools.formatDate(p.time, DATE_FORMAT)) != null) {
                store.setImageAcquisitionDate(new Timestamp(date), i);
            }
            if (p.name != null) {
                store.setImageName(p.name, i);
            } else if (this.positions.size() > 1) {
                Location parent = new Location(p.metadataFile).getParentFile();
                store.setImageName(parent.getName(), i);
            }
            if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) continue;
            store.setImageDescription(p.comment, i);
            store.setImageInstrumentRef(instrumentID, i);
            for (int c = 0; c < p.channels.length; ++c) {
                store.setChannelName(p.channels[c], i, c);
            }
            Length sizeX = FormatTools.getPhysicalSizeX(p.pixelSize);
            Length sizeY = FormatTools.getPhysicalSizeY(p.pixelSize);
            Length sizeZ = FormatTools.getPhysicalSizeZ(p.sliceThickness);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, i);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, i);
            }
            if (sizeZ != null) {
                store.setPixelsPhysicalSizeZ(sizeZ, i);
            }
            int nextStamp = 0;
            for (int q = 0; q < this.getImageCount(); ++q) {
                store.setPlaneExposureTime(p.exposureTime, i, q);
                String tiff = this.positions.get(this.getSeries()).getFile(q);
                if (tiff != null && new Location(tiff).exists() && nextStamp < p.timestamps.length && p.timestamps[nextStamp] != null) {
                    store.setPlaneDeltaT(new Time(p.timestamps[nextStamp++], UNITS.MILLISECOND), i, q);
                }
                if (p.positions == null || q >= p.positions.length) continue;
                if (p.positions[q][0] != null) {
                    store.setPlanePositionX(new Length(p.positions[q][0], UNITS.MICROMETER), i, q);
                }
                if (p.positions[q][1] != null) {
                    store.setPlanePositionY(new Length(p.positions[q][1], UNITS.MICROMETER), i, q);
                }
                if (p.positions[q][2] == null) continue;
                store.setPlanePositionZ(new Length(p.positions[q][2], UNITS.MICROMETER), i, q);
            }
            String serialNumber = p.detectorID;
            p.detectorID = MetadataTools.createLSID("Detector", 0, i);
            for (int c = 0; c < p.channels.length; ++c) {
                store.setDetectorSettingsBinning(this.getBinning(p.binning), i, c);
                store.setDetectorSettingsGain(new Double(p.gain), i, c);
                if (c < p.voltage.size()) {
                    store.setDetectorSettingsVoltage(new ElectricPotential(p.voltage.get(c), UNITS.VOLT), i, c);
                }
                store.setDetectorSettingsID(p.detectorID, i, c);
            }
            store.setDetectorID(p.detectorID, 0, i);
            if (p.detectorModel != null) {
                store.setDetectorModel(p.detectorModel, 0, i);
            }
            if (serialNumber != null) {
                store.setDetectorSerialNumber(serialNumber, 0, i);
            }
            if (p.detectorManufacturer != null) {
                store.setDetectorManufacturer(p.detectorManufacturer, 0, i);
            }
            if (p.cameraMode == null) {
                p.cameraMode = "Other";
            }
            store.setDetectorType(this.getDetectorType(p.cameraMode), 0, i);
            store.setImagingEnvironmentTemperature(new Temperature(p.temperature, UNITS.CELSIUS), i);
        }
    }

    public void populateMetadataStore(String[] jsonData) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, false, 1);
        this.currentId = "in-memory-json";
        this.core.clear();
        this.positions = new Vector();
        for (int pos = 0; pos < jsonData.length; ++pos) {
            this.core.add(new CoreMetadata());
            Position p = new Position();
            p.metadataFile = "Position #" + (pos + 1);
            this.positions.add(p);
            this.setSeries(pos);
            this.parsePosition(jsonData[pos], pos);
        }
        this.setSeries(0);
        this.populateMetadata();
    }

    private void parsePosition(int posIndex) throws IOException, FormatException {
        Position p = this.positions.get(posIndex);
        String s = DataTools.readFile(p.metadataFile);
        this.parsePosition(s, posIndex);
        this.buildTIFFList(posIndex);
        p.positions = new Double[p.tiffs.size()][3];
        int digits = String.valueOf(p.tiffs.size() - 1).length();
        boolean parseMMJSONTag = true;
        int plane = 0;
        while (plane < p.tiffs.size()) {
            String path = p.tiffs.get(plane);
            if (p.tiffs.size() == p.fileNameMap.size() && plane < this.getImageCount()) {
                path = p.getFile(plane);
            }
            if (path == null || !new Location(path).exists()) {
                ++plane;
                continue;
            }
            try {
                TiffParser parser = new TiffParser(path);
                int nIFDs = parser.getMainIFDs().size();
                IFD firstIFD = parser.getFirstIFD();
                parser.fillInIFD(firstIFD);
                CoreMetadata ms = (CoreMetadata)this.core.get(posIndex);
                ms.sizeX = (int)firstIFD.getImageWidth();
                ms.sizeY = (int)firstIFD.getImageLength();
                ms.pixelType = firstIFD.getPixelType();
                ms.littleEndian = firstIFD.isLittleEndian();
                String json = firstIFD.getIFDTextValue(50839);
                if (json != null) {
                    String[] lines;
                    for (String line : lines = json.split("\n")) {
                        String[] values;
                        String toSplit = line.trim();
                        if (toSplit.length() == 0 || (values = (toSplit = toSplit.substring(0, toSplit.length() - 1)).split("\": ")).length < 2) continue;
                        String key = values[0].replaceAll("\"", "");
                        String value = values[1].replaceAll("\"", "");
                        if (key.length() <= 0 || value.length() <= 0) continue;
                        this.parseKeyAndValue(key, value, digits, plane * nIFDs, nIFDs);
                    }
                }
                IFDList ifds = parser.getMainIFDs();
                for (int i = 0; i < ifds.size() && parseMMJSONTag; ++i) {
                    IFD ifd = (IFD)ifds.get(i);
                    parser.fillInIFD(ifd);
                    json = ifd.getIFDTextValue(51123);
                    LOGGER.trace("JSON for IFD #{} = {}", (Object)i, (Object)json);
                    if (json == null) {
                        parseMMJSONTag = false;
                        break;
                    }
                    String[] tokens = json.split("[\\{\\}:,\"]");
                    String key = null;
                    String value = null;
                    String propType = null;
                    int nEmptyTokens = 0;
                    for (int q = 0; q < tokens.length; ++q) {
                        String token = tokens[q];
                        if (token.length() == 0) {
                            ++nEmptyTokens;
                            continue;
                        }
                        if (nEmptyTokens == 5 && value == null) {
                            key = null;
                        }
                        if (key == null && value == null && propType == null) {
                            if (!token.equals("completeCoords")) {
                                key = token;
                            }
                            nEmptyTokens = 0;
                            continue;
                        }
                        if (token.equals("PropVal") || token.equals("[")) {
                            value = token;
                            continue;
                        }
                        if (token.equals("PropType")) {
                            propType = token;
                            continue;
                        }
                        if (value != null && value.equals("PropVal") && propType == null) {
                            value = token;
                            continue;
                        }
                        if (value != null && propType == null && value.startsWith("[") && !token.startsWith("]")) {
                            value = value + token;
                            value = value + ", ";
                            continue;
                        }
                        if ((propType == null || !propType.equals("PropType")) && !token.equals("]") && (key == null || value != null)) continue;
                        if (!(value != null || propType != null && propType.equals("PropType"))) {
                            StringBuilder sb = new StringBuilder(token);
                            while (q + 1 < tokens.length && tokens[q + 1].trim().length() > 0) {
                                sb.append(':');
                                sb.append(tokens[q + 1]);
                                ++q;
                            }
                            value = sb.toString();
                        }
                        if (!value.equals("PropVal")) {
                            this.parseKeyAndValue(key, value, digits, plane + i, 1);
                        }
                        propType = null;
                        key = null;
                        value = null;
                        nEmptyTokens = 0;
                    }
                }
                plane += ifds.size();
                parser.getStream().close();
            }
            catch (IOException e) {
                LOGGER.debug("Failed to read metadata from " + path, e);
            }
        }
    }

    private void parseKeyAndValue(String key, String value, int digits, int plane, int nPlanes) {
        Position p = this.positions.get(this.getCoreIndex());
        for (int i = plane; i < plane + nPlanes; ++i) {
            this.addSeriesMeta(String.format("Plane #%0" + digits + "d %s", i, key), value);
            if (key.equals("XPositionUm")) {
                try {
                    p.positions[i][0] = new Double(value);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (key.equals("YPositionUm")) {
                try {
                    p.positions[i][1] = new Double(value);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!key.equals("ZPositionUm")) continue;
            try {
                p.positions[i][2] = new Double(value);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void buildTIFFList(int posIndex) throws FormatException {
        Position p = this.positions.get(posIndex);
        CoreMetadata ms = (CoreMetadata)this.core.get(posIndex);
        String parent = new Location(p.metadataFile).getParent();
        LOGGER.info("Finding image file names");
        if (p.tiffs == null) {
            p.tiffs = new Vector();
        }
        if (p.baseTiff != null) {
            this.buildTIFFList(posIndex, parent + File.separator + p.baseTiff);
        }
        if (p.tiffs.size() == 0) {
            Vector<String> uniqueZ = new Vector<String>();
            Vector<String> uniqueC = new Vector<String>();
            Vector<String> uniqueT = new Vector<String>();
            Location dir = new Location(p.metadataFile).getAbsoluteFile().getParentFile();
            Object[] files = dir.list(true);
            Arrays.sort(files);
            for (Object f : files) {
                if (!MicromanagerReader.checkSuffix((String)f, "tif") && !MicromanagerReader.checkSuffix((String)f, "tiff")) continue;
                String[] blocks = ((String)f).split("_");
                if (!uniqueT.contains(blocks[1])) {
                    uniqueT.add(blocks[1]);
                }
                if (!uniqueC.contains(blocks[2])) {
                    uniqueC.add(blocks[2]);
                }
                if (!uniqueZ.contains(blocks[3])) {
                    uniqueZ.add(blocks[3]);
                }
                String path = new Location(dir, (String)f).getAbsolutePath();
                p.tiffs.add(path);
            }
            if (this.getSizeZ() * this.getSizeC() * this.getSizeT() != uniqueZ.size() * uniqueC.size() * uniqueT.size()) {
                ms.sizeZ = uniqueZ.size();
                ms.sizeC = uniqueC.size();
                ms.sizeT = uniqueT.size();
            }
            if (p.tiffs.size() == 0) {
                throw new FormatException("Could not find TIFF files.");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parsePosition(String jsonData, int posIndex) throws IOException, FormatException {
        Position p = this.positions.get(posIndex);
        CoreMetadata ms = (CoreMetadata)this.core.get(posIndex);
        String parent = new Location(p.metadataFile).getParent();
        LOGGER.info("Populating metadata");
        Vector<Double> stamps = new Vector<Double>();
        p.voltage = new Vector();
        StringTokenizer st = new StringTokenizer(jsonData, "\n");
        int[] slice = new int[3];
        block4: while (true) {
            int position;
            int[] zct;
            String path;
            String token;
            block87: {
                String value;
                String key;
                block89: {
                    StringBuilder valueBuffer;
                    boolean closed;
                    block90: {
                        block86: {
                            block88: {
                                if (!st.hasMoreTokens()) break block86;
                                token = st.nextToken().trim();
                                boolean open = token.indexOf(91) != -1;
                                boolean bl = closed = token.indexOf(93) != -1;
                                if (!open && (open || closed || token.equals("{") || token.startsWith("}"))) break block87;
                                int quote = token.indexOf("\"") + 1;
                                key = token.substring(quote, token.indexOf("\"", quote));
                                value = null;
                                if (open != closed) break block88;
                                value = token.substring(token.indexOf(58) + 1);
                                break block89;
                            }
                            if (closed) break block89;
                            valueBuffer = new StringBuilder();
                            break block90;
                        }
                        p.timestamps = stamps.toArray(new Double[stamps.size()]);
                        Arrays.sort((Object[])p.timestamps);
                        if (new Location(parent, XML).exists()) {
                            p.xmlFile = new Location(parent, XML).getAbsolutePath();
                            this.parseXMLFile();
                        }
                        if (this.getSizeZ() == 0) {
                            ms.sizeZ = 1;
                        }
                        if (this.getSizeT() == 0) {
                            ms.sizeT = 1;
                        }
                        if (ms.dimensionOrder == null) {
                            ms.dimensionOrder = "XYZCT";
                        }
                        ms.interleaved = false;
                        ms.rgb = false;
                        ms.littleEndian = false;
                        ms.imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
                        ms.indexed = false;
                        ms.falseColor = false;
                        ms.metadataComplete = true;
                        return;
                    }
                    while (!closed) {
                        token = st.nextToken();
                        closed = token.indexOf(93) != -1;
                        valueBuffer.append(token);
                    }
                    value = valueBuffer.toString();
                    value = value.replaceAll("\n", "");
                }
                if (value == null) continue;
                int startIndex = value.indexOf(91);
                int endIndex = value.indexOf(93);
                if (endIndex == -1) {
                    endIndex = value.length();
                }
                if ((value = value.substring(startIndex + 1, endIndex).trim()).length() == 0) continue;
                value = value.substring(0, value.length() - 1);
                if ((value = value.replaceAll("\"", "")).endsWith(",")) {
                    value = value.substring(0, value.length() - 1);
                }
                this.handleKeyValue(key, value);
                if (key.equals("Channels")) {
                    ms.sizeC = Integer.parseInt(value);
                } else if (key.equals("ChNames")) {
                    p.channels = value.split(",");
                    for (int q = 0; q < p.channels.length; ++q) {
                        p.channels[q] = p.channels[q].replaceAll("\"", "").trim();
                    }
                } else if (key.equals("Frames")) {
                    ms.sizeT = Integer.parseInt(value);
                } else if (key.equals("Slices")) {
                    ms.sizeZ = Integer.parseInt(value);
                } else if (key.equals("SlicesFirst")) {
                    ms.dimensionOrder = value.equals("false") ? "XYCZT" : "XYZCT";
                } else if (key.equals("PixelSize_um")) {
                    p.pixelSize = new Double(value);
                } else if (key.equals("z-step_um")) {
                    p.sliceThickness = new Double(value);
                } else if (key.equals("Time")) {
                    p.time = value;
                } else if (key.equals("Comment")) {
                    p.comment = value;
                } else if (key.equals("FileName")) {
                    p.fileNameMap.put(new Index(slice), value);
                    if (p.baseTiff == null) {
                        p.baseTiff = value;
                    }
                } else if (key.equals("Width")) {
                    ms.sizeX = Integer.parseInt(value);
                } else if (key.equals("Height")) {
                    ms.sizeY = Integer.parseInt(value);
                } else if (key.equals("IJType")) {
                    int type = Integer.parseInt(value);
                    switch (type) {
                        case 0: {
                            ms.pixelType = 1;
                            break;
                        }
                        case 1: {
                            ms.pixelType = 3;
                            break;
                        }
                        default: {
                            throw new FormatException("Unknown type: " + type);
                        }
                    }
                }
            }
            if (!token.startsWith("\"FrameKey")) {
                if (!token.startsWith("\"Coords-")) continue;
                path = token.substring(token.indexOf(45) + 1, token.lastIndexOf("\""));
                zct = new int[3];
                position = 0;
            } else {
                int dash = token.indexOf(45) + 1;
                int nextDash = token.indexOf("-", dash);
                slice[2] = Integer.parseInt(token.substring(dash, nextDash));
                dash = nextDash + 1;
                nextDash = token.indexOf("-", dash);
                slice[1] = Integer.parseInt(token.substring(dash, nextDash));
                dash = nextDash + 1;
                slice[0] = Integer.parseInt(token.substring(dash, token.indexOf("\"", dash)));
                token = st.nextToken().trim();
                String key = "";
                StringBuilder valueBuffer = new StringBuilder();
                boolean valueArray = false;
                int nestedCount = 0;
                while (true) {
                    block85: {
                        if (token.startsWith("}") && nestedCount <= 0) continue block4;
                        if (token.trim().endsWith("{")) {
                            ++nestedCount;
                            token = st.nextToken().trim();
                            continue;
                        }
                        if (token.trim().startsWith("}")) {
                            --nestedCount;
                            token = st.nextToken().trim();
                            continue;
                        }
                        if (valueArray || token.trim().equals("],")) {
                            if (token.trim().equals("],")) {
                                valueArray = false;
                                break block85;
                            } else {
                                valueBuffer.append(token.trim().replaceAll("\"", ""));
                                token = st.nextToken().trim();
                                continue;
                            }
                        }
                        int colon = token.indexOf(58);
                        key = token.substring(1, colon).trim();
                        valueBuffer.setLength(0);
                        valueBuffer.append(token.substring(colon + 1, token.length() - 1).trim().replaceAll("\"", ""));
                        key = key.replaceAll("\"", "");
                        if (token.trim().endsWith("[")) {
                            valueArray = true;
                            token = st.nextToken().trim();
                            continue;
                        }
                    }
                    String value = valueBuffer.toString();
                    this.handleKeyValue(key, value);
                    if (key.equals("Exposure-ms")) {
                        p.exposureTime = new Time(Double.valueOf(value), UNITS.MILLISECOND);
                    } else if (key.equals("ElapsedTime-ms")) {
                        stamps.add(Double.valueOf(value));
                    } else if (key.equals("Core-Camera")) {
                        p.cameraRef = value;
                    } else if (key.equals(p.cameraRef + "-Binning")) {
                        p.binning = value.indexOf(120) != -1 ? value : value + "x" + value;
                    } else if (key.equals(p.cameraRef + "-CameraID")) {
                        p.detectorID = value;
                    } else if (key.equals(p.cameraRef + "-CameraName")) {
                        p.detectorModel = value;
                    } else if (key.equals(p.cameraRef + "-Gain")) {
                        p.gain = (int)Double.parseDouble(value);
                    } else if (key.equals(p.cameraRef + "-Name")) {
                        p.detectorManufacturer = value;
                    } else if (key.equals(p.cameraRef + "-Temperature")) {
                        p.temperature = Double.parseDouble(value);
                    } else if (key.equals(p.cameraRef + "-CCDMode")) {
                        p.cameraMode = value;
                    } else if (key.startsWith("DAC-") && key.endsWith("-Volts")) {
                        p.voltage.add(new Double(value));
                    } else if (key.equals("PositionName") && !value.equals("null")) {
                        p.name = value;
                    } else if (key.equals("FileName")) {
                        p.fileNameMap.put(new Index(slice), value);
                        Location realFile = new Location(parent, value);
                        if (realFile.exists()) {
                            if (p.tiffs == null) {
                                p.tiffs = new Vector();
                            }
                            p.tiffs.add(realFile.getAbsolutePath());
                        }
                        if (p.baseTiff == null) {
                            p.baseTiff = value;
                        }
                    }
                    token = st.nextToken().trim();
                }
            }
            while (!token.startsWith("}")) {
                int sep = token.indexOf(58);
                if (sep > 0) {
                    String key = token.substring(0, sep);
                    String value = token.substring(sep + 1);
                    key = key.replaceAll("\"", "").trim();
                    value = value.replaceAll(",", "").trim();
                    if (key.equals("position")) {
                        position = Integer.parseInt(value);
                    } else if (key.equals("time")) {
                        zct[2] = Integer.parseInt(value);
                    } else if (key.equals("z")) {
                        zct[0] = Integer.parseInt(value);
                    } else if (key.equals("channel")) {
                        zct[1] = Integer.parseInt(value);
                    }
                }
                token = st.nextToken().trim();
            }
            Index idx = new Index(zct);
            idx.position = position;
            p.fileNameMap.put(idx, path);
        }
    }

    private void buildTIFFList(int posIndex, String baseTiff) {
        LOGGER.info("Building list of TIFFs");
        Position p = this.positions.get(posIndex);
        if (p.tiffs.size() > 0 && p.tiffs.size() == p.fileNameMap.size() || baseTiff == null) {
            return;
        }
        p.tiffs.clear();
        String prefix = "";
        if (baseTiff.indexOf(File.separator) != -1) {
            prefix = baseTiff.substring(0, baseTiff.lastIndexOf(File.separator) + 1);
            baseTiff = baseTiff.substring(baseTiff.lastIndexOf(File.separator) + 1);
        }
        String[] blocks = baseTiff.split("_");
        StringBuilder filename = new StringBuilder();
        for (int t = 0; t < this.getSizeT(); ++t) {
            for (int c = 0; c < this.getSizeC(); ++c) {
                for (int z = 0; z < this.getSizeZ(); ++z) {
                    filename.append(prefix);
                    if (!prefix.endsWith(File.separator) && !blocks[0].startsWith(File.separator)) {
                        filename.append(File.separator);
                    }
                    filename.append(blocks[0]);
                    filename.append("_");
                    int zeros = blocks[1].length() - String.valueOf(t).length();
                    for (int q = 0; q < zeros; ++q) {
                        filename.append("0");
                    }
                    filename.append(t);
                    filename.append("_");
                    String prechannel = filename.toString();
                    if (blocks[2].length() > 0) {
                        String channel = p.channels[c];
                        if (channel.indexOf(45) != -1) {
                            channel = channel.substring(0, channel.indexOf(45));
                        }
                        filename.append(channel);
                    }
                    filename.append("_");
                    zeros = blocks[3].length() - String.valueOf(z).length() - 4;
                    for (int q = 0; q < zeros; ++q) {
                        filename.append("0");
                    }
                    filename.append(z);
                    filename.append(".tif");
                    if (!new Location(filename.toString()).exists() && blocks[2].length() > 0) {
                        filename = new StringBuilder(prechannel);
                        String channel = p.channels[c];
                        filename.append(channel);
                        filename.append("_");
                        zeros = blocks[3].length() - String.valueOf(z).length() - 4;
                        for (int q = 0; q < zeros; ++q) {
                            filename.append("0");
                        }
                        filename.append(z);
                        filename.append(".tif");
                    }
                    p.tiffs.add(filename.toString());
                    filename.delete(0, filename.length());
                }
            }
        }
        int firstEmptyTimepoint = -1;
        int nextFile = 0;
        for (int t = 0; t < this.getSizeT(); ++t) {
            boolean emptyTimepoint = true;
            for (int c = 0; c < this.getSizeC(); ++c) {
                for (int z = 0; z < this.getSizeZ(); ++z) {
                    String file2;
                    if (!new Location(file2 = p.tiffs.get(nextFile++)).exists()) continue;
                    emptyTimepoint = false;
                    break;
                }
                if (!emptyTimepoint) break;
            }
            if (emptyTimepoint && firstEmptyTimepoint < 0) {
                firstEmptyTimepoint = t;
                continue;
            }
            if (emptyTimepoint || firstEmptyTimepoint < 0) continue;
            firstEmptyTimepoint = -1;
        }
        if (firstEmptyTimepoint >= 0) {
            int imageCount = this.getImageCount() / this.getSizeT();
            ((CoreMetadata)this.core.get((int)posIndex)).sizeT = firstEmptyTimepoint;
            ((CoreMetadata)this.core.get((int)posIndex)).imageCount = imageCount * this.getSizeT();
        }
    }

    private void parseXMLFile() throws IOException {
        Position p = this.positions.get(this.getSeries());
        String xmlData = DataTools.readFile(p.xmlFile);
        xmlData = XMLTools.sanitizeXML(xmlData);
        MicromanagerHandler handler = new MicromanagerHandler();
        XMLTools.parseXML(xmlData, (DefaultHandler)handler);
    }

    private void setupReader() {
        try {
            String file2 = this.positions.get(this.getSeries()).getFile(this.getDimensionOrder(), this.getSizeZ(), this.getSizeC(), this.getSizeT(), this.getImageCount(), 0);
            this.tiffReader.setId(file2);
        }
        catch (Exception e) {
            LOGGER.warn("", e);
        }
    }

    private String getPrefixMetadataName(String baseName) {
        int dot = baseName.indexOf(46);
        if (dot > 0) {
            return baseName.substring(0, dot) + "_" + METADATA;
        }
        return baseName + "_" + METADATA;
    }

    private void handleKeyValue(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        this.addSeriesMeta(key, value);
        if (key.equals("MicroManagerVersion")) {
            String[] version = value.split("\\.");
            Integer major = null;
            try {
                if (version.length > 0) {
                    major = new Integer(version[0]);
                }
            }
            catch (NumberFormatException e) {
                LOGGER.trace("Could not parse major version " + version[0], e);
            }
            if (major == null || major > 1) {
                LOGGER.warn("Dataset acquired with Micro-Manager {}; versions greater than {} are not officially supported", (Object)value, (Object)MAX_VERSION);
            }
        }
    }

    class Index {
        public int z;
        public int c;
        public int t;
        public int position;

        public Index(int[] zct) {
            this.z = zct[0];
            this.c = zct[1];
            this.t = zct[2];
        }

        public String toString() {
            return "[position = " + this.position + ", z = " + this.z + ", c = " + this.c + ", t = " + this.t + "]";
        }
    }

    class Position {
        public String baseTiff;
        public Vector<String> tiffs;
        public HashMap<Index, String> fileNameMap = new HashMap();
        public String metadataFile;
        public String xmlFile;
        public transient String name;
        public String[] channels;
        public String comment;
        public String time;
        public Time exposureTime;
        public Double sliceThickness;
        public Double pixelSize;
        public Double[] timestamps;
        public int gain;
        public String binning;
        public String detectorID;
        public String detectorModel;
        public String detectorManufacturer;
        public double temperature;
        public Vector<Double> voltage;
        public String cameraRef;
        public String cameraMode;
        public Double[][] positions;

        Position() {
        }

        public String getFile(int no) {
            return this.getFile(MicromanagerReader.this.getDimensionOrder(), MicromanagerReader.this.getSizeZ(), MicromanagerReader.this.getSizeC(), MicromanagerReader.this.getSizeT(), MicromanagerReader.this.getImageCount(), no);
        }

        public String getFile(String order, int z, int c, int t, int count, int no) {
            int[] zct = FormatTools.getZCTCoords(order, z, c, t, count, no);
            for (Index key : this.fileNameMap.keySet()) {
                if (key.z != zct[0] || key.c != zct[1] || key.t != zct[2]) continue;
                String file2 = this.fileNameMap.get(key);
                if (this.tiffs == null) continue;
                for (String tiff : this.tiffs) {
                    if (!tiff.endsWith(File.separator + file2)) continue;
                    return tiff;
                }
            }
            return this.fileNameMap.size() == 0 ? this.tiffs.get(no) : null;
        }
    }

    class MicromanagerHandler
    extends BaseHandler {
        MicromanagerHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("entry")) {
                String key = attributes.getValue("key");
                String value = attributes.getValue("value");
                MicromanagerReader.this.handleKeyValue(key, value);
            }
        }
    }
}

