/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.optim.OptimStatus;
import mitiv.optim.OptimTask;

public abstract class ReverseCommunicationOptimizer {
    public static final int SUCCESS = 0;
    public static final int FAILURE = -1;
    protected final VectorSpace space;
    private OptimTask task;
    private OptimStatus status;
    protected int evaluations = 0;
    protected int iterations = 0;
    protected int restarts = 0;

    protected ReverseCommunicationOptimizer(VectorSpace space) {
        if (space == null) {
            throw new IllegalArgumentException("Illegal null vector space");
        }
        this.space = space;
        this.failure(OptimStatus.ALGORITHM_NOT_STARTED);
    }

    public abstract OptimTask start();

    public abstract OptimTask restart();

    public abstract OptimTask iterate(Vector var1, double var2, Vector var4);

    public final OptimTask getTask() {
        return this.task;
    }

    public final VectorSpace getSpace() {
        return this.space;
    }

    public final int getIterations() {
        return this.iterations;
    }

    public final int getEvaluations() {
        return this.evaluations;
    }

    public final int getRestarts() {
        return this.restarts;
    }

    protected final OptimTask failure(OptimStatus status) {
        this.status = status;
        this.task = OptimTask.ERROR;
        return this.task;
    }

    protected final OptimTask warning(OptimStatus status) {
        this.status = status;
        this.task = OptimTask.WARNING;
        return this.task;
    }

    protected final OptimTask success(OptimTask task) {
        this.status = OptimStatus.SUCCESS;
        this.task = task;
        return this.task;
    }

    public final String getReason() {
        return this.status == OptimStatus.SUCCESS ? this.task.toString() : this.status.toString();
    }

    public final OptimStatus getStatus() {
        return this.status;
    }
}

