/*
 * Decompiled with CFR 0.152.
 */
package mitiv.utils;

public class FFTUtils {
    protected FFTUtils() {
    }

    public static int bestPowerOfTwo(int dim) {
        int best;
        int maxDim = 0x40000000;
        if (dim > 0x40000000) {
            throw new IllegalArgumentException("Integer overflow");
        }
        for (best = 1; best < dim; best *= 2) {
        }
        return best;
    }

    public static int bestDimension(int dim) {
        int best = 2 * dim;
        for (int n5 = 1; n5 < best; n5 *= 5) {
            for (int n3 = n5; n3 < best; n3 *= 3) {
                int n2;
                for (n2 = n3; n2 < dim; n2 *= 2) {
                }
                if (n2 == dim) {
                    return dim;
                }
                if (best <= n2) continue;
                best = n2;
            }
        }
        return best;
    }

    public static int[] generateFrequels(int dim) {
        int[] freq = new int[dim];
        FFTUtils.generateFrequels(freq);
        return freq;
    }

    public static void generateFrequels(int[] freq) {
        int i;
        int dim = freq.length;
        int cut = dim / 2;
        for (i = 0; i <= cut; ++i) {
            freq[i] = i;
        }
        for (i = cut + 1; i < dim; ++i) {
            freq[i] = i - dim;
        }
    }
}

