/*
 * Decompiled with CFR 0.152.
 */
package mitiv.jobs;

import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.cost.EdgePreservingDeconvolution;
import mitiv.optim.OptimTask;
import mitiv.utils.TiPiHook;

public class DeconvolutionJob {
    public EdgePreservingDeconvolution solver = new EdgePreservingDeconvolution();
    protected TiPiHook iterHook;
    protected TiPiHook finalHook;
    protected boolean run = true;

    public DeconvolutionJob(ShapedArray dataArray, ShapedArray psfArray, ShapedArray wgtArray, Shape outputShape, double mu, double epsilon, double[] scale, boolean positivity, boolean single, int nbIterDeconv, TiPiHook iterHook, TiPiHook finalHook) {
        this.solver.setForceSinglePrecision(single);
        this.solver.setRelativeTolerance(0.0);
        this.solver.setUseNewCode(false);
        this.solver.setObjectShape(outputShape);
        this.solver.setPSF(psfArray);
        this.solver.setData(dataArray);
        this.solver.setWeights(wgtArray);
        this.solver.setEdgeThreshold(epsilon);
        this.solver.setRegularizationLevel(mu);
        this.solver.setScale(scale);
        this.solver.setSaveBest(true);
        this.solver.setLowerBound(positivity ? 0.0 : Double.NEGATIVE_INFINITY);
        this.solver.setUpperBound(Double.POSITIVE_INFINITY);
        this.solver.setMaximumIterations(nbIterDeconv);
        this.solver.setMaximumEvaluations(2 * nbIterDeconv);
        this.iterHook = iterHook;
        this.finalHook = finalHook;
    }

    public ShapedArray deconv(ShapedArray objArray) {
        int iter = 0;
        this.run = true;
        this.solver.setInitialSolution(objArray);
        OptimTask task = this.solver.start();
        while (this.run) {
            task = this.solver.getTask();
            if (task == OptimTask.ERROR) {
                System.err.format("Error: %s\n", this.solver.getReason());
                break;
            }
            if (task == OptimTask.NEW_X || task == OptimTask.FINAL_X) {
                if (this.iterHook != null) {
                    this.iterHook.run(this, iter++);
                }
                if (task == OptimTask.FINAL_X) break;
            }
            if (task == OptimTask.WARNING) break;
            this.solver.iterate();
        }
        objArray = this.solver.getBestSolution().asShapedArray();
        this.finalHook.run(this, iter);
        return objArray;
    }

    public void abort() {
        this.run = false;
    }

    public void updatePsf(ShapedArray psfArray) {
        this.solver.setPSF(psfArray);
    }

    public boolean isRunning() {
        return this.run;
    }
}

