/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg;

import java.io.PrintStream;
import mitiv.exception.NonConformableArrayException;

public class ArrayOps {
    protected ArrayOps() {
    }

    public static void main(String[] args) {
        int n = 200;
        double[] a = new double[n];
        double[] b = new double[n];
        double[] c = new double[n];
        for (int i = 0; i < n; ++i) {
            a[i] = 3.0 * (double)i - 10.0;
            b[i] = 50.0 - 7.0 * (double)i;
            c[i] = 4.0 * (double)i - 110.0;
        }
        try {
            System.out.println("dot(a,b) = " + ArrayOps.dot(a, b));
            System.out.println("dot(a,b,c) = " + ArrayOps.dot(a, b, c));
        }
        catch (Exception e) {
            System.err.println("error: " + e);
        }
    }

    public static final int getLength(byte[] x) {
        return x == null ? 0 : x.length;
    }

    public static final int getLength(short[] x) {
        return x == null ? 0 : x.length;
    }

    public static final int getLength(int[] x) {
        return x == null ? 0 : x.length;
    }

    public static final int getLength(long[] x) {
        return x == null ? 0 : x.length;
    }

    public static final int getLength(float[] x) {
        return x == null ? 0 : x.length;
    }

    public static final int getLength(double[] x) {
        return x == null ? 0 : x.length;
    }

    public static final int getNonZeroLength(float[] x) {
        if (x == null) {
            throw new IllegalArgumentException("Illegal NULL array.");
        }
        int n = x.length;
        if (n == 0) {
            throw new IllegalArgumentException("Illegal zero-length array.");
        }
        return n;
    }

    public static final int getNonZeroLength(double[] x) {
        if (x == null) {
            throw new IllegalArgumentException("Illegal NULL array.");
        }
        int n = x.length;
        if (n == 0) {
            throw new IllegalArgumentException("Illegal zero-length array.");
        }
        return n;
    }

    public static final int getLength(float[] x, float[] y) {
        int n = ArrayOps.getLength(x);
        if (ArrayOps.getLength(y) != n) {
            throw new NonConformableArrayException(1);
        }
        return n;
    }

    public static final int getLength(double[] x, double[] y) {
        int n = ArrayOps.getLength(x);
        if (ArrayOps.getLength(y) != n) {
            throw new NonConformableArrayException(1);
        }
        return n;
    }

    public static final int getLength(float[] w, float[] x, float[] y) {
        int n = ArrayOps.getLength(w);
        if (ArrayOps.getLength(x) != n || ArrayOps.getLength(y) != n) {
            throw new NonConformableArrayException(1);
        }
        return n;
    }

    public static final int getLength(double[] w, double[] x, double[] y) {
        int n = ArrayOps.getLength(w);
        if (ArrayOps.getLength(x) != n || ArrayOps.getLength(y) != n) {
            throw new NonConformableArrayException(1);
        }
        return n;
    }

    public static final int getLength(double[] w, double[] x, double[] y, double[] z) {
        int n = ArrayOps.getLength(w);
        if (ArrayOps.getLength(x) != n || ArrayOps.getLength(y) != n || ArrayOps.getLength(z) != n) {
            throw new NonConformableArrayException(1);
        }
        return n;
    }

    public static final int getLength(float[] w, float[] x, float[] y, float[] z) {
        int n = ArrayOps.getLength(w);
        if (ArrayOps.getLength(x) != n || ArrayOps.getLength(y) != n || ArrayOps.getLength(z) != n) {
            throw new NonConformableArrayException(1);
        }
        return n;
    }

    public static final int getLength(float[][] x) {
        if (x == null) {
            throw new IllegalArgumentException("Illegal NULL array.");
        }
        int n = x.length;
        if (n == 0) {
            throw new IllegalArgumentException("Illegal zero-length array.");
        }
        return n;
    }

    public static final int getLength(double[][] x) {
        if (x == null) {
            throw new IllegalArgumentException("Illegal NULL array.");
        }
        int n = x.length;
        if (n == 0) {
            throw new IllegalArgumentException("Illegal zero-length array.");
        }
        return n;
    }

    public static final int getLength(double[][] x, double[][] y) {
        int n = ArrayOps.getLength(x);
        if (ArrayOps.getLength(y) != n) {
            throw new NonConformableArrayException(2);
        }
        return n;
    }

    public static final int getLength(double[][] w, double[][] x, double[][] y) {
        int n = ArrayOps.getLength(w);
        if (ArrayOps.getLength(x) != n || ArrayOps.getLength(y) != n) {
            throw new NonConformableArrayException(2);
        }
        return n;
    }

    public static final int getLength(float[][] x, float[][] y) {
        int n = ArrayOps.getLength(x);
        if (ArrayOps.getLength(y) != n) {
            throw new NonConformableArrayException(2);
        }
        return n;
    }

    public static final int getLength(float[][] w, float[][] x, float[][] y) {
        int n = ArrayOps.getLength(w);
        if (ArrayOps.getLength(x) != n || ArrayOps.getLength(y) != n) {
            throw new NonConformableArrayException(2);
        }
        return n;
    }

    public static final int getLength(double[][][] x) {
        if (x == null) {
            throw new IllegalArgumentException("Illegal NULL array.");
        }
        int n = x.length;
        if (n == 0) {
            throw new IllegalArgumentException("Illegal zero-length array.");
        }
        return n;
    }

    public static final int getLength(float[][][] x) {
        if (x == null) {
            throw new IllegalArgumentException("Illegal NULL array.");
        }
        int n = x.length;
        if (n == 0) {
            throw new IllegalArgumentException("Illegal zero-length array.");
        }
        return n;
    }

    public static final int getLength(double[][][] x, double[][][] y) {
        int n = ArrayOps.getLength(x);
        if (ArrayOps.getLength(y) != n) {
            throw new NonConformableArrayException(3);
        }
        return n;
    }

    public static final int getLength(float[][][] x, float[][][] y) {
        int n = ArrayOps.getLength(x);
        if (ArrayOps.getLength(y) != n) {
            throw new NonConformableArrayException(3);
        }
        return n;
    }

    public static final int getLength(double[][][] w, double[][][] x, double[][][] y) {
        int n = ArrayOps.getLength(w);
        if (ArrayOps.getLength(x) != n || ArrayOps.getLength(y) != n) {
            throw new NonConformableArrayException(3);
        }
        return n;
    }

    public static final int getLength(float[][][] w, float[][][] x, float[][][] y) {
        int n = ArrayOps.getLength(w);
        if (ArrayOps.getLength(x) != n || ArrayOps.getLength(y) != n) {
            throw new NonConformableArrayException(3);
        }
        return n;
    }

    public static final float getMin(float[] x) {
        int n = ArrayOps.getNonZeroLength(x);
        float xmin = x[0];
        for (int i = 1; i < n; ++i) {
            float xval = x[i];
            if (!(xval < xmin)) continue;
            xmin = xval;
        }
        return xmin;
    }

    public static final float getMax(float[] x) {
        int n = ArrayOps.getNonZeroLength(x);
        float xmax = x[0];
        for (int i = 1; i < n; ++i) {
            float xval = x[i];
            if (!(xval > xmax)) continue;
            xmax = xval;
        }
        return xmax;
    }

    public static final float[] getMinMax(float[] x) {
        return ArrayOps.getMinMax(x, new float[2]);
    }

    public static final float[] getMinMax(float[] x, float[] minMax) {
        if (minMax == null || minMax.length < 2) {
            throw new IllegalArgumentException("Invalid storage for min/max value.");
        }
        int n = ArrayOps.getNonZeroLength(x);
        float xmin = x[0];
        float xmax = x[0];
        for (int i = 1; i < n; ++i) {
            float xval = x[i];
            if (xval < xmin) {
                xmin = xval;
            }
            if (!(xval > xmax)) continue;
            xmax = xval;
        }
        minMax[0] = xmin;
        minMax[1] = xmax;
        return minMax;
    }

    public static final double getMin(double[] x) {
        int n = ArrayOps.getNonZeroLength(x);
        double xmin = x[0];
        for (int i = 1; i < n; ++i) {
            double xval = x[i];
            if (!(xval < xmin)) continue;
            xmin = xval;
        }
        return xmin;
    }

    public static final double getMax(double[] x) {
        int n = ArrayOps.getNonZeroLength(x);
        double xmax = x[0];
        for (int i = 1; i < n; ++i) {
            double xval = x[i];
            if (!(xval > xmax)) continue;
            xmax = xval;
        }
        return xmax;
    }

    public static final double[] getMinMax(double[] x) {
        return ArrayOps.getMinMax(x, new double[2]);
    }

    public static final double[] getMinMax(double[] x, double[] minMax) {
        if (minMax == null || minMax.length < 2) {
            throw new IllegalArgumentException("Invalid storage for min/max value.");
        }
        int n = ArrayOps.getNonZeroLength(x);
        double xmin = x[0];
        double xmax = x[0];
        for (int i = 1; i < n; ++i) {
            double xval = x[i];
            if (xval < xmin) {
                xmin = xval;
            }
            if (!(xval > xmax)) continue;
            xmax = xval;
        }
        minMax[0] = xmin;
        minMax[1] = xmax;
        return minMax;
    }

    public static final float sum(float[] x) {
        float s = 0.0f;
        int n = ArrayOps.getLength(x);
        for (int i = 1; i < n; ++i) {
            s += x[i];
        }
        return s;
    }

    public static final float sum(float[][] x) {
        float s = 0.0f;
        int n = ArrayOps.getLength(x);
        for (int i = 1; i < n; ++i) {
            s += ArrayOps.sum(x[i]);
        }
        return s;
    }

    public static final float sum(float[][][] x) {
        float s = 0.0f;
        int n = ArrayOps.getLength(x);
        for (int i = 1; i < n; ++i) {
            s += ArrayOps.sum(x[i]);
        }
        return s;
    }

    public static final double sum(double[] x) {
        double s = 0.0;
        int n = ArrayOps.getLength(x);
        for (int i = 1; i < n; ++i) {
            s += x[i];
        }
        return s;
    }

    public static final double sum(double[][] x) {
        double s = 0.0;
        int n = ArrayOps.getLength(x);
        for (int i = 1; i < n; ++i) {
            s += ArrayOps.sum(x[i]);
        }
        return s;
    }

    public static final double sum(double[][][] x) {
        double s = 0.0;
        int n = ArrayOps.getLength(x);
        for (int i = 1; i < n; ++i) {
            s += ArrayOps.sum(x[i]);
        }
        return s;
    }

    public static final double dot(int n, double[] x, double[] y) {
        double result = 0.0;
        for (int i = 0; i < n; ++i) {
            result += x[i] * y[i];
        }
        return result;
    }

    public static final double dot(int n, float[] x, float[] y) {
        float result = 0.0f;
        for (int i = 0; i < n; ++i) {
            result += x[i] * y[i];
        }
        return result;
    }

    public static final double dot(int n, double[] w, double[] x, double[] y) {
        double result = 0.0;
        for (int i = 0; i < n; ++i) {
            result += w[i] * x[i] * y[i];
        }
        return result;
    }

    public static final double dot(int n, float[] w, float[] x, float[] y) {
        float result = 0.0f;
        for (int i = 0; i < n; ++i) {
            result += w[i] * x[i] * y[i];
        }
        return result;
    }

    public static final double dot(double[] x, double[] y) {
        return ArrayOps.dot(ArrayOps.getLength(x, y), x, y);
    }

    public static final double dot(float[] x, float[] y) {
        return ArrayOps.dot(ArrayOps.getLength(x, y), x, y);
    }

    public static final double dot(double[] w, double[] x, double[] y) {
        return ArrayOps.dot(ArrayOps.getLength(w, x, y), w, x, y);
    }

    public static final double dot(float[] w, float[] x, float[] y) {
        return ArrayOps.dot(ArrayOps.getLength(w, x, y), w, x, y);
    }

    public static final double dot(double[][] x, double[][] y) {
        double s = 0.0;
        int n = ArrayOps.getLength(x, y);
        for (int i = 0; i < n; ++i) {
            s += ArrayOps.dot(x[i], y[i]);
        }
        return s;
    }

    public static final double dot(float[][] x, float[][] y) {
        double s = 0.0;
        int n = ArrayOps.getLength(x, y);
        for (int i = 0; i < n; ++i) {
            s += ArrayOps.dot(x[i], y[i]);
        }
        return s;
    }

    public static final double dot(double[][] w, double[][] x, double[][] y) {
        double s = 0.0;
        int n = ArrayOps.getLength(w, x, y);
        for (int i = 0; i < n; ++i) {
            s += ArrayOps.dot(w[i], x[i], y[i]);
        }
        return s;
    }

    public static final double dot(float[][] w, float[][] x, float[][] y) {
        double s = 0.0;
        int n = ArrayOps.getLength(w, x, y);
        for (int i = 0; i < n; ++i) {
            s += ArrayOps.dot(w[i], x[i], y[i]);
        }
        return s;
    }

    public static final double dot(double[][][] x, double[][][] y) {
        double s = 0.0;
        int n = ArrayOps.getLength(x, y);
        for (int i = 0; i < n; ++i) {
            s += ArrayOps.dot(x[i], y[i]);
        }
        return s;
    }

    public static final double dot(float[][][] x, float[][][] y) {
        double s = 0.0;
        int n = ArrayOps.getLength(x, y);
        for (int i = 0; i < n; ++i) {
            s += ArrayOps.dot(x[i], y[i]);
        }
        return s;
    }

    public static final double dot(double[][][] w, double[][][] x, double[][][] y) {
        double s = 0.0;
        int n = ArrayOps.getLength(w, x, y);
        for (int i = 0; i < n; ++i) {
            s += ArrayOps.dot(w[i], x[i], y[i]);
        }
        return s;
    }

    public static final double dot(float[][][] w, float[][][] x, float[][][] y) {
        double s = 0.0;
        int n = ArrayOps.getLength(w, x, y);
        for (int i = 0; i < n; ++i) {
            s += ArrayOps.dot(w[i], x[i], y[i]);
        }
        return s;
    }

    public static double norm2(double[] x) {
        double s = 0.0;
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            s += x[i] * x[i];
        }
        return Math.sqrt(s);
    }

    public static double norm1(double[] x) {
        double s = 0.0;
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            s += Math.abs(x[i]);
        }
        return s;
    }

    public static double normInf(double[] x) {
        double s = 0.0;
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            double r = Math.abs(x[i]);
            if (!(r > s)) continue;
            s = r;
        }
        return s;
    }

    public static float norm2(float[] x) {
        float s = 0.0f;
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            s += x[i] * x[i];
        }
        return (float)Math.sqrt(s);
    }

    public static double norm1(float[] x) {
        float s = 0.0f;
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            s += Math.abs(x[i]);
        }
        return s;
    }

    public static float normInf(float[] x) {
        float s = 0.0f;
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            float r = Math.abs(x[i]);
            if (!(r > s)) continue;
            s = r;
        }
        return s;
    }

    public static void zero(double[] x, int n) {
        ArrayOps.fill(x, n, 0.0);
    }

    public static void zero(float[] x, int n) {
        ArrayOps.fill(x, n, 0.0);
    }

    public static void zero(double[] x) {
        ArrayOps.zero(x, x.length);
    }

    public static void zero(float[] x) {
        ArrayOps.zero(x, x.length);
    }

    public static void zero(double[][] x) {
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            ArrayOps.zero(x[i]);
        }
    }

    public static void zero(float[][] x) {
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            ArrayOps.zero(x[i]);
        }
    }

    public static void zero(double[][][] x) {
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            ArrayOps.zero(x[i]);
        }
    }

    public static void zero(float[][][] x) {
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            ArrayOps.zero(x[i]);
        }
    }

    public static void copy(double[] dst, int n, double[] src) {
        System.arraycopy(src, 0, dst, 0, n);
    }

    public static void copy(float[] dst, int n, float[] src) {
        System.arraycopy(src, 0, dst, 0, n);
    }

    public static void copy(double[] dst, double[] src) {
        ArrayOps.copy(dst, ArrayOps.getLength(src, dst), src);
    }

    public static void copy(float[] dst, float[] src) {
        ArrayOps.copy(dst, ArrayOps.getLength(src, dst), src);
    }

    public static void copy(double[][] dst, double[][] src) {
        int n = ArrayOps.getLength(src, dst);
        for (int i = 0; i < n; ++i) {
            ArrayOps.copy(dst[i], src[i]);
        }
    }

    public static void copy(float[][] dst, float[][] src) {
        int n = ArrayOps.getLength(src, dst);
        for (int i = 0; i < n; ++i) {
            ArrayOps.copy(dst[i], src[i]);
        }
    }

    public static void fill(double[] x, int n, double alpha) {
        for (int i = 0; i < n; ++i) {
            x[i] = alpha;
        }
    }

    public static void fill(float[] x, int n, double alpha) {
        float a = (float)alpha;
        for (int i = 0; i < n; ++i) {
            x[i] = a;
        }
    }

    public static void combine(int n, double alpha, double[] x, double beta, double[] y) {
        block37: {
            block35: {
                block38: {
                    block36: {
                        if (beta != 1.0) break block35;
                        if (alpha != 1.0) break block36;
                        for (int i = 0; i < n; ++i) {
                            int n2 = i;
                            y[n2] = y[n2] + x[i];
                        }
                        break block37;
                    }
                    if (alpha != -1.0) break block38;
                    for (int i = 0; i < n; ++i) {
                        int n3 = i;
                        y[n3] = y[n3] - x[i];
                    }
                    break block37;
                }
                if (alpha == 0.0) break block37;
                for (int i = 0; i < n; ++i) {
                    int n4 = i;
                    y[n4] = y[n4] + alpha * x[i];
                }
                break block37;
            }
            if (beta == 0.0) {
                if (alpha == 1.0) {
                    ArrayOps.copy(y, n, x);
                } else if (alpha == 0.0) {
                    ArrayOps.zero(y, n);
                } else if (alpha == -1.0) {
                    for (int i = 0; i < n; ++i) {
                        y[i] = -x[i];
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        y[i] = alpha * x[i];
                    }
                }
            } else if (beta == -1.0) {
                if (alpha == 1.0) {
                    for (int i = 0; i < n; ++i) {
                        y[i] = x[i] - y[i];
                    }
                } else if (alpha == 0.0) {
                    for (int i = 0; i < n; ++i) {
                        y[i] = -y[i];
                    }
                } else if (alpha == -1.0) {
                    for (int i = 0; i < n; ++i) {
                        y[i] = -x[i] - y[i];
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        y[i] = alpha * x[i] - y[i];
                    }
                }
            } else if (alpha == 1.0) {
                for (int i = 0; i < n; ++i) {
                    y[i] = x[i] + beta * y[i];
                }
            } else if (alpha == -1.0) {
                for (int i = 0; i < n; ++i) {
                    y[i] = beta * y[i] - x[i];
                }
            } else if (alpha == 0.0) {
                int i = 0;
                while (i < n) {
                    int n5 = i++;
                    y[n5] = y[n5] * beta;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    y[i] = alpha * x[i] + beta * y[i];
                }
            }
        }
    }

    public static void combine(double[] dst, int n, double alpha, double[] x, double beta, double[] y) {
        if (beta == 1.0) {
            if (alpha == 1.0) {
                for (int i = 0; i < n; ++i) {
                    dst[i] = y[i] + x[i];
                }
            } else if (alpha == -1.0) {
                for (int i = 0; i < n; ++i) {
                    dst[i] = y[i] - x[i];
                }
            } else if (alpha == 0.0) {
                for (int i = 0; i < n; ++i) {
                    ArrayOps.copy(dst, n, y);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    dst[i] = alpha * x[i] + y[i];
                }
            }
        } else if (beta == -1.0) {
            if (alpha == 1.0) {
                for (int i = 0; i < n; ++i) {
                    dst[i] = x[i] - y[i];
                }
            } else if (alpha == -1.0) {
                for (int i = 0; i < n; ++i) {
                    dst[i] = -x[i] - y[i];
                }
            } else if (alpha == 0.0) {
                for (int i = 0; i < n; ++i) {
                    dst[i] = -y[i];
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    dst[i] = alpha * x[i] - y[i];
                }
            }
        } else if (beta == 0.0) {
            if (alpha == 1.0) {
                ArrayOps.copy(dst, n, x);
            } else if (alpha == -1.0) {
                for (int i = 0; i < n; ++i) {
                    dst[i] = -x[i];
                }
            } else if (alpha == 0.0) {
                ArrayOps.zero(dst, n);
            } else {
                for (int i = 0; i < n; ++i) {
                    dst[i] = alpha * x[i];
                }
            }
        } else if (alpha == 1.0) {
            for (int i = 0; i < n; ++i) {
                dst[i] = x[i] + beta * y[i];
            }
        } else if (alpha == -1.0) {
            for (int i = 0; i < n; ++i) {
                dst[i] = beta * y[i] - x[i];
            }
        } else if (alpha == 0.0) {
            for (int i = 0; i < n; ++i) {
                dst[i] = beta * y[i];
            }
        } else {
            for (int i = 0; i < n; ++i) {
                dst[i] = alpha * x[i] + beta * y[i];
            }
        }
    }

    public static void combine(double alpha, double[] x, double beta, double[] y) {
        ArrayOps.combine(ArrayOps.getLength(x, y), alpha, x, beta, y);
    }

    public static void combine(double[] dst, double alpha, double[] x, double beta, double[] y) {
        ArrayOps.combine(dst, ArrayOps.getLength(dst, x, y), alpha, x, beta, y);
    }

    public static void combine(int n, double alpha, float[] x, double beta, float[] y) {
        block37: {
            block35: {
                block38: {
                    block36: {
                        if (beta != 1.0) break block35;
                        if (alpha != 1.0) break block36;
                        for (int i = 0; i < n; ++i) {
                            int n2 = i;
                            y[n2] = y[n2] + x[i];
                        }
                        break block37;
                    }
                    if (alpha != -1.0) break block38;
                    for (int i = 0; i < n; ++i) {
                        int n3 = i;
                        y[n3] = y[n3] - x[i];
                    }
                    break block37;
                }
                if (alpha == 0.0) break block37;
                float a = (float)alpha;
                for (int i = 0; i < n; ++i) {
                    int n4 = i;
                    y[n4] = y[n4] + a * x[i];
                }
                break block37;
            }
            if (beta == 0.0) {
                if (alpha == 1.0) {
                    ArrayOps.copy(y, n, x);
                } else if (alpha == 0.0) {
                    ArrayOps.zero(y, n);
                } else if (alpha == -1.0) {
                    for (int i = 0; i < n; ++i) {
                        y[i] = -x[i];
                    }
                } else {
                    float a = (float)alpha;
                    for (int i = 0; i < n; ++i) {
                        y[i] = a * x[i];
                    }
                }
            } else if (beta == -1.0) {
                if (alpha == 1.0) {
                    for (int i = 0; i < n; ++i) {
                        y[i] = x[i] - y[i];
                    }
                } else if (alpha == 0.0) {
                    for (int i = 0; i < n; ++i) {
                        y[i] = -y[i];
                    }
                } else if (alpha == -1.0) {
                    for (int i = 0; i < n; ++i) {
                        y[i] = -x[i] - y[i];
                    }
                } else {
                    float a = (float)alpha;
                    for (int i = 0; i < n; ++i) {
                        y[i] = a * x[i] - y[i];
                    }
                }
            } else {
                float b = (float)beta;
                if (alpha == 1.0) {
                    for (int i = 0; i < n; ++i) {
                        y[i] = x[i] + b * y[i];
                    }
                } else if (alpha == -1.0) {
                    for (int i = 0; i < n; ++i) {
                        y[i] = b * y[i] - x[i];
                    }
                } else if (alpha == 0.0) {
                    int i = 0;
                    while (i < n) {
                        int n5 = i++;
                        y[n5] = y[n5] * b;
                    }
                } else {
                    float a = (float)alpha;
                    for (int i = 0; i < n; ++i) {
                        y[i] = a * x[i] + b * y[i];
                    }
                }
            }
        }
    }

    public static void combine(float[] dst, int n, double alpha, float[] x, double beta, float[] y) {
        if (beta == 1.0) {
            if (alpha == 1.0) {
                for (int i = 0; i < n; ++i) {
                    dst[i] = y[i] + x[i];
                }
            } else if (alpha == -1.0) {
                for (int i = 0; i < n; ++i) {
                    dst[i] = y[i] - x[i];
                }
            } else if (alpha == 0.0) {
                for (int i = 0; i < n; ++i) {
                    ArrayOps.copy(dst, n, y);
                }
            } else {
                float a = (float)alpha;
                for (int i = 0; i < n; ++i) {
                    dst[i] = a * x[i] + y[i];
                }
            }
        } else if (beta == -1.0) {
            if (alpha == 1.0) {
                for (int i = 0; i < n; ++i) {
                    dst[i] = x[i] - y[i];
                }
            } else if (alpha == -1.0) {
                for (int i = 0; i < n; ++i) {
                    dst[i] = -x[i] - y[i];
                }
            } else if (alpha == 0.0) {
                for (int i = 0; i < n; ++i) {
                    dst[i] = -y[i];
                }
            } else {
                float a = (float)alpha;
                for (int i = 0; i < n; ++i) {
                    dst[i] = a * x[i] - y[i];
                }
            }
        } else if (beta == 0.0) {
            if (alpha == 1.0) {
                ArrayOps.copy(dst, n, x);
            } else if (alpha == -1.0) {
                for (int i = 0; i < n; ++i) {
                    dst[i] = -x[i];
                }
            } else if (alpha == 0.0) {
                ArrayOps.zero(dst, n);
            } else {
                float a = (float)alpha;
                for (int i = 0; i < n; ++i) {
                    dst[i] = a * x[i];
                }
            }
        } else {
            float b = (float)beta;
            if (alpha == 1.0) {
                for (int i = 0; i < n; ++i) {
                    dst[i] = x[i] + b * y[i];
                }
            } else if (alpha == -1.0) {
                for (int i = 0; i < n; ++i) {
                    dst[i] = b * y[i] - x[i];
                }
            } else if (alpha == 0.0) {
                for (int i = 0; i < n; ++i) {
                    dst[i] = b * y[i];
                }
            } else {
                float a = (float)alpha;
                for (int i = 0; i < n; ++i) {
                    dst[i] = a * x[i] + b * y[i];
                }
            }
        }
    }

    public static void combine(double alpha, float[] x, double beta, float[] y) {
        ArrayOps.combine(ArrayOps.getLength(x, y), alpha, x, beta, y);
    }

    public static void combine(float[] dst, double alpha, float[] x, double beta, float[] y) {
        ArrayOps.combine(dst, ArrayOps.getLength(dst, x, y), alpha, x, beta, y);
    }

    public static void combine(double[] dst, int n, double alpha, double[] x, double beta, double[] y, double gamma, double[] z) {
        if (alpha == 0.0) {
            ArrayOps.combine(dst, beta, y, gamma, z);
        } else if (beta == 0.0) {
            ArrayOps.combine(dst, alpha, x, gamma, z);
        } else if (gamma == 0.0) {
            ArrayOps.combine(dst, alpha, x, beta, y);
        } else {
            for (int i = 0; i < n; ++i) {
                dst[i] = alpha * x[i] + beta * y[i] + gamma * z[i];
            }
        }
    }

    public static void combine(double[] dst, double alpha, double[] x, double beta, double[] y, double gamma, double[] z) {
        ArrayOps.combine(dst, ArrayOps.getLength(dst, x, y, z), alpha, x, beta, y, gamma, z);
    }

    public static void combine(float[] dst, int n, double alpha, float[] x, double beta, float[] y, double gamma, float[] z) {
        if (alpha == 0.0) {
            ArrayOps.combine(dst, beta, y, gamma, z);
        } else if (beta == 0.0) {
            ArrayOps.combine(dst, alpha, x, gamma, z);
        } else if (gamma == 0.0) {
            ArrayOps.combine(dst, alpha, x, beta, y);
        } else {
            float a = (float)alpha;
            float b = (float)beta;
            float c = (float)gamma;
            for (int i = 0; i < n; ++i) {
                dst[i] = a * x[i] + b * y[i] + c * z[i];
            }
        }
    }

    public static void combine(float[] dst, float alpha, float[] x, float beta, float[] y, float gamma, float[] z) {
        ArrayOps.combine(dst, ArrayOps.getLength(dst, x, y, z), (double)alpha, x, (double)beta, y, (double)gamma, z);
    }

    public static double dot(Object x, Object y) {
        return 0.0;
    }

    public static double dot(Object w, Object x, Object y) {
        return 0.0;
    }

    public static void printArray(Object obj) {
        ArrayOps.printArray(obj, System.out, true);
    }

    public static void printArray(Object obj, boolean newline) {
        ArrayOps.printArray(obj, System.out, newline);
    }

    public static void printArray(Object obj, PrintStream stream) {
        ArrayOps.printArray(obj, stream, true);
    }

    public static void printArray(Object obj, PrintStream stream, boolean newline) {
        if (obj == null) {
            stream.print("null");
        } else {
            String classname = obj.getClass().getName();
            char c0 = classname.charAt(0);
            if (c0 == '[') {
                char c1 = classname.charAt(1);
                if (c1 == 'B') {
                    byte[] arr = (byte[])obj;
                    for (int i = 0; i < arr.length; ++i) {
                        stream.print((i == 0 ? "{" : ", ") + arr[i]);
                    }
                    stream.print("}");
                } else if (c1 == 'S') {
                    short[] arr = (short[])obj;
                    for (int i = 0; i < arr.length; ++i) {
                        stream.print((i == 0 ? "{" : ", ") + arr[i]);
                    }
                    stream.print("}");
                } else if (c1 == 'I') {
                    int[] arr = (int[])obj;
                    for (int i = 0; i < arr.length; ++i) {
                        stream.print((i == 0 ? "{" : ", ") + arr[i]);
                    }
                    stream.print("}");
                } else if (c1 == 'J') {
                    long[] arr = (long[])obj;
                    for (int i = 0; i < arr.length; ++i) {
                        stream.print((i == 0 ? "{" : ", ") + arr[i]);
                    }
                    stream.print("}");
                } else if (c1 == 'F') {
                    float[] arr = (float[])obj;
                    for (int i = 0; i < arr.length; ++i) {
                        stream.print((i == 0 ? "{" : ", ") + arr[i]);
                    }
                    stream.print("}");
                } else if (c1 == 'D') {
                    double[] arr = (double[])obj;
                    for (int i = 0; i < arr.length; ++i) {
                        stream.print((i == 0 ? "{" : ", ") + arr[i]);
                    }
                    stream.print("}");
                } else if (c1 == 'C') {
                    char[] arr = (char[])obj;
                    for (int i = 0; i < arr.length; ++i) {
                        stream.print((i == 0 ? "{" : ", ") + arr[i]);
                    }
                    stream.print("}");
                } else if (c1 == 'Z') {
                    boolean[] arr = (boolean[])obj;
                    for (int i = 0; i < arr.length; ++i) {
                        stream.print((i == 0 ? "{" : ", ") + arr[i]);
                    }
                    stream.print("}");
                } else if (c1 == 'L') {
                    stream.print(classname.substring(2));
                } else if (c1 == '[') {
                    Object[] arr = (Object[])obj;
                    stream.print("{");
                    for (int i = 0; i < arr.length; ++i) {
                        if (i > 0) {
                            stream.print(", ");
                        }
                        ArrayOps.printArray(arr[i], stream, false);
                    }
                    stream.print("}");
                } else {
                    stream.print("{*unknown*}");
                }
            }
        }
        if (newline) {
            stream.println();
        }
    }
}

