/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.util;

import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.util.Filter;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

public class CLDeviceFilters {
    public static Filter<CLDevice> type(final CLDevice.Type ... typeArray) {
        return new Filter<CLDevice>(){
            private final EnumSet<CLDevice.Type> set;
            {
                this.set = EnumSet.copyOf(Arrays.asList(typeArray));
            }

            @Override
            public boolean accept(CLDevice cLDevice) {
                if (this.set.contains((Object)CLDevice.Type.ALL)) {
                    return true;
                }
                return this.set.contains((Object)cLDevice.getType());
            }
        };
    }

    public static Filter<CLDevice> byteOrder(final ByteOrder byteOrder) {
        return new Filter<CLDevice>(){

            @Override
            public boolean accept(CLDevice cLDevice) {
                return cLDevice.getByteOrder().equals(byteOrder);
            }
        };
    }

    public static Filter<CLDevice> glSharing() {
        return new Filter<CLDevice>(){

            @Override
            public boolean accept(CLDevice cLDevice) {
                return cLDevice.isGLMemorySharingSupported();
            }
        };
    }

    public static Filter<CLDevice> extension(final String ... stringArray) {
        return new Filter<CLDevice>(){
            private final List<String> extensionList;
            {
                this.extensionList = Arrays.asList(stringArray);
            }

            @Override
            public boolean accept(CLDevice cLDevice) {
                return cLDevice.getExtensions().containsAll(this.extensionList);
            }
        };
    }

    public static Filter<CLDevice> queueMode(final CLCommandQueue.Mode ... modeArray) {
        return new Filter<CLDevice>(){
            private final List<CLCommandQueue.Mode> modeList;
            {
                this.modeList = Arrays.asList(modeArray);
            }

            @Override
            public boolean accept(CLDevice cLDevice) {
                return cLDevice.getQueueProperties().containsAll(this.modeList);
            }
        };
    }
}

