/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.map.tdouble.AbstractLongDoubleMap;
import cern.colt.map.tdouble.OpenLongDoubleHashMap;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.SelectedSparseDoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;

public class SparseDoubleMatrix3D
extends DoubleMatrix3D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongDoubleMap elements;

    public SparseDoubleMatrix3D(double[][][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length, values.length == 0 ? 0 : (values[0].length == 0 ? 0 : values[0][0].length));
        this.assign(values);
    }

    public SparseDoubleMatrix3D(int slices, int rows, int columns) {
        this(slices, rows, columns, slices * rows * (columns / 1000), 0.2, 0.5);
    }

    public SparseDoubleMatrix3D(int slices, int rows, int columns, int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        block2: {
            try {
                this.setUp(slices, rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = new OpenLongDoubleHashMap(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    protected SparseDoubleMatrix3D(int slices, int rows, int columns, AbstractLongDoubleMap elements, int sliceZero, int rowZero, int columnZero, int sliceStride, int rowStride, int columnStride) {
        block2: {
            try {
                this.setUp(slices, rows, columns, sliceZero, rowZero, columnZero, sliceStride, rowStride, columnStride);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = elements;
        this.isNoView = false;
    }

    @Override
    public DoubleMatrix3D assign(double value) {
        if (this.isNoView && value == 0.0) {
            this.elements.clear();
        } else {
            super.assign(value);
        }
        return this;
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    @Override
    public AbstractLongDoubleMap elements() {
        return this.elements;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.elements.ensureCapacity(minCapacity);
    }

    @Override
    public synchronized double getQuick(int slice, int row, int column) {
        return this.elements.get((long)this.sliceZero + (long)slice * (long)this.sliceStride + (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride);
    }

    @Override
    public long index(int slice, int row, int column) {
        return (long)this.sliceZero + (long)slice * (long)this.sliceStride + (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride;
    }

    @Override
    public DoubleMatrix3D like(int slices, int rows, int columns) {
        return new SparseDoubleMatrix3D(slices, rows, columns);
    }

    @Override
    public DoubleMatrix2D like2D(int rows, int columns) {
        return new SparseDoubleMatrix2D(rows, columns);
    }

    @Override
    public synchronized void setQuick(int slice, int row, int column, double value) {
        long index = (long)this.sliceZero + (long)slice * (long)this.sliceStride + (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride;
        if (value == 0.0) {
            this.elements.removeKey(index);
        } else {
            this.elements.put(index, value);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.slices).append(" x ").append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        int s = 0;
        while (s < this.slices) {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    double elem = this.getQuick(s, r, c);
                    if (elem != 0.0) {
                        builder.append('(').append(s).append(',').append(r).append(',').append(c).append(')').append('\t').append(elem).append('\n');
                    }
                    ++c;
                }
                ++r;
            }
            ++s;
        }
        return builder.toString();
    }

    @Override
    public void trimToSize() {
        this.elements.trimToSize();
    }

    @Override
    public DoubleMatrix1D vectorize() {
        SparseDoubleMatrix1D v = new SparseDoubleMatrix1D((int)this.size());
        int length = this.rows * this.columns;
        int s = 0;
        while (s < this.slices) {
            v.viewPart(s * length, length).assign(this.viewSlice(s).vectorize());
            ++s;
        }
        return v;
    }

    @Override
    protected boolean haveSharedCellsRaw(DoubleMatrix3D other) {
        if (other instanceof SelectedSparseDoubleMatrix3D) {
            SelectedSparseDoubleMatrix3D otherMatrix = (SelectedSparseDoubleMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseDoubleMatrix3D) {
            SparseDoubleMatrix3D otherMatrix = (SparseDoubleMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected DoubleMatrix2D like2D(int rows, int columns, int rowZero, int columnZero, int rowStride, int columnStride) {
        return new SparseDoubleMatrix2D(rows, columns, this.elements, rowZero, columnZero, rowStride, columnStride);
    }

    @Override
    protected DoubleMatrix3D viewSelectionLike(int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets) {
        return new SelectedSparseDoubleMatrix3D(this.elements, sliceOffsets, rowOffsets, columnOffsets, 0);
    }
}

