/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tint.IntFunction;
import cern.colt.function.tint.IntIntFunction;
import cern.colt.function.tint.IntProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.DenseIntMatrix2D;
import cern.colt.matrix.tint.impl.SelectedDenseIntMatrix3D;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseIntMatrix3D
extends IntMatrix3D {
    private static final long serialVersionUID = 1L;
    protected int[] elements;

    public DenseIntMatrix3D(int[][][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length, values.length == 0 ? 0 : (values[0].length == 0 ? 0 : values[0][0].length));
        this.assign(values);
    }

    public DenseIntMatrix3D(int slices, int rows, int columns) {
        this.setUp(slices, rows, columns);
        this.elements = new int[slices * rows * columns];
    }

    public DenseIntMatrix3D(int slices, int rows, int columns, int[] elements, int sliceZero, int rowZero, int columnZero, int sliceStride, int rowStride, int columnStride, boolean isView) {
        this.setUp(slices, rows, columns, sliceZero, rowZero, columnZero, sliceStride, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = !isView;
    }

    @Override
    public int aggregate(final IntIntFunction aggr, final IntFunction f) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        int a = 0;
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int a = f.apply(DenseIntMatrix3D.this.elements[zero + firstSlice * DenseIntMatrix3D.this.sliceStride]);
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseIntMatrix3D.this.rows) {
                                int c = d;
                                while (c < DenseIntMatrix3D.this.columns) {
                                    a = aggr.apply(a, f.apply(DenseIntMatrix3D.this.elements[zero + s * DenseIntMatrix3D.this.sliceStride + r * DenseIntMatrix3D.this.rowStride + c * DenseIntMatrix3D.this.columnStride]));
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero]);
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        a = aggr.apply(a, f.apply(this.elements[zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride]));
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return a;
    }

    @Override
    public int aggregate(final IntIntFunction aggr, final IntFunction f, final IntProcedure cond) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        int a = 0;
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int elem = DenseIntMatrix3D.this.elements[zero + firstSlice * DenseIntMatrix3D.this.sliceStride];
                        int a = 0;
                        if (cond.apply(elem)) {
                            a = aggr.apply(a, f.apply(elem));
                        }
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseIntMatrix3D.this.rows) {
                                int c = d;
                                while (c < DenseIntMatrix3D.this.columns) {
                                    elem = DenseIntMatrix3D.this.elements[zero + s * DenseIntMatrix3D.this.sliceStride + r * DenseIntMatrix3D.this.rowStride + c * DenseIntMatrix3D.this.columnStride];
                                    if (cond.apply(elem)) {
                                        a = aggr.apply(a, f.apply(elem));
                                    }
                                    d = 0;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int elem = this.elements[zero];
            if (cond.apply(elem)) {
                a = aggr.apply(a, f.apply(elem));
            }
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        elem = this.elements[zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride];
                        if (cond.apply(elem)) {
                            a = aggr.apply(a, f.apply(elem));
                        }
                        d = 0;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return a;
    }

    @Override
    public int aggregate(final IntIntFunction aggr, final IntFunction f, IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        if (sliceList.size() == 0 || rowList.size() == 0 || columnList.size() == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        int size = sliceList.size();
        final int[] sliceElements = sliceList.elements();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        final int zero = (int)this.index(0, 0, 0);
        int a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int a = f.apply(DenseIntMatrix3D.this.elements[zero + sliceElements[firstIdx] * DenseIntMatrix3D.this.sliceStride + rowElements[firstIdx] * DenseIntMatrix3D.this.rowStride + columnElements[firstIdx] * DenseIntMatrix3D.this.columnStride]);
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            int elem = DenseIntMatrix3D.this.elements[zero + sliceElements[i] * DenseIntMatrix3D.this.sliceStride + rowElements[i] * DenseIntMatrix3D.this.rowStride + columnElements[i] * DenseIntMatrix3D.this.columnStride];
                            a = aggr.apply(a, f.apply(elem));
                            ++i;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero + sliceElements[0] * this.sliceStride + rowElements[0] * this.rowStride + columnElements[0] * this.columnStride]);
            int i = 1;
            while (i < size) {
                int elem = this.elements[zero + sliceElements[i] * this.sliceStride + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride];
                a = aggr.apply(a, f.apply(elem));
                ++i;
            }
        }
        return a;
    }

    @Override
    public int aggregate(IntMatrix3D other, final IntIntFunction aggr, final IntIntFunction f) {
        if (!(other instanceof DenseIntMatrix3D)) {
            return super.aggregate(other, aggr, f);
        }
        this.checkShape(other);
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        int a = 0;
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)other.index(0, 0, 0);
        final int sliceStrideOther = other.sliceStride();
        final int rowStrideOther = other.rowStride();
        final int colStrideOther = other.columnStride();
        final int[] elemsOther = (int[])other.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int idx = zero + firstSlice * DenseIntMatrix3D.this.sliceStride;
                        int idxOther = zeroOther + firstSlice * sliceStrideOther;
                        int a = f.apply(DenseIntMatrix3D.this.elements[idx], elemsOther[idxOther]);
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseIntMatrix3D.this.rows) {
                                int c = d;
                                while (c < DenseIntMatrix3D.this.columns) {
                                    idx = zero + s * DenseIntMatrix3D.this.sliceStride + r * DenseIntMatrix3D.this.rowStride + c * DenseIntMatrix3D.this.columnStride;
                                    idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther + c * colStrideOther;
                                    a = aggr.apply(a, f.apply(DenseIntMatrix3D.this.elements[idx], elemsOther[idxOther]));
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0, 0), other.getQuick(0, 0, 0));
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride;
                        int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther + c * colStrideOther;
                        a = aggr.apply(a, f.apply(this.elements[idx], elemsOther[idxOther]));
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return a;
    }

    @Override
    public IntMatrix3D assign(final IntFunction function) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseIntMatrix3D.this.rows) {
                                int idx = zero + s * DenseIntMatrix3D.this.sliceStride + r * DenseIntMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseIntMatrix3D.this.columns) {
                                    DenseIntMatrix3D.this.elements[idx] = function.apply(DenseIntMatrix3D.this.elements[idx]);
                                    idx += DenseIntMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        this.elements[idx] = function.apply(this.elements[idx]);
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public IntMatrix3D assign(final int value) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseIntMatrix3D.this.rows) {
                                int idx = zero + s * DenseIntMatrix3D.this.sliceStride + r * DenseIntMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseIntMatrix3D.this.columns) {
                                    DenseIntMatrix3D.this.elements[idx] = value;
                                    idx += DenseIntMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        this.elements[idx] = value;
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public IntMatrix3D assign(final int[] values) {
        if ((long)values.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "slices()*rows()*columns()=" + this.slices() * this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else {
            final int zero = (int)this.index(0, 0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                nthreads = Math.min(nthreads, this.slices);
                Future[] futures = new Future[nthreads];
                int k = this.slices / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstSlice = j * k;
                    final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idxOther = firstSlice * DenseIntMatrix3D.this.rows * DenseIntMatrix3D.this.columns;
                            int s = firstSlice;
                            while (s < lastSlice) {
                                int r = 0;
                                while (r < DenseIntMatrix3D.this.rows) {
                                    int idx = zero + s * DenseIntMatrix3D.this.sliceStride + r * DenseIntMatrix3D.this.rowStride;
                                    int c = 0;
                                    while (c < DenseIntMatrix3D.this.columns) {
                                        DenseIntMatrix3D.this.elements[idx] = values[idxOther++];
                                        idx += DenseIntMatrix3D.this.columnStride;
                                        ++c;
                                    }
                                    ++r;
                                }
                                ++s;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idxOther = 0;
                int s = 0;
                while (s < this.slices) {
                    int r = 0;
                    while (r < this.rows) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        int c = 0;
                        while (c < this.columns) {
                            this.elements[idx] = values[idxOther++];
                            idx += this.columnStride;
                            ++c;
                        }
                        ++r;
                    }
                    ++s;
                }
            }
        }
        return this;
    }

    @Override
    public IntMatrix3D assign(final int[][][] values) {
        if (values.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + values.length + "slices()=" + this.slices());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                nthreads = Math.min(nthreads, this.slices);
                Future[] futures = new Future[nthreads];
                int k = this.slices / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstSlice = j * k;
                    final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int i = firstSlice * DenseIntMatrix3D.this.sliceStride;
                            int s = firstSlice;
                            while (s < lastSlice) {
                                int[][] currentSlice = values[s];
                                if (currentSlice.length != DenseIntMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + DenseIntMatrix3D.this.rows());
                                }
                                int r = 0;
                                while (r < DenseIntMatrix3D.this.rows) {
                                    int[] currentRow = currentSlice[r];
                                    if (currentRow.length != DenseIntMatrix3D.this.columns) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + DenseIntMatrix3D.this.columns());
                                    }
                                    System.arraycopy(currentRow, 0, DenseIntMatrix3D.this.elements, i, DenseIntMatrix3D.this.columns);
                                    i += DenseIntMatrix3D.this.columns;
                                    ++r;
                                }
                                ++s;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int i = 0;
                int s = 0;
                while (s < this.slices) {
                    int[][] currentSlice = values[s];
                    if (currentSlice.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + this.rows());
                    }
                    int r = 0;
                    while (r < this.rows) {
                        int[] currentRow = currentSlice[r];
                        if (currentRow.length != this.columns) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                        }
                        System.arraycopy(currentRow, 0, this.elements, i, this.columns);
                        i += this.columns;
                        ++r;
                    }
                    ++s;
                }
            }
        } else {
            final int zero = (int)this.index(0, 0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                nthreads = Math.min(nthreads, this.slices);
                Future[] futures = new Future[nthreads];
                int k = this.slices / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstSlice = j * k;
                    final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int s = firstSlice;
                            while (s < lastSlice) {
                                int[][] currentSlice = values[s];
                                if (currentSlice.length != DenseIntMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + DenseIntMatrix3D.this.rows());
                                }
                                int r = 0;
                                while (r < DenseIntMatrix3D.this.rows) {
                                    int idx = zero + s * DenseIntMatrix3D.this.sliceStride + r * DenseIntMatrix3D.this.rowStride;
                                    int[] currentRow = currentSlice[r];
                                    if (currentRow.length != DenseIntMatrix3D.this.columns) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + DenseIntMatrix3D.this.columns());
                                    }
                                    int c = 0;
                                    while (c < DenseIntMatrix3D.this.columns) {
                                        DenseIntMatrix3D.this.elements[idx] = currentRow[c];
                                        idx += DenseIntMatrix3D.this.columnStride;
                                        ++c;
                                    }
                                    ++r;
                                }
                                ++s;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int s = 0;
                while (s < this.slices) {
                    int[][] currentSlice = values[s];
                    if (currentSlice.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + this.rows());
                    }
                    int r = 0;
                    while (r < this.rows) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        int[] currentRow = currentSlice[r];
                        if (currentRow.length != this.columns) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                        }
                        int c = 0;
                        while (c < this.columns) {
                            this.elements[idx] = currentRow[c];
                            idx += this.columnStride;
                            ++c;
                        }
                        ++r;
                    }
                    ++s;
                }
            }
        }
        return this;
    }

    @Override
    public IntMatrix3D assign(final IntProcedure cond, final IntFunction f) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseIntMatrix3D.this.rows) {
                                int idx = zero + s * DenseIntMatrix3D.this.sliceStride + r * DenseIntMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseIntMatrix3D.this.columns) {
                                    int elem = DenseIntMatrix3D.this.elements[idx];
                                    if (cond.apply(elem)) {
                                        DenseIntMatrix3D.this.elements[idx] = f.apply(elem);
                                    }
                                    idx += DenseIntMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        int elem = this.elements[idx];
                        if (cond.apply(elem)) {
                            this.elements[idx] = f.apply(elem);
                        }
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public IntMatrix3D assign(final IntProcedure cond, final int value) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseIntMatrix3D.this.rows) {
                                int idx = zero + s * DenseIntMatrix3D.this.sliceStride + r * DenseIntMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseIntMatrix3D.this.columns) {
                                    int elem = DenseIntMatrix3D.this.elements[idx];
                                    if (cond.apply(elem)) {
                                        DenseIntMatrix3D.this.elements[idx] = value;
                                    }
                                    idx += DenseIntMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        int elem = this.elements[idx];
                        if (cond.apply(elem)) {
                            this.elements[idx] = value;
                        }
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public IntMatrix3D assign(IntMatrix3D source) {
        if (!(source instanceof DenseIntMatrix3D)) {
            super.assign(source);
            return this;
        }
        DenseIntMatrix3D other = (DenseIntMatrix3D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        if (this.haveSharedCells(other)) {
            IntMatrix3D c = other.copy();
            if (!(c instanceof DenseIntMatrix3D)) {
                super.assign(source);
                return this;
            }
            other = (DenseIntMatrix3D)c;
        }
        DenseIntMatrix3D other_final = other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other_final.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)other_final.index(0, 0, 0);
        final int sliceStrideOther = other_final.sliceStride;
        final int rowStrideOther = other_final.rowStride;
        final int columnStrideOther = other_final.columnStride;
        final int[] elemsOther = other_final.elements;
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseIntMatrix3D.this.rows) {
                                int idx = zero + s * DenseIntMatrix3D.this.sliceStride + r * DenseIntMatrix3D.this.rowStride;
                                int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                int c = 0;
                                while (c < DenseIntMatrix3D.this.columns) {
                                    DenseIntMatrix3D.this.elements[idx] = elemsOther[idxOther];
                                    idx += DenseIntMatrix3D.this.columnStride;
                                    idxOther += columnStrideOther;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                    int c = 0;
                    while (c < this.columns) {
                        this.elements[idx] = elemsOther[idxOther];
                        idx += this.columnStride;
                        idxOther += columnStrideOther;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public IntMatrix3D assign(IntMatrix3D y, final IntIntFunction function) {
        if (!(y instanceof DenseIntMatrix3D)) {
            super.assign(y, function);
            return this;
        }
        this.checkShape(y);
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)y.index(0, 0, 0);
        final int sliceStrideOther = y.sliceStride();
        final int rowStrideOther = y.rowStride();
        final int columnStrideOther = y.columnStride();
        final int[] elemsOther = (int[])y.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseIntMatrix3D.this.rows) {
                                int idx = zero + s * DenseIntMatrix3D.this.sliceStride + r * DenseIntMatrix3D.this.rowStride;
                                int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                int c = 0;
                                while (c < DenseIntMatrix3D.this.columns) {
                                    DenseIntMatrix3D.this.elements[idx] = function.apply(DenseIntMatrix3D.this.elements[idx], elemsOther[idxOther]);
                                    idx += DenseIntMatrix3D.this.columnStride;
                                    idxOther += columnStrideOther;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                    int c = 0;
                    while (c < this.columns) {
                        this.elements[idx] = function.apply(this.elements[idx], elemsOther[idxOther]);
                        idx += this.columnStride;
                        idxOther += columnStrideOther;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public IntMatrix3D assign(IntMatrix3D y, final IntIntFunction function, IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList) {
        if (!(y instanceof DenseIntMatrix3D)) {
            super.assign(y, function);
            return this;
        }
        this.checkShape(y);
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)y.index(0, 0, 0);
        final int sliceStrideOther = y.sliceStride();
        final int rowStrideOther = y.rowStride();
        final int columnStrideOther = y.columnStride();
        final int[] elemsOther = (int[])y.elements();
        int size = sliceList.size();
        final int[] sliceElements = sliceList.elements();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            int idx = zero + sliceElements[i] * DenseIntMatrix3D.this.sliceStride + rowElements[i] * DenseIntMatrix3D.this.rowStride + columnElements[i] * DenseIntMatrix3D.this.columnStride;
                            int idxOther = zeroOther + sliceElements[i] * sliceStrideOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                            DenseIntMatrix3D.this.elements[idx] = function.apply(DenseIntMatrix3D.this.elements[idx], elemsOther[idxOther]);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < size) {
                int idx = zero + sliceElements[i] * this.sliceStride + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride;
                int idxOther = zeroOther + sliceElements[i] * sliceStrideOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                this.elements[idx] = function.apply(this.elements[idx], elemsOther[idxOther]);
                ++i;
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        int cardinality = 0;
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseIntMatrix3D.this.rows) {
                                int idx = zero + s * DenseIntMatrix3D.this.sliceStride + r * DenseIntMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseIntMatrix3D.this.columns) {
                                    if (DenseIntMatrix3D.this.elements[idx] != 0) {
                                        ++cardinality;
                                    }
                                    idx += DenseIntMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                        return cardinality;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                cardinality = results[0];
                j = 1;
                while (j < nthreads) {
                    cardinality += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        if (this.elements[idx] != 0) {
                            ++cardinality;
                        }
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return cardinality;
    }

    public int[] elements() {
        return this.elements;
    }

    @Override
    public void getNegativeValues(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, IntArrayList valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int zero = (int)this.index(0, 0, 0);
        int s = 0;
        while (s < this.slices) {
            int r = 0;
            while (r < this.rows) {
                int idx = zero + s * this.sliceStride + r * this.rowStride;
                int c = 0;
                while (c < this.columns) {
                    int value = this.elements[idx];
                    if (value < 0) {
                        sliceList.add(s);
                        rowList.add(r);
                        columnList.add(c);
                        valueList.add(value);
                    }
                    idx += this.columnStride;
                    ++c;
                }
                ++r;
            }
            ++s;
        }
    }

    @Override
    public void getNonZeros(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, IntArrayList valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int zero = (int)this.index(0, 0, 0);
        int s = 0;
        while (s < this.slices) {
            int r = 0;
            while (r < this.rows) {
                int idx = zero + s * this.sliceStride + r * this.rowStride;
                int c = 0;
                while (c < this.columns) {
                    int value = this.elements[idx];
                    if (value != 0) {
                        sliceList.add(s);
                        rowList.add(r);
                        columnList.add(c);
                        valueList.add(value);
                    }
                    idx += this.columnStride;
                    ++c;
                }
                ++r;
            }
            ++s;
        }
    }

    @Override
    public void getPositiveValues(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, IntArrayList valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int zero = (int)this.index(0, 0, 0);
        int s = 0;
        while (s < this.slices) {
            int r = 0;
            while (r < this.rows) {
                int idx = zero + s * this.sliceStride + r * this.rowStride;
                int c = 0;
                while (c < this.columns) {
                    int value = this.elements[idx];
                    if (value > 0) {
                        sliceList.add(s);
                        rowList.add(r);
                        columnList.add(c);
                        valueList.add(value);
                    }
                    idx += this.columnStride;
                    ++c;
                }
                ++r;
            }
            ++s;
        }
    }

    @Override
    public int getQuick(int slice, int row, int column) {
        return this.elements[this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride];
    }

    @Override
    public long index(int slice, int row, int column) {
        return this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    @Override
    public IntMatrix3D like(int slices, int rows, int columns) {
        return new DenseIntMatrix3D(slices, rows, columns);
    }

    @Override
    public IntMatrix2D like2D(int rows, int columns) {
        return new DenseIntMatrix2D(rows, columns);
    }

    @Override
    public int[] getMaxLocation() {
        final int zero = (int)this.index(0, 0, 0);
        int slice_loc = 0;
        int row_loc = 0;
        int col_loc = 0;
        int maxValue = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int[][] results = new int[nthreads][2];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int slice_loc = firstSlice;
                        int row_loc = 0;
                        int col_loc = 0;
                        int maxValue = DenseIntMatrix3D.this.elements[zero + firstSlice * DenseIntMatrix3D.this.sliceStride];
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseIntMatrix3D.this.rows) {
                                int c = d;
                                while (c < DenseIntMatrix3D.this.columns) {
                                    int elem = DenseIntMatrix3D.this.elements[zero + s * DenseIntMatrix3D.this.sliceStride + r * DenseIntMatrix3D.this.rowStride + c * DenseIntMatrix3D.this.columnStride];
                                    if (maxValue < elem) {
                                        maxValue = elem;
                                        slice_loc = s;
                                        row_loc = r;
                                        col_loc = c;
                                    }
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return new int[]{maxValue, slice_loc, row_loc, col_loc};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (int[])futures[j].get();
                    ++j;
                }
                maxValue = results[0][0];
                slice_loc = results[0][1];
                row_loc = results[0][2];
                col_loc = results[0][3];
                j = 1;
                while (j < nthreads) {
                    if (maxValue < results[j][0]) {
                        maxValue = results[j][0];
                        slice_loc = results[j][1];
                        row_loc = results[j][2];
                        col_loc = results[j][3];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.elements[zero];
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        int elem = this.elements[zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride];
                        if (maxValue < elem) {
                            maxValue = elem;
                            slice_loc = s;
                            row_loc = r;
                            col_loc = c;
                        }
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return new int[]{maxValue, slice_loc, row_loc, col_loc};
    }

    @Override
    public int[] getMinLocation() {
        final int zero = (int)this.index(0, 0, 0);
        int slice_loc = 0;
        int row_loc = 0;
        int col_loc = 0;
        int minValue = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int[][] results = new int[nthreads][2];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int slice_loc = firstSlice;
                        int row_loc = 0;
                        int col_loc = 0;
                        int minValue = DenseIntMatrix3D.this.elements[zero + slice_loc * DenseIntMatrix3D.this.sliceStride];
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseIntMatrix3D.this.rows) {
                                int c = d;
                                while (c < DenseIntMatrix3D.this.columns) {
                                    int elem = DenseIntMatrix3D.this.elements[zero + s * DenseIntMatrix3D.this.sliceStride + r * DenseIntMatrix3D.this.rowStride + c * DenseIntMatrix3D.this.columnStride];
                                    if (minValue > elem) {
                                        minValue = elem;
                                        slice_loc = s;
                                        row_loc = r;
                                        col_loc = c;
                                    }
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return new int[]{minValue, slice_loc, row_loc, col_loc};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (int[])futures[j].get();
                    ++j;
                }
                minValue = results[0][0];
                slice_loc = results[0][1];
                row_loc = results[0][2];
                col_loc = results[0][3];
                j = 1;
                while (j < nthreads) {
                    if (minValue > results[j][0]) {
                        minValue = results[j][0];
                        slice_loc = results[j][1];
                        row_loc = results[j][2];
                        col_loc = results[j][3];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.elements[zero];
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        int elem = this.elements[zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride];
                        if (minValue > elem) {
                            minValue = elem;
                            slice_loc = s;
                            row_loc = r;
                            col_loc = c;
                        }
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return new int[]{minValue, slice_loc, row_loc, col_loc};
    }

    @Override
    public void setQuick(int slice, int row, int column, int value) {
        this.elements[this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride] = value;
    }

    @Override
    public int[][][] toArray() {
        final int[][][] values = new int[this.slices][this.rows][this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int[][] currentSlice = values[s];
                            int r = 0;
                            while (r < DenseIntMatrix3D.this.rows) {
                                int idx = zero + s * DenseIntMatrix3D.this.sliceStride + r * DenseIntMatrix3D.this.rowStride;
                                int[] currentRow = currentSlice[r];
                                int c = 0;
                                while (c < DenseIntMatrix3D.this.columns) {
                                    currentRow[c] = DenseIntMatrix3D.this.elements[idx];
                                    idx += DenseIntMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int[][] currentSlice = values[s];
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int[] currentRow = currentSlice[r];
                    int c = 0;
                    while (c < this.columns) {
                        currentRow[c] = this.elements[idx];
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return values;
    }

    @Override
    public IntMatrix1D vectorize() {
        DenseIntMatrix1D v = new DenseIntMatrix1D((int)this.size());
        int length = this.rows * this.columns;
        int s = 0;
        while (s < this.slices) {
            v.viewPart(s * length, length).assign(this.viewSlice(s).vectorize());
            ++s;
        }
        return v;
    }

    @Override
    public int zSum() {
        int sum = 0;
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int sum = 0;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseIntMatrix3D.this.rows) {
                                int idx = zero + s * DenseIntMatrix3D.this.sliceStride + r * DenseIntMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseIntMatrix3D.this.columns) {
                                    sum += DenseIntMatrix3D.this.elements[idx];
                                    idx += DenseIntMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                        return sum;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    sum += ((Integer)futures[j].get()).intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        sum += this.elements[idx];
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return sum;
    }

    @Override
    protected boolean haveSharedCellsRaw(IntMatrix3D other) {
        if (other instanceof SelectedDenseIntMatrix3D) {
            SelectedDenseIntMatrix3D otherMatrix = (SelectedDenseIntMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseIntMatrix3D) {
            DenseIntMatrix3D otherMatrix = (DenseIntMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected IntMatrix2D like2D(int rows, int columns, int rowZero, int columnZero, int rowStride, int columnStride) {
        return new DenseIntMatrix2D(rows, columns, this.elements, rowZero, columnZero, rowStride, columnStride, true);
    }

    @Override
    protected IntMatrix3D viewSelectionLike(int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseIntMatrix3D(this.elements, sliceOffsets, rowOffsets, columnOffsets, 0);
    }
}

