/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;

class DelegateDoubleMatrix1D
extends DoubleMatrix1D {
    private static final long serialVersionUID = 1L;
    protected DoubleMatrix2D content;
    protected int row;

    public DelegateDoubleMatrix1D(DoubleMatrix2D newContent, int row) {
        if (row < 0 || row >= newContent.rows()) {
            throw new IllegalArgumentException();
        }
        this.setUp(newContent.columns());
        this.row = row;
        this.content = newContent;
    }

    @Override
    public synchronized double getQuick(int index) {
        return this.content.getQuick(this.row, index);
    }

    @Override
    public DoubleMatrix1D like(int size) {
        return this.content.like1D(size);
    }

    @Override
    public DoubleMatrix2D like2D(int rows, int columns) {
        return this.content.like(rows, columns);
    }

    @Override
    public synchronized void setQuick(int index, double value) {
        this.content.setQuick(this.row, index, value);
    }

    @Override
    public Object elements() {
        return this.content.elements();
    }

    @Override
    public DoubleMatrix2D reshape(int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    public DoubleMatrix3D reshape(int slices, int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    protected DoubleMatrix1D viewSelectionLike(int[] offsets) {
        throw new InternalError();
    }
}

