/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tfcomplex.FComplexFComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexProcedure;
import cern.colt.function.tfcomplex.FComplexRealFunction;
import cern.colt.function.tfcomplex.IntIntFComplexFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.SelectedDenseColumnFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseColumnFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.jet.math.tfcomplex.FComplexFunctions;
import cern.jet.math.tfcomplex.FComplexMult;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseColumnFComplexMatrix2D
extends FComplexMatrix2D {
    static final long serialVersionUID = 1020177651L;
    private FloatFFT_2D fft2;
    protected float[] elements;

    public DenseColumnFComplexMatrix2D(float[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length / 2);
        this.assign(values);
    }

    public DenseColumnFComplexMatrix2D(FloatMatrix2D realPart) {
        this(realPart.rows(), realPart.columns());
        this.assignReal(realPart);
    }

    public DenseColumnFComplexMatrix2D(int rows, int columns) {
        this.setUp(rows, columns, 0, 0, 2, 2 * rows);
        this.elements = new float[rows * 2 * columns];
    }

    public DenseColumnFComplexMatrix2D(int rows, int columns, float[] elements, int rowZero, int columnZero, int rowStride, int columnStride, boolean isNoView) {
        this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = isNoView;
    }

    @Override
    public float[] aggregate(final FComplexFComplexFComplexFunction aggr, final FComplexFComplexFunction f) {
        float[] b = new float[2];
        if (this.size() == 0L) {
            b[0] = Float.NaN;
            b[1] = Float.NaN;
            return b;
        }
        final int zero = (int)this.index(0, 0);
        float[] a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int idx = zero + firstColumn * DenseColumnFComplexMatrix2D.this.columnStride;
                        float[] a = f.apply(DenseColumnFComplexMatrix2D.this.elements[idx], DenseColumnFComplexMatrix2D.this.elements[idx + 1]);
                        int d = 1;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int r = d;
                            while (r < DenseColumnFComplexMatrix2D.this.rows) {
                                idx = zero + r * DenseColumnFComplexMatrix2D.this.rowStride + c * DenseColumnFComplexMatrix2D.this.columnStride;
                                a = aggr.apply(a, f.apply(DenseColumnFComplexMatrix2D.this.elements[idx], DenseColumnFComplexMatrix2D.this.elements[idx + 1]));
                                ++r;
                            }
                            d = 0;
                            ++c;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero], this.elements[zero + 1]);
            int d = 1;
            int c = 0;
            while (c < this.columns) {
                int r = d;
                while (r < this.rows) {
                    int idx = zero + r * this.rowStride + c * this.columnStride;
                    a = aggr.apply(a, f.apply(this.elements[idx], this.elements[idx + 1]));
                    ++r;
                }
                d = 0;
                ++c;
            }
        }
        return a;
    }

    @Override
    public float[] aggregate(FComplexMatrix2D other, final FComplexFComplexFComplexFunction aggr, final FComplexFComplexFComplexFunction f) {
        if (!(other instanceof DenseColumnFComplexMatrix2D)) {
            return super.aggregate(other, aggr, f);
        }
        this.checkShape(other);
        float[] b = new float[2];
        if (this.size() == 0L) {
            b[0] = Float.NaN;
            b[1] = Float.NaN;
            return b;
        }
        final int zero = (int)this.index(0, 0);
        final int zeroOther = (int)other.index(0, 0);
        final int rowStrideOther = other.rowStride();
        final int columnStrideOther = other.columnStride();
        final float[] elemsOther = (float[])other.elements();
        float[] a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int idx = zero + firstColumn * DenseColumnFComplexMatrix2D.this.columnStride;
                        int idxOther = zeroOther + firstColumn * columnStrideOther;
                        float[] a = f.apply(new float[]{DenseColumnFComplexMatrix2D.this.elements[idx], DenseColumnFComplexMatrix2D.this.elements[idx + 1]}, new float[]{elemsOther[idxOther], elemsOther[idxOther + 1]});
                        int d = 1;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int r = d;
                            while (r < DenseColumnFComplexMatrix2D.this.rows) {
                                idx = zero + r * DenseColumnFComplexMatrix2D.this.rowStride + c * DenseColumnFComplexMatrix2D.this.columnStride;
                                idxOther = zeroOther + r * rowStrideOther + c * columnStrideOther;
                                a = aggr.apply(a, f.apply(new float[]{DenseColumnFComplexMatrix2D.this.elements[idx], DenseColumnFComplexMatrix2D.this.elements[idx + 1]}, new float[]{elemsOther[idxOther], elemsOther[idxOther + 1]}));
                                ++r;
                            }
                            d = 0;
                            ++c;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(new float[]{this.elements[zero], this.elements[zero + 1]}, new float[]{elemsOther[zeroOther], elemsOther[zeroOther + 1]});
            int d = 1;
            int c = 0;
            while (c < this.columns) {
                int r = d;
                while (r < this.rows) {
                    int idx = zero + r * this.rowStride + c * this.columnStride;
                    int idxOther = zeroOther + r * rowStrideOther + c * columnStrideOther;
                    a = aggr.apply(a, f.apply(new float[]{this.elements[idx], this.elements[idx + 1]}, new float[]{elemsOther[idxOther], elemsOther[idxOther + 1]}));
                    ++r;
                }
                d = 0;
                ++c;
            }
        }
        return a;
    }

    @Override
    public FComplexMatrix2D assign(final FComplexFComplexFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            if (function instanceof FComplexMult) {
                float[] multiplicator = ((FComplexMult)function).multiplicator;
                if (multiplicator[0] == 1.0f && multiplicator[1] == 0.0f) {
                    return this;
                }
                if (multiplicator[0] == 0.0f && multiplicator[1] == 0.0f) {
                    return this.assign(0.0f, 0.0f);
                }
            }
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstColumn * DenseColumnFComplexMatrix2D.this.columnStride;
                        float[] tmp = new float[2];
                        if (function instanceof FComplexMult) {
                            float[] multiplicator = ((FComplexMult)function).multiplicator;
                            int c = firstColumn;
                            while (c < lastColumn) {
                                int i = idx;
                                int r = 0;
                                while (r < DenseColumnFComplexMatrix2D.this.rows) {
                                    tmp[0] = DenseColumnFComplexMatrix2D.this.elements[i];
                                    tmp[1] = DenseColumnFComplexMatrix2D.this.elements[i + 1];
                                    DenseColumnFComplexMatrix2D.this.elements[i] = tmp[0] * multiplicator[0] - tmp[1] * multiplicator[1];
                                    DenseColumnFComplexMatrix2D.this.elements[i + 1] = tmp[1] * multiplicator[0] + tmp[0] * multiplicator[1];
                                    i += DenseColumnFComplexMatrix2D.this.rowStride;
                                    ++r;
                                }
                                idx += DenseColumnFComplexMatrix2D.this.columnStride;
                                ++c;
                            }
                        } else {
                            int c = firstColumn;
                            while (c < lastColumn) {
                                int i = idx;
                                int r = 0;
                                while (r < DenseColumnFComplexMatrix2D.this.rows) {
                                    tmp = function.apply(DenseColumnFComplexMatrix2D.this.elements[i], DenseColumnFComplexMatrix2D.this.elements[i + 1]);
                                    DenseColumnFComplexMatrix2D.this.elements[i] = tmp[0];
                                    DenseColumnFComplexMatrix2D.this.elements[i + 1] = tmp[1];
                                    i += DenseColumnFComplexMatrix2D.this.rowStride;
                                    ++r;
                                }
                                idx += DenseColumnFComplexMatrix2D.this.columnStride;
                                ++c;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            float[] tmp = new float[2];
            if (function instanceof FComplexMult) {
                float[] multiplicator = ((FComplexMult)function).multiplicator;
                int c = 0;
                while (c < this.columns) {
                    int i = idx;
                    int r = 0;
                    while (r < this.rows) {
                        tmp[0] = this.elements[i];
                        tmp[1] = this.elements[i + 1];
                        this.elements[i] = tmp[0] * multiplicator[0] - tmp[1] * multiplicator[1];
                        this.elements[i + 1] = tmp[1] * multiplicator[0] + tmp[0] * multiplicator[1];
                        i += this.rowStride;
                        ++r;
                    }
                    idx += this.columnStride;
                    ++c;
                }
            } else {
                int c = 0;
                while (c < this.columns) {
                    int i = idx;
                    int r = 0;
                    while (r < this.rows) {
                        tmp = function.apply(this.elements[i], this.elements[i + 1]);
                        this.elements[i] = tmp[0];
                        this.elements[i + 1] = tmp[1];
                        i += this.rowStride;
                        ++r;
                    }
                    idx += this.columnStride;
                    ++c;
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(final FComplexProcedure cond, final FComplexFComplexFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] elem = new float[2];
                        int idx = zero + firstColumn * DenseColumnFComplexMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int i = idx;
                            int r = 0;
                            while (r < DenseColumnFComplexMatrix2D.this.rows) {
                                elem[0] = DenseColumnFComplexMatrix2D.this.elements[i];
                                elem[1] = DenseColumnFComplexMatrix2D.this.elements[i + 1];
                                if (cond.apply(elem)) {
                                    elem = function.apply(elem);
                                    DenseColumnFComplexMatrix2D.this.elements[i] = elem[0];
                                    DenseColumnFComplexMatrix2D.this.elements[i + 1] = elem[1];
                                }
                                i += DenseColumnFComplexMatrix2D.this.rowStride;
                                ++r;
                            }
                            idx += DenseColumnFComplexMatrix2D.this.columnStride;
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            float[] elem = new float[2];
            int idx = zero;
            int c = 0;
            while (c < this.columns) {
                int i = idx;
                int r = 0;
                while (r < this.rows) {
                    elem[0] = this.elements[i];
                    elem[1] = this.elements[i + 1];
                    if (cond.apply(elem)) {
                        elem = function.apply(elem);
                        this.elements[i] = elem[0];
                        this.elements[i + 1] = elem[1];
                    }
                    i += this.rowStride;
                    ++r;
                }
                idx += this.columnStride;
                ++c;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(final FComplexProcedure cond, final float[] value) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstColumn * DenseColumnFComplexMatrix2D.this.columnStride;
                        float[] elem = new float[2];
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int i = idx;
                            int r = 0;
                            while (r < DenseColumnFComplexMatrix2D.this.rows) {
                                elem[0] = DenseColumnFComplexMatrix2D.this.elements[i];
                                elem[1] = DenseColumnFComplexMatrix2D.this.elements[i + 1];
                                if (cond.apply(elem)) {
                                    DenseColumnFComplexMatrix2D.this.elements[i] = value[0];
                                    DenseColumnFComplexMatrix2D.this.elements[i + 1] = value[1];
                                }
                                i += DenseColumnFComplexMatrix2D.this.rowStride;
                                ++r;
                            }
                            idx += DenseColumnFComplexMatrix2D.this.columnStride;
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            float[] elem = new float[2];
            int idx = zero;
            int c = 0;
            while (c < this.columns) {
                int i = idx;
                int r = 0;
                while (r < this.rows) {
                    elem[0] = this.elements[i];
                    elem[1] = this.elements[i + 1];
                    if (cond.apply(elem)) {
                        this.elements[i] = value[0];
                        this.elements[i + 1] = value[1];
                    }
                    i += this.rowStride;
                    ++r;
                }
                idx += this.columnStride;
                ++c;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(final FComplexRealFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstColumn * DenseColumnFComplexMatrix2D.this.columnStride;
                        float[] tmp = new float[2];
                        if (function == FComplexFunctions.abs) {
                            int c = firstColumn;
                            while (c < lastColumn) {
                                int i = idx;
                                int r = 0;
                                while (r < DenseColumnFComplexMatrix2D.this.rows) {
                                    float d;
                                    tmp[0] = DenseColumnFComplexMatrix2D.this.elements[i];
                                    tmp[1] = DenseColumnFComplexMatrix2D.this.elements[i + 1];
                                    float absX = Math.abs(DenseColumnFComplexMatrix2D.this.elements[i]);
                                    float absY = Math.abs(DenseColumnFComplexMatrix2D.this.elements[i + 1]);
                                    if (absX == 0.0f && absY == 0.0f) {
                                        DenseColumnFComplexMatrix2D.this.elements[i] = 0.0f;
                                    } else if (absX >= absY) {
                                        d = tmp[1] / tmp[0];
                                        DenseColumnFComplexMatrix2D.this.elements[i] = (float)((double)absX * Math.sqrt(1.0f + d * d));
                                    } else {
                                        d = tmp[0] / tmp[1];
                                        DenseColumnFComplexMatrix2D.this.elements[i] = (float)((double)absY * Math.sqrt(1.0f + d * d));
                                    }
                                    DenseColumnFComplexMatrix2D.this.elements[i + 1] = 0.0f;
                                    i += DenseColumnFComplexMatrix2D.this.rowStride;
                                    ++r;
                                }
                                idx += DenseColumnFComplexMatrix2D.this.columnStride;
                                ++c;
                            }
                        } else {
                            int c = firstColumn;
                            while (c < lastColumn) {
                                int i = idx;
                                int r = 0;
                                while (r < DenseColumnFComplexMatrix2D.this.rows) {
                                    tmp[0] = DenseColumnFComplexMatrix2D.this.elements[i];
                                    tmp[1] = DenseColumnFComplexMatrix2D.this.elements[i + 1];
                                    tmp[0] = function.apply(tmp);
                                    DenseColumnFComplexMatrix2D.this.elements[i] = tmp[0];
                                    DenseColumnFComplexMatrix2D.this.elements[i + 1] = 0.0f;
                                    i += DenseColumnFComplexMatrix2D.this.rowStride;
                                    ++r;
                                }
                                idx += DenseColumnFComplexMatrix2D.this.columnStride;
                                ++c;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            float[] tmp = new float[2];
            if (function == FComplexFunctions.abs) {
                int c = 0;
                while (c < this.columns) {
                    int i = idx;
                    int r = 0;
                    while (r < this.rows) {
                        float d;
                        tmp[0] = this.elements[i];
                        tmp[1] = this.elements[i + 1];
                        float absX = Math.abs(tmp[0]);
                        float absY = Math.abs(tmp[1]);
                        if (absX == 0.0f && absY == 0.0f) {
                            this.elements[i] = 0.0f;
                        } else if (absX >= absY) {
                            d = tmp[1] / tmp[0];
                            this.elements[i] = (float)((double)absX * Math.sqrt(1.0f + d * d));
                        } else {
                            d = tmp[0] / tmp[1];
                            this.elements[i] = (float)((double)absY * Math.sqrt(1.0f + d * d));
                        }
                        this.elements[i + 1] = 0.0f;
                        i += this.rowStride;
                        ++r;
                    }
                    idx += this.columnStride;
                    ++c;
                }
            } else {
                int c = 0;
                while (c < this.columns) {
                    int i = idx;
                    int r = 0;
                    while (r < this.rows) {
                        tmp[0] = this.elements[i];
                        tmp[1] = this.elements[i + 1];
                        tmp[0] = function.apply(tmp);
                        this.elements[i] = tmp[0];
                        this.elements[i + 1] = 0.0f;
                        i += this.rowStride;
                        ++r;
                    }
                    idx += this.columnStride;
                    ++c;
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(FComplexMatrix2D source) {
        if (!(source instanceof DenseColumnFComplexMatrix2D)) {
            super.assign(source);
            return this;
        }
        DenseColumnFComplexMatrix2D other = (DenseColumnFComplexMatrix2D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(other)) {
            FComplexMatrix2D c = other.copy();
            if (!(c instanceof DenseColumnFComplexMatrix2D)) {
                super.assign(other);
                return this;
            }
            other = (DenseColumnFComplexMatrix2D)c;
        }
        final float[] elemsOther = other.elements;
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        final int columnStrideOther = other.columnStride;
        final int rowStrideOther = other.rowStride;
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstColumn * DenseColumnFComplexMatrix2D.this.columnStride;
                        int idxOther = zeroOther + firstColumn * columnStrideOther;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int i = idx;
                            int j = idxOther;
                            int r = 0;
                            while (r < DenseColumnFComplexMatrix2D.this.rows) {
                                DenseColumnFComplexMatrix2D.this.elements[i] = elemsOther[j];
                                DenseColumnFComplexMatrix2D.this.elements[i + 1] = elemsOther[j + 1];
                                i += DenseColumnFComplexMatrix2D.this.rowStride;
                                j += rowStrideOther;
                                ++r;
                            }
                            idx += DenseColumnFComplexMatrix2D.this.columnStride;
                            idxOther += columnStrideOther;
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            int c = 0;
            while (c < this.columns) {
                int i = idx;
                int j = idxOther;
                int r = 0;
                while (r < this.rows) {
                    this.elements[i] = elemsOther[j];
                    this.elements[i + 1] = elemsOther[j + 1];
                    i += this.rowStride;
                    j += rowStrideOther;
                    ++r;
                }
                idx += this.columnStride;
                idxOther += columnStrideOther;
                ++c;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(FComplexMatrix2D y, final FComplexFComplexFComplexFunction function) {
        if (!(y instanceof DenseColumnFComplexMatrix2D)) {
            super.assign(y, function);
            return this;
        }
        this.checkShape(y);
        final float[] elemsOther = ((DenseColumnFComplexMatrix2D)y).elements;
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        final int columnStrideOther = y.columnStride();
        final int rowStrideOther = y.rowStride();
        final int zeroOther = (int)y.index(0, 0);
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstColumn * DenseColumnFComplexMatrix2D.this.columnStride;
                        int idxOther = zeroOther + firstColumn * columnStrideOther;
                        float[] tmp1 = new float[2];
                        float[] tmp2 = new float[2];
                        if (function == FComplexFunctions.mult) {
                            int c = firstColumn;
                            while (c < lastColumn) {
                                int i = idx;
                                int j = idxOther;
                                int r = 0;
                                while (r < DenseColumnFComplexMatrix2D.this.rows) {
                                    tmp1[0] = DenseColumnFComplexMatrix2D.this.elements[i];
                                    tmp1[1] = DenseColumnFComplexMatrix2D.this.elements[i + 1];
                                    tmp2[0] = elemsOther[j];
                                    tmp2[1] = elemsOther[j + 1];
                                    DenseColumnFComplexMatrix2D.this.elements[i] = tmp1[0] * tmp2[0] - tmp1[1] * tmp2[1];
                                    DenseColumnFComplexMatrix2D.this.elements[i + 1] = tmp1[1] * tmp2[0] + tmp1[0] * tmp2[1];
                                    i += DenseColumnFComplexMatrix2D.this.rowStride;
                                    j += rowStrideOther;
                                    ++r;
                                }
                                idx += DenseColumnFComplexMatrix2D.this.columnStride;
                                idxOther += columnStrideOther;
                                ++c;
                            }
                        } else if (function == FComplexFunctions.multConjFirst) {
                            int c = firstColumn;
                            while (c < lastColumn) {
                                int i = idx;
                                int j = idxOther;
                                int r = 0;
                                while (r < DenseColumnFComplexMatrix2D.this.rows) {
                                    tmp1[0] = DenseColumnFComplexMatrix2D.this.elements[i];
                                    tmp1[1] = DenseColumnFComplexMatrix2D.this.elements[i + 1];
                                    tmp2[0] = elemsOther[j];
                                    tmp2[1] = elemsOther[j + 1];
                                    DenseColumnFComplexMatrix2D.this.elements[i] = tmp1[0] * tmp2[0] + tmp1[1] * tmp2[1];
                                    DenseColumnFComplexMatrix2D.this.elements[i + 1] = -tmp1[1] * tmp2[0] + tmp1[0] * tmp2[1];
                                    i += DenseColumnFComplexMatrix2D.this.rowStride;
                                    j += rowStrideOther;
                                    ++r;
                                }
                                idx += DenseColumnFComplexMatrix2D.this.columnStride;
                                idxOther += columnStrideOther;
                                ++c;
                            }
                        } else if (function == FComplexFunctions.multConjSecond) {
                            int c = firstColumn;
                            while (c < lastColumn) {
                                int i = idx;
                                int j = idxOther;
                                int r = 0;
                                while (r < DenseColumnFComplexMatrix2D.this.rows) {
                                    tmp1[0] = DenseColumnFComplexMatrix2D.this.elements[i];
                                    tmp1[1] = DenseColumnFComplexMatrix2D.this.elements[i + 1];
                                    tmp2[0] = elemsOther[j];
                                    tmp2[1] = elemsOther[j + 1];
                                    DenseColumnFComplexMatrix2D.this.elements[i] = tmp1[0] * tmp2[0] + tmp1[1] * tmp2[1];
                                    DenseColumnFComplexMatrix2D.this.elements[i + 1] = tmp1[1] * tmp2[0] - tmp1[0] * tmp2[1];
                                    i += DenseColumnFComplexMatrix2D.this.rowStride;
                                    j += rowStrideOther;
                                    ++r;
                                }
                                idx += DenseColumnFComplexMatrix2D.this.columnStride;
                                idxOther += columnStrideOther;
                                ++c;
                            }
                        } else {
                            int c = firstColumn;
                            while (c < lastColumn) {
                                int i = idx;
                                int j = idxOther;
                                int r = 0;
                                while (r < DenseColumnFComplexMatrix2D.this.rows) {
                                    tmp1[0] = DenseColumnFComplexMatrix2D.this.elements[i];
                                    tmp1[1] = DenseColumnFComplexMatrix2D.this.elements[i + 1];
                                    tmp2[0] = elemsOther[j];
                                    tmp2[1] = elemsOther[j + 1];
                                    tmp1 = function.apply(tmp1, tmp2);
                                    DenseColumnFComplexMatrix2D.this.elements[i] = tmp1[0];
                                    DenseColumnFComplexMatrix2D.this.elements[i + 1] = tmp1[1];
                                    i += DenseColumnFComplexMatrix2D.this.rowStride;
                                    j += rowStrideOther;
                                    ++r;
                                }
                                idx += DenseColumnFComplexMatrix2D.this.columnStride;
                                idxOther += columnStrideOther;
                                ++c;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            float[] tmp1 = new float[2];
            float[] tmp2 = new float[2];
            int idx = zero;
            int idxOther = zeroOther;
            if (function == FComplexFunctions.mult) {
                int c = 0;
                while (c < this.columns) {
                    int i = idx;
                    int j = idxOther;
                    int r = 0;
                    while (r < this.rows) {
                        tmp1[0] = this.elements[i];
                        tmp1[1] = this.elements[i + 1];
                        tmp2[0] = elemsOther[j];
                        tmp2[1] = elemsOther[j + 1];
                        this.elements[i] = tmp1[0] * tmp2[0] - tmp1[1] * tmp2[1];
                        this.elements[i + 1] = tmp1[1] * tmp2[0] + tmp1[0] * tmp2[1];
                        i += this.rowStride;
                        j += rowStrideOther;
                        ++r;
                    }
                    idx += this.columnStride;
                    idxOther += columnStrideOther;
                    ++c;
                }
            } else if (function == FComplexFunctions.multConjFirst) {
                int c = 0;
                while (c < this.columns) {
                    int i = idx;
                    int j = idxOther;
                    int r = 0;
                    while (r < this.rows) {
                        tmp1[0] = this.elements[i];
                        tmp1[1] = this.elements[i + 1];
                        tmp2[0] = elemsOther[j];
                        tmp2[1] = elemsOther[j + 1];
                        this.elements[i] = tmp1[0] * tmp2[0] + tmp1[1] * tmp2[1];
                        this.elements[i + 1] = -tmp1[1] * tmp2[0] + tmp1[0] * tmp2[1];
                        i += this.rowStride;
                        j += rowStrideOther;
                        ++r;
                    }
                    idx += this.columnStride;
                    idxOther += columnStrideOther;
                    ++c;
                }
            } else if (function == FComplexFunctions.multConjSecond) {
                int c = 0;
                while (c < this.columns) {
                    int i = idx;
                    int j = idxOther;
                    int r = 0;
                    while (r < this.rows) {
                        tmp1[0] = this.elements[i];
                        tmp1[1] = this.elements[i + 1];
                        tmp2[0] = elemsOther[j];
                        tmp2[1] = elemsOther[j + 1];
                        this.elements[i] = tmp1[0] * tmp2[0] + tmp1[1] * tmp2[1];
                        this.elements[i + 1] = tmp1[1] * tmp2[0] - tmp1[0] * tmp2[1];
                        i += this.rowStride;
                        j += rowStrideOther;
                        ++r;
                    }
                    idx += this.columnStride;
                    idxOther += columnStrideOther;
                    ++c;
                }
            } else {
                int c = 0;
                while (c < this.columns) {
                    int i = idx;
                    int j = idxOther;
                    int r = 0;
                    while (r < this.rows) {
                        tmp1[0] = this.elements[i];
                        tmp1[1] = this.elements[i + 1];
                        tmp2[0] = elemsOther[j];
                        tmp2[1] = elemsOther[j + 1];
                        tmp1 = function.apply(tmp1, tmp2);
                        this.elements[i] = tmp1[0];
                        this.elements[i + 1] = tmp1[1];
                        i += this.rowStride;
                        j += rowStrideOther;
                        ++r;
                    }
                    idx += this.columnStride;
                    idxOther += columnStrideOther;
                    ++c;
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(final float re, final float im) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstColumn * DenseColumnFComplexMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int i = idx;
                            int r = 0;
                            while (r < DenseColumnFComplexMatrix2D.this.rows) {
                                DenseColumnFComplexMatrix2D.this.elements[i] = re;
                                DenseColumnFComplexMatrix2D.this.elements[i + 1] = im;
                                i += DenseColumnFComplexMatrix2D.this.rowStride;
                                ++r;
                            }
                            idx += DenseColumnFComplexMatrix2D.this.columnStride;
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int c = 0;
            while (c < this.columns) {
                int i = idx;
                int r = 0;
                while (r < this.rows) {
                    this.elements[i] = re;
                    this.elements[i + 1] = im;
                    i += this.rowStride;
                    ++r;
                }
                idx += this.columnStride;
                ++c;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(final float[] values) {
        if (values.length != this.rows * 2 * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "rows()*2*columns()=" + this.rows() * 2 * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else {
            final int zero = (int)this.index(0, 0);
            if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.columns);
                Future[] futures = new Future[nthreads];
                int k = this.columns / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstColumn = j * k;
                    final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idxOther = firstColumn * DenseColumnFComplexMatrix2D.this.rows * 2;
                            int idx = zero + firstColumn * DenseColumnFComplexMatrix2D.this.columnStride;
                            int c = firstColumn;
                            while (c < lastColumn) {
                                int i = idx;
                                int r = 0;
                                while (r < DenseColumnFComplexMatrix2D.this.rows) {
                                    DenseColumnFComplexMatrix2D.this.elements[i] = values[idxOther++];
                                    DenseColumnFComplexMatrix2D.this.elements[i + 1] = values[idxOther++];
                                    i += DenseColumnFComplexMatrix2D.this.rowStride;
                                    ++r;
                                }
                                idx += DenseColumnFComplexMatrix2D.this.columnStride;
                                ++c;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idxOther = 0;
                int idx = zero;
                int c = 0;
                while (c < this.columns) {
                    int i = idx;
                    int r = 0;
                    while (r < this.rows) {
                        this.elements[i] = values[idxOther++];
                        this.elements[i + 1] = values[idxOther++];
                        i += this.rowStride;
                        ++r;
                    }
                    idx += this.columnStride;
                    ++c;
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(final float[][] values) {
        if (values.length != this.columns) {
            throw new IllegalArgumentException("Must have same number of columns: values.length=" + values.length + "columns()=" + this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.columns);
                Future[] futures = new Future[nthreads];
                int k = this.columns / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstColumn = j * k;
                    final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idx = 2 * DenseColumnFComplexMatrix2D.this.rows;
                            int i = firstColumn * DenseColumnFComplexMatrix2D.this.columnStride;
                            int c = firstColumn;
                            while (c < lastColumn) {
                                float[] currentColumn = values[c];
                                if (currentColumn.length != idx) {
                                    throw new IllegalArgumentException("Must have same number of rows in every column: rows=" + currentColumn.length + "2*rows()=" + idx);
                                }
                                System.arraycopy(currentColumn, 0, DenseColumnFComplexMatrix2D.this.elements, i, idx);
                                i += idx;
                                ++c;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx = 2 * this.rows;
                int i = 0;
                int c = 0;
                while (c < this.columns) {
                    float[] currentColumn = values[c];
                    if (currentColumn.length != idx) {
                        throw new IllegalArgumentException("Must have same number of rows in every column: rows=" + currentColumn.length + "2*rows()=" + idx);
                    }
                    System.arraycopy(currentColumn, 0, this.elements, i, idx);
                    i += idx;
                    ++c;
                }
            }
        } else {
            final int zero = (int)this.index(0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.columns);
                Future[] futures = new Future[nthreads];
                int k = this.columns / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstColumn = j * k;
                    final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idx = zero + firstColumn * DenseColumnFComplexMatrix2D.this.columnStride;
                            int c = firstColumn;
                            while (c < lastColumn) {
                                float[] currentColumn = values[c];
                                if (currentColumn.length != 2 * DenseColumnFComplexMatrix2D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every column: rows=" + currentColumn.length + "2*rows()=" + idx);
                                }
                                int i = idx;
                                int r = 0;
                                while (r < DenseColumnFComplexMatrix2D.this.rows) {
                                    DenseColumnFComplexMatrix2D.this.elements[i] = currentColumn[2 * r];
                                    DenseColumnFComplexMatrix2D.this.elements[i + 1] = currentColumn[2 * r + 1];
                                    i += DenseColumnFComplexMatrix2D.this.rowStride;
                                    ++r;
                                }
                                idx += DenseColumnFComplexMatrix2D.this.columnStride;
                                ++c;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx = zero;
                int c = 0;
                while (c < this.columns) {
                    float[] currentColumn = values[c];
                    if (currentColumn.length != 2 * this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every column: rows=" + currentColumn.length + "2*rows()=" + idx);
                    }
                    int i = idx;
                    int r = 0;
                    while (r < this.rows) {
                        this.elements[i] = currentColumn[2 * r];
                        this.elements[i + 1] = currentColumn[2 * r + 1];
                        i += this.rowStride;
                        ++r;
                    }
                    idx += this.columnStride;
                    ++c;
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assignImaginary(FloatMatrix2D other) {
        this.checkShape(other);
        final int columnStrideOther = other.columnStride();
        final int rowStrideOther = other.rowStride();
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final float[] elemsOther = ((DenseFloatMatrix2D)other).elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstColumn * DenseColumnFComplexMatrix2D.this.columnStride;
                        int idxOther = zeroOther + firstColumn * columnStrideOther;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int i = idx;
                            int j = idxOther;
                            int r = 0;
                            while (r < DenseColumnFComplexMatrix2D.this.rows) {
                                DenseColumnFComplexMatrix2D.this.elements[i + 1] = elemsOther[j];
                                i += DenseColumnFComplexMatrix2D.this.rowStride;
                                j += rowStrideOther;
                                ++r;
                            }
                            idx += DenseColumnFComplexMatrix2D.this.columnStride;
                            idxOther += columnStrideOther;
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            int c = 0;
            while (c < this.columns) {
                int i = idx;
                int j = idxOther;
                int r = 0;
                while (r < this.rows) {
                    this.elements[i + 1] = elemsOther[j];
                    i += this.rowStride;
                    j += rowStrideOther;
                    ++r;
                }
                idx += this.columnStride;
                idxOther += columnStrideOther;
                ++c;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assignReal(FloatMatrix2D other) {
        this.checkShape(other);
        final int columnStrideOther = other.columnStride();
        final int rowStrideOther = other.rowStride();
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final float[] elemsOther = ((DenseFloatMatrix2D)other).elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstColumn * DenseColumnFComplexMatrix2D.this.columnStride;
                        int idxOther = zeroOther + firstColumn * columnStrideOther;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int i = idx;
                            int j = idxOther;
                            int r = 0;
                            while (r < DenseColumnFComplexMatrix2D.this.rows) {
                                DenseColumnFComplexMatrix2D.this.elements[i] = elemsOther[j];
                                i += DenseColumnFComplexMatrix2D.this.rowStride;
                                j += rowStrideOther;
                                ++r;
                            }
                            idx += DenseColumnFComplexMatrix2D.this.columnStride;
                            idxOther += columnStrideOther;
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            int c = 0;
            while (c < this.columns) {
                int i = idx;
                int j = idxOther;
                int r = 0;
                while (r < this.rows) {
                    this.elements[i] = elemsOther[j];
                    i += this.rowStride;
                    j += rowStrideOther;
                    ++r;
                }
                idx += this.columnStride;
                idxOther += columnStrideOther;
                ++c;
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int idx = zero + firstColumn * DenseColumnFComplexMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int i = idx;
                            int r = 0;
                            while (r < DenseColumnFComplexMatrix2D.this.rows) {
                                if ((double)DenseColumnFComplexMatrix2D.this.elements[i] != 0.0 || (double)DenseColumnFComplexMatrix2D.this.elements[i + 1] != 0.0) {
                                    ++cardinality;
                                }
                                i += DenseColumnFComplexMatrix2D.this.rowStride;
                                ++r;
                            }
                            idx += DenseColumnFComplexMatrix2D.this.columnStride;
                            ++c;
                        }
                        return cardinality;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                cardinality = results[0];
                j = 1;
                while (j < nthreads) {
                    cardinality += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = zero;
            int c = 0;
            while (c < this.columns) {
                int i = idx;
                int r = 0;
                while (r < this.rows) {
                    if ((double)this.elements[i] != 0.0 || (double)this.elements[i + 1] != 0.0) {
                        ++cardinality;
                    }
                    i += this.rowStride;
                    ++r;
                }
                idx += this.columnStride;
                ++c;
            }
        }
        return cardinality;
    }

    public void fft2() {
        FComplexMatrix2D transpose = this.viewDice().copy();
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        this.fft2.complexForward((float[])transpose.elements());
        this.assign(transpose.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void fftColumns() {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (c < lastColumn) {
                            ((DenseFComplexMatrix1D)DenseColumnFComplexMatrix2D.this.viewColumn(c)).fft();
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = 0;
            while (c < this.columns) {
                ((DenseFComplexMatrix1D)this.viewColumn(c)).fft();
                ++c;
            }
        }
    }

    public void fftRows() {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            ((DenseFComplexMatrix1D)DenseColumnFComplexMatrix2D.this.viewRow(r)).fft();
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = 0;
            while (r < this.rows) {
                ((DenseFComplexMatrix1D)this.viewRow(r)).fft();
                ++r;
            }
        }
    }

    @Override
    public FComplexMatrix2D forEachNonZero(final IntIntFComplexFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstColumn * DenseColumnFComplexMatrix2D.this.columnStride;
                        float[] value = new float[2];
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int i = idx;
                            int r = 0;
                            while (r < DenseColumnFComplexMatrix2D.this.rows) {
                                value[0] = DenseColumnFComplexMatrix2D.this.elements[i];
                                value[1] = DenseColumnFComplexMatrix2D.this.elements[i + 1];
                                if (value[0] != 0.0f || value[1] != 0.0f) {
                                    float[] v = function.apply(r, c, value);
                                    DenseColumnFComplexMatrix2D.this.elements[i] = v[0];
                                    DenseColumnFComplexMatrix2D.this.elements[i + 1] = v[1];
                                }
                                i += DenseColumnFComplexMatrix2D.this.rowStride;
                                ++r;
                            }
                            idx += DenseColumnFComplexMatrix2D.this.columnStride;
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            float[] value = new float[2];
            int c = 0;
            while (c < this.columns) {
                int i = idx;
                int r = 0;
                while (r < this.rows) {
                    value[0] = this.elements[i];
                    value[1] = this.elements[i + 1];
                    if (value[0] != 0.0f || value[1] != 0.0f) {
                        float[] v = function.apply(r, c, value);
                        this.elements[i] = v[0];
                        this.elements[i + 1] = v[1];
                    }
                    i += this.rowStride;
                    ++r;
                }
                idx += this.columnStride;
                ++c;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D getConjugateTranspose() {
        FComplexMatrix2D transpose = this.viewDice().copy();
        final float[] elemsOther = ((DenseColumnFComplexMatrix2D)transpose).elements;
        final int zeroOther = (int)transpose.index(0, 0);
        final int columnStrideOther = transpose.columnStride();
        int rowStrideOther = transpose.rowStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        int columnsOther = transpose.columns();
        final int rowsOther = transpose.rows();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, columnsOther);
            Future[] futures = new Future[nthreads];
            int k = columnsOther / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? columnsOther : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idxOther = zeroOther + firstColumn * columnStrideOther;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int r = 0;
                            while (r < rowsOther) {
                                elemsOther[idxOther + 1] = -elemsOther[idxOther + 1];
                                idxOther += 2;
                                ++r;
                            }
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idxOther = zeroOther;
            int c = 0;
            while (c < columnsOther) {
                int r = 0;
                while (r < rowsOther) {
                    elemsOther[idxOther + 1] = -elemsOther[idxOther + 1];
                    idxOther += 2;
                    ++r;
                }
                ++c;
            }
        }
        return transpose;
    }

    public float[] elements() {
        return this.elements;
    }

    @Override
    public FloatMatrix2D getImaginaryPart() {
        DenseColumnFloatMatrix2D Im = new DenseColumnFloatMatrix2D(this.rows, this.columns);
        final float[] elemsOther = Im.elements();
        final int columnStrideOther = Im.columnStride();
        final int rowStrideOther = Im.rowStride();
        final int zeroOther = (int)Im.index(0, 0);
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstColumn * DenseColumnFComplexMatrix2D.this.columnStride;
                        int idxOther = zeroOther + firstColumn * columnStrideOther;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int i = idx;
                            int j = idxOther;
                            int r = 0;
                            while (r < DenseColumnFComplexMatrix2D.this.rows) {
                                elemsOther[j] = DenseColumnFComplexMatrix2D.this.elements[i + 1];
                                i += DenseColumnFComplexMatrix2D.this.rowStride;
                                j += rowStrideOther;
                                ++r;
                            }
                            idx += DenseColumnFComplexMatrix2D.this.columnStride;
                            idxOther += columnStrideOther;
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            int c = 0;
            while (c < this.columns) {
                int i = idx;
                int j = idxOther;
                int r = 0;
                while (r < this.rows) {
                    elemsOther[j] = this.elements[i + 1];
                    i += this.rowStride;
                    j += rowStrideOther;
                    ++r;
                }
                idx += this.columnStride;
                idxOther += columnStrideOther;
                ++c;
            }
        }
        return Im;
    }

    @Override
    public void getNonZeros(IntArrayList rowList, IntArrayList columnList, ArrayList<float[]> valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        int c = 0;
        while (c < this.columns) {
            int i = idx;
            int r = 0;
            while (r < this.rows) {
                float[] value = new float[]{this.elements[i], this.elements[i + 1]};
                if (value[0] != 0.0f || value[1] != 0.0f) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.rowStride;
                ++r;
            }
            idx += this.columnStride;
            ++c;
        }
    }

    @Override
    public float[] getQuick(int row, int column) {
        int idx = this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
        return new float[]{this.elements[idx], this.elements[idx + 1]};
    }

    @Override
    public FloatMatrix2D getRealPart() {
        DenseColumnFloatMatrix2D R = new DenseColumnFloatMatrix2D(this.rows, this.columns);
        final float[] elemsOther = R.elements();
        final int columnStrideOther = R.columnStride();
        final int rowStrideOther = R.rowStride();
        final int zeroOther = (int)R.index(0, 0);
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstColumn * DenseColumnFComplexMatrix2D.this.columnStride;
                        int idxOther = zeroOther + firstColumn * columnStrideOther;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int i = idx;
                            int j = idxOther;
                            int r = 0;
                            while (r < DenseColumnFComplexMatrix2D.this.rows) {
                                elemsOther[j] = DenseColumnFComplexMatrix2D.this.elements[i];
                                i += DenseColumnFComplexMatrix2D.this.rowStride;
                                j += rowStrideOther;
                                ++r;
                            }
                            idx += DenseColumnFComplexMatrix2D.this.columnStride;
                            idxOther += columnStrideOther;
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            int c = 0;
            while (c < this.columns) {
                int i = idx;
                int j = idxOther;
                int r = 0;
                while (r < this.rows) {
                    elemsOther[j] = this.elements[i];
                    i += this.rowStride;
                    j += rowStrideOther;
                    ++r;
                }
                idx += this.columnStride;
                idxOther += columnStrideOther;
                ++c;
            }
        }
        return R;
    }

    public void ifft2(boolean scale) {
        FComplexMatrix2D transpose = this.viewDice().copy();
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        this.fft2.complexInverse((float[])transpose.elements(), scale);
        this.assign(transpose.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void ifftColumns(final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (c < lastColumn) {
                            ((DenseFComplexMatrix1D)DenseColumnFComplexMatrix2D.this.viewColumn(c)).ifft(scale);
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = 0;
            while (c < this.columns) {
                ((DenseFComplexMatrix1D)this.viewColumn(c)).ifft(scale);
                ++c;
            }
        }
    }

    public void ifftRows(final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            ((DenseFComplexMatrix1D)DenseColumnFComplexMatrix2D.this.viewRow(r)).ifft(scale);
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = 0;
            while (r < this.rows) {
                ((DenseFComplexMatrix1D)this.viewRow(r)).ifft(scale);
                ++r;
            }
        }
    }

    @Override
    public FComplexMatrix2D like(int rows, int columns) {
        return new DenseColumnFComplexMatrix2D(rows, columns);
    }

    @Override
    public FComplexMatrix1D like1D(int size) {
        return new DenseFComplexMatrix1D(size);
    }

    @Override
    public void setQuick(int row, int column, float re, float im) {
        int idx = this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
        this.elements[idx] = re;
        this.elements[idx + 1] = im;
    }

    @Override
    public void setQuick(int row, int column, float[] value) {
        int idx = this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
        this.elements[idx] = value[0];
        this.elements[idx + 1] = value[1];
    }

    @Override
    public float[][] toArray() {
        final float[][] values = new float[this.rows][2 * this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstColumn * DenseColumnFComplexMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int i = idx;
                            int r = 0;
                            while (r < DenseColumnFComplexMatrix2D.this.rows) {
                                values[r][2 * c] = DenseColumnFComplexMatrix2D.this.elements[i];
                                values[r][2 * c + 1] = DenseColumnFComplexMatrix2D.this.elements[i + 1];
                                i += DenseColumnFComplexMatrix2D.this.rowStride;
                                ++r;
                            }
                            idx += DenseColumnFComplexMatrix2D.this.columnStride;
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int c = 0;
            while (c < this.columns) {
                int i = idx;
                int r = 0;
                while (r < this.rows) {
                    values[r][2 * c] = this.elements[i];
                    values[r][2 * c + 1] = this.elements[i + 1];
                    i += this.rowStride;
                    ++r;
                }
                idx += this.columnStride;
                ++c;
            }
        }
        return values;
    }

    @Override
    public FComplexMatrix1D vectorize() {
        DenseFComplexMatrix1D v = new DenseFComplexMatrix1D((int)this.size());
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, ((FComplexMatrix1D)v).elements(), 0, this.elements.length);
        } else {
            final int zero = (int)this.index(0, 0);
            final int zeroOther = (int)((AbstractMatrix1D)v).index(0);
            final int strideOther = v.stride();
            final float[] elemsOther = (float[])((FComplexMatrix1D)v).elements();
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.columns);
                Future[] futures = new Future[nthreads];
                int k = this.columns / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstColumn = j * k;
                    final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                    final int firstIdx = j * k * this.rows;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idx = 0;
                            int idxOther = zeroOther + firstIdx * strideOther;
                            int c = firstColumn;
                            while (c < lastColumn) {
                                idx = zero + c * DenseColumnFComplexMatrix2D.this.columnStride;
                                int r = 0;
                                while (r < DenseColumnFComplexMatrix2D.this.rows) {
                                    elemsOther[idxOther] = DenseColumnFComplexMatrix2D.this.elements[idx];
                                    elemsOther[idxOther + 1] = DenseColumnFComplexMatrix2D.this.elements[idx + 1];
                                    idx += DenseColumnFComplexMatrix2D.this.rowStride;
                                    idxOther += strideOther;
                                    ++r;
                                }
                                ++c;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx = 0;
                int idxOther = zeroOther;
                int c = 0;
                while (c < this.columns) {
                    idx = zero + c * this.columnStride;
                    int r = 0;
                    while (r < this.rows) {
                        elemsOther[idxOther] = this.elements[idx];
                        elemsOther[idxOther + 1] = this.elements[idx + 1];
                        idx += this.rowStride;
                        idxOther += strideOther;
                        ++r;
                    }
                    ++c;
                }
            }
        }
        return v;
    }

    @Override
    public FComplexMatrix2D zMult(FComplexMatrix2D B, FComplexMatrix2D C, final float[] alpha, final float[] beta, final boolean transposeA, final boolean transposeB) {
        int columnsC;
        int rowsA = this.rows;
        int columnsA = this.columns;
        int rowsB = B.rows();
        int columnsB = B.columns();
        int rowsC = transposeA ? columnsA : rowsA;
        int n = columnsC = transposeB ? rowsB : columnsB;
        if (C == null) {
            C = new DenseColumnFComplexMatrix2D(rowsC, columnsC);
        }
        if (transposeA) {
            return this.getConjugateTranspose().zMult(B, C, alpha, beta, false, transposeB);
        }
        if (transposeB) {
            return this.zMult(B.getConjugateTranspose(), C, alpha, beta, transposeA, false);
        }
        if (B.rows() != columnsA) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (C.rows() != rowsA || C.columns() != columnsB) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        long flops = 2L * (long)rowsA * (long)columnsA * (long)columnsB;
        int noOfTasks = (int)Math.min(flops / 30000L, (long)ConcurrencyUtils.getNumberOfThreads());
        boolean splitB = columnsB >= noOfTasks;
        int width = splitB ? columnsB : rowsA;
        noOfTasks = Math.min(width, noOfTasks);
        if (noOfTasks < 2) {
            return this.zMultSeq(B, C, alpha, beta, transposeA, transposeB);
        }
        int span = width / noOfTasks;
        Future[] subTasks = new Future[noOfTasks];
        int i = 0;
        while (i < noOfTasks) {
            FComplexMatrix2D CC;
            FComplexMatrix2D BB;
            FComplexMatrix2D AA;
            int offset = i * span;
            if (i == noOfTasks - 1) {
                span = width - span * i;
            }
            if (splitB) {
                AA = this;
                BB = B.viewPart(0, offset, columnsA, span);
                CC = C.viewPart(0, offset, rowsA, span);
            } else {
                AA = this.viewPart(offset, 0, span, columnsA);
                BB = B;
                CC = C.viewPart(offset, 0, span, columnsB);
            }
            subTasks[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    ((DenseColumnFComplexMatrix2D)AA).zMultSeq(BB, CC, alpha, beta, transposeA, transposeB);
                }
            });
            ++i;
        }
        ConcurrencyUtils.waitForCompletion(subTasks);
        return C;
    }

    protected FComplexMatrix2D zMultSeq(FComplexMatrix2D B, FComplexMatrix2D C, float[] alpha, float[] beta, boolean transposeA, boolean transposeB) {
        if (transposeA) {
            return this.getConjugateTranspose().zMult(B, C, alpha, beta, false, transposeB);
        }
        if (transposeB) {
            return this.zMult(B.getConjugateTranspose(), C, alpha, beta, transposeA, false);
        }
        int m = this.rows;
        int n = this.columns;
        int p = B.columns();
        if (C == null) {
            C = new DenseColumnFComplexMatrix2D(m, p);
        }
        if (!(C instanceof DenseColumnFComplexMatrix2D)) {
            return super.zMult(B, C, alpha, beta, transposeA, transposeB);
        }
        if (B.rows() != n) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (C.rows() != m || C.columns() != p) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        DenseColumnFComplexMatrix2D BB = (DenseColumnFComplexMatrix2D)B;
        DenseColumnFComplexMatrix2D CC = (DenseColumnFComplexMatrix2D)C;
        float[] AElems = this.elements;
        float[] BElems = BB.elements;
        float[] CElems = CC.elements;
        if (AElems == null || BElems == null || CElems == null) {
            throw new InternalError();
        }
        int cA = this.columnStride;
        int cB = BB.columnStride;
        int cC = CC.columnStride;
        int rA = this.rowStride;
        int rB = BB.rowStride;
        int rC = CC.rowStride;
        int BLOCK_SIZE = 30000;
        int m_optimal = (30000 - n) / (n + 1);
        if (m_optimal <= 0) {
            m_optimal = 1;
        }
        int blocks = m / m_optimal;
        int rr = 0;
        if (m % m_optimal != 0) {
            ++blocks;
        }
        while (--blocks >= 0) {
            int jB = (int)BB.index(0, 0);
            int indexA = (int)this.index(rr, 0);
            int jC = (int)CC.index(rr, 0);
            rr += m_optimal;
            if (blocks == 0) {
                m_optimal += m - rr;
            }
            int j = p;
            while (--j >= 0) {
                int iA = indexA;
                int iC = jC;
                int i = m_optimal;
                while (--i >= 0) {
                    float imB;
                    float reB;
                    float imA;
                    float reA;
                    int kA = iA;
                    int kB = jB;
                    float reS = 0.0f;
                    float imS = 0.0f;
                    kA -= cA;
                    kB -= rB;
                    int k = n % 4;
                    while (--k >= 0) {
                        reA = AElems[kA += cA];
                        imA = AElems[kA + 1];
                        reB = BElems[kB += rB];
                        imB = BElems[kB + 1];
                        reS += reA * reB - imA * imB;
                        imS += imA * reB + reA * imB;
                    }
                    k = n / 4;
                    while (--k >= 0) {
                        reA = AElems[kA += cA];
                        imA = AElems[kA + 1];
                        reB = BElems[kB += rB];
                        imB = BElems[kB + 1];
                        reS += reA * reB - imA * imB;
                        imS += imA * reB + reA * imB;
                        reA = AElems[kA += cA];
                        imA = AElems[kA + 1];
                        reB = BElems[kB += rB];
                        imB = BElems[kB + 1];
                        reS += reA * reB - imA * imB;
                        imS += imA * reB + reA * imB;
                        reA = AElems[kA += cA];
                        imA = AElems[kA + 1];
                        reB = BElems[kB += rB];
                        imB = BElems[kB + 1];
                        reS += reA * reB - imA * imB;
                        imS += imA * reB + reA * imB;
                        reA = AElems[kA += cA];
                        imA = AElems[kA + 1];
                        reB = BElems[kB += rB];
                        imB = BElems[kB + 1];
                        reS += reA * reB - imA * imB;
                        imS += imA * reB + reA * imB;
                    }
                    float reC = CElems[iC];
                    float imC = CElems[iC + 1];
                    CElems[iC] = alpha[0] * reS - alpha[1] * imS + beta[0] * reC - beta[1] * imC;
                    CElems[iC + 1] = alpha[1] * reS + alpha[0] * imS + beta[1] * reC + beta[0] * imC;
                    iA += rA;
                    iC += rC;
                }
                jB += cB;
                jC += cC;
            }
        }
        return C;
    }

    @Override
    public float[] zSum() {
        float[] sum = new float[2];
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float[] sum = new float[2];
                        int idx = zero + firstColumn * DenseColumnFComplexMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int i = idx;
                            int r = 0;
                            while (r < DenseColumnFComplexMatrix2D.this.rows) {
                                sum[0] = sum[0] + DenseColumnFComplexMatrix2D.this.elements[i];
                                sum[1] = sum[1] + DenseColumnFComplexMatrix2D.this.elements[i + 1];
                                i += DenseColumnFComplexMatrix2D.this.rowStride;
                                ++r;
                            }
                            idx += DenseColumnFComplexMatrix2D.this.columnStride;
                            ++c;
                        }
                        return sum;
                    }
                });
                ++j;
            }
            try {
                int j2 = 0;
                while (j2 < nthreads) {
                    float[] tmp = (float[])futures[j2].get();
                    sum[0] = sum[0] + tmp[0];
                    sum[1] = sum[1] + tmp[1];
                    ++j2;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = zero;
            int c = 0;
            while (c < this.columns) {
                int i = idx;
                int r = 0;
                while (r < this.rows) {
                    sum[0] = sum[0] + this.elements[i];
                    sum[1] = sum[1] + this.elements[i + 1];
                    i += this.rowStride;
                    ++r;
                }
                idx += this.columnStride;
                ++c;
            }
        }
        return sum;
    }

    @Override
    protected boolean haveSharedCellsRaw(FComplexMatrix2D other) {
        if (other instanceof SelectedDenseColumnFComplexMatrix2D) {
            SelectedDenseColumnFComplexMatrix2D otherMatrix = (SelectedDenseColumnFComplexMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseColumnFComplexMatrix2D) {
            DenseColumnFComplexMatrix2D otherMatrix = (DenseColumnFComplexMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    public long index(int row, int column) {
        return this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    @Override
    protected FComplexMatrix1D like1D(int size, int zero, int stride) {
        return new DenseFComplexMatrix1D(size, this.elements, zero, stride, false);
    }

    @Override
    protected FComplexMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseColumnFComplexMatrix2D(this.elements, rowOffsets, columnOffsets, 0);
    }
}

